/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.ES6Iterator;
import dev.gigaherz.rhinolib.NativeArray;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Undefined;

public final class NativeArrayIterator
extends ES6Iterator {
    private static final String ITERATOR_TAG = "ArrayIterator";
    private ArrayIteratorType type;
    private Scriptable arrayLike;
    private int index;

    static void init(ScriptableObject scope, boolean sealed, Context cx) {
        NativeArrayIterator.init(scope, sealed, new NativeArrayIterator(), ITERATOR_TAG, cx);
    }

    private NativeArrayIterator() {
    }

    public NativeArrayIterator(Context cx, Scriptable scope, Scriptable arrayLike, ArrayIteratorType type) {
        super(scope, ITERATOR_TAG, cx);
        this.index = 0;
        this.arrayLike = arrayLike;
        this.type = type;
    }

    @Override
    public String getClassName() {
        return "Array Iterator";
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return (long)this.index >= NativeArray.getLengthProperty(cx, this.arrayLike, false);
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        if (this.type == ArrayIteratorType.KEYS) {
            return this.index++;
        }
        Object value = this.arrayLike.get(cx, this.index, this.arrayLike);
        if (value == NOT_FOUND) {
            value = Undefined.instance;
        }
        if (this.type == ArrayIteratorType.ENTRIES) {
            value = cx.newArray(scope, new Object[]{this.index, value});
        }
        ++this.index;
        return value;
    }

    @Override
    protected String getTag() {
        return ITERATOR_TAG;
    }

    public static enum ArrayIteratorType {
        ENTRIES,
        KEYS,
        VALUES;

    }
}

