/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import dev.gigaherz.rhinolib.Callable;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.IdFunctionObject;
import dev.gigaherz.rhinolib.IdScriptableObject;
import dev.gigaherz.rhinolib.NativeArray;
import dev.gigaherz.rhinolib.NativeNumber;
import dev.gigaherz.rhinolib.NativeString;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.Wrapper;
import dev.gigaherz.rhinolib.json.JsonParser;
import dev.gigaherz.rhinolib.util.HideFromJS;
import dev.gigaherz.rhinolib.util.Remapper;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public final class NativeJSON
extends IdScriptableObject {
    private static final Object JSON_TAG = "JSON";
    private static final int MAX_STRINGIFY_GAP_LENGTH = 10;
    private static final HashSet<String> IGNORED_METHODS = new HashSet();
    private static final int Id_toSource = 1;
    private static final int Id_parse = 2;
    private static final int Id_stringify = 3;
    private static final int LAST_METHOD_ID = 3;
    private static final int MAX_ID = 3;

    static void init(Scriptable scope, boolean sealed, Context cx) {
        NativeJSON obj = new NativeJSON();
        obj.activatePrototypeMap(3);
        obj.setPrototype(NativeJSON.getObjectPrototype(scope, cx));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject(cx);
        }
        NativeJSON.defineProperty(scope, "JSON", obj, 2, cx);
    }

    private static Object parse(Context cx, Scriptable scope, String jtext) {
        try {
            return new JsonParser(scope).parseValue(cx, jtext);
        }
        catch (JsonParser.ParseException ex) {
            throw ScriptRuntime.constructError(cx, "SyntaxError", ex.getMessage());
        }
    }

    public static Object parse(Context cx, Scriptable scope, String jtext, Callable reviver) {
        Object unfiltered = NativeJSON.parse(cx, scope, jtext);
        Scriptable root = cx.newObject(scope);
        root.put(cx, "", root, unfiltered);
        return NativeJSON.walk(cx, scope, reviver, root, "");
    }

    private static Object walk(Context cx, Scriptable scope, Callable reviver, Scriptable holder, Object name) {
        Object property;
        block10: {
            property = name instanceof Number ? holder.get(cx, ((Number)name).intValue(), holder) : holder.get(cx, (String)name, holder);
            Object object = property;
            if (!(object instanceof Scriptable)) break block10;
            Scriptable val = (Scriptable)object;
            if (val instanceof NativeArray) {
                long len = ((NativeArray)val).getLength();
                for (long i = 0L; i < len; ++i) {
                    Object newElement;
                    if (i > Integer.MAX_VALUE) {
                        String id = Long.toString(i);
                        newElement = NativeJSON.walk(cx, scope, reviver, val, id);
                        if (newElement == Undefined.instance) {
                            val.delete(cx, id);
                            continue;
                        }
                        val.put(cx, id, val, newElement);
                        continue;
                    }
                    int idx = (int)i;
                    newElement = NativeJSON.walk(cx, scope, reviver, val, idx);
                    if (newElement == Undefined.instance) {
                        val.delete(cx, idx);
                        continue;
                    }
                    val.put(cx, idx, val, newElement);
                }
            } else {
                Object[] keys;
                for (Object p : keys = val.getIds(cx)) {
                    Object newElement = NativeJSON.walk(cx, scope, reviver, val, p);
                    if (newElement == Undefined.instance) {
                        if (p instanceof Number) {
                            val.delete(cx, ((Number)p).intValue());
                            continue;
                        }
                        val.delete(cx, (String)p);
                        continue;
                    }
                    if (p instanceof Number) {
                        val.put(cx, ((Number)p).intValue(), val, newElement);
                        continue;
                    }
                    val.put(cx, (String)p, val, newElement);
                }
            }
        }
        return reviver.call(cx, scope, holder, new Object[]{name, property});
    }

    private static String repeat(char c, int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static String stringify(Object value, Object replacer, Object space, Context cx) {
        JsonElement e = NativeJSON.stringify0(cx, cx.getRemapper(), value);
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        String indent = null;
        if (space instanceof NativeNumber) {
            space = ScriptRuntime.toNumber(cx, space);
        } else if (space instanceof NativeString) {
            space = ScriptRuntime.toString(cx, space);
        }
        if (space instanceof Number) {
            int gapLength = (int)ScriptRuntime.toInteger(cx, space);
            indent = (gapLength = Math.min(10, gapLength)) > 0 ? NativeJSON.repeat(' ', gapLength) : "";
        } else if (space instanceof String && (indent = (String)space).length() > 10) {
            indent = indent.substring(0, 10);
        }
        if (indent != null) {
            writer.setIndent(indent);
        }
        writer.setSerializeNulls(true);
        writer.setHtmlSafe(false);
        writer.setLenient(true);
        try {
            Streams.write((JsonElement)e, (JsonWriter)writer);
            return stringWriter.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "error";
        }
    }

    private static void type(Remapper remapper, StringBuilder builder, Class<?> type) {
        String s = remapper.getMappedClass(type);
        if (s.startsWith("java.lang.") || s.startsWith("java.util.")) {
            builder.append(s.substring(10));
        } else {
            builder.append(s.isEmpty() ? type.getName() : s);
        }
    }

    private static void params(Remapper remapper, StringBuilder builder, Class<?>[] params) {
        builder.append('(');
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            NativeJSON.type(remapper, builder, params[i]);
        }
        builder.append(')');
    }

    public static JsonElement stringify0(Context cx, Remapper remapper, Object v) {
        StringBuilder builder;
        if (v == null) {
            return JsonNull.INSTANCE;
        }
        if (v instanceof Boolean) {
            return new JsonPrimitive((Boolean)v);
        }
        if (v instanceof CharSequence) {
            return new JsonPrimitive(v.toString());
        }
        if (v instanceof Number) {
            return new JsonPrimitive((Number)v);
        }
        if (v instanceof NativeString) {
            return new JsonPrimitive(ScriptRuntime.toString(cx, v));
        }
        if (v instanceof NativeNumber) {
            return new JsonPrimitive((Number)ScriptRuntime.toNumber(cx, v));
        }
        if (v instanceof Map) {
            JsonObject json = new JsonObject();
            for (Map.Entry entry : ((Map)v).entrySet()) {
                json.add(entry.getKey().toString(), NativeJSON.stringify0(cx, remapper, entry.getValue()));
            }
            return json;
        }
        if (v instanceof Iterable) {
            JsonArray json = new JsonArray();
            for (Object o : (Iterable)v) {
                json.add(NativeJSON.stringify0(cx, remapper, o));
            }
            return json;
        }
        if (v instanceof Wrapper) {
            v = ((Wrapper)v).unwrap();
        }
        Class<?> cl = v.getClass();
        int array = 0;
        while (cl.isArray()) {
            cl = cl.getComponentType();
            ++array;
        }
        String mcl = remapper.getMappedClass(cl);
        StringBuilder clName = new StringBuilder(mcl.isEmpty() ? cl.getName() : mcl);
        if (array > 0) {
            clName.append("[]".repeat(array));
        }
        JsonArray list = new JsonArray();
        if (cl.isInterface()) {
            clName.insert(0, "interface ");
        } else if (cl.isAnnotation()) {
            clName.insert(0, "annotation ");
        } else if (cl.isEnum()) {
            clName.insert(0, "enum ");
        } else {
            clName.insert(0, "class ");
        }
        list.add(clName.toString());
        for (Constructor<?> constructor : cl.getConstructors()) {
            int si;
            if (constructor.isAnnotationPresent(HideFromJS.class)) continue;
            StringBuilder builder2 = new StringBuilder("new ");
            String s = remapper.getMappedClass(constructor.getDeclaringClass());
            if (s.isEmpty()) {
                s = constructor.getDeclaringClass().getName();
            }
            builder2.append((si = s.lastIndexOf(46)) == -1 || si >= s.length() ? s : s.substring(si + 1));
            NativeJSON.params(remapper, builder2, constructor.getParameterTypes());
            list.add(builder2.toString());
        }
        for (AccessibleObject accessibleObject : cl.getFields()) {
            int mod = ((Field)accessibleObject).getModifiers();
            if (Modifier.isTransient(mod) || accessibleObject.isAnnotationPresent(HideFromJS.class)) continue;
            builder = new StringBuilder();
            if (Modifier.isStatic(mod)) {
                builder.append("static ");
            }
            if (Modifier.isFinal(mod)) {
                builder.append("final ");
            }
            if (Modifier.isNative(mod)) {
                builder.append("native ");
            }
            NativeJSON.type(remapper, builder, ((Field)accessibleObject).getType());
            builder.append(' ');
            builder.append(remapper.getMappedField(cl, (Field)accessibleObject));
            list.add(builder.toString());
        }
        for (AccessibleObject accessibleObject : cl.getMethods()) {
            if (accessibleObject.isAnnotationPresent(HideFromJS.class)) continue;
            int mod = ((Method)accessibleObject).getModifiers();
            builder = new StringBuilder();
            if (Modifier.isStatic(mod)) {
                builder.append("static ");
            }
            if (Modifier.isNative(mod)) {
                builder.append("native ");
            }
            NativeJSON.type(remapper, builder, ((Method)accessibleObject).getReturnType());
            builder.append(' ');
            builder.append(remapper.getMappedMethod(cl, (Method)accessibleObject));
            NativeJSON.params(remapper, builder, ((Method)accessibleObject).getParameterTypes());
            String s = builder.toString();
            if (IGNORED_METHODS.contains(s)) continue;
            list.add(s);
        }
        return list;
    }

    private NativeJSON() {
    }

    @Override
    public String getClassName() {
        return "JSON";
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        String name;
        int arity;
        if (id <= 3) {
            switch (id) {
                case 1: {
                    arity = 0;
                    name = "toSource";
                    break;
                }
                case 2: {
                    arity = 2;
                    name = "parse";
                    break;
                }
                case 3: {
                    arity = 3;
                    name = "stringify";
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(id));
                }
            }
        } else {
            throw new IllegalStateException(String.valueOf(id));
        }
        this.initPrototypeMethod(JSON_TAG, id, name, arity, cx);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(JSON_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int methodId = f.methodId();
        switch (methodId) {
            case 1: {
                return "JSON";
            }
            case 2: {
                String jtext = ScriptRuntime.toString(cx, args, 0);
                Object reviver = null;
                if (args.length > 1) {
                    reviver = args[1];
                }
                if (reviver instanceof Callable) {
                    return NativeJSON.parse(cx, scope, jtext, (Callable)reviver);
                }
                return NativeJSON.parse(cx, scope, jtext);
            }
            case 3: {
                Object value = null;
                Object replacer = null;
                Object space = null;
                switch (args.length) {
                    case 3: {
                        space = args[2];
                    }
                    case 2: {
                        replacer = args[1];
                    }
                    case 1: {
                        value = args[0];
                    }
                }
                return NativeJSON.stringify(value, replacer, space, cx);
            }
        }
        throw new IllegalStateException(String.valueOf(methodId));
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "toSource" -> 1;
            case "parse" -> 2;
            case "stringify" -> 3;
            default -> 0;
        };
    }

    static {
        IGNORED_METHODS.add("void wait()");
        IGNORED_METHODS.add("void wait(long, int)");
        IGNORED_METHODS.add("native void wait(long)");
        IGNORED_METHODS.add("boolean equals(Object)");
        IGNORED_METHODS.add("String toString()");
        IGNORED_METHODS.add("native int hashCode()");
        IGNORED_METHODS.add("native Class getClass()");
        IGNORED_METHODS.add("native void notify()");
        IGNORED_METHODS.add("native void notifyAll()");
    }
}

