/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Symbol;
import dev.gigaherz.rhinolib.SymbolKey;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.util.Deletable;
import dev.gigaherz.rhinolib.util.ValueUnwrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class NativeJavaList
extends NativeJavaObject {
    private final List list;
    private final Class<?> listType;
    private final ValueUnwrapper valueUnwrapper;

    public NativeJavaList(Context cx, Scriptable scope, Object jo, List list, @Nullable Class<?> listType, ValueUnwrapper valueUnwrapper) {
        super(scope, jo, jo.getClass(), cx);
        this.list = list;
        this.listType = listType;
        this.valueUnwrapper = valueUnwrapper;
    }

    public NativeJavaList(Context cx, Scriptable scope, Object jo, List list) {
        this(cx, scope, jo, list, null, ValueUnwrapper.DEFAULT);
    }

    @Override
    public String getClassName() {
        return "JavaList";
    }

    @Override
    public boolean has(Context cx, int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            return true;
        }
        return super.has(cx, index, start);
    }

    @Override
    public boolean has(Context cx, Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return true;
        }
        return super.has(cx, key, start);
    }

    @Override
    public Object get(Context cx, int index, Scriptable start) {
        if (this.isWithValidIndex(index)) {
            return this.valueUnwrapper.unwrap(cx, this, this.list.get(index));
        }
        return Undefined.instance;
    }

    @Override
    public Object get(Context cx, Symbol key, Scriptable start) {
        if (SymbolKey.IS_CONCAT_SPREADABLE.equals(key)) {
            return Boolean.TRUE;
        }
        return super.get(cx, key, start);
    }

    @Override
    public void put(Context cx, int index, Scriptable start, Object value) {
        if (this.isWithValidIndex(index)) {
            this.list.set(index, Context.jsToJava(cx, value, this.listType));
            return;
        }
        super.put(cx, index, start, value);
    }

    @Override
    public Object[] getIds(Context cx) {
        List list = (List)this.javaObject;
        Object[] result = new Object[list.size()];
        int i = list.size();
        while (--i >= 0) {
            result[i] = i;
        }
        return result;
    }

    private boolean isWithValidIndex(int index) {
        return index >= 0 && index < this.list.size();
    }

    @Override
    public void delete(Context cx, int index) {
        if (this.isWithValidIndex(index)) {
            Deletable.deleteObject(this.list.remove(index));
        }
    }

    @Override
    protected void initMembers(Context cx, Scriptable scope) {
        super.initMembers(cx, scope);
        this.addCustomProperty("length", this::getLength);
        this.addCustomFunction("push", this::push, Object.class);
        this.addCustomFunction("pop", this::pop);
        this.addCustomFunction("shift", this::shift);
        this.addCustomFunction("unshift", this::unshift, Object.class);
        this.addCustomFunction("concat", this::concat, List.class);
        this.addCustomFunction("join", this::join, String.class);
        this.addCustomFunction("reverse", this::reverse);
        this.addCustomFunction("slice", this::slice, Object.class);
        this.addCustomFunction("splice", this::splice, Object.class);
        this.addCustomFunction("every", this::every, Predicate.class);
        this.addCustomFunction("some", this::some, Predicate.class);
        this.addCustomFunction("filter", this::filter, Predicate.class);
        this.addCustomFunction("map", this::map, Function.class);
        this.addCustomFunction("reduce", this::reduce, BinaryOperator.class);
        this.addCustomFunction("reduceRight", this::reduceRight, BinaryOperator.class);
        this.addCustomFunction("find", this::find, Predicate.class);
        this.addCustomFunction("findIndex", this::findIndex, Predicate.class);
        this.addCustomFunction("findLast", this::findLast, Predicate.class);
        this.addCustomFunction("findLastIndex", this::findLastIndex, Predicate.class);
    }

    private int getLength(Context cx) {
        return this.list.size();
    }

    private int push(Context cx, Object[] args) {
        if (args.length == 1) {
            this.list.add(Context.jsToJava(cx, args[0], this.listType));
        } else if (args.length > 1) {
            Object[] args1 = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                args1[i] = Context.jsToJava(cx, args[i], this.listType);
            }
            this.list.addAll(Arrays.asList(args1));
        }
        return this.list.size();
    }

    private Object pop(Context cx) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        return this.list.remove(this.list.size() - 1);
    }

    private Object shift(Context cx) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        return this.list.remove(0);
    }

    private int unshift(Context cx, Object[] args) {
        for (int i = args.length - 1; i >= 0; --i) {
            this.list.add(0, Context.jsToJava(cx, args[i], this.listType));
        }
        return this.list.size();
    }

    private Object concat(Context cx, Object[] args) {
        ArrayList list1 = new ArrayList(this.list);
        if (args.length > 0 && args[0] instanceof List) {
            list1.addAll((List)args[0]);
        }
        return list1;
    }

    private String join(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return "";
        }
        if (this.list.size() == 1) {
            return ScriptRuntime.toString(cx, this.list.get(0));
        }
        String j = ScriptRuntime.toString(cx, args[0]);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                sb.append(j);
            }
            sb.append(ScriptRuntime.toString(cx, this.list.get(i)));
        }
        return sb.toString();
    }

    private NativeJavaList reverse(Context cx) {
        if (this.list.size() > 1) {
            Collections.reverse(this.list);
        }
        return this;
    }

    private Object slice(Context cx, Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object splice(Context cx, Object[] args) {
        throw new IllegalStateException("Not implemented yet!");
    }

    private Object every(Context cx, Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (predicate.test(o)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object some(Context cx, Object[] args) {
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private Object filter(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Predicate predicate = (Predicate)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            list1.add(o);
        }
        return list1;
    }

    private Object map(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return this;
        }
        Function function = (Function)args[0];
        ArrayList list1 = new ArrayList();
        for (Object o : this.list) {
            list1.add(function.apply(o));
        }
        return list1;
    }

    private Object reduce(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.valueUnwrapper.unwrap(cx, this, this.list.get(0));
        for (int i = 1; i < this.list.size(); ++i) {
            o = this.valueUnwrapper.unwrap(cx, this, operator.apply(o, this.valueUnwrapper.unwrap(cx, this, this.list.get(i))));
        }
        return o;
    }

    private Object reduceRight(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        BinaryOperator operator = (BinaryOperator)args[0];
        Object o = this.valueUnwrapper.unwrap(cx, this, this.list.get(0));
        for (int i = this.list.size() - 1; i >= 1; --i) {
            o = this.valueUnwrapper.unwrap(cx, this, operator.apply(o, this.valueUnwrapper.unwrap(cx, this, this.list.get(i))));
        }
        return o;
    }

    private Object find(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        Predicate predicate = (Predicate)args[0];
        for (Object o : this.list) {
            if (!predicate.test(o)) continue;
            return o;
        }
        return Undefined.instance;
    }

    private Object findIndex(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return -1;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = 0; i < this.list.size(); ++i) {
            if (!predicate.test(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }

    private Object findLast(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return Undefined.instance;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object o = this.list.get(i);
            if (!predicate.test(o)) continue;
            return o;
        }
        return Undefined.instance;
    }

    private Object findLastIndex(Context cx, Object[] args) {
        if (this.list.isEmpty()) {
            return -1;
        }
        Predicate predicate = (Predicate)args[0];
        for (int i = this.list.size() - 1; i >= 0; --i) {
            if (!predicate.test(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }
}

