/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.NativeJavaArray;
import dev.gigaherz.rhinolib.NativeJavaClass;
import dev.gigaherz.rhinolib.NativeJavaList;
import dev.gigaherz.rhinolib.NativeJavaMap;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.util.CustomJavaToJsWrapper;
import dev.gigaherz.rhinolib.util.JavaSetWrapper;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WrapFactory {
    private boolean javaPrimitiveWrap = true;

    public Object wrap(Context cx, Scriptable scope, Object obj, Class<?> staticType) {
        Class<?> cls;
        if (obj == null || obj == Undefined.instance || obj instanceof Scriptable) {
            return obj;
        }
        if (staticType == Void.TYPE) {
            return Undefined.instance;
        }
        if (staticType == Character.TYPE) {
            return (int)((Character)obj).charValue();
        }
        if (staticType != null && staticType.isPrimitive()) {
            return obj;
        }
        if (!this.isJavaPrimitiveWrap()) {
            if (obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof Short || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
                return obj;
            }
            if (obj instanceof Character) {
                return String.valueOf(((Character)obj).charValue());
            }
        }
        if ((cls = obj.getClass()).isArray()) {
            return NativeJavaArray.wrap(scope, obj, cx);
        }
        return this.wrapAsJavaObject(cx, scope, obj, staticType);
    }

    public Scriptable wrapNewObject(Scriptable scope, Object obj, Context cx) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            return NativeJavaArray.wrap(scope, obj, cx);
        }
        return this.wrapAsJavaObject(cx, scope, obj, null);
    }

    public Scriptable wrapAsJavaObject(Context cx, Scriptable scope, Object javaObject, Class<?> staticType) {
        Object object = javaObject;
        if (object instanceof CustomJavaToJsWrapper) {
            CustomJavaToJsWrapper w = (CustomJavaToJsWrapper)object;
            return w.convertJavaToJs(cx, scope, staticType);
        }
        CustomJavaToJsWrapper w = cx.wrapCustomJavaToJs(javaObject);
        if (w != null) {
            return w.convertJavaToJs(cx, scope, staticType);
        }
        Object object2 = javaObject;
        if (object2 instanceof Map) {
            Map map = (Map)object2;
            return new NativeJavaMap(cx, scope, map, map);
        }
        object2 = javaObject;
        if (object2 instanceof List) {
            List list = (List)object2;
            return new NativeJavaList(cx, scope, list, list);
        }
        object2 = javaObject;
        if (object2 instanceof Set) {
            Set set = (Set)object2;
            return new NativeJavaList(cx, scope, set, new JavaSetWrapper(set));
        }
        return new NativeJavaObject(scope, javaObject, staticType, cx);
    }

    public Scriptable wrapJavaClass(Context cx, Scriptable scope, Class<?> javaClass) {
        return new NativeJavaClass(cx, scope, javaClass);
    }

    public final boolean isJavaPrimitiveWrap() {
        return this.javaPrimitiveWrap;
    }

    public final void setJavaPrimitiveWrap(boolean value) {
        this.javaPrimitiveWrap = value;
    }
}

