/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib.util;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.util.RemappedEnumConstant;
import dev.gigaherz.rhinolib.util.wrap.TypeWrapperFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EnumTypeWrapper<T>
implements TypeWrapperFactory<T> {
    private static final Map<Class<?>, EnumTypeWrapper<?>> WRAPPERS = new HashMap();
    public final Class<T> enumType;
    public final T[] indexValues;
    public final Map<String, T> nameValues;
    public final Map<T, String> valueNames;

    public static <T> EnumTypeWrapper<T> get(Class<T> enumType) {
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException("Class " + enumType.getName() + " is not an enum!");
        }
        return WRAPPERS.computeIfAbsent(enumType, EnumTypeWrapper::new);
    }

    public static String getName(Class<?> enumType, Enum<?> e, boolean cache) {
        RemappedEnumConstant c;
        String s;
        if (cache) {
            return EnumTypeWrapper.get(enumType).valueNames.getOrDefault(e, e.name());
        }
        String name = e.name();
        Enum<?> enum_ = e;
        if (enum_ instanceof RemappedEnumConstant && !(s = (c = (RemappedEnumConstant)((Object)enum_)).getRemappedEnumConstantName()).isEmpty()) {
            return s;
        }
        return name;
    }

    private EnumTypeWrapper(Class<T> enumType) {
        this.enumType = enumType;
        this.indexValues = enumType.getEnumConstants();
        this.nameValues = new HashMap<String, T>();
        this.valueNames = new HashMap<T, String>();
        for (T t : this.indexValues) {
            String name = EnumTypeWrapper.getName(enumType, (Enum)t, false).toLowerCase();
            this.nameValues.put(name, t);
            this.valueNames.put(t, name);
        }
    }

    @Override
    public T wrap(Context cx, Object o) {
        if (o instanceof CharSequence) {
            String s = o.toString().toLowerCase();
            if (s.isEmpty()) {
                return null;
            }
            T t = this.nameValues.get(s);
            if (t == null) {
                throw new IllegalArgumentException("'" + s + "' is not a valid enum constant! Valid values are: " + this.nameValues.keySet().stream().map(s1 -> "'" + s1 + "'").collect(Collectors.joining(", ")));
            }
            return t;
        }
        if (o instanceof Number) {
            int index = ((Number)o).intValue();
            if (index < 0 || index >= this.indexValues.length) {
                throw new IllegalArgumentException(index + " is not a valid enum index! Valid values are: 0 - " + (this.indexValues.length - 1));
            }
            return this.indexValues[index];
        }
        return (T)o;
    }
}

