/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib.util.wrap;

import dev.gigaherz.rhinolib.util.EnumTypeWrapper;
import dev.gigaherz.rhinolib.util.wrap.ArrayTypeWrapperFactory;
import dev.gigaherz.rhinolib.util.wrap.TypeWrapper;
import dev.gigaherz.rhinolib.util.wrap.TypeWrapperFactory;
import java.lang.reflect.Array;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TypeWrappers {
    private final Map<Class<?>, TypeWrapper<?>> wrappers = new LinkedHashMap();

    public <T> void register(Class<T> target, Predicate<Object> validator, TypeWrapperFactory<T> factory) {
        if (target == null || target == Object.class) {
            throw new IllegalArgumentException("target can't be Object.class!");
        }
        if (target.isArray()) {
            throw new IllegalArgumentException("target can't be an array!");
        }
        if (this.wrappers.containsKey(target)) {
            throw new IllegalArgumentException("Wrapper for class " + target.getName() + " already exists!");
        }
        TypeWrapper<T> typeWrapper0 = new TypeWrapper<T>(target, validator, factory);
        this.wrappers.put(target, typeWrapper0);
        Class<T[]> target1 = Array.newInstance(target, 0).getClass();
        TypeWrapper<T[]> typeWrapper1 = new TypeWrapper<T[]>(target1, validator, new ArrayTypeWrapperFactory<T>(typeWrapper0, target, target1));
        this.wrappers.put(target1, typeWrapper1);
        Class<T[]> target2 = Array.newInstance(target1, 0).getClass();
        TypeWrapper<T[]> typeWrapper2 = new TypeWrapper<T[]>(target2, validator, new ArrayTypeWrapperFactory<T[]>(typeWrapper1, target1, target2));
        this.wrappers.put(target2, typeWrapper2);
        Class<T[]> target3 = Array.newInstance(target2, 0).getClass();
        TypeWrapper<T[]> typeWrapper3 = new TypeWrapper<T[]>(target3, validator, new ArrayTypeWrapperFactory<T[]>(typeWrapper2, target2, target3));
        this.wrappers.put(target3, typeWrapper3);
    }

    public <T> void register(Class<T> target, TypeWrapperFactory<T> factory) {
        this.register(target, TypeWrapper.ALWAYS_VALID, factory);
    }

    public <T> void registerSimple(Class<T> target, Predicate<Object> validator, TypeWrapperFactory.Simple<T> factory) {
        this.register(target, validator, factory);
    }

    public <T> void registerSimple(Class<T> target, TypeWrapperFactory.Simple<T> factory) {
        this.register(target, TypeWrapper.ALWAYS_VALID, factory);
    }

    @Nullable
    public TypeWrapperFactory<?> getWrapperFactory(Class<?> target, @Nullable Object from) {
        if (target == Object.class) {
            return null;
        }
        TypeWrapper<?> wrapper = this.wrappers.get(target);
        if (wrapper != null && wrapper.validator.test(from)) {
            return wrapper.factory;
        }
        if (target.isEnum()) {
            return EnumTypeWrapper.get(target);
        }
        return null;
    }
}

