/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit;

import dev.latvian.mods.unit.FixedBooleanUnit;
import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.UnitVariables;

public final class FixedNumberUnit
extends Unit {
    public static final FixedNumberUnit ZERO = new FixedNumberUnit(0.0);
    public static final FixedNumberUnit ONE = new FixedNumberUnit(1.0);
    public static final FixedNumberUnit MINUS_ONE = new FixedNumberUnit(-1.0);
    public static final FixedNumberUnit TEN = new FixedNumberUnit(10.0);
    public static final FixedNumberUnit SIXTEEN = new FixedNumberUnit(16.0);
    public static final FixedNumberUnit PI = new FixedNumberUnit(Math.PI);
    public static final FixedNumberUnit TWO_PI = new FixedNumberUnit(Math.PI * 2);
    public static final FixedNumberUnit HALF_PI = new FixedNumberUnit(1.5707963267948966);
    public static final FixedNumberUnit E = new FixedNumberUnit(Math.E);
    public static final FixedNumberUnit NaN = new FixedNumberUnit(Double.NaN);
    public final double value;

    public static FixedNumberUnit of(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        if (value == -1.0) {
            return MINUS_ONE;
        }
        if (value == 10.0) {
            return TEN;
        }
        if (value == 16.0) {
            return SIXTEEN;
        }
        return new FixedNumberUnit(value);
    }

    private FixedNumberUnit(double value) {
        this.value = value;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public double get(UnitVariables variables) {
        return this.value;
    }

    @Override
    public boolean getBoolean(UnitVariables variables) {
        return this != ZERO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        Object object = obj;
        if (!(object instanceof FixedNumberUnit)) return false;
        FixedNumberUnit u = (FixedNumberUnit)object;
        if (this.value != u.value) return false;
        return true;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public void toString(StringBuilder builder) {
        long r = Math.round(this.value);
        if (Math.abs((double)r - this.value) < 1.0E-5) {
            builder.append(r);
        } else {
            builder.append(this.value);
        }
    }

    @Override
    public Unit negate() {
        return FixedNumberUnit.of(-this.value);
    }

    @Override
    public Unit add(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(this.value + u.value);
        } else {
            unit = super.add(other);
        }
        return unit;
    }

    @Override
    public Unit add(double value) {
        return FixedNumberUnit.of(this.value + value);
    }

    @Override
    public Unit sub(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(this.value - u.value);
        } else {
            unit = super.sub(other);
        }
        return unit;
    }

    @Override
    public Unit sub(double value) {
        return FixedNumberUnit.of(this.value - value);
    }

    @Override
    public Unit mul(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(this.value * u.value);
        } else {
            unit = super.mul(other);
        }
        return unit;
    }

    @Override
    public Unit mul(double value) {
        return FixedNumberUnit.of(this.value * value);
    }

    @Override
    public Unit div(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(this.value / u.value);
        } else {
            unit = super.div(other);
        }
        return unit;
    }

    @Override
    public Unit div(double value) {
        return FixedNumberUnit.of(this.value / value);
    }

    @Override
    public Unit mod(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(this.value % u.value);
        } else {
            unit = super.mod(other);
        }
        return unit;
    }

    @Override
    public Unit mod(double value) {
        return FixedNumberUnit.of(this.value % value);
    }

    @Override
    public Unit pow(Unit other) {
        Unit unit;
        Unit unit2 = other;
        if (unit2 instanceof FixedNumberUnit) {
            FixedNumberUnit u = (FixedNumberUnit)unit2;
            unit = FixedNumberUnit.of(Math.pow(this.value, u.value));
        } else {
            unit = super.add(other);
        }
        return unit;
    }

    @Override
    public Unit abs() {
        return FixedNumberUnit.of(Math.abs(this.value));
    }

    @Override
    public Unit sin() {
        return FixedNumberUnit.of(Math.sin(this.value));
    }

    @Override
    public Unit cos() {
        return FixedNumberUnit.of(Math.cos(this.value));
    }

    @Override
    public Unit tan() {
        return FixedNumberUnit.of(Math.tan(this.value));
    }

    @Override
    public Unit deg() {
        return FixedNumberUnit.of(Math.toDegrees(this.value));
    }

    @Override
    public Unit rad() {
        return FixedNumberUnit.of(Math.toRadians(this.value));
    }

    @Override
    public Unit atan() {
        return FixedNumberUnit.of(Math.atan(this.value));
    }

    @Override
    public Unit log() {
        return FixedNumberUnit.of(Math.log(this.value));
    }

    @Override
    public Unit log10() {
        return FixedNumberUnit.of(Math.log10(this.value));
    }

    @Override
    public Unit log1p() {
        return FixedNumberUnit.of(Math.log1p(this.value));
    }

    @Override
    public Unit sqrt() {
        return FixedNumberUnit.of(Math.sqrt(this.value));
    }

    @Override
    public Unit sq() {
        return FixedNumberUnit.of(this.value * this.value);
    }

    @Override
    public Unit floor() {
        return FixedNumberUnit.of(Math.floor(this.value));
    }

    @Override
    public Unit ceil() {
        return FixedNumberUnit.of(Math.ceil(this.value));
    }

    @Override
    public Unit bool() {
        return this == ZERO ? FixedBooleanUnit.FALSE : FixedBooleanUnit.TRUE;
    }

    @Override
    public Unit smoothstep() {
        return FixedNumberUnit.of(this.value * this.value * this.value * (this.value * (this.value * 6.0 - 15.0) + 10.0));
    }
}

