/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.unit.token;

import dev.latvian.mods.unit.Unit;
import dev.latvian.mods.unit.token.OpResultUnitToken;
import dev.latvian.mods.unit.token.UnitSymbol;
import dev.latvian.mods.unit.token.UnitToken;
import dev.latvian.mods.unit.token.UnitTokenStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public record PostfixUnitToken(List<UnitToken> infix) implements UnitToken
{
    @Override
    public Unit interpret(UnitTokenStream stream) {
        Stack<UnitSymbol> operatorsStack = new Stack<UnitSymbol>();
        LinkedList<UnitToken> postfix = new LinkedList<UnitToken>();
        for (UnitToken unitToken : this.infix) {
            UnitToken unitToken2;
            if (stream.context.isDebug()) {
                stream.context.debugInfo("> " + unitToken);
            }
            if ((unitToken2 = unitToken) instanceof UnitSymbol) {
                UnitSymbol o;
                UnitSymbol unitSymbol = (UnitSymbol)unitToken2;
                boolean pushedCurrent = false;
                while (!operatorsStack.isEmpty() && (o = (UnitSymbol)operatorsStack.peek()) != null) {
                    if (o.hasHigherPrecedenceThan(unitSymbol)) {
                        postfix.add((UnitToken)operatorsStack.pop());
                        if (!stream.context.isDebug()) continue;
                        stream.context.debugInfo("Operator Stack", operatorsStack);
                        stream.context.debugInfo("Operand Stack", postfix);
                        continue;
                    }
                    pushedCurrent = true;
                    operatorsStack.push(unitSymbol);
                    if (!stream.context.isDebug()) break;
                    stream.context.debugInfo("Operator Stack", operatorsStack);
                    stream.context.debugInfo("Operand Stack", postfix);
                    break;
                }
                if (pushedCurrent) continue;
                operatorsStack.push(unitSymbol);
                if (!stream.context.isDebug()) continue;
                stream.context.debugInfo("Operator Stack", operatorsStack);
                stream.context.debugInfo("Operand Stack", postfix);
                continue;
            }
            postfix.add(unitToken);
            if (!stream.context.isDebug()) continue;
            stream.context.debugInfo("Operator Stack", operatorsStack);
            stream.context.debugInfo("Operand Stack", postfix);
        }
        while (!operatorsStack.isEmpty()) {
            UnitSymbol last = (UnitSymbol)operatorsStack.pop();
            postfix.add(last);
        }
        if (stream.context.isDebug()) {
            stream.context.debugInfo("Postfix", postfix);
        }
        Stack<UnitToken> resultStack = new Stack<UnitToken>();
        for (UnitToken unitToken : postfix) {
            unitToken.unstack(resultStack);
            if (!stream.context.isDebug()) continue;
            stream.context.debugInfo("Result Stack", resultStack);
        }
        UnitToken unitToken = (UnitToken)resultStack.pop();
        return unitToken.interpret(stream);
    }

    public UnitToken normalize() {
        UnitToken unitToken;
        if (this.infix.size() == 1) {
            return this.infix.get(0);
        }
        if (this.infix.size() == 3 && (unitToken = this.infix.get(1)) instanceof UnitSymbol) {
            UnitSymbol symbol = (UnitSymbol)unitToken;
            if (symbol.op != null) {
                return new OpResultUnitToken(symbol, this.infix.get(0), this.infix.get(2));
            }
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int i = 0; i < this.infix.size(); ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(this.infix.get(i));
        }
        sb.append(')');
        return sb.toString();
    }
}

