/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.BaseFunction;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Undefined;

public class CustomFunction
extends BaseFunction {
    public static final Class<?>[] NO_ARGS = new Class[0];
    private final String functionName;
    private final Func func;
    private final Class<?>[] argTypes;

    public CustomFunction(String functionName, Func func, Class<?>[] argTypes) {
        this.functionName = functionName;
        this.func = func;
        this.argTypes = argTypes;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object[] origArgs = args;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Object coerced = Context.jsToJava(cx, arg, this.argTypes[i]);
            if (coerced == arg) continue;
            if (origArgs == args) {
                args = (Object[])args.clone();
            }
            args[i] = coerced;
        }
        Object retval = this.func.call(cx, args);
        if (retval == null) {
            return Undefined.instance;
        }
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, retval, retval.getClass());
        if (wrapped == null) {
            wrapped = Undefined.instance;
        }
        return wrapped;
    }

    @FunctionalInterface
    public static interface Func {
        public Object call(Context var1, Object[] var2);
    }

    @FunctionalInterface
    public static interface NoArgFunc
    extends Func {
        public Object call(Context var1);

        @Override
        default public Object call(Context cx, Object[] args) {
            return this.call(cx);
        }
    }
}

