/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.CompilerEnvirons;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.ErrorReporter;
import dev.gigaherz.rhinolib.Kit;
import dev.gigaherz.rhinolib.Node;
import dev.gigaherz.rhinolib.Parser;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.ast.ArrayComprehension;
import dev.gigaherz.rhinolib.ast.ArrayComprehensionLoop;
import dev.gigaherz.rhinolib.ast.ArrayLiteral;
import dev.gigaherz.rhinolib.ast.Assignment;
import dev.gigaherz.rhinolib.ast.AstNode;
import dev.gigaherz.rhinolib.ast.AstRoot;
import dev.gigaherz.rhinolib.ast.AstSymbol;
import dev.gigaherz.rhinolib.ast.Block;
import dev.gigaherz.rhinolib.ast.CatchClause;
import dev.gigaherz.rhinolib.ast.ConditionalExpression;
import dev.gigaherz.rhinolib.ast.ContinueStatement;
import dev.gigaherz.rhinolib.ast.DestructuringForm;
import dev.gigaherz.rhinolib.ast.DoLoop;
import dev.gigaherz.rhinolib.ast.ElementGet;
import dev.gigaherz.rhinolib.ast.EmptyExpression;
import dev.gigaherz.rhinolib.ast.ExpressionStatement;
import dev.gigaherz.rhinolib.ast.ForInLoop;
import dev.gigaherz.rhinolib.ast.ForLoop;
import dev.gigaherz.rhinolib.ast.FunctionCall;
import dev.gigaherz.rhinolib.ast.FunctionNode;
import dev.gigaherz.rhinolib.ast.GeneratorExpression;
import dev.gigaherz.rhinolib.ast.GeneratorExpressionLoop;
import dev.gigaherz.rhinolib.ast.IfStatement;
import dev.gigaherz.rhinolib.ast.InfixExpression;
import dev.gigaherz.rhinolib.ast.Jump;
import dev.gigaherz.rhinolib.ast.Label;
import dev.gigaherz.rhinolib.ast.LabeledStatement;
import dev.gigaherz.rhinolib.ast.LetNode;
import dev.gigaherz.rhinolib.ast.Name;
import dev.gigaherz.rhinolib.ast.NewExpression;
import dev.gigaherz.rhinolib.ast.NumberLiteral;
import dev.gigaherz.rhinolib.ast.ObjectLiteral;
import dev.gigaherz.rhinolib.ast.ObjectProperty;
import dev.gigaherz.rhinolib.ast.ParenthesizedExpression;
import dev.gigaherz.rhinolib.ast.PropertyGet;
import dev.gigaherz.rhinolib.ast.RegExpLiteral;
import dev.gigaherz.rhinolib.ast.ReturnStatement;
import dev.gigaherz.rhinolib.ast.Scope;
import dev.gigaherz.rhinolib.ast.ScriptNode;
import dev.gigaherz.rhinolib.ast.StringLiteral;
import dev.gigaherz.rhinolib.ast.SwitchCase;
import dev.gigaherz.rhinolib.ast.SwitchStatement;
import dev.gigaherz.rhinolib.ast.TaggedTemplateLiteral;
import dev.gigaherz.rhinolib.ast.TemplateCharacters;
import dev.gigaherz.rhinolib.ast.TemplateLiteral;
import dev.gigaherz.rhinolib.ast.ThrowStatement;
import dev.gigaherz.rhinolib.ast.TryStatement;
import dev.gigaherz.rhinolib.ast.UnaryExpression;
import dev.gigaherz.rhinolib.ast.VariableDeclaration;
import dev.gigaherz.rhinolib.ast.VariableInitializer;
import dev.gigaherz.rhinolib.ast.WhileLoop;
import dev.gigaherz.rhinolib.ast.WithStatement;
import dev.gigaherz.rhinolib.ast.Yield;
import java.util.ArrayList;
import java.util.List;

public final class IRFactory
extends Parser {
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    private static void addSwitchCase(Node switchBlock, Node caseExpression, Node statements) {
        if (switchBlock.getType() != 130) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 115) {
            throw Kit.codeBug();
        }
        Node gotoTarget = Node.newTarget();
        if (caseExpression != null) {
            Jump caseNode = new Jump(116, caseExpression);
            caseNode.target = gotoTarget;
            switchNode.addChildToBack(caseNode);
        } else {
            switchNode.setDefault(gotoTarget);
        }
        switchBlock.addChildToBack(gotoTarget);
        switchBlock.addChildToBack(statements);
    }

    private static void closeSwitch(Node switchBlock) {
        Node switchBreakTarget;
        if (switchBlock.getType() != 130) {
            throw Kit.codeBug();
        }
        Jump switchNode = (Jump)switchBlock.getFirstChild();
        if (switchNode.getType() != 115) {
            throw Kit.codeBug();
        }
        switchNode.target = switchBreakTarget = Node.newTarget();
        Node defaultTarget = switchNode.getDefault();
        if (defaultTarget == null) {
            defaultTarget = switchBreakTarget;
        }
        switchBlock.addChildAfter(IRFactory.makeJump(5, defaultTarget), switchNode);
        switchBlock.addChildToBack(switchBreakTarget);
    }

    private static Node createExprStatementNoReturn(Node expr, int lineno) {
        return new Node(134, expr, lineno);
    }

    private static Node createString(String string) {
        return Node.newString(string);
    }

    private static Node initFunction(FunctionNode fnNode, int functionIndex, Node statements, int functionType) {
        Node lastStmt;
        Name name;
        fnNode.setFunctionType(functionType);
        fnNode.addChildToBack(statements);
        int functionCount = fnNode.getFunctionCount();
        if (functionCount != 0) {
            fnNode.setRequiresActivation();
        }
        if (functionType == 2 && (name = fnNode.getFunctionName()) != null && name.length() != 0 && fnNode.getSymbol(name.getIdentifier()) == null) {
            fnNode.putSymbol(new AstSymbol(110, name.getIdentifier()));
            Node setFn = new Node(134, new Node(8, Node.newString(49, name.getIdentifier()), new Node(64)));
            statements.addChildrenToFront(setFn);
        }
        if ((lastStmt = statements.getLastChild()) == null || lastStmt.getType() != 4) {
            statements.addChildToBack(new Node(4));
        }
        Node result = Node.newString(110, fnNode.getName());
        result.putIntProp(1, functionIndex);
        return result;
    }

    private static Node createFor(Scope loop, Node init, Node test, Node incr, Node body) {
        if (init.getType() == 154) {
            Scope let = Scope.splitScope(loop);
            let.setType(154);
            let.addChildrenToBack(init);
            let.addChildToBack(IRFactory.createLoop(loop, 2, body, test, new Node(129), incr));
            return let;
        }
        return IRFactory.createLoop(loop, 2, body, test, init, incr);
    }

    private static Node createLoop(Jump loop, int loopType, Node body, Node cond, Node init, Node incr) {
        Node bodyTarget = Node.newTarget();
        Node condTarget = Node.newTarget();
        if (loopType == 2 && cond.getType() == 129) {
            cond = new Node(45);
        }
        Jump IFEQ = new Jump(6, cond);
        IFEQ.target = bodyTarget;
        Node breakTarget = Node.newTarget();
        loop.addChildToBack(bodyTarget);
        loop.addChildrenToBack(body);
        if (loopType == 1 || loopType == 2) {
            loop.addChildrenToBack(new Node(129, loop.getLineno()));
        }
        loop.addChildToBack(condTarget);
        loop.addChildToBack(IFEQ);
        loop.addChildToBack(breakTarget);
        loop.target = breakTarget;
        Node continueTarget = condTarget;
        if (loopType == 1 || loopType == 2) {
            loop.addChildToFront(IRFactory.makeJump(5, condTarget));
            if (loopType == 2) {
                int initType = init.getType();
                if (initType != 129) {
                    if (initType != 123 && initType != 154) {
                        init = new Node(134, init);
                    }
                    loop.addChildToFront(init);
                }
                Node incrTarget = Node.newTarget();
                loop.addChildAfter(incrTarget, body);
                if (incr.getType() != 129) {
                    incr = new Node(134, incr);
                    loop.addChildAfter(incr, incrTarget);
                }
                continueTarget = incrTarget;
            }
        }
        loop.setContinue(continueTarget);
        return loop;
    }

    private static Node createIf(Node cond, Node ifTrue, Node ifFalse, int lineno) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            if (ifFalse != null) {
                return ifFalse;
            }
            return new Node(130, lineno);
        }
        Node result = new Node(130, lineno);
        Node ifNotTarget = Node.newTarget();
        Jump IFNE = new Jump(7, cond);
        IFNE.target = ifNotTarget;
        result.addChildToBack(IFNE);
        result.addChildrenToBack(ifTrue);
        if (ifFalse != null) {
            Node endTarget = Node.newTarget();
            result.addChildToBack(IRFactory.makeJump(5, endTarget));
            result.addChildToBack(ifNotTarget);
            result.addChildrenToBack(ifFalse);
            result.addChildToBack(endTarget);
        } else {
            result.addChildToBack(ifNotTarget);
        }
        return result;
    }

    private static Node createCondExpr(Node cond, Node ifTrue, Node ifFalse) {
        int condStatus = IRFactory.isAlwaysDefinedBoolean(cond);
        if (condStatus == 1) {
            return ifTrue;
        }
        if (condStatus == -1) {
            return ifFalse;
        }
        return new Node(103, cond, ifTrue, ifFalse);
    }

    private static Node createUnary(int nodeType, Node child) {
        int childType = child.getType();
        switch (nodeType) {
            case 31: {
                Node n;
                if (childType == 39) {
                    child.setType(49);
                    Node left = child;
                    Node right = Node.newString(child.getString());
                    n = new Node(nodeType, left, right);
                } else if (childType == 33 || childType == 36) {
                    Node left = child.getFirstChild();
                    Node right = child.getLastChild();
                    child.removeChild(left);
                    child.removeChild(right);
                    n = new Node(nodeType, left, right);
                } else if (childType == 68) {
                    Node ref = child.getFirstChild();
                    child.removeChild(ref);
                    n = new Node(70, ref);
                } else {
                    n = new Node(nodeType, new Node(45), child);
                }
                return n;
            }
            case 32: {
                if (childType != 39) break;
                child.setType(138);
                return child;
            }
            case 27: {
                if (childType != 40) break;
                int value = ScriptRuntime.toInt32(child.getDouble());
                child.setDouble(~value);
                return child;
            }
            case 29: {
                if (childType != 40) break;
                child.setDouble(-child.getDouble());
                return child;
            }
            case 26: {
                int status = IRFactory.isAlwaysDefinedBoolean(child);
                if (status == 0) break;
                int type = status == 1 ? 44 : 45;
                if (childType == 45 || childType == 44) {
                    child.setType(type);
                    return child;
                }
                return new Node(type);
            }
        }
        return new Node(nodeType, child);
    }

    private static Node createIncDec(int nodeType, boolean post, Node child) {
        child = IRFactory.makeReference(child);
        int childType = child.getType();
        switch (childType) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                Node n = new Node(nodeType, child);
                int incrDecrMask = 0;
                if (nodeType == 108) {
                    incrDecrMask |= 1;
                }
                if (post) {
                    incrDecrMask |= 2;
                }
                n.putIntProp(13, incrDecrMask);
                return n;
            }
        }
        throw Kit.codeBug();
    }

    private static Node createBinary(int nodeType, Node left, Node right, Context cx) {
        switch (nodeType) {
            case 21: {
                if (left.type == 41) {
                    String s2;
                    if (right.type == 41) {
                        s2 = right.getString();
                    } else {
                        if (right.type != 40) break;
                        s2 = ScriptRuntime.numberToString(cx, right.getDouble(), 10);
                    }
                    String s1 = left.getString();
                    left.setString(s1.concat(s2));
                    return left;
                }
                if (left.type != 40) break;
                if (right.type == 40) {
                    left.setDouble(left.getDouble() + right.getDouble());
                    return left;
                }
                if (right.type != 41) break;
                String s1 = ScriptRuntime.numberToString(cx, left.getDouble(), 10);
                String s2 = right.getString();
                right.setString(s1.concat(s2));
                return right;
            }
            case 22: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld - right.getDouble());
                        return left;
                    }
                    if (ld != 0.0) break;
                    return new Node(29, right);
                }
                if (right.type != 40 || right.getDouble() != 0.0) break;
                return new Node(28, left);
            }
            case 23: {
                if (left.type == 40) {
                    double ld = left.getDouble();
                    if (right.type == 40) {
                        left.setDouble(ld * right.getDouble());
                        return left;
                    }
                    if (ld != 1.0) break;
                    return new Node(28, right);
                }
                if (right.type != 40 || right.getDouble() != 1.0) break;
                return new Node(28, left);
            }
            case 24: {
                if (right.type != 40) break;
                double rd = right.getDouble();
                if (left.type == 40) {
                    left.setDouble(left.getDouble() / rd);
                    return left;
                }
                if (rd != 1.0) break;
                return new Node(28, left);
            }
            case 106: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == -1) {
                    return left;
                }
                if (leftStatus != 1) break;
                return right;
            }
            case 105: {
                int leftStatus = IRFactory.isAlwaysDefinedBoolean(left);
                if (leftStatus == 1) {
                    return left;
                }
                if (leftStatus != -1) break;
                return right;
            }
        }
        return new Node(nodeType, left, right);
    }

    private static Node createUseLocal(Node localBlock) {
        if (142 != localBlock.getType()) {
            throw Kit.codeBug();
        }
        Node result = new Node(54);
        result.putProp(3, localBlock);
        return result;
    }

    private static Jump makeJump(int type, Node target) {
        Jump n = new Jump(type);
        n.target = target;
        return n;
    }

    private static Node makeReference(Node node) {
        int type = node.getType();
        switch (type) {
            case 33: 
            case 36: 
            case 39: 
            case 68: {
                return node;
            }
            case 38: {
                node.setType(71);
                return new Node(68, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double num = node.getDouble();
                if (!Double.isNaN(num) && num != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    public IRFactory(Context cx) {
        super(cx);
    }

    public IRFactory(Context cx, CompilerEnvirons env) {
        this(cx, env, env.getErrorReporter());
    }

    public IRFactory(Context cx, CompilerEnvirons env, ErrorReporter errorReporter) {
        super(cx, env, errorReporter);
    }

    public ScriptNode transformTree(AstRoot root) {
        this.currentScriptOrFn = root;
        this.inUseStrictDirective = root.isInStrictMode();
        return (ScriptNode)this.transform(root);
    }

    public Node transform(AstNode node) {
        return switch (node.getType()) {
            case 39, 40, 42, 43, 44, 45, 121, 129, 162 -> node;
            case 158 -> this.transformArrayComp((ArrayComprehension)node);
            case 66 -> this.transformArrayLiteral((ArrayLiteral)node);
            case 130 -> this.transformBlock(node);
            case 38 -> this.transformFunctionCall((FunctionCall)node);
            case 122 -> this.transformContinue((ContinueStatement)node);
            case 119 -> this.transformDoLoop((DoLoop)node);
            case 120 -> {
                if (node instanceof ForInLoop) {
                    yield this.transformForInLoop((ForInLoop)node);
                }
                yield this.transformForLoop((ForLoop)node);
            }
            case 110 -> this.transformFunction((FunctionNode)node);
            case 163 -> this.transformGenExpr((GeneratorExpression)node);
            case 36 -> this.transformElementGet((ElementGet)node);
            case 33 -> this.transformPropertyGet((PropertyGet)node);
            case 103 -> this.transformCondExpr((ConditionalExpression)node);
            case 113 -> this.transformIf((IfStatement)node);
            case 30 -> this.transformNewExpr((NewExpression)node);
            case 67 -> this.transformObjectLiteral((ObjectLiteral)node);
            case 167 -> this.transformTemplateLiteral((TemplateLiteral)node);
            case 170 -> this.transformTemplateLiteralCall((TaggedTemplateLiteral)node);
            case 48 -> this.transformRegExp((RegExpLiteral)node);
            case 4 -> this.transformReturn((ReturnStatement)node);
            case 137 -> this.transformScript((ScriptNode)node);
            case 41 -> this.transformString((StringLiteral)node);
            case 115 -> this.transformSwitch((SwitchStatement)node);
            case 50 -> this.transformThrow((ThrowStatement)node);
            case 82 -> this.transformTry((TryStatement)node);
            case 118 -> this.transformWhileLoop((WhileLoop)node);
            case 124 -> this.transformWith((WithStatement)node);
            case 73, 166 -> this.transformYield((Yield)node);
            default -> {
                AstNode var10_2 = node;
                if (var10_2 instanceof ExpressionStatement) {
                    ExpressionStatement n = (ExpressionStatement)var10_2;
                    yield this.transformExprStmt(n);
                }
                var10_2 = node;
                if (var10_2 instanceof Assignment) {
                    Assignment n = (Assignment)var10_2;
                    yield this.transformAssignment(n);
                }
                var10_2 = node;
                if (var10_2 instanceof UnaryExpression) {
                    UnaryExpression n = (UnaryExpression)var10_2;
                    yield this.transformUnary(n);
                }
                var10_2 = node;
                if (var10_2 instanceof InfixExpression) {
                    InfixExpression n = (InfixExpression)var10_2;
                    yield this.transformInfix(n);
                }
                var10_2 = node;
                if (var10_2 instanceof VariableDeclaration) {
                    VariableDeclaration n = (VariableDeclaration)var10_2;
                    yield this.transformVariables(n);
                }
                var10_2 = node;
                if (var10_2 instanceof ParenthesizedExpression) {
                    ParenthesizedExpression n = (ParenthesizedExpression)var10_2;
                    yield this.transformParenExpr(n);
                }
                var10_2 = node;
                if (var10_2 instanceof LabeledStatement) {
                    LabeledStatement n = (LabeledStatement)var10_2;
                    yield this.transformLabeledStatement(n);
                }
                var10_2 = node;
                if (var10_2 instanceof LetNode) {
                    LetNode n = (LetNode)var10_2;
                    yield this.transformLetNode(n);
                }
                throw new IllegalArgumentException("Can't transform: " + node + " (" + node.getClass().getName() + ")");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformArrayComp(ArrayComprehension node) {
        int lineno = node.getLineno();
        Scope scopeNode = this.createScopeNode(158, lineno);
        String arrayName = this.currentScriptOrFn.getNextTempName();
        this.pushScope(scopeNode);
        try {
            this.defineSymbol(154, arrayName);
            Node block = new Node(130, lineno);
            Node newArray = this.createCallOrNew(30, this.createName("Array"));
            Node init = new Node(134, this.createAssignment(91, this.createName(arrayName), newArray), lineno);
            block.addChildToBack(init);
            block.addChildToBack(this.arrayCompTransformHelper(node, arrayName));
            scopeNode.addChildToBack(block);
            scopeNode.addChildToBack(this.createName(arrayName));
            Scope scope = scopeNode;
            return scope;
        }
        finally {
            this.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node arrayCompTransformHelper(ArrayComprehension node, String arrayName) {
        int i;
        int lineno = node.getLineno();
        Node expr = this.transform(node.getResult());
        List<ArrayComprehensionLoop> loops = node.getLoops();
        int numLoops = loops.size();
        Node[] iterators = new Node[numLoops];
        Node[] iteratedObjs = new Node[numLoops];
        for (int i2 = 0; i2 < numLoops; ++i2) {
            String name;
            ArrayComprehensionLoop acl = loops.get(i2);
            AstNode iter = acl.getIterator();
            if (iter.getType() == 39) {
                name = iter.getString();
            } else {
                name = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(88, name);
                expr = IRFactory.createBinary(90, this.createAssignment(91, iter, this.createName(name)), expr, this.cx);
            }
            Node init = this.createName(name);
            this.defineSymbol(154, name);
            iterators[i2] = init;
            iteratedObjs[i2] = this.transform(acl.getIteratedObject());
        }
        Node call = this.createCallOrNew(38, this.createPropertyGet(this.createName(arrayName), null, "push", 0));
        Node body = new Node(134, call, lineno);
        if (node.getFilter() != null) {
            body = IRFactory.createIf(this.transform(node.getFilter()), body, null, lineno);
        }
        int pushed = 0;
        try {
            for (i = numLoops - 1; i >= 0; --i) {
                ArrayComprehensionLoop acl = loops.get(i);
                Scope loop = this.createLoopNode(null, acl.getLineno());
                this.pushScope(loop);
                ++pushed;
                body = this.createForIn(154, loop, iterators[i], iteratedObjs[i], body, acl.isForEach(), acl.isForOf());
            }
        }
        finally {
            for (i = 0; i < pushed; ++i) {
                this.popScope();
            }
        }
        call.addChildToBack(expr);
        return body;
    }

    private Node transformArrayLiteral(ArrayLiteral node) {
        if (node.isDestructuring()) {
            return node;
        }
        List<AstNode> elems = node.getElements();
        Node array = new Node(66);
        ArrayList<Integer> skipIndexes = null;
        for (int i = 0; i < elems.size(); ++i) {
            AstNode elem = elems.get(i);
            if (elem.getType() != 129) {
                array.addChildToBack(this.transform(elem));
                continue;
            }
            if (skipIndexes == null) {
                skipIndexes = new ArrayList<Integer>();
            }
            skipIndexes.add(i);
        }
        array.putIntProp(21, node.getDestructuringLength());
        if (skipIndexes != null) {
            int[] skips = new int[skipIndexes.size()];
            for (int i = 0; i < skipIndexes.size(); ++i) {
                skips[i] = (Integer)skipIndexes.get(i);
            }
            array.putProp(11, skips);
        }
        return array;
    }

    private Node transformAssignment(Assignment node) {
        AstNode left = this.removeParens(node.getLeft());
        Node target = this.isDestructuring(left) ? left : this.transform(left);
        return this.createAssignment(node.getType(), target, this.transform(node.getRight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformBlock(AstNode node) {
        if (node instanceof Scope) {
            this.pushScope((Scope)node);
        }
        try {
            ArrayList<Node> kids = new ArrayList<Node>();
            for (Node kid : node) {
                kids.add(this.transform((AstNode)kid));
            }
            node.removeChildren();
            for (Node kid : kids) {
                node.addChildToBack(kid);
            }
            AstNode astNode = node;
            return astNode;
        }
        finally {
            if (node instanceof Scope) {
                this.popScope();
            }
        }
    }

    private Node transformCondExpr(ConditionalExpression node) {
        Node test = this.transform(node.getTestExpression());
        Node ifTrue = this.transform(node.getTrueExpression());
        Node ifFalse = this.transform(node.getFalseExpression());
        return IRFactory.createCondExpr(test, ifTrue, ifFalse);
    }

    private Node transformContinue(ContinueStatement node) {
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformDoLoop(DoLoop loop) {
        loop.setType(133);
        this.pushScope(loop);
        try {
            Node body = this.transform(loop.getBody());
            Node cond = this.transform(loop.getCondition());
            Node node = IRFactory.createLoop(loop, 0, body, cond, null, null);
            return node;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformElementGet(ElementGet node) {
        Node target = this.transform(node.getTarget());
        Node element = this.transform(node.getElement());
        return new Node(36, target, element);
    }

    private Node transformExprStmt(ExpressionStatement node) {
        Node expr = this.transform(node.getExpression());
        return new Node(node.getType(), expr, node.getLineno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForInLoop(ForInLoop loop) {
        loop.setType(133);
        this.pushScope(loop);
        try {
            int declType = -1;
            AstNode iter = loop.getIterator();
            if (iter instanceof VariableDeclaration) {
                declType = iter.getType();
            }
            Node lhs = this.transform(iter);
            Node obj = this.transform(loop.getIteratedObject());
            Node body = this.transform(loop.getBody());
            Node node = this.createForIn(declType, loop, lhs, obj, body, loop.isForEach(), loop.isForOf());
            return node;
        }
        finally {
            this.popScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformForLoop(ForLoop loop) {
        loop.setType(133);
        Scope savedScope = this.currentScope;
        this.currentScope = loop;
        try {
            Node init = this.transform(loop.getInitializer());
            Node test = this.transform(loop.getCondition());
            Node incr = this.transform(loop.getIncrement());
            Node body = this.transform(loop.getBody());
            Node node = IRFactory.createFor(loop, init, test, incr, body);
            return node;
        }
        finally {
            this.currentScope = savedScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformFunction(FunctionNode fn) {
        int index = this.currentScriptOrFn.addFunction(fn);
        Parser.PerFunctionVariables savedVars = new Parser.PerFunctionVariables(this, fn);
        try {
            Node pn;
            Node destructuring = (Node)fn.getProp(23);
            fn.removeProp(23);
            int lineno = fn.getBody().getLineno();
            ++this.nestingOfFunction;
            Node body = this.transform(fn.getBody());
            if (destructuring != null) {
                body.addChildToFront(new Node(134, destructuring, lineno));
            }
            int syntheticType = fn.getFunctionType();
            Node node = pn = IRFactory.initFunction(fn, index, body, syntheticType);
            return node;
        }
        finally {
            --this.nestingOfFunction;
            savedVars.restore();
        }
    }

    private Node transformFunctionCall(FunctionCall node) {
        Node call = this.createCallOrNew(38, this.transform(node.getTarget()));
        call.setLineno(node.getLineno());
        List<AstNode> args = node.getArguments();
        for (AstNode arg : args) {
            call.addChildToBack(this.transform(arg));
        }
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformGenExpr(GeneratorExpression node) {
        Node pn;
        FunctionNode fn = new FunctionNode();
        fn.setSourceName(this.currentScriptOrFn.getNextTempName());
        fn.setIsGenerator();
        fn.setFunctionType(2);
        fn.setRequiresActivation();
        int index = this.currentScriptOrFn.addFunction(fn);
        Parser.PerFunctionVariables savedVars = new Parser.PerFunctionVariables(this, fn);
        try {
            Node destructuring = (Node)fn.getProp(23);
            fn.removeProp(23);
            int lineno = node.lineno;
            ++this.nestingOfFunction;
            Node body = this.genExprTransformHelper(node);
            if (destructuring != null) {
                body.addChildToFront(new Node(134, destructuring, lineno));
            }
            int syntheticType = fn.getFunctionType();
            pn = IRFactory.initFunction(fn, index, body, syntheticType);
        }
        finally {
            --this.nestingOfFunction;
            savedVars.restore();
        }
        Node call = this.createCallOrNew(38, pn);
        call.setLineno(node.getLineno());
        return call;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node genExprTransformHelper(GeneratorExpression node) {
        int i;
        int lineno = node.getLineno();
        Node expr = this.transform(node.getResult());
        List<GeneratorExpressionLoop> loops = node.getLoops();
        int numLoops = loops.size();
        Node[] iterators = new Node[numLoops];
        Node[] iteratedObjs = new Node[numLoops];
        for (int i2 = 0; i2 < numLoops; ++i2) {
            String name;
            GeneratorExpressionLoop acl = loops.get(i2);
            AstNode iter = acl.getIterator();
            if (iter.getType() == 39) {
                name = iter.getString();
            } else {
                name = this.currentScriptOrFn.getNextTempName();
                this.defineSymbol(88, name);
                expr = IRFactory.createBinary(90, this.createAssignment(91, iter, this.createName(name)), expr, this.cx);
            }
            Node init = this.createName(name);
            this.defineSymbol(154, name);
            iterators[i2] = init;
            iteratedObjs[i2] = this.transform(acl.getIteratedObject());
        }
        Node yield = new Node(73, expr, node.getLineno());
        Node body = new Node(134, yield, lineno);
        if (node.getFilter() != null) {
            body = IRFactory.createIf(this.transform(node.getFilter()), body, null, lineno);
        }
        int pushed = 0;
        try {
            for (i = numLoops - 1; i >= 0; --i) {
                GeneratorExpressionLoop acl = loops.get(i);
                Scope loop = this.createLoopNode(null, acl.getLineno());
                this.pushScope(loop);
                ++pushed;
                body = this.createForIn(154, loop, iterators[i], iteratedObjs[i], body, acl.isForEach(), acl.isForOf());
            }
        }
        finally {
            for (i = 0; i < pushed; ++i) {
                this.popScope();
            }
        }
        return body;
    }

    private Node transformIf(IfStatement n) {
        Node cond = this.transform(n.getCondition());
        Node ifTrue = this.transform(n.getThenPart());
        Node ifFalse = null;
        if (n.getElsePart() != null) {
            ifFalse = this.transform(n.getElsePart());
        }
        return IRFactory.createIf(cond, ifTrue, ifFalse, n.getLineno());
    }

    private Node transformInfix(InfixExpression node) {
        Node left = this.transform(node.getLeft());
        Node right = this.transform(node.getRight());
        return IRFactory.createBinary(node.getType(), left, right, this.cx);
    }

    private Node transformLabeledStatement(LabeledStatement ls) {
        Label label = ls.getFirstLabel();
        Node statement = this.transform(ls.getStatement());
        Node breakTarget = Node.newTarget();
        Node block = new Node(130, (Node)label, statement, breakTarget);
        label.target = breakTarget;
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformLetNode(LetNode node) {
        this.pushScope(node);
        try {
            Node vars = this.transformVariableInitializers(node.getVariables());
            node.addChildToBack(vars);
            if (node.getBody() != null) {
                node.addChildToBack(this.transform(node.getBody()));
            }
            LetNode letNode = node;
            return letNode;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformNewExpr(NewExpression node) {
        Node nx = this.createCallOrNew(30, this.transform(node.getTarget()));
        nx.setLineno(node.getLineno());
        for (AstNode arg : node.getArguments()) {
            nx.addChildToBack(this.transform(arg));
        }
        if (node.getInitializer() != null) {
            nx.addChildToBack(this.transformObjectLiteral(node.getInitializer()));
        }
        return nx;
    }

    private Node transformObjectLiteral(ObjectLiteral node) {
        Object[] properties;
        if (node.isDestructuring()) {
            return node;
        }
        List<ObjectProperty> elems = node.getElements();
        Node object = new Node(67);
        if (elems.isEmpty()) {
            properties = ScriptRuntime.EMPTY_OBJECTS;
        } else {
            int size = elems.size();
            int i = 0;
            properties = new Object[size];
            for (ObjectProperty prop : elems) {
                properties[i++] = this.getPropKey(prop.getLeft());
                Node right = this.transform(prop.getRight());
                if (prop.isGetterMethod()) {
                    right = IRFactory.createUnary(152, right);
                } else if (prop.isSetterMethod()) {
                    right = IRFactory.createUnary(153, right);
                } else if (prop.isNormalMethod()) {
                    right = IRFactory.createUnary(164, right);
                }
                object.addChildToBack(right);
            }
        }
        object.putProp(12, properties);
        return object;
    }

    private Object getPropKey(Node id) {
        Object key;
        if (id instanceof Name) {
            String s = ((Name)id).getIdentifier();
            key = ScriptRuntime.getIndexObject(s);
        } else if (id instanceof StringLiteral) {
            String s = ((StringLiteral)id).getValue();
            key = ScriptRuntime.getIndexObject(s);
        } else if (id instanceof NumberLiteral) {
            double n = ((NumberLiteral)id).getNumber();
            key = ScriptRuntime.getIndexObject(this.cx, n);
        } else {
            throw Kit.codeBug();
        }
        return key;
    }

    private Node transformParenExpr(ParenthesizedExpression node) {
        AstNode expr = node.getExpression();
        while (expr instanceof ParenthesizedExpression) {
            expr = ((ParenthesizedExpression)expr).getExpression();
        }
        Node result = this.transform(expr);
        result.putProp(19, Boolean.TRUE);
        return result;
    }

    private Node transformPropertyGet(PropertyGet node) {
        Node target = this.transform(node.getTarget());
        String name = node.getProperty().getIdentifier();
        return this.createPropertyGet(target, null, name, 0);
    }

    private Node transformTemplateLiteral(TemplateLiteral node) {
        List<AstNode> elems = node.getElements();
        Node pn = Node.newString("");
        for (AstNode elem : elems) {
            if (elem.getType() != 168) {
                pn = IRFactory.createBinary(21, pn, this.transform(elem), this.cx);
                continue;
            }
            TemplateCharacters chars = (TemplateCharacters)elem;
            String value = chars.getValue();
            if (value.length() <= 0) continue;
            pn = IRFactory.createBinary(21, pn, Node.newString(value), this.cx);
        }
        return pn;
    }

    private Node transformTemplateLiteralCall(TaggedTemplateLiteral node) {
        Node call = this.createCallOrNew(38, this.transform(node.getTarget()));
        call.setLineno(node.getLineno());
        TemplateLiteral templateLiteral = (TemplateLiteral)node.getTemplateLiteral();
        List<AstNode> elems = templateLiteral.getElements();
        call.addChildToBack(templateLiteral);
        for (AstNode elem : elems) {
            if (elem.getType() != 168) {
                call.addChildToBack(this.transform(elem));
                continue;
            }
            TemplateCharacters templateCharacters = (TemplateCharacters)elem;
        }
        this.currentScriptOrFn.addTemplateLiteral(templateLiteral);
        return call;
    }

    private Node transformRegExp(RegExpLiteral node) {
        this.currentScriptOrFn.addRegExp(node);
        return node;
    }

    private Node transformReturn(ReturnStatement node) {
        AstNode rv = node.getReturnValue();
        Node value = rv == null ? null : this.transform(rv);
        return rv == null ? new Node(4, node.getLineno()) : new Node(4, value, node.getLineno());
    }

    private Node transformScript(ScriptNode node) {
        if (this.currentScope != null) {
            Kit.codeBug();
        }
        this.currentScope = node;
        Node body = new Node(130);
        for (Node kid : node) {
            body.addChildToBack(this.transform((AstNode)kid));
        }
        node.removeChildren();
        Node children = body.getFirstChild();
        if (children != null) {
            node.addChildrenToBack(children);
        }
        return node;
    }

    private Node transformString(StringLiteral node) {
        return Node.newString(node.getValue());
    }

    private Node transformSwitch(SwitchStatement node) {
        Node switchExpr = this.transform(node.getExpression());
        node.addChildToBack(switchExpr);
        Node block = new Node(130, (Node)node, node.getLineno());
        for (SwitchCase sc : node.getCases()) {
            AstNode expr = sc.getExpression();
            Node caseExpr = null;
            if (expr != null) {
                caseExpr = this.transform(expr);
            }
            List<AstNode> stmts = sc.getStatements();
            Block body = new Block();
            if (stmts != null) {
                for (AstNode kid : stmts) {
                    body.addChildToBack(this.transform(kid));
                }
            }
            IRFactory.addSwitchCase(block, caseExpr, body);
        }
        IRFactory.closeSwitch(block);
        return block;
    }

    private Node transformThrow(ThrowStatement node) {
        Node value = this.transform(node.getExpression());
        return new Node(50, value, node.getLineno());
    }

    private Node transformTry(TryStatement node) {
        Node tryBlock = this.transform(node.getTryBlock());
        Block catchBlocks = new Block();
        for (CatchClause cc : node.getCatchClauses()) {
            String varName = cc.getVarName().getIdentifier();
            AstNode ccc = cc.getCatchCondition();
            Node catchCond = ccc != null ? this.transform(ccc) : new EmptyExpression();
            Node body = this.transform(cc.getBody());
            catchBlocks.addChildToBack(this.createCatch(varName, catchCond, body, cc.getLineno()));
        }
        Node finallyBlock = null;
        if (node.getFinallyBlock() != null) {
            finallyBlock = this.transform(node.getFinallyBlock());
        }
        return this.createTryCatchFinally(tryBlock, catchBlocks, finallyBlock, node.getLineno());
    }

    private Node transformUnary(UnaryExpression node) {
        int type = node.getType();
        Node child = this.transform(node.getOperand());
        if (type == 107 || type == 108) {
            return IRFactory.createIncDec(type, node.isPostfix(), child);
        }
        return IRFactory.createUnary(type, child);
    }

    private Node transformVariables(VariableDeclaration node) {
        this.transformVariableInitializers(node);
        AstNode parent = node.getParent();
        return node;
    }

    private Node transformVariableInitializers(VariableDeclaration node) {
        for (VariableInitializer var : node.getVariables()) {
            AstNode target = var.getTarget();
            AstNode init = var.getInitializer();
            Node left = var.isDestructuring() ? target : this.transform(target);
            Node right = null;
            if (init != null) {
                right = this.transform(init);
            }
            if (var.isDestructuring()) {
                if (right == null) {
                    node.addChildToBack(left);
                    continue;
                }
                Node d = this.createDestructuringAssignment(node.getType(), left, right);
                node.addChildToBack(d);
                continue;
            }
            if (right != null) {
                left.addChildToBack(right);
            }
            node.addChildToBack(left);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node transformWhileLoop(WhileLoop loop) {
        loop.setType(133);
        this.pushScope(loop);
        try {
            Node cond = this.transform(loop.getCondition());
            Node body = this.transform(loop.getBody());
            Node node = IRFactory.createLoop(loop, 1, body, cond, null, null);
            return node;
        }
        finally {
            this.popScope();
        }
    }

    private Node transformWith(WithStatement node) {
        Node expr = this.transform(node.getExpression());
        Node stmt = this.transform(node.getStatement());
        return this.createWith(expr, stmt, node.getLineno());
    }

    private Node transformYield(Yield node) {
        Node kid;
        Node node2 = kid = node.getValue() == null ? null : this.transform(node.getValue());
        if (kid != null) {
            return new Node(node.getType(), kid, node.getLineno());
        }
        return new Node(node.getType(), node.getLineno());
    }

    private Node createCatch(String varName, Node catchCond, Node stmts, int lineno) {
        if (catchCond == null) {
            catchCond = new Node(129);
        }
        return new Node(125, this.createName(varName), catchCond, stmts, lineno);
    }

    private Scope createLoopNode(Node loopLabel, int lineno) {
        Scope result = this.createScopeNode(133, lineno);
        if (loopLabel != null) {
            ((Jump)loopLabel).setLoop(result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node createForIn(int declType, Node loop, Node lhs, Node obj, Node body, boolean isForEach, boolean isForOf) {
        Node assign;
        Node lvalue;
        int type;
        int destructuringLen;
        int destructuring;
        block13: {
            block12: {
                destructuring = -1;
                destructuringLen = 0;
                type = lhs.getType();
                if (type != 123 && type != 154) break block12;
                Node kid = lhs.getLastChild();
                int kidType = kid.getType();
                if (kidType == 66 || kidType == 67) {
                    type = destructuring = kidType;
                    lvalue = kid;
                    if (kid instanceof ArrayLiteral) {
                        destructuringLen = ((ArrayLiteral)kid).getDestructuringLength();
                    }
                    break block13;
                } else {
                    if (kidType != 39) {
                        this.reportError("msg.bad.for.in.lhs");
                        return null;
                    }
                    lvalue = Node.newString(39, kid.getString());
                }
                break block13;
            }
            if (type == 66 || type == 67) {
                destructuring = type;
                lvalue = lhs;
                if (lhs instanceof ArrayLiteral) {
                    destructuringLen = ((ArrayLiteral)lhs).getDestructuringLength();
                }
            } else {
                lvalue = IRFactory.makeReference(lhs);
                if (lvalue == null) {
                    this.reportError("msg.bad.for.in.lhs");
                    return null;
                }
            }
        }
        Node localBlock = new Node(142);
        int initType = isForEach ? 59 : (isForOf ? 61 : (destructuring != -1 ? 60 : 58));
        Node init = new Node(initType, obj);
        init.putProp(3, localBlock);
        Node cond = new Node(62);
        cond.putProp(3, localBlock);
        Node id = new Node(63);
        id.putProp(3, localBlock);
        Node newBody = new Node(130);
        if (destructuring != -1) {
            assign = this.createDestructuringAssignment(declType, lvalue, id);
            if (!(isForEach || isForOf || destructuring != 67 && destructuringLen == 2)) {
                this.reportError("msg.bad.for.in.destruct");
            }
        } else {
            assign = this.simpleAssignment(lvalue, id);
        }
        newBody.addChildToBack(new Node(134, assign));
        newBody.addChildToBack(body);
        loop = IRFactory.createLoop((Jump)loop, 1, newBody, cond, null, null);
        loop.addChildToFront(init);
        if (type == 123 || type == 154) {
            loop.addChildToFront(lhs);
        }
        localBlock.addChildToBack(loop);
        return localBlock;
    }

    private Node createTryCatchFinally(Node tryBlock, Node catchBlocks, Node finallyBlock, int lineno) {
        boolean hasFinally;
        boolean bl = hasFinally = finallyBlock != null && (finallyBlock.getType() != 130 || finallyBlock.hasChildren());
        if (tryBlock.getType() == 130 && !tryBlock.hasChildren() && !hasFinally) {
            return tryBlock;
        }
        boolean hasCatch = catchBlocks.hasChildren();
        if (!hasFinally && !hasCatch) {
            return tryBlock;
        }
        Node handlerBlock = new Node(142);
        Jump pn = new Jump(82, tryBlock, lineno);
        pn.putProp(3, handlerBlock);
        if (hasCatch) {
            Node catchTarget;
            Node endCatch = Node.newTarget();
            pn.addChildToBack(IRFactory.makeJump(5, endCatch));
            pn.target = catchTarget = Node.newTarget();
            pn.addChildToBack(catchTarget);
            Node catchScopeBlock = new Node(142);
            Node cb = catchBlocks.getFirstChild();
            boolean hasDefault = false;
            int scopeIndex = 0;
            while (cb != null) {
                Node condStmt;
                int catchLineNo = cb.getLineno();
                Node name = cb.getFirstChild();
                Node cond = name.getNext();
                Node catchStatement = cond.getNext();
                cb.removeChild(name);
                cb.removeChild(cond);
                cb.removeChild(catchStatement);
                catchStatement.addChildToBack(new Node(3));
                catchStatement.addChildToBack(IRFactory.makeJump(5, endCatch));
                if (cond.getType() == 129) {
                    condStmt = catchStatement;
                    hasDefault = true;
                } else {
                    condStmt = IRFactory.createIf(cond, catchStatement, null, catchLineNo);
                }
                Node catchScope = new Node(57, name, IRFactory.createUseLocal(handlerBlock));
                catchScope.putProp(3, catchScopeBlock);
                catchScope.putIntProp(14, scopeIndex);
                catchScopeBlock.addChildToBack(catchScope);
                catchScopeBlock.addChildToBack(this.createWith(IRFactory.createUseLocal(catchScopeBlock), condStmt, catchLineNo));
                cb = cb.getNext();
                ++scopeIndex;
            }
            pn.addChildToBack(catchScopeBlock);
            if (!hasDefault) {
                Node rethrow = new Node(51);
                rethrow.putProp(3, handlerBlock);
                pn.addChildToBack(rethrow);
            }
            pn.addChildToBack(endCatch);
        }
        if (hasFinally) {
            Node finallyTarget = Node.newTarget();
            pn.setFinally(finallyTarget);
            pn.addChildToBack(IRFactory.makeJump(136, finallyTarget));
            Node finallyEnd = Node.newTarget();
            pn.addChildToBack(IRFactory.makeJump(5, finallyEnd));
            pn.addChildToBack(finallyTarget);
            Node fBlock = new Node(126, finallyBlock);
            fBlock.putProp(3, handlerBlock);
            pn.addChildToBack(fBlock);
            pn.addChildToBack(finallyEnd);
        }
        handlerBlock.addChildToBack(pn);
        return handlerBlock;
    }

    private Node createWith(Node obj, Node body, int lineno) {
        this.setRequiresActivation();
        Node result = new Node(130, lineno);
        result.addChildToBack(new Node(2, obj));
        Node bodyNode = new Node(124, body, lineno);
        result.addChildrenToBack(bodyNode);
        result.addChildToBack(new Node(3));
        return result;
    }

    private Node createCallOrNew(int nodeType, Node child) {
        String name;
        int type = 0;
        if (child.getType() == 39) {
            name = child.getString();
            if (name.equals("eval")) {
                type = 1;
            } else if (name.equals("With")) {
                type = 2;
            }
        } else if (child.getType() == 33 && (name = child.getLastChild().getString()).equals("eval")) {
            type = 1;
        }
        Node node = new Node(nodeType, child);
        if (type != 0) {
            this.setRequiresActivation();
            node.putIntProp(10, type);
        }
        return node;
    }

    private Node createPropertyGet(Node target, String namespace, String name, int memberTypeFlags) {
        if (namespace == null && memberTypeFlags == 0) {
            if (target == null) {
                return this.createName(name);
            }
            this.checkActivationName(name, 33);
            if (ScriptRuntime.isSpecialProperty(name)) {
                Node ref = new Node(72, target);
                ref.putProp(17, name);
                return new Node(68, ref);
            }
            return new Node(33, target, Node.newString(name));
        }
        Node elem = Node.newString(name);
        return this.createMemberRefGet(target, namespace, elem, memberTypeFlags |= 1);
    }

    private Node createMemberRefGet(Node target, String namespace, Node elem, int memberTypeFlags) {
        return new Node(68, elem);
    }

    private Node createAssignment(int assignType, Node left, Node right) {
        int assignOp;
        Node ref = IRFactory.makeReference(left);
        if (ref == null) {
            if (left.getType() == 66 || left.getType() == 67) {
                if (assignType != 91) {
                    this.reportError("msg.bad.destruct.op");
                    return right;
                }
                return this.createDestructuringAssignment(-1, left, right);
            }
            this.reportError("msg.bad.assign.left");
            return right;
        }
        left = ref;
        switch (assignType) {
            case 91: {
                return this.simpleAssignment(left, right);
            }
            case 92: {
                assignOp = 9;
                break;
            }
            case 93: {
                assignOp = 10;
                break;
            }
            case 94: {
                assignOp = 11;
                break;
            }
            case 95: {
                assignOp = 18;
                break;
            }
            case 96: {
                assignOp = 19;
                break;
            }
            case 97: {
                assignOp = 20;
                break;
            }
            case 98: {
                assignOp = 21;
                break;
            }
            case 99: {
                assignOp = 22;
                break;
            }
            case 100: {
                assignOp = 23;
                break;
            }
            case 101: {
                assignOp = 24;
                break;
            }
            case 102: {
                assignOp = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int nodeType = left.getType();
        switch (nodeType) {
            case 39: {
                Node op = new Node(assignOp, left, right);
                Node lvalueLeft = Node.newString(49, left.getString());
                return new Node(8, lvalueLeft, op);
            }
            case 33: 
            case 36: {
                Node obj = left.getFirstChild();
                Node id = left.getLastChild();
                int type = nodeType == 33 ? 140 : 141;
                Node opLeft = new Node(139);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(type, obj, id, op);
            }
            case 68: {
                ref = left.getFirstChild();
                this.checkMutableReference(ref);
                Node opLeft = new Node(139);
                Node op = new Node(assignOp, opLeft, right);
                return new Node(143, ref, op);
            }
        }
        throw Kit.codeBug();
    }

    boolean isDestructuring(Node n) {
        return n instanceof DestructuringForm && ((DestructuringForm)((Object)n)).isDestructuring();
    }
}

