/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.Kit;
import dev.gigaherz.rhinolib.RhinoException;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import java.lang.reflect.InvocationTargetException;

public final class LazilyLoadedCtor {
    private static final int STATE_BEFORE_INIT = 0;
    private static final int STATE_INITIALIZING = 1;
    private static final int STATE_WITH_VALUE = 2;
    private final ScriptableObject scope;
    private final String propertyName;
    private final String className;
    private final boolean sealed;
    private final boolean privileged;
    private Object initializedValue;
    private int state;

    private static Class<? extends Scriptable> cast(Class<?> cl) {
        return cl;
    }

    public LazilyLoadedCtor(ScriptableObject scope, String propertyName, String className, boolean sealed, Context cx) {
        this(scope, propertyName, className, sealed, false, cx);
    }

    LazilyLoadedCtor(ScriptableObject scope, String propertyName, String className, boolean sealed, boolean privileged, Context cx) {
        this.scope = scope;
        this.propertyName = propertyName;
        this.className = className;
        this.sealed = sealed;
        this.privileged = privileged;
        this.state = 0;
        scope.addLazilyInitializedValue(cx, propertyName, 0, this, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(Context cx) {
        LazilyLoadedCtor lazilyLoadedCtor = this;
        synchronized (lazilyLoadedCtor) {
            if (this.state == 1) {
                throw new IllegalStateException("Recursive initialization for " + this.propertyName);
            }
            if (this.state == 0) {
                this.state = 1;
                Object value = Scriptable.NOT_FOUND;
                try {
                    value = this.buildValue(cx);
                }
                finally {
                    this.initializedValue = value;
                    this.state = 2;
                }
            }
        }
    }

    Object getValue() {
        if (this.state != 2) {
            throw new IllegalStateException(this.propertyName);
        }
        return this.initializedValue;
    }

    private Object buildValue(Context cx) {
        return this.buildValue0(cx);
    }

    private Object buildValue0(Context cx) {
        Class<? extends Scriptable> cl = LazilyLoadedCtor.cast(Kit.classOrNull(this.className));
        if (cl != null) {
            try {
                Object value = ScriptableObject.buildClassCtor(this.scope, cl, this.sealed, false, cx);
                if (value != null) {
                    return value;
                }
                value = this.scope.get(cx, this.propertyName, (Scriptable)this.scope);
                if (value != Scriptable.NOT_FOUND) {
                    return value;
                }
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
            }
            catch (RhinoException | IllegalAccessException | InstantiationException | SecurityException exception) {
                // empty catch block
            }
        }
        return Scriptable.NOT_FOUND;
    }
}

