/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.EvaluatorException;
import dev.gigaherz.rhinolib.Function;
import dev.gigaherz.rhinolib.IdFunctionObject;
import dev.gigaherz.rhinolib.IdScriptableObject;
import dev.gigaherz.rhinolib.NativeCallSite;
import dev.gigaherz.rhinolib.RhinoException;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.ScriptStackElement;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.WrappedExecutable;

final class NativeError
extends IdScriptableObject {
    public static final int DEFAULT_STACK_LIMIT = -1;
    private static final Object ERROR_TAG = "Error";
    private static final WrappedExecutable ERROR_DELEGATE_GET_STACK = (cx, scope, self, args) -> ((NativeError)self).getStackDelegated(cx, scope);
    private static final WrappedExecutable ERROR_DELEGATE_SET_STACK = (cx, scope, self, args) -> ((NativeError)self).setStackDelegated(cx, scope, args[0]);
    private static final String STACK_HIDE_KEY = "_stackHide";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int ConstructorId_captureStackTrace = -1;
    private static final int MAX_PROTOTYPE_ID = 3;
    private RhinoException stackProvider;
    private final Context localContext;

    static void init(Scriptable scope, boolean sealed, Context cx) {
        NativeError obj = new NativeError(cx);
        NativeError.putProperty((Scriptable)obj, "name", (Object)"Error", cx);
        NativeError.putProperty((Scriptable)obj, "message", (Object)"", cx);
        NativeError.putProperty((Scriptable)obj, "fileName", (Object)"", cx);
        NativeError.putProperty((Scriptable)obj, "lineNumber", (Object)0, cx);
        obj.setAttributes(cx, "name", 2);
        obj.setAttributes(cx, "message", 2);
        obj.exportAsJSClass(3, scope, sealed, cx);
        NativeCallSite.init(obj, sealed, cx);
    }

    static NativeError make(Context cx, Scriptable scope, IdFunctionObject ctorObj, Object[] args) {
        Scriptable proto = (Scriptable)ctorObj.get(cx, "prototype", (Scriptable)ctorObj);
        NativeError obj = new NativeError(cx);
        obj.setPrototype(proto);
        obj.setParentScope(scope);
        int arglen = args.length;
        if (arglen >= 1) {
            if (args[0] != Undefined.instance) {
                NativeError.putProperty((Scriptable)obj, "message", (Object)ScriptRuntime.toString(cx, args[0]), cx);
            }
            if (arglen >= 2) {
                NativeError.putProperty((Scriptable)obj, "fileName", args[1], cx);
                if (arglen >= 3) {
                    int line = ScriptRuntime.toInt32(cx, args[2]);
                    NativeError.putProperty((Scriptable)obj, "lineNumber", (Object)line, cx);
                }
            }
        }
        return obj;
    }

    private static Object js_toString(Context cx, Scriptable thisObj) {
        Object name = NativeError.getProperty(thisObj, "name", cx);
        name = name == NOT_FOUND || name == Undefined.instance ? "Error" : ScriptRuntime.toString(cx, name);
        Object msg = NativeError.getProperty(thisObj, "message", cx);
        msg = msg == NOT_FOUND || msg == Undefined.instance ? "" : ScriptRuntime.toString(cx, msg);
        if (name.toString().length() == 0) {
            return msg;
        }
        if (msg.toString().length() == 0) {
            return name;
        }
        return name + ": " + msg;
    }

    private static void js_captureStackTrace(Context cx, Scriptable thisObj, Object[] args) {
        Object funcName;
        ScriptableObject obj = (ScriptableObject)ScriptRuntime.toObjectOrNull(cx, args[0], thisObj);
        Function func = null;
        if (args.length > 1) {
            func = (Function)ScriptRuntime.toObjectOrNull(cx, args[1], thisObj);
        }
        NativeError err = (NativeError)cx.newObject(thisObj, "Error");
        err.setStackProvider(new EvaluatorException(cx, "[object Object]"), cx);
        if (func != null && (funcName = func.get(cx, "name", (Scriptable)func)) != null && !Undefined.instance.equals(funcName)) {
            err.associateValue(STACK_HIDE_KEY, ScriptRuntime.toString(cx, funcName));
        }
        obj.defineProperty(cx, "stack", err, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 0);
    }

    public NativeError(Context cx) {
        this.localContext = cx;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject ctor, Context cx) {
        this.addIdFunctionProperty(ctor, ERROR_TAG, -1, "captureStackTrace", 2, cx);
        ProtoProps protoProps = new ProtoProps();
        this.associateValue("_ErrorPrototypeProps", protoProps);
        ctor.defineProperty(cx, "stackTraceLimit", protoProps, ProtoProps.GET_STACK_LIMIT, ProtoProps.SET_STACK_LIMIT, 0);
        ctor.defineProperty(cx, "prepareStackTrace", protoProps, ProtoProps.GET_PREPARE_STACK, ProtoProps.SET_PREPARE_STACK, 0);
        super.fillConstructorProperties(ctor, cx);
    }

    @Override
    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object toString = NativeError.js_toString(this.localContext, this);
        return toString instanceof String ? (String)toString : super.toString();
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        this.initPrototypeMethod(ERROR_TAG, id, switch (id) {
            case 1 -> {
                arity = 1;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "toString";
            }
            case 3 -> {
                arity = 0;
                yield "toSource";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity, cx);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ERROR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return NativeError.make(cx, scope, f, args);
            }
            case 2: {
                return NativeError.js_toString(cx, thisObj);
            }
            case 3: {
                return "not_supported";
            }
            case -1: {
                NativeError.js_captureStackTrace(cx, thisObj, args);
                return Undefined.instance;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public void setStackProvider(RhinoException re, Context cx) {
        if (this.stackProvider == null) {
            this.stackProvider = re;
            this.defineProperty(cx, "stack", this, ERROR_DELEGATE_GET_STACK, ERROR_DELEGATE_SET_STACK, 2);
        }
    }

    public Object getStackDelegated(Context cx, Scriptable target) {
        if (this.stackProvider == null) {
            return NOT_FOUND;
        }
        int limit = -1;
        Function prepare = null;
        NativeError cons = (NativeError)this.getPrototype(cx);
        ProtoProps pp = (ProtoProps)cons.getAssociatedValue("_ErrorPrototypeProps");
        if (pp != null) {
            limit = pp.getStackTraceLimit();
            prepare = pp.getPrepareStackTrace();
        }
        String hideFunc = (String)this.getAssociatedValue(STACK_HIDE_KEY);
        ScriptStackElement[] stack = this.stackProvider.getScriptStack(limit, hideFunc);
        Object value = prepare == null ? RhinoException.formatStackTrace(stack, this.stackProvider.details()) : this.callPrepareStack(prepare, stack, cx);
        this.setStackDelegated(cx, target, value);
        return value;
    }

    public Object setStackDelegated(Context cx, Scriptable target, Object value) {
        target.delete(cx, "stack");
        this.stackProvider = null;
        target.put(cx, "stack", target, value);
        return null;
    }

    private Object callPrepareStack(Function prepare, ScriptStackElement[] stack, Context cx) {
        Object[] elts = new Object[stack.length];
        for (int i = 0; i < stack.length; ++i) {
            NativeCallSite site = (NativeCallSite)cx.newObject(this, "CallSite");
            site.setElement(stack[i]);
            elts[i] = site;
        }
        Scriptable eltArray = cx.newArray((Scriptable)this, elts);
        return prepare.call(cx, prepare, this, new Object[]{this, eltArray});
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "toString" -> 2;
            case "toSource" -> 3;
            default -> 0;
        };
    }

    private static final class ProtoProps {
        static final String KEY = "_ErrorPrototypeProps";
        static final WrappedExecutable GET_STACK_LIMIT = (cx, scope, self, args) -> ((ProtoProps)self).getStackTraceLimit(cx);
        static final WrappedExecutable SET_STACK_LIMIT = (cx, scope, self, args) -> ((ProtoProps)self).setStackTraceLimit(cx, args[0]);
        static final WrappedExecutable GET_PREPARE_STACK = (cx, scope, self, args) -> ((ProtoProps)self).getPrepareStackTrace(cx);
        static final WrappedExecutable SET_PREPARE_STACK = (cx, scope, self, args) -> ((ProtoProps)self).setPrepareStackTrace(cx, args[0]);
        private int stackTraceLimit = -1;
        private Function prepareStackTrace;

        private ProtoProps() {
        }

        public Object getStackTraceLimit(Context cx) {
            if (this.stackTraceLimit >= 0) {
                return this.stackTraceLimit;
            }
            return Double.POSITIVE_INFINITY;
        }

        public int getStackTraceLimit() {
            return this.stackTraceLimit;
        }

        public Object setStackTraceLimit(Context cx, Object value) {
            double limit = ScriptRuntime.toNumber(cx, value);
            this.stackTraceLimit = Double.isNaN(limit) || Double.isInfinite(limit) ? -1 : (int)limit;
            return null;
        }

        public Object getPrepareStackTrace(Context cx) {
            Function ps = this.getPrepareStackTrace();
            return ps == null ? Undefined.instance : ps;
        }

        public Function getPrepareStackTrace() {
            return this.prepareStackTrace;
        }

        public Object setPrepareStackTrace(Context cx, Object value) {
            if (value == null || Undefined.instance.equals(value)) {
                this.prepareStackTrace = null;
            } else if (value instanceof Function) {
                this.prepareStackTrace = (Function)value;
            }
            return null;
        }
    }
}

