/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.ES6Generator;
import dev.gigaherz.rhinolib.IdEnumeration;
import dev.gigaherz.rhinolib.IdFunctionObject;
import dev.gigaherz.rhinolib.IdScriptableObject;
import dev.gigaherz.rhinolib.JavaScriptException;
import dev.gigaherz.rhinolib.NativeObject;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.Wrapper;
import java.util.Iterator;

public final class NativeIterator
extends IdScriptableObject {
    public static final String ITERATOR_PROPERTY_NAME = "__iterator__";
    private static final Object ITERATOR_TAG = "Iterator";
    private static final String STOP_ITERATION = "StopIteration";
    private static final int Id_constructor = 1;
    private static final int Id_next = 2;
    private static final int Id___iterator__ = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    private IdEnumeration objectIterator;

    static void init(Context cx, ScriptableObject scope, boolean sealed) {
        NativeIterator iterator = new NativeIterator();
        iterator.exportAsJSClass(3, scope, sealed, cx);
        ES6Generator.init(scope, sealed, cx);
        StopIteration obj = new StopIteration(cx);
        obj.setPrototype(NativeIterator.getObjectPrototype(scope, cx));
        obj.setParentScope(scope);
        if (sealed) {
            obj.sealObject(cx);
        }
        NativeIterator.defineProperty(scope, STOP_ITERATION, obj, 2, cx);
        scope.associateValue(ITERATOR_TAG, obj);
    }

    public static Object getStopIterationObject(Scriptable scope, Context cx) {
        Scriptable top = NativeIterator.getTopLevelScope(scope);
        return NativeIterator.getTopScopeValue(top, ITERATOR_TAG, cx);
    }

    private static Object jsConstructor(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        boolean keyOnly;
        if (args.length == 0 || args[0] == null || args[0] == Undefined.instance) {
            Object argument = args.length == 0 ? Undefined.instance : args[0];
            throw ScriptRuntime.typeError1(cx, "msg.no.properties", ScriptRuntime.toString(cx, argument));
        }
        Scriptable obj = ScriptRuntime.toObject(cx, scope, args[0]);
        boolean bl = keyOnly = args.length > 1 && ScriptRuntime.toBoolean(cx, args[1]);
        if (thisObj != null) {
            Iterator<?> iterator = NativeIterator.getJavaIterator(obj);
            if (iterator != null) {
                scope = NativeIterator.getTopLevelScope(scope);
                return cx.getWrapFactory().wrap(cx, scope, new WrappedJavaIterator(cx, iterator, scope), WrappedJavaIterator.class);
            }
            Scriptable jsIterator = ScriptRuntime.toIterator(cx, scope, obj, keyOnly);
            if (jsIterator != null) {
                return jsIterator;
            }
        }
        IdEnumeration objectIterator = ScriptRuntime.enumInit(cx, scope, obj, keyOnly ? 3 : 5);
        objectIterator.enumNumbers = true;
        NativeIterator result = new NativeIterator(objectIterator);
        result.setPrototype(NativeIterator.getClassPrototype(scope, result.getClassName(), cx));
        result.setParentScope(scope);
        return result;
    }

    private static Iterator<?> getJavaIterator(Object obj) {
        if (obj instanceof Wrapper) {
            Object unwrapped = ((Wrapper)obj).unwrap();
            Iterator iterator = null;
            if (unwrapped instanceof Iterator) {
                iterator = (Iterator)unwrapped;
            }
            if (unwrapped instanceof Iterable) {
                iterator = ((Iterable)unwrapped).iterator();
            }
            return iterator;
        }
        return null;
    }

    private NativeIterator() {
    }

    private NativeIterator(IdEnumeration objectIterator) {
        this.objectIterator = objectIterator;
    }

    @Override
    public String getClassName() {
        return "Iterator";
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        this.initPrototypeMethod(ITERATOR_TAG, id, switch (id) {
            case 1 -> {
                arity = 2;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "next";
            }
            case 3 -> {
                arity = 1;
                yield ITERATOR_PROPERTY_NAME;
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity, cx);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(ITERATOR_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        if (id == 1) {
            return NativeIterator.jsConstructor(cx, scope, thisObj, args);
        }
        Scriptable scriptable = thisObj;
        if (!(scriptable instanceof NativeIterator)) {
            throw NativeIterator.incompatibleCallError(f, cx);
        }
        NativeIterator iterator = (NativeIterator)scriptable;
        return switch (id) {
            case 2 -> iterator.objectIterator.nextExec(cx, scope);
            case 3 -> thisObj;
            default -> throw new IllegalArgumentException(String.valueOf(id));
        };
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "next" -> 2;
            case ITERATOR_PROPERTY_NAME -> 3;
            case "constructor" -> 1;
            default -> 0;
        };
    }

    public static class StopIteration
    extends NativeObject {
        private Object value = Undefined.instance;

        public StopIteration(Context cx) {
            super(cx);
        }

        public StopIteration(Context cx, Object val) {
            this(cx);
            this.value = val;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public String getClassName() {
            return NativeIterator.STOP_ITERATION;
        }

        @Override
        public boolean hasInstance(Context cx, Scriptable instance) {
            return instance instanceof StopIteration;
        }
    }

    public static class WrappedJavaIterator {
        private final Context localContext;
        private final Iterator<?> iterator;
        private final Scriptable scope;

        WrappedJavaIterator(Context cx, Iterator<?> iterator, Scriptable scope) {
            this.localContext = cx;
            this.iterator = iterator;
            this.scope = scope;
        }

        public Object next() {
            if (!this.iterator.hasNext()) {
                throw new JavaScriptException(this.localContext, NativeIterator.getStopIterationObject(this.scope, this.localContext), null, 0);
            }
            return this.iterator.next();
        }

        public Object __iterator__(boolean b) {
            return this;
        }
    }
}

