/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.FieldAndMethods;
import dev.gigaherz.rhinolib.Function;
import dev.gigaherz.rhinolib.JavaMembers;
import dev.gigaherz.rhinolib.Kit;
import dev.gigaherz.rhinolib.MemberBox;
import dev.gigaherz.rhinolib.NativeArray;
import dev.gigaherz.rhinolib.NativeJavaArray;
import dev.gigaherz.rhinolib.NativeJavaMethod;
import dev.gigaherz.rhinolib.NativeJavaObject;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.Wrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Map;

public class NativeJavaClass
extends NativeJavaObject
implements Function {
    static final String javaClassPropertyName = "__javaObject__";
    private Map<String, FieldAndMethods> staticFieldAndMethods;

    static Scriptable constructSpecific(Context cx, Scriptable scope, Object[] args, MemberBox ctor) {
        Object instance = NativeJavaClass.constructInternal(cx, scope, args, ctor);
        Scriptable topLevel = ScriptableObject.getTopLevelScope(scope);
        return cx.getWrapFactory().wrapNewObject(topLevel, instance, cx);
    }

    static Object constructInternal(Context cx, Scriptable scope, Object[] args, MemberBox ctor) {
        Class<?>[] argTypes = ctor.argTypes;
        if (ctor.vararg) {
            Object varArgs;
            Object[] newArgs = new Object[argTypes.length];
            for (int i = 0; i < argTypes.length - 1; ++i) {
                newArgs[i] = Context.jsToJava(cx, args[i], argTypes[i]);
            }
            if (args.length == argTypes.length && (args[args.length - 1] == null || args[args.length - 1] instanceof NativeArray || args[args.length - 1] instanceof NativeJavaArray)) {
                varArgs = Context.jsToJava(cx, args[args.length - 1], argTypes[argTypes.length - 1]);
            } else {
                Class<?> componentType = argTypes[argTypes.length - 1].getComponentType();
                varArgs = Array.newInstance(componentType, args.length - argTypes.length + 1);
                for (int i = 0; i < Array.getLength(varArgs); ++i) {
                    Object value = Context.jsToJava(cx, args[argTypes.length - 1 + i], componentType);
                    Array.set(varArgs, i, value);
                }
            }
            newArgs[argTypes.length - 1] = varArgs;
            args = newArgs;
        } else {
            Object[] origArgs = args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object x = Context.jsToJava(cx, arg, argTypes[i]);
                if (x == arg) continue;
                if (args == origArgs) {
                    args = (Object[])origArgs.clone();
                }
                args[i] = x;
            }
        }
        return ctor.newInstance(args, cx, scope);
    }

    private static Class<?> findNestedClass(Class<?> parentClass, String name) {
        String nestedClassName = parentClass.getName() + "$" + name;
        ClassLoader loader = parentClass.getClassLoader();
        if (loader == null) {
            return Kit.classOrNull(nestedClassName);
        }
        return Kit.classOrNull(loader, nestedClassName);
    }

    public NativeJavaClass() {
    }

    public NativeJavaClass(Context cx, Scriptable scope, Class<?> cl) {
        this(cx, scope, cl, false);
    }

    public NativeJavaClass(Context cx, Scriptable scope, Class<?> cl, boolean isAdapter) {
        super(scope, cl, null, isAdapter, cx);
    }

    @Override
    protected void initMembers(Context cx, Scriptable scope) {
        Class cl = (Class)this.javaObject;
        this.members = JavaMembers.lookupClass(cx, scope, cl, cl, this.isAdapter);
        this.staticFieldAndMethods = this.members.getFieldAndMethodsObjects(this, cl, true, cx);
    }

    @Override
    public String getClassName() {
        return "JavaClass";
    }

    @Override
    public boolean has(Context cx, String name, Scriptable start) {
        return this.members.has(name, true) || javaClassPropertyName.equals(name);
    }

    @Override
    public Object get(Context cx, String name, Scriptable start) {
        FieldAndMethods result;
        if (name.equals("prototype")) {
            return null;
        }
        if (this.staticFieldAndMethods != null && (result = this.staticFieldAndMethods.get(name)) != null) {
            return result;
        }
        if (this.members.has(name, true)) {
            return this.members.get(this, name, this.javaObject, true, cx);
        }
        Scriptable scope = ScriptableObject.getTopLevelScope(start);
        if (javaClassPropertyName.equals(name)) {
            return cx.getWrapFactory().wrap(cx, scope, this.javaObject, ScriptRuntime.ClassClass);
        }
        Class<?> nestedClass = NativeJavaClass.findNestedClass(this.getClassObject(), name);
        if (nestedClass != null) {
            Scriptable nestedValue = cx.getWrapFactory().wrapJavaClass(cx, scope, nestedClass);
            nestedValue.setParentScope(this);
            return nestedValue;
        }
        throw this.members.reportMemberNotFound(name, cx);
    }

    @Override
    public void put(Context cx, String name, Scriptable start, Object value) {
        this.members.put(this, name, this.javaObject, value, true, cx);
    }

    @Override
    public Object[] getIds(Context cx) {
        return this.members.getIds(true);
    }

    public Class<?> getClassObject() {
        return (Class)super.unwrap();
    }

    @Override
    public Object getDefaultValue(Context cx, Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return this.toString();
        }
        if (hint == ScriptRuntime.BooleanClass) {
            return Boolean.TRUE;
        }
        if (hint == ScriptRuntime.NumberClass) {
            return ScriptRuntime.NaNobj;
        }
        return this;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        Object object;
        if (args.length == 1 && (object = args[0]) instanceof Scriptable) {
            Scriptable p = (Scriptable)object;
            Class<?> c = this.getClassObject();
            do {
                Object o;
                if (!(p instanceof Wrapper) || !c.isInstance(o = ((Wrapper)((Object)p)).unwrap())) continue;
                return p;
            } while ((p = p.getPrototype(cx)) != null);
        }
        return this.construct(cx, scope, args);
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        String msg;
        Class<?> classObject;
        block7: {
            classObject = this.getClassObject();
            int modifiers = classObject.getModifiers();
            if (!Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers)) {
                NativeJavaMethod ctors = this.members.ctors;
                int index = ctors.findCachedFunction(cx, args);
                if (index < 0) {
                    String sig = NativeJavaMethod.scriptSignature(args);
                    throw Context.reportRuntimeError2("msg.no.java.ctor", classObject.getName(), sig, cx);
                }
                return NativeJavaClass.constructSpecific(cx, scope, args, ctors.methods[index]);
            }
            if (args.length == 0) {
                throw Context.reportRuntimeError0("msg.adapter.zero.args", cx);
            }
            Scriptable topLevel = ScriptableObject.getTopLevelScope(this);
            msg = "";
            try {
                if ("Dalvik".equals(System.getProperty("java.vm.name")) && classObject.isInterface()) {
                    Object obj = NativeJavaClass.createInterfaceAdapter(cx, classObject, ScriptableObject.ensureScriptableObject(args[0], cx));
                    return cx.getWrapFactory().wrapAsJavaObject(cx, scope, obj, null);
                }
                Object v = topLevel.get(cx, "JavaAdapter", topLevel);
                if (v != NOT_FOUND) {
                    Function f = (Function)v;
                    Object[] adapterArgs = new Object[]{this, args[0]};
                    return f.construct(cx, topLevel, adapterArgs);
                }
            }
            catch (Exception ex) {
                String m = ex.getMessage();
                if (m == null) break block7;
                msg = m;
            }
        }
        throw Context.reportRuntimeError2("msg.cant.instantiate", msg, classObject.getName(), cx);
    }

    public String toString() {
        return "[JavaClass " + this.getClassObject().getName() + "]";
    }

    @Override
    public boolean hasInstance(Context cx, Scriptable value) {
        if (value instanceof Wrapper && !(value instanceof NativeJavaClass)) {
            Object instance = ((Wrapper)((Object)value)).unwrap();
            return this.getClassObject().isInstance(instance);
        }
        return false;
    }
}

