/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.BaseFunction;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.DefaultErrorReporter;
import dev.gigaherz.rhinolib.ErrorReporter;
import dev.gigaherz.rhinolib.IdFunctionObject;
import dev.gigaherz.rhinolib.Script;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.Undefined;

class NativeScript
extends BaseFunction {
    private static final Object SCRIPT_TAG = "Script";
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_compile = 3;
    private static final int Id_exec = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Script script;

    static void init(Scriptable scope, boolean sealed, Context cx) {
        NativeScript obj = new NativeScript(null);
        obj.exportAsJSClass(4, scope, sealed, cx);
    }

    private static NativeScript realThis(Scriptable thisObj, IdFunctionObject f, Context cx) {
        if (!(thisObj instanceof NativeScript)) {
            throw NativeScript.incompatibleCallError(f, cx);
        }
        return (NativeScript)thisObj;
    }

    private static Script compile(Context cx, String source) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        if (filename == null) {
            filename = "<Script object>";
            linep[0] = 1;
        }
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        return cx.compileString(source, null, reporter, filename, linep[0], null);
    }

    private NativeScript(Script script) {
        this.script = script;
    }

    @Override
    public String getClassName() {
        return "Script";
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (this.script != null) {
            return this.script.exec(cx, scope);
        }
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw Context.reportRuntimeError0("msg.script.is.not.constructor", cx);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    protected void initPrototypeId(int id, Context cx) {
        int arity;
        this.initPrototypeMethod(SCRIPT_TAG, id, switch (id) {
            case 1 -> {
                arity = 1;
                yield "constructor";
            }
            case 2 -> {
                arity = 0;
                yield "toString";
            }
            case 4 -> {
                arity = 0;
                yield "exec";
            }
            case 3 -> {
                arity = 1;
                yield "compile";
            }
            default -> throw new IllegalArgumentException(String.valueOf(id));
        }, arity, cx);
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(SCRIPT_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                String source = args.length == 0 ? "" : ScriptRuntime.toString(cx, args[0]);
                Script script = NativeScript.compile(cx, source);
                NativeScript nscript = new NativeScript(script);
                ScriptRuntime.setObjectProtoAndParent(cx, scope, nscript);
                return nscript;
            }
            case 2: {
                return "not_supported";
            }
            case 4: {
                throw Context.reportRuntimeError1("msg.cant.call.indirect", "exec", cx);
            }
            case 3: {
                NativeScript real = NativeScript.realThis(thisObj, f, cx);
                String source = ScriptRuntime.toString(cx, args, 0);
                real.script = NativeScript.compile(cx, source);
                return real;
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    @Override
    protected int findPrototypeId(String s) {
        return switch (s) {
            case "constructor" -> 1;
            case "toString" -> 2;
            case "compile" -> 3;
            case "exec" -> 4;
            default -> 0;
        };
    }
}

