/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.Arguments;
import dev.gigaherz.rhinolib.BaseFunction;
import dev.gigaherz.rhinolib.Callable;
import dev.gigaherz.rhinolib.ClassShutter;
import dev.gigaherz.rhinolib.ConsString;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.DToA;
import dev.gigaherz.rhinolib.DefaultErrorReporter;
import dev.gigaherz.rhinolib.EcmaError;
import dev.gigaherz.rhinolib.ErrorReporter;
import dev.gigaherz.rhinolib.Evaluator;
import dev.gigaherz.rhinolib.EvaluatorException;
import dev.gigaherz.rhinolib.Function;
import dev.gigaherz.rhinolib.IdEnumeration;
import dev.gigaherz.rhinolib.IdEnumerationIterator;
import dev.gigaherz.rhinolib.InterpretedFunction;
import dev.gigaherz.rhinolib.JavaScriptException;
import dev.gigaherz.rhinolib.Kit;
import dev.gigaherz.rhinolib.LazilyLoadedCtor;
import dev.gigaherz.rhinolib.MemberType;
import dev.gigaherz.rhinolib.NativeArray;
import dev.gigaherz.rhinolib.NativeArrayIterator;
import dev.gigaherz.rhinolib.NativeBoolean;
import dev.gigaherz.rhinolib.NativeCall;
import dev.gigaherz.rhinolib.NativeCollectionIterator;
import dev.gigaherz.rhinolib.NativeDate;
import dev.gigaherz.rhinolib.NativeError;
import dev.gigaherz.rhinolib.NativeFunction;
import dev.gigaherz.rhinolib.NativeGlobal;
import dev.gigaherz.rhinolib.NativeIterator;
import dev.gigaherz.rhinolib.NativeJSON;
import dev.gigaherz.rhinolib.NativeMap;
import dev.gigaherz.rhinolib.NativeMath;
import dev.gigaherz.rhinolib.NativeNumber;
import dev.gigaherz.rhinolib.NativeObject;
import dev.gigaherz.rhinolib.NativeScript;
import dev.gigaherz.rhinolib.NativeSet;
import dev.gigaherz.rhinolib.NativeString;
import dev.gigaherz.rhinolib.NativeStringIterator;
import dev.gigaherz.rhinolib.NativeSymbol;
import dev.gigaherz.rhinolib.NativeWeakMap;
import dev.gigaherz.rhinolib.NativeWeakSet;
import dev.gigaherz.rhinolib.NativeWith;
import dev.gigaherz.rhinolib.Ref;
import dev.gigaherz.rhinolib.RefCallable;
import dev.gigaherz.rhinolib.RhinoException;
import dev.gigaherz.rhinolib.Script;
import dev.gigaherz.rhinolib.Scriptable;
import dev.gigaherz.rhinolib.ScriptableObject;
import dev.gigaherz.rhinolib.SpecialRef;
import dev.gigaherz.rhinolib.Symbol;
import dev.gigaherz.rhinolib.SymbolKey;
import dev.gigaherz.rhinolib.SymbolScriptable;
import dev.gigaherz.rhinolib.TokenStream;
import dev.gigaherz.rhinolib.TopLevel;
import dev.gigaherz.rhinolib.Undefined;
import dev.gigaherz.rhinolib.WrappedException;
import dev.gigaherz.rhinolib.Wrapper;
import dev.gigaherz.rhinolib.regexp.RegExp;
import dev.gigaherz.rhinolib.util.SpecialEquality;
import dev.gigaherz.rhinolib.v8dtoa.DoubleConversion;
import dev.gigaherz.rhinolib.v8dtoa.FastDtoa;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ScriptRuntime {
    public static final Object[] EMPTY_OBJECTS = new Object[0];
    public static final String[] EMPTY_STRINGS = new String[0];
    public static final Class<Boolean> BooleanClass = Boolean.class;
    public static final Class<Byte> ByteClass = Byte.class;
    public static final Class<Character> CharacterClass = Character.class;
    public static final Class<Class> ClassClass = Class.class;
    public static final Class<Double> DoubleClass = Double.class;
    public static final Class<Float> FloatClass = Float.class;
    public static final Class<Integer> IntegerClass = Integer.class;
    public static final Class<Long> LongClass = Long.class;
    public static final Class<Number> NumberClass = Number.class;
    public static final Class<Object> ObjectClass = Object.class;
    public static final Class<Short> ShortClass = Short.class;
    public static final Class<String> StringClass = String.class;
    public static final Class<Date> DateClass = Date.class;
    public static final Class<?> ContextClass = Context.class;
    public static final Class<Function> FunctionClass = Function.class;
    public static final Class<ScriptableObject> ScriptableObjectClass = ScriptableObject.class;
    public static final Class<Scriptable> ScriptableClass = Scriptable.class;
    public static final double NaN = Double.NaN;
    public static final Double NaNobj = Double.NaN;
    public static final double negativeZero = Double.longBitsToDouble(Long.MIN_VALUE);
    public static final Double zeroObj = 0.0;
    public static final Double negativeZeroObj = -0.0;
    public static final int ENUMERATE_KEYS = 0;
    public static final int ENUMERATE_VALUES = 1;
    public static final int ENUMERATE_ARRAY = 2;
    public static final int ENUMERATE_KEYS_NO_ITERATOR = 3;
    public static final int ENUMERATE_VALUES_NO_ITERATOR = 4;
    public static final int ENUMERATE_ARRAY_NO_ITERATOR = 5;
    public static final int ENUMERATE_VALUES_IN_ORDER = 6;
    public static final MessageProvider messageProvider = new DefaultMessageProvider();
    private static final Object LIBRARY_SCOPE_KEY = "LIBRARY_SCOPE";

    public static BaseFunction typeErrorThrower(Context cx) {
        if (cx.typeErrorThrower == null) {
            BaseFunction thrower = new BaseFunction(){

                @Override
                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    throw ScriptRuntime.typeError0(cx, "msg.op.not.allowed");
                }

                @Override
                public int getLength() {
                    return 0;
                }
            };
            ScriptRuntime.setFunctionProtoAndParent(cx, cx.topCallScope, thrower);
            thrower.preventExtensions();
            cx.typeErrorThrower = thrower;
        }
        return cx.typeErrorThrower;
    }

    public static boolean isRhinoRuntimeType(Class<?> cl) {
        if (cl.isPrimitive()) {
            return cl != Character.TYPE;
        }
        return cl == StringClass || cl == BooleanClass || NumberClass.isAssignableFrom(cl) || ScriptableClass.isAssignableFrom(cl);
    }

    public static ScriptableObject initSafeStandardObjects(Context cx, ScriptableObject scope, boolean sealed) {
        if (scope == null) {
            scope = new NativeObject(cx);
        }
        scope.associateValue(LIBRARY_SCOPE_KEY, scope);
        BaseFunction.init(scope, sealed, cx);
        NativeObject.init(cx, scope, sealed);
        Scriptable objectProto = ScriptableObject.getObjectPrototype(scope, cx);
        Scriptable functionProto = ScriptableObject.getClassPrototype(scope, "Function", cx);
        functionProto.setPrototype(objectProto);
        if (scope.getPrototype(cx) == null) {
            scope.setPrototype(objectProto);
        }
        NativeError.init(scope, sealed, cx);
        NativeGlobal.init(cx, scope, sealed);
        NativeArray.init(scope, sealed, cx);
        NativeString.init(scope, sealed, cx);
        NativeBoolean.init(scope, sealed, cx);
        NativeNumber.init(scope, sealed, cx);
        NativeDate.init(scope, sealed, cx);
        NativeMath.init(scope, sealed, cx);
        NativeJSON.init(scope, sealed, cx);
        NativeWith.init(scope, sealed, cx);
        NativeCall.init(scope, sealed, cx);
        NativeScript.init(scope, sealed, cx);
        NativeIterator.init(cx, scope, sealed);
        NativeArrayIterator.init(scope, sealed, cx);
        NativeStringIterator.init(scope, sealed, cx);
        new LazilyLoadedCtor(scope, "RegExp", "regexp.dev.gigaherz.rhinolib.NativeRegExp", sealed, true, cx);
        new LazilyLoadedCtor(scope, "Continuation", "dev.gigaherz.rhinolib.NativeContinuation", sealed, true, cx);
        NativeSymbol.init(cx, scope, sealed);
        NativeCollectionIterator.init(scope, "Set Iterator", sealed, cx);
        NativeCollectionIterator.init(scope, "Map Iterator", sealed, cx);
        NativeMap.init(cx, scope, sealed);
        NativeSet.init(cx, scope, sealed);
        NativeWeakMap.init(scope, sealed, cx);
        NativeWeakSet.init(scope, sealed, cx);
        if (scope instanceof TopLevel) {
            ((TopLevel)scope).cacheBuiltins(scope, sealed, cx);
        }
        return scope;
    }

    public static ScriptableObject initStandardObjects(Context cx, ScriptableObject scope, boolean sealed) {
        ScriptableObject s = ScriptRuntime.initSafeStandardObjects(cx, scope, sealed);
        new LazilyLoadedCtor(s, "JavaAdapter", "dev.gigaherz.rhinolib.JavaAdapter", sealed, true, cx);
        return s;
    }

    public static ScriptableObject getLibraryScopeOrNull(Scriptable scope, Context cx) {
        ScriptableObject libScope = (ScriptableObject)ScriptableObject.getTopScopeValue(scope, LIBRARY_SCOPE_KEY, cx);
        return libScope;
    }

    public static boolean isJSLineTerminator(int c) {
        if ((c & 0xDFD0) != 0) {
            return false;
        }
        return c == 10 || c == 13 || c == 8232 || c == 8233;
    }

    public static boolean isJSWhitespaceOrLineTerminator(int c) {
        return ScriptRuntime.isStrWhiteSpaceChar(c) || ScriptRuntime.isJSLineTerminator(c);
    }

    static boolean isStrWhiteSpaceChar(int c) {
        return switch (c) {
            case 9, 10, 11, 12, 13, 32, 160, 8232, 8233, 65279 -> true;
            default -> Character.getType(c) == 12;
        };
    }

    public static Number wrapNumber(double x) {
        if (Double.isNaN(x)) {
            return NaNobj;
        }
        return x;
    }

    public static boolean toBoolean(Context cx, Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val == null || val == Undefined.instance) {
            return false;
        }
        if (val instanceof CharSequence) {
            return ((CharSequence)val).length() != 0;
        }
        if (val instanceof Number) {
            double d = ((Number)val).doubleValue();
            return !Double.isNaN(d) && d != 0.0;
        }
        if (val instanceof Scriptable) {
            return !(val instanceof ScriptableObject) || !((ScriptableObject)val).avoidObjectDetection();
        }
        ScriptRuntime.warnAboutNonJSObject(cx, val);
        return true;
    }

    public static double toNumber(Context cx, Object val) {
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val == null) {
            return 0.0;
        }
        if (val == Undefined.instance) {
            return Double.NaN;
        }
        if (val instanceof String) {
            return ScriptRuntime.toNumber(cx, (String)val);
        }
        if (val instanceof CharSequence) {
            return ScriptRuntime.toNumber(cx, val.toString());
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? 1.0 : 0.0;
        }
        if (val instanceof Symbol) {
            throw ScriptRuntime.typeError0(cx, "msg.not.a.number");
        }
        if (val instanceof Scriptable) {
            if ((val = ((Scriptable)val).getDefaultValue(cx, NumberClass)) instanceof Scriptable && !ScriptRuntime.isSymbol(val)) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val, cx);
            }
            return ScriptRuntime.toNumber(cx, val);
        }
        ScriptRuntime.warnAboutNonJSObject(cx, val);
        return Double.NaN;
    }

    public static double toNumber(Context cx, Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toNumber(cx, args[index]) : Double.NaN;
    }

    static double stringPrefixToNumber(String s, int start, int radix) {
        return ScriptRuntime.stringToNumber(s, start, s.length() - 1, radix, true);
    }

    static double stringToNumber(String s, int start, int end, int radix) {
        return ScriptRuntime.stringToNumber(s, start, end, radix, false);
    }

    private static double stringToNumber(String source, int sourceStart, int sourceEnd, int radix, boolean isPrefix) {
        int end;
        char digitMax = '9';
        char lowerCaseBound = 'a';
        char upperCaseBound = 'A';
        if (radix < 10) {
            digitMax = (char)(48 + radix - 1);
        }
        if (radix > 10) {
            lowerCaseBound = (char)(97 + radix - 10);
            upperCaseBound = (char)(65 + radix - 10);
        }
        double sum = 0.0;
        for (end = sourceStart; end <= sourceEnd; ++end) {
            int newDigit;
            char c = source.charAt(end);
            if ('0' <= c && c <= digitMax) {
                newDigit = c - 48;
            } else if ('a' <= c && c < lowerCaseBound) {
                newDigit = c - 97 + 10;
            } else if ('A' <= c && c < upperCaseBound) {
                newDigit = c - 65 + 10;
            } else {
                if (isPrefix) break;
                return Double.NaN;
            }
            sum = sum * (double)radix + (double)newDigit;
        }
        if (sourceStart == end) {
            return Double.NaN;
        }
        if (sum > 9.007199254740991E15) {
            if (radix == 10) {
                try {
                    return Double.parseDouble(source.substring(sourceStart, end));
                }
                catch (NumberFormatException nfe) {
                    return Double.NaN;
                }
            }
            if (radix == 2 || radix == 4 || radix == 8 || radix == 16 || radix == 32) {
                int bitShiftInChar = 1;
                int digit = 0;
                boolean SKIP_LEADING_ZEROS = false;
                boolean FIRST_EXACT_53_BITS = true;
                int AFTER_BIT_53 = 2;
                int ZEROS_AFTER_54 = 3;
                int MIXED_AFTER_54 = 4;
                int state = 0;
                int exactBitsLimit = 53;
                double factor = 0.0;
                boolean bit53 = false;
                boolean bit54 = false;
                int pos = sourceStart;
                while (true) {
                    if (bitShiftInChar == 1) {
                        if (pos == end) break;
                        digit = 48 <= (digit = (int)source.charAt(pos++)) && digit <= 57 ? (digit -= 48) : (97 <= digit && digit <= 122 ? (digit -= 87) : (digit -= 55));
                        bitShiftInChar = radix;
                    }
                    boolean bit = (digit & (bitShiftInChar >>= 1)) != 0;
                    switch (state) {
                        case 0: {
                            if (!bit) break;
                            --exactBitsLimit;
                            sum = 1.0;
                            state = 1;
                            break;
                        }
                        case 1: {
                            sum *= 2.0;
                            if (bit) {
                                sum += 1.0;
                            }
                            if (--exactBitsLimit != 0) break;
                            bit53 = bit;
                            state = 2;
                            break;
                        }
                        case 2: {
                            bit54 = bit;
                            factor = 2.0;
                            state = 3;
                            break;
                        }
                        case 3: {
                            if (bit) {
                                state = 4;
                            }
                        }
                        case 4: {
                            factor *= 2.0;
                        }
                    }
                }
                switch (state) {
                    case 0: {
                        sum = 0.0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (bit54 & bit53) {
                            sum += 1.0;
                        }
                        sum *= factor;
                        break;
                    }
                    case 4: {
                        if (bit54) {
                            sum += 1.0;
                        }
                        sum *= factor;
                    }
                }
            }
        }
        return sum;
    }

    public static double toNumber(Context cx, String s) {
        char radixC;
        boolean oldParsingMode;
        char endChar;
        char startChar;
        int len = s.length();
        int start = 0;
        while (true) {
            if (start == len) {
                return 0.0;
            }
            startChar = s.charAt(start);
            if (!ScriptRuntime.isStrWhiteSpaceChar(startChar)) break;
            ++start;
        }
        int end = len - 1;
        while (ScriptRuntime.isStrWhiteSpaceChar(endChar = s.charAt(end))) {
            --end;
        }
        boolean bl = oldParsingMode = cx == null;
        if (startChar == '0') {
            if (start + 2 <= end) {
                radixC = s.charAt(start + 1);
                int radix = -1;
                if (radixC == 'x' || radixC == 'X') {
                    radix = 16;
                } else if (!(oldParsingMode || radixC != 'o' && radixC != 'O')) {
                    radix = 8;
                } else if (!(oldParsingMode || radixC != 'b' && radixC != 'B')) {
                    radix = 2;
                }
                if (radix != -1) {
                    if (oldParsingMode) {
                        return ScriptRuntime.stringPrefixToNumber(s, start + 2, radix);
                    }
                    return ScriptRuntime.stringToNumber(s, start + 2, end, radix);
                }
            }
        } else if (!(!oldParsingMode || startChar != '+' && startChar != '-' || start + 3 > end || s.charAt(start + 1) != '0' || (radixC = s.charAt(start + 2)) != 'x' && radixC != 'X')) {
            double val = ScriptRuntime.stringPrefixToNumber(s, start + 3, 16);
            return startChar == '-' ? -val : val;
        }
        if (endChar == 'y') {
            if (startChar == '+' || startChar == '-') {
                ++start;
            }
            if (start + 7 == end && s.regionMatches(start, "Infinity", 0, 8)) {
                return startChar == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        String sub = s.substring(start, end + 1);
        for (int i = sub.length() - 1; i >= 0; --i) {
            char c = sub.charAt(i);
            if ('0' <= c && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '+' || c == '-') continue;
            return Double.NaN;
        }
        try {
            return Double.parseDouble(sub);
        }
        catch (NumberFormatException ex) {
            return Double.NaN;
        }
    }

    public static Object[] padArguments(Object[] args, int count) {
        if (count < args.length) {
            return args;
        }
        Object[] result = new Object[count];
        System.arraycopy(args, 0, result, 0, args.length);
        if (args.length < count) {
            Arrays.fill(result, args.length, count, Undefined.instance);
        }
        return result;
    }

    public static String escapeString(String s) {
        return ScriptRuntime.escapeString(s, '\"');
    }

    public static String escapeString(String s, char escapeQuote) {
        if (escapeQuote != '\"' && escapeQuote != '\'') {
            Kit.codeBug();
        }
        StringBuilder sb = null;
        int L = s.length();
        for (int i = 0; i != L; ++i) {
            int escape;
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != escapeQuote && c != '\\') {
                if (sb == null) continue;
                sb.append(c);
                continue;
            }
            if (sb == null) {
                sb = new StringBuilder(L + 3);
                sb.append(s);
                sb.setLength(i);
            }
            switch (c) {
                case '\b': {
                    int n = 98;
                    break;
                }
                case '\f': {
                    int n = 102;
                    break;
                }
                case '\n': {
                    int n = 110;
                    break;
                }
                case '\r': {
                    int n = 114;
                    break;
                }
                case '\t': {
                    int n = 116;
                    break;
                }
                case '\u000b': {
                    int n = 118;
                    break;
                }
                case ' ': {
                    int n = 32;
                    break;
                }
                case '\\': {
                    int n = 92;
                    break;
                }
                default: {
                    int n = escape = -1;
                }
            }
            if (escape >= 0) {
                sb.append('\\');
                sb.append((char)escape);
                continue;
            }
            if (c == escapeQuote) {
                sb.append('\\');
                sb.append(escapeQuote);
                continue;
            }
            if (c < '\u0100') {
                sb.append("\\x");
                hexSize = 2;
            } else {
                sb.append("\\u");
                hexSize = 4;
            }
            for (int shift = (hexSize - 1) * 4; shift >= 0; shift -= 4) {
                int digit = 0xF & c >> shift;
                int hc = digit < 10 ? 48 + digit : 87 + digit;
                sb.append((char)hc);
            }
        }
        return sb == null ? s : sb.toString();
    }

    static boolean isValidIdentifierName(Context cx, String s, boolean isStrict) {
        int L = s.length();
        if (L == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i != L; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return !TokenStream.isKeyword(s, isStrict);
    }

    public static CharSequence toCharSequence(Context cx, Object val) {
        if (val instanceof NativeString) {
            return ((NativeString)val).toCharSequence();
        }
        return val instanceof CharSequence ? (CharSequence)val : ScriptRuntime.toString(cx, val);
    }

    public static String toString(Context cx, Object val) {
        if (val == null) {
            return "null";
        }
        if (val == Undefined.instance || val == Undefined.SCRIPTABLE_UNDEFINED) {
            return "undefined";
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof CharSequence) {
            return val.toString();
        }
        if (val instanceof Number) {
            return ScriptRuntime.numberToString(cx, ((Number)val).doubleValue(), 10);
        }
        if (val instanceof Symbol) {
            throw ScriptRuntime.typeError0(cx, "msg.not.a.string");
        }
        if (val instanceof Scriptable) {
            if ((val = ((Scriptable)val).getDefaultValue(cx, StringClass)) instanceof Scriptable && !ScriptRuntime.isSymbol(val)) {
                throw ScriptRuntime.errorWithClassName("msg.primitive.expected", val, cx);
            }
            return ScriptRuntime.toString(cx, val);
        }
        return val.toString();
    }

    static String defaultObjectToString(Scriptable obj) {
        if (obj == null) {
            return "[object Null]";
        }
        if (Undefined.isUndefined(obj)) {
            return "[object Undefined]";
        }
        return "[object " + obj.getClassName() + "]";
    }

    public static String toString(Context cx, Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toString(cx, args[index]) : "undefined";
    }

    public static String toString(Context cx, double val) {
        return ScriptRuntime.numberToString(cx, val, 10);
    }

    public static String numberToString(Context cx, double d, int base) {
        if (base < 2 || base > 36) {
            throw Context.reportRuntimeError1("msg.bad.radix", Integer.toString(base), cx);
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Infinity";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "-Infinity";
        }
        if (d == 0.0) {
            return "0";
        }
        if (base != 10) {
            return DToA.JS_dtobasestr(base, d);
        }
        String result = FastDtoa.numberToString(d);
        if (result != null) {
            return result;
        }
        StringBuilder buffer = new StringBuilder();
        DToA.JS_dtostr(buffer, 0, 0, d);
        return buffer.toString();
    }

    static String uneval(Context cx, Scriptable scope, Object value) {
        if (value == null) {
            return "null";
        }
        if (value == Undefined.instance) {
            return "undefined";
        }
        if (value instanceof CharSequence) {
            String escaped = ScriptRuntime.escapeString(value.toString());
            return "\"" + escaped + "\"";
        }
        if (value instanceof Number) {
            double d = ((Number)value).doubleValue();
            if (d == 0.0 && 1.0 / d < 0.0) {
                return "-0";
            }
            return ScriptRuntime.toString(cx, d);
        }
        if (value instanceof Boolean) {
            return ScriptRuntime.toString(cx, value);
        }
        Object object = value;
        if (object instanceof Scriptable) {
            Object v;
            Object object2;
            Scriptable obj = (Scriptable)object;
            if (ScriptableObject.hasProperty(obj, "toSource", cx) && (object2 = (v = ScriptableObject.getProperty(obj, "toSource", cx))) instanceof Function) {
                Function f = (Function)object2;
                return ScriptRuntime.toString(cx, f.call(cx, scope, obj, EMPTY_OBJECTS));
            }
            return ScriptRuntime.toString(cx, value);
        }
        ScriptRuntime.warnAboutNonJSObject(cx, value);
        return value.toString();
    }

    static String defaultObjectToSource(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return "not_supported";
    }

    @Deprecated
    public static Scriptable toObjectOrNull(Context cx, Object obj) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        if (obj != null && obj != Undefined.instance) {
            return ScriptRuntime.toObject(cx, ScriptRuntime.getTopCallScope(cx), obj);
        }
        return null;
    }

    public static Scriptable toObjectOrNull(Context cx, Object obj, Scriptable scope) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        if (obj != null && obj != Undefined.instance) {
            return ScriptRuntime.toObject(cx, scope, obj);
        }
        return null;
    }

    public static Scriptable toObject(Context cx, Scriptable scope, Object val) {
        if (val == null) {
            throw ScriptRuntime.typeError0(cx, "msg.null.to.object");
        }
        if (Undefined.isUndefined(val)) {
            throw ScriptRuntime.typeError0(cx, "msg.undef.to.object");
        }
        if (ScriptRuntime.isSymbol(val)) {
            NativeSymbol result = new NativeSymbol((NativeSymbol)val);
            ScriptRuntime.setBuiltinProtoAndParent(cx, scope, result, TopLevel.Builtins.Symbol);
            return result;
        }
        if (val instanceof Scriptable) {
            return (Scriptable)val;
        }
        if (val instanceof CharSequence) {
            NativeString result = new NativeString((CharSequence)val);
            ScriptRuntime.setBuiltinProtoAndParent(cx, scope, result, TopLevel.Builtins.String);
            return result;
        }
        if (val instanceof Number) {
            NativeNumber result = new NativeNumber(cx, ((Number)val).doubleValue());
            ScriptRuntime.setBuiltinProtoAndParent(cx, scope, result, TopLevel.Builtins.Number);
            return result;
        }
        if (val instanceof Boolean) {
            NativeBoolean result = new NativeBoolean((Boolean)val);
            ScriptRuntime.setBuiltinProtoAndParent(cx, scope, result, TopLevel.Builtins.Boolean);
            return result;
        }
        Object wrapped = cx.getWrapFactory().wrap(cx, scope, val, null);
        if (wrapped instanceof Scriptable) {
            return (Scriptable)wrapped;
        }
        throw ScriptRuntime.errorWithClassName("msg.invalid.type", val, cx);
    }

    public static Scriptable newObject(Context cx, Scriptable scope, String constructorName, Object[] args) {
        scope = ScriptableObject.getTopLevelScope(scope);
        Function ctor = ScriptRuntime.getExistingCtor(cx, scope, constructorName);
        if (args == null) {
            args = EMPTY_OBJECTS;
        }
        return ctor.construct(cx, scope, args);
    }

    public static Scriptable newBuiltinObject(Context cx, Scriptable scope, TopLevel.Builtins type, Object[] args) {
        scope = ScriptableObject.getTopLevelScope(scope);
        Function ctor = TopLevel.getBuiltinCtor(cx, scope, type);
        if (args == null) {
            args = EMPTY_OBJECTS;
        }
        return ctor.construct(cx, scope, args);
    }

    static Scriptable newNativeError(Context cx, Scriptable scope, TopLevel.NativeErrors type, Object[] args) {
        scope = ScriptableObject.getTopLevelScope(scope);
        Function ctor = TopLevel.getNativeErrorCtor(cx, scope, type);
        if (args == null) {
            args = EMPTY_OBJECTS;
        }
        return ctor.construct(cx, scope, args);
    }

    public static double toInteger(Context cx, Object val) {
        return ScriptRuntime.toInteger(ScriptRuntime.toNumber(cx, val));
    }

    public static double toInteger(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        if (d == 0.0 || Double.isInfinite(d)) {
            return d;
        }
        if (d > 0.0) {
            return Math.floor(d);
        }
        return Math.ceil(d);
    }

    public static double toInteger(Context cx, Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInteger(cx, args[index]) : 0.0;
    }

    public static long toLength(Context cx, Object[] args, int index) {
        double len = ScriptRuntime.toInteger(cx, args, index);
        if (len <= 0.0) {
            return 0L;
        }
        return (long)Math.min(len, 9.007199254740991E15);
    }

    public static int toInt32(Context cx, Object val) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return ScriptRuntime.toInt32(ScriptRuntime.toNumber(cx, val));
    }

    public static int toInt32(Context cx, Object[] args, int index) {
        return index < args.length ? ScriptRuntime.toInt32(cx, args[index]) : 0;
    }

    public static int toInt32(double d) {
        return DoubleConversion.doubleToInt32(d);
    }

    public static long toUint32(double d) {
        return (long)DoubleConversion.doubleToInt32(d) & 0xFFFFFFFFL;
    }

    public static long toUint32(Context cx, Object val) {
        return ScriptRuntime.toUint32(ScriptRuntime.toNumber(cx, val));
    }

    public static char toUint16(Context cx, Object val) {
        double d = ScriptRuntime.toNumber(cx, val);
        return (char)DoubleConversion.doubleToInt32(d);
    }

    public static Object getTopLevelProp(Context cx, Scriptable scope, String id) {
        scope = ScriptableObject.getTopLevelScope(scope);
        return ScriptableObject.getProperty(scope, id, cx);
    }

    static Function getExistingCtor(Context cx, Scriptable scope, String constructorName) {
        Object ctorVal = ScriptableObject.getProperty(scope, constructorName, cx);
        if (ctorVal instanceof Function) {
            return (Function)ctorVal;
        }
        if (ctorVal == Scriptable.NOT_FOUND) {
            throw Context.reportRuntimeError1("msg.ctor.not.found", constructorName, cx);
        }
        throw Context.reportRuntimeError1("msg.not.ctor", constructorName, cx);
    }

    public static long indexFromString(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (len > 0) {
            int i = 0;
            boolean negate = false;
            int c = str.charAt(0);
            if (c == 45 && len > 1) {
                c = str.charAt(1);
                if (c == 48) {
                    return -1L;
                }
                i = 1;
                negate = true;
            }
            if (0 <= (c -= 48) && c <= 9 && len <= (negate ? 11 : 10)) {
                int index = -c;
                int oldIndex = 0;
                ++i;
                if (index != 0) {
                    while (i != len && 0 <= (c = str.charAt(i) - 48) && c <= 9) {
                        oldIndex = index;
                        index = 10 * index - c;
                        ++i;
                    }
                }
                if (i == len && (oldIndex > -214748364 || oldIndex == -214748364 && c <= (negate ? 8 : 7))) {
                    return 0xFFFFFFFFL & (long)(negate ? index : -index);
                }
            }
        }
        return -1L;
    }

    public static long testUint32String(String str) {
        int MAX_VALUE_LENGTH = 10;
        int len = str.length();
        if (1 <= len && len <= 10) {
            int c = str.charAt(0);
            if ((c -= 48) == 0) {
                return len == 1 ? 0L : -1L;
            }
            if (1 <= c && c <= 9) {
                long v = c;
                for (int i = 1; i != len; ++i) {
                    c = str.charAt(i) - 48;
                    if (0 > c || c > 9) {
                        return -1L;
                    }
                    v = 10L * v + (long)c;
                }
                if (v >>> 32 == 0L) {
                    return v;
                }
            }
        }
        return -1L;
    }

    static Object getIndexObject(String s) {
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return (int)indexTest;
        }
        return s;
    }

    static Object getIndexObject(Context cx, double d) {
        int i = (int)d;
        if ((double)i == d) {
            return i;
        }
        return ScriptRuntime.toString(cx, d);
    }

    static StringIdOrIndex toStringIdOrIndex(Context cx, Object id) {
        if (id instanceof Number) {
            double d = ((Number)id).doubleValue();
            int index = (int)d;
            if ((double)index == d) {
                return new StringIdOrIndex(index);
            }
            return new StringIdOrIndex(ScriptRuntime.toString(cx, id));
        }
        String s = id instanceof String ? (String)id : ScriptRuntime.toString(cx, id);
        long indexTest = ScriptRuntime.indexFromString(s);
        if (indexTest >= 0L) {
            return new StringIdOrIndex((int)indexTest);
        }
        return new StringIdOrIndex(s);
    }

    public static Object getObjectElem(Context cx, Scriptable scope, Object obj, Object elem) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefReadError(cx, obj, elem);
        }
        return ScriptRuntime.getObjectElem(cx, sobj, elem);
    }

    public static Object getObjectElem(Context cx, Scriptable obj, Object elem) {
        Object result;
        if (ScriptRuntime.isSymbol(elem)) {
            result = ScriptableObject.getProperty(obj, (Symbol)elem, cx);
        } else {
            StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, elem);
            if (s.stringId == null) {
                int index = s.index;
                result = ScriptableObject.getProperty(obj, index, cx);
            } else {
                result = ScriptableObject.getProperty(obj, s.stringId, cx);
            }
        }
        if (result == Scriptable.NOT_FOUND) {
            result = Undefined.instance;
        }
        return result;
    }

    public static Object getObjectProp(Context cx, Scriptable scope, Object obj, String property) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefReadError(cx, obj, property);
        }
        return ScriptRuntime.getObjectProp(cx, sobj, property);
    }

    public static Object getObjectProp(Context cx, Scriptable obj, String property) {
        Object result = ScriptableObject.getProperty(obj, property, cx);
        if (result == Scriptable.NOT_FOUND) {
            return Undefined.instance;
        }
        return result;
    }

    public static Object getObjectPropNoWarn(Context cx, Scriptable scope, Object obj, String property) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefReadError(cx, obj, property);
        }
        Object result = ScriptableObject.getProperty(sobj, property, cx);
        if (result == Scriptable.NOT_FOUND) {
            return Undefined.instance;
        }
        return result;
    }

    public static Object getObjectPropOptional(Context cx, Scriptable scope, Object obj, String property) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            return Undefined.instance;
        }
        Object result = ScriptableObject.getProperty(sobj, property, cx);
        if (result == Scriptable.NOT_FOUND) {
            return Undefined.instance;
        }
        return result;
    }

    public static Object getObjectIndex(Context cx, Scriptable scope, Object obj, double dblIndex) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefReadError(cx, obj, ScriptRuntime.toString(cx, dblIndex));
        }
        int index = (int)dblIndex;
        if ((double)index == dblIndex) {
            return ScriptRuntime.getObjectIndex(cx, sobj, index);
        }
        String s = ScriptRuntime.toString(cx, dblIndex);
        return ScriptRuntime.getObjectProp(cx, sobj, s);
    }

    public static Object getObjectIndex(Context cx, Scriptable obj, int index) {
        Object result = ScriptableObject.getProperty(obj, index, cx);
        if (result == Scriptable.NOT_FOUND) {
            result = Undefined.instance;
        }
        return result;
    }

    public static Object setObjectElem(Context cx, Scriptable scope, Object obj, Object elem, Object value) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefWriteError(cx, obj, elem, value);
        }
        return ScriptRuntime.setObjectElem(cx, sobj, elem, value);
    }

    public static Object setObjectElem(Context cx, Scriptable obj, Object elem, Object value) {
        if (ScriptRuntime.isSymbol(elem)) {
            ScriptableObject.putProperty(obj, (Symbol)elem, value, cx);
        } else {
            StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, elem);
            if (s.stringId == null) {
                ScriptableObject.putProperty(obj, s.index, value, cx);
            } else {
                ScriptableObject.putProperty(obj, s.stringId, value, cx);
            }
        }
        return value;
    }

    public static Object setObjectProp(Context cx, Scriptable scope, Object obj, String property, Object value) {
        if (!(obj instanceof Scriptable) && cx.isStrictMode()) {
            throw ScriptRuntime.undefWriteError(cx, obj, property, value);
        }
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefWriteError(cx, obj, property, value);
        }
        return ScriptRuntime.setObjectProp(cx, sobj, property, value);
    }

    public static Object setObjectProp(Context cx, Scriptable obj, String property, Object value) {
        ScriptableObject.putProperty(obj, property, value, cx);
        return value;
    }

    public static Object setObjectIndex(Context cx, Scriptable scope, Object obj, double dblIndex, Object value) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.undefWriteError(cx, obj, String.valueOf(dblIndex), value);
        }
        int index = (int)dblIndex;
        if ((double)index == dblIndex) {
            return ScriptRuntime.setObjectIndex(cx, sobj, index, value);
        }
        String s = ScriptRuntime.toString(cx, dblIndex);
        return ScriptRuntime.setObjectProp(cx, sobj, s, value);
    }

    public static Object setObjectIndex(Context cx, Scriptable obj, int index, Object value) {
        ScriptableObject.putProperty(obj, index, value, cx);
        return value;
    }

    public static boolean deleteObjectElem(Context cx, Scriptable target, Object elem) {
        if (ScriptRuntime.isSymbol(elem)) {
            SymbolScriptable so = ScriptableObject.ensureSymbolScriptable(target, cx);
            Symbol s = (Symbol)elem;
            so.delete(cx, s);
            return !so.has(cx, s, target);
        }
        StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, elem);
        if (s.stringId == null) {
            target.delete(cx, s.index);
            return !target.has(cx, s.index, target);
        }
        target.delete(cx, s.stringId);
        return !target.has(cx, s.stringId, target);
    }

    public static boolean hasObjectElem(Context cx, Scriptable target, Object elem) {
        boolean result;
        if (ScriptRuntime.isSymbol(elem)) {
            result = ScriptableObject.hasProperty(target, (Symbol)elem, cx);
        } else {
            StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, elem);
            result = s.stringId == null ? ScriptableObject.hasProperty(target, s.index, cx) : ScriptableObject.hasProperty(target, s.stringId, cx);
        }
        return result;
    }

    public static Object refGet(Context cx, Ref ref) {
        return ref.get(cx);
    }

    public static Object refSet(Context cx, Scriptable scope, Ref ref, Object value) {
        return ref.set(cx, scope, value);
    }

    public static Object refDel(Context cx, Ref ref) {
        return ref.delete(cx);
    }

    static boolean isSpecialProperty(String s) {
        return s.equals("__proto__") || s.equals("__parent__");
    }

    public static Ref specialRef(Context cx, Scriptable scope, Object obj, String specialProperty) {
        return SpecialRef.createSpecial(cx, scope, obj, specialProperty);
    }

    public static Object delete(Context cx, Scriptable scope, Object obj, Object id, boolean isName) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            if (isName) {
                return Boolean.TRUE;
            }
            throw ScriptRuntime.undefDeleteError(cx, obj, id);
        }
        return ScriptRuntime.deleteObjectElem(cx, sobj, id);
    }

    public static Object name(Context cx, Scriptable scope, String name) {
        Scriptable parent = scope.getParentScope();
        if (parent == null) {
            Object result = ScriptRuntime.topScopeName(cx, scope, name);
            if (result == Scriptable.NOT_FOUND) {
                throw ScriptRuntime.notFoundError(cx, scope, name);
            }
            return result;
        }
        return ScriptRuntime.nameOrFunction(cx, scope, parent, name, false);
    }

    private static Object nameOrFunction(Context cx, Scriptable scope, Scriptable parentScope, String name, boolean asFunctionCall) {
        Object result;
        Scriptable thisObj;
        block12: {
            thisObj = scope;
            do {
                if (scope instanceof NativeWith) {
                    Scriptable withObj = scope.getPrototype(cx);
                    result = ScriptableObject.getProperty(withObj, name, cx);
                    if (result != Scriptable.NOT_FOUND) {
                        thisObj = withObj;
                        break block12;
                    }
                } else if (scope instanceof NativeCall) {
                    result = scope.get(cx, name, scope);
                    if (result != Scriptable.NOT_FOUND) {
                        if (asFunctionCall) {
                            thisObj = ScriptableObject.getTopLevelScope(parentScope);
                        }
                        break block12;
                    }
                } else {
                    result = ScriptableObject.getProperty(scope, name, cx);
                    if (result != Scriptable.NOT_FOUND) {
                        thisObj = scope;
                        break block12;
                    }
                }
                scope = parentScope;
            } while ((parentScope = parentScope.getParentScope()) != null);
            result = ScriptRuntime.topScopeName(cx, scope, name);
            if (result == Scriptable.NOT_FOUND) {
                throw ScriptRuntime.notFoundError(cx, scope, name);
            }
            thisObj = scope;
        }
        if (asFunctionCall) {
            if (!(result instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(cx, result, name);
            }
            ScriptRuntime.storeScriptable(cx, thisObj);
        }
        return result;
    }

    private static Object topScopeName(Context cx, Scriptable scope, String name) {
        return ScriptableObject.getProperty(scope, name, cx);
    }

    public static Scriptable bind(Context cx, Scriptable scope, String id) {
        Scriptable firstXMLObject;
        block6: {
            firstXMLObject = null;
            Scriptable parent = scope.getParentScope();
            if (parent != null) {
                while (scope instanceof NativeWith) {
                    Scriptable withObj = scope.getPrototype(cx);
                    if (ScriptableObject.hasProperty(withObj, id, cx)) {
                        return withObj;
                    }
                    scope = parent;
                    if ((parent = parent.getParentScope()) != null) continue;
                    break block6;
                }
                do {
                    if (ScriptableObject.hasProperty(scope, id, cx)) {
                        return scope;
                    }
                    scope = parent;
                } while ((parent = parent.getParentScope()) != null);
            }
        }
        if (ScriptableObject.hasProperty(scope, id, cx)) {
            return scope;
        }
        return firstXMLObject;
    }

    public static Object setName(Context cx, Scriptable scope, Scriptable bound, Object value, String id) {
        if (bound != null) {
            ScriptableObject.putProperty(bound, id, value, cx);
        } else {
            Context.reportError(cx, ScriptRuntime.getMessage1("msg.assn.create.strict", id));
            bound = ScriptableObject.getTopLevelScope(scope);
            bound.put(cx, id, bound, value);
        }
        return value;
    }

    public static Object strictSetName(Context cx, Scriptable scope, Scriptable bound, Object value, String id) {
        if (bound != null) {
            ScriptableObject.putProperty(bound, id, value, cx);
            return value;
        }
        String msg = "Assignment to undefined \"" + id + "\" in strict mode";
        throw ScriptRuntime.constructError(cx, "ReferenceError", msg);
    }

    public static Object setConst(Context cx, Scriptable bound, Object value, String id) {
        ScriptableObject.putConstProperty(bound, id, value, cx);
        return value;
    }

    public static Scriptable toIterator(Context cx, Scriptable scope, Scriptable obj, boolean keyOnly) {
        if (ScriptableObject.hasProperty(obj, "__iterator__", cx)) {
            Object v = ScriptableObject.getProperty(obj, "__iterator__", cx);
            Object object = v;
            if (!(object instanceof Callable)) {
                throw ScriptRuntime.typeError0(cx, "msg.invalid.iterator");
            }
            Callable f = (Callable)object;
            Object[] args = new Object[]{keyOnly ? Boolean.TRUE : Boolean.FALSE};
            v = f.call(cx, scope, obj, args);
            if (!(v instanceof Scriptable)) {
                throw ScriptRuntime.typeError0(cx, "msg.iterator.primitive");
            }
            return (Scriptable)v;
        }
        return null;
    }

    public static IdEnumeration enumInit(Context cx, Scriptable scope, Object value, int enumType) {
        IdEnumeration x = new IdEnumeration();
        x.obj = ScriptRuntime.toObjectOrNull(cx, value, scope);
        if (enumType == 6) {
            x.enumType = enumType;
            x.iterator = null;
            return ScriptRuntime.enumInitInOrder(cx, x);
        }
        if (x.obj == null) {
            return x;
        }
        x.enumType = enumType;
        x.iterator = null;
        if (enumType != 3 && enumType != 4 && enumType != 5) {
            x.iterator = ScriptRuntime.toIterator(cx, x.obj.getParentScope(), x.obj, enumType == 0);
        }
        if (x.iterator == null) {
            x.changeObject(cx);
        }
        return x;
    }

    private static IdEnumeration enumInitInOrder(Context cx, IdEnumeration x) {
        Object iterator = x.obj instanceof SymbolScriptable ? ScriptableObject.getProperty(x.obj, SymbolKey.ITERATOR, cx) : null;
        Object object = iterator;
        if (!(object instanceof Callable)) {
            if (iterator instanceof IdEnumerationIterator) {
                x.iterator = (IdEnumerationIterator)iterator;
                return x;
            }
            throw ScriptRuntime.typeError1(cx, "msg.not.iterable", ScriptRuntime.toString(cx, x.obj));
        }
        Callable f = (Callable)object;
        Scriptable scope = x.obj.getParentScope();
        Object v = f.call(cx, scope, x.obj, EMPTY_OBJECTS);
        if (!(v instanceof Scriptable)) {
            if (v instanceof IdEnumerationIterator) {
                x.iterator = (IdEnumerationIterator)v;
                return x;
            }
            throw ScriptRuntime.typeError1(cx, "msg.not.iterable", ScriptRuntime.toString(cx, x.obj));
        }
        x.iterator = (Scriptable)v;
        return x;
    }

    public static Callable getNameFunctionAndThis(Context cx, Scriptable scope, String name) {
        Scriptable parent = scope.getParentScope();
        if (parent == null) {
            Object result = ScriptRuntime.topScopeName(cx, scope, name);
            if (!(result instanceof Callable)) {
                if (result == Scriptable.NOT_FOUND) {
                    throw ScriptRuntime.notFoundError(cx, scope, name);
                }
                throw ScriptRuntime.notFunctionError(cx, result, name);
            }
            Scriptable thisObj = scope;
            ScriptRuntime.storeScriptable(cx, thisObj);
            return (Callable)result;
        }
        return (Callable)ScriptRuntime.nameOrFunction(cx, scope, parent, name, true);
    }

    public static Callable getElemFunctionAndThis(Context cx, Scriptable scope, Object obj, Object elem) {
        Object value;
        Scriptable thisObj;
        if (ScriptRuntime.isSymbol(elem)) {
            thisObj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
            if (thisObj == null) {
                throw ScriptRuntime.undefCallError(cx, obj, String.valueOf(elem));
            }
            value = ScriptableObject.getProperty(thisObj, (Symbol)elem, cx);
        } else {
            StringIdOrIndex s = ScriptRuntime.toStringIdOrIndex(cx, elem);
            if (s.stringId != null) {
                return ScriptRuntime.getPropFunctionAndThis(cx, scope, obj, s.stringId);
            }
            thisObj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
            if (thisObj == null) {
                throw ScriptRuntime.undefCallError(cx, obj, String.valueOf(elem));
            }
            value = ScriptableObject.getProperty(thisObj, s.index, cx);
        }
        if (!(value instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, value, elem);
        }
        ScriptRuntime.storeScriptable(cx, thisObj);
        return (Callable)value;
    }

    public static Callable getPropFunctionAndThis(Context cx, Scriptable scope, Object obj, String property) {
        Scriptable thisObj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        return ScriptRuntime.getPropFunctionAndThisHelper(cx, thisObj, obj, property);
    }

    private static Callable getPropFunctionAndThisHelper(Context cx, Scriptable thisObj, Object obj, String property) {
        Object noSuchMethod;
        if (thisObj == null) {
            throw ScriptRuntime.undefCallError(cx, obj, property);
        }
        Object value = ScriptableObject.getProperty(thisObj, property, cx);
        if (!(value instanceof Callable) && (noSuchMethod = ScriptableObject.getProperty(thisObj, "__noSuchMethod__", cx)) instanceof Callable) {
            value = new NoSuchMethodShim((Callable)noSuchMethod, property);
        }
        if (!(value instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, thisObj, value, property);
        }
        ScriptRuntime.storeScriptable(cx, thisObj);
        return (Callable)value;
    }

    public static Callable getValueFunctionAndThis(Context cx, Object value) {
        Object object = value;
        if (!(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(cx, value);
        }
        Callable f = (Callable)object;
        Scriptable thisObj = null;
        if (f instanceof Scriptable) {
            thisObj = ((Scriptable)((Object)f)).getParentScope();
        }
        if (thisObj == null) {
            if (cx.topCallScope == null) {
                throw new IllegalStateException();
            }
            thisObj = cx.topCallScope;
        }
        if (thisObj.getParentScope() != null && !(thisObj instanceof NativeWith) && thisObj instanceof NativeCall) {
            thisObj = ScriptableObject.getTopLevelScope(thisObj);
        }
        ScriptRuntime.storeScriptable(cx, thisObj);
        return f;
    }

    public static Object callIterator(Context cx, Scriptable scope, Object obj) {
        Callable getIterator = ScriptRuntime.getElemFunctionAndThis(cx, scope, obj, SymbolKey.ITERATOR);
        Scriptable iterable = ScriptRuntime.lastStoredScriptable(cx);
        return getIterator.call(cx, scope, iterable, EMPTY_OBJECTS);
    }

    public static boolean isIteratorDone(Context cx, Object result) {
        if (!(result instanceof Scriptable)) {
            return false;
        }
        Object prop = ScriptRuntime.getObjectProp(cx, (Scriptable)result, "done");
        return ScriptRuntime.toBoolean(cx, prop);
    }

    public static Ref callRef(Context cx, Scriptable thisObj, Callable function, Object[] args) {
        Callable callable = function;
        if (callable instanceof RefCallable) {
            RefCallable rfunction = (RefCallable)callable;
            Ref ref = rfunction.refCall(cx, thisObj, args);
            if (ref == null) {
                throw new IllegalStateException(rfunction.getClass().getName() + ".refCall() returned null");
            }
            return ref;
        }
        String msg = ScriptRuntime.getMessage1("msg.no.ref.from.function", ScriptRuntime.toString(cx, function));
        throw ScriptRuntime.constructError(cx, "ReferenceError", msg);
    }

    public static Scriptable newObject(Object fun, Context cx, Scriptable scope, Object[] args) {
        Object object = fun;
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(cx, fun);
        }
        Function function = (Function)object;
        return function.construct(cx, scope, args);
    }

    public static Object callSpecial(Context cx, Scriptable scope, Callable fun, Scriptable thisObj, Object[] args, Scriptable callerThis, int callType, String filename, int lineNumber) {
        if (callType == 1) {
            if (thisObj.getParentScope() == null && NativeGlobal.isEvalFunction(fun)) {
                return ScriptRuntime.evalSpecial(cx, scope, callerThis, args, filename, lineNumber);
            }
        } else if (callType == 2) {
            if (NativeWith.isWithFunction(fun)) {
                throw Context.reportRuntimeError1("msg.only.from.new", "With", cx);
            }
        } else {
            throw Kit.codeBug();
        }
        return fun.call(cx, scope, thisObj, args);
    }

    public static Object newSpecial(Context cx, Scriptable scope, Object fun, Object[] args, int callType) {
        if (callType == 1) {
            if (NativeGlobal.isEvalFunction(fun)) {
                throw ScriptRuntime.typeError1(cx, "msg.not.ctor", "eval");
            }
        } else if (callType == 2) {
            if (NativeWith.isWithFunction(fun)) {
                return NativeWith.newWithSpecial(cx, scope, args);
            }
        } else {
            throw Kit.codeBug();
        }
        return ScriptRuntime.newObject(fun, cx, scope, args);
    }

    public static Object applyOrCall(Context cx, Scriptable scope, boolean isApply, Scriptable thisObj, Object[] args) {
        Object[] callArgs;
        int L = args.length;
        Callable function = ScriptRuntime.getCallable(cx, thisObj);
        Scriptable callThis = null;
        if (L != 0) {
            Scriptable scriptable = callThis = args[0] == Undefined.instance ? Undefined.SCRIPTABLE_UNDEFINED : ScriptRuntime.toObjectOrNull(cx, args[0], scope);
        }
        if (isApply) {
            callArgs = L <= 1 ? EMPTY_OBJECTS : ScriptRuntime.getApplyArguments(cx, args[1]);
        } else if (L <= 1) {
            callArgs = EMPTY_OBJECTS;
        } else {
            callArgs = new Object[L - 1];
            System.arraycopy(args, 1, callArgs, 0, L - 1);
        }
        return function.call(cx, scope, callThis, callArgs);
    }

    private static boolean isArrayLike(Context cx, Scriptable obj) {
        return obj != null && (obj instanceof NativeArray || obj instanceof Arguments || ScriptableObject.hasProperty(obj, "length", cx));
    }

    static Object[] getApplyArguments(Context cx, Object arg1) {
        if (arg1 == null || arg1 == Undefined.instance) {
            return EMPTY_OBJECTS;
        }
        if (arg1 instanceof Scriptable && ScriptRuntime.isArrayLike(cx, (Scriptable)arg1)) {
            return ScriptRuntime.getArrayElements(cx, (Scriptable)arg1);
        }
        if (arg1 instanceof ScriptableObject) {
            return EMPTY_OBJECTS;
        }
        throw ScriptRuntime.typeError0(cx, "msg.arg.isnt.array");
    }

    static Callable getCallable(Context cx, Scriptable thisObj) {
        Callable function;
        if (thisObj instanceof Callable) {
            function = (Callable)((Object)thisObj);
        } else {
            Object value = thisObj.getDefaultValue(cx, FunctionClass);
            if (!(value instanceof Callable)) {
                throw ScriptRuntime.notFunctionError(cx, value, thisObj);
            }
            function = (Callable)value;
        }
        return function;
    }

    public static Object evalSpecial(Context cx, Scriptable scope, Object thisArg, Object[] args, String filename, int lineNumber) {
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object x = args[0];
        if (!(x instanceof CharSequence)) {
            String message = ScriptRuntime.getMessage0("msg.eval.nonstring");
            Context.reportWarning(message, cx);
            return x;
        }
        if (filename == null) {
            int[] linep = new int[1];
            filename = Context.getSourcePositionFromStack(cx, linep);
            if (filename != null) {
                lineNumber = linep[0];
            } else {
                filename = "";
            }
        }
        String sourceName = ScriptRuntime.makeUrlForGeneratedScript(true, filename, lineNumber);
        ErrorReporter reporter = DefaultErrorReporter.forEval(cx.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException(cx, "Interpreter not present", filename, lineNumber);
        }
        Script script = cx.compileString(x.toString(), evaluator, reporter, sourceName, 1, null);
        evaluator.setEvalScriptFlag(script);
        Callable c = (Callable)((Object)script);
        return c.call(cx, scope, (Scriptable)thisArg, EMPTY_OBJECTS);
    }

    public static MemberType typeof(Context cx, Object value) {
        return MemberType.get(value, cx);
    }

    public static MemberType typeofName(Context cx, Scriptable scope, String id) {
        Scriptable val = ScriptRuntime.bind(cx, scope, id);
        if (val == null) {
            return MemberType.UNDEFINED;
        }
        return ScriptRuntime.typeof(cx, ScriptRuntime.getObjectProp(cx, val, id));
    }

    public static boolean isObject(Object value) {
        if (value == null) {
            return false;
        }
        if (Undefined.instance.equals(value)) {
            return false;
        }
        if (value instanceof ScriptableObject) {
            MemberType type = ((ScriptableObject)value).getTypeOf();
            return type == MemberType.OBJECT || type == MemberType.FUNCTION;
        }
        if (value instanceof Scriptable) {
            return !(value instanceof Callable);
        }
        return false;
    }

    public static Object add(Context cx, Object val1, Object val2) {
        if (val1 instanceof Number && val2 instanceof Number) {
            return ScriptRuntime.wrapNumber(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
        }
        if (val1 instanceof Symbol || val2 instanceof Symbol) {
            throw ScriptRuntime.typeError0(cx, "msg.not.a.number");
        }
        if (val1 instanceof Scriptable) {
            val1 = ((Scriptable)val1).getDefaultValue(cx, null);
        }
        if (val2 instanceof Scriptable) {
            val2 = ((Scriptable)val2).getDefaultValue(cx, null);
        }
        if (!(val1 instanceof CharSequence) && !(val2 instanceof CharSequence)) {
            if (val1 instanceof Number && val2 instanceof Number) {
                return ScriptRuntime.wrapNumber(((Number)val1).doubleValue() + ((Number)val2).doubleValue());
            }
            return ScriptRuntime.wrapNumber(ScriptRuntime.toNumber(cx, val1) + ScriptRuntime.toNumber(cx, val2));
        }
        return new ConsString(ScriptRuntime.toCharSequence(cx, val1), ScriptRuntime.toCharSequence(cx, val2));
    }

    public static CharSequence add(Context cx, CharSequence val1, Object val2) {
        return new ConsString(val1, ScriptRuntime.toCharSequence(cx, val2));
    }

    public static CharSequence add(Context cx, Object val1, CharSequence val2) {
        return new ConsString(ScriptRuntime.toCharSequence(cx, val1), val2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object nameIncrDecr(Context cx, Scriptable scopeChain, String id, int incrDecrMask) {
        do {
            Scriptable target = scopeChain;
            do {
                Object value;
                if ((value = target.get(cx, id, scopeChain)) == Scriptable.NOT_FOUND) continue;
                return ScriptRuntime.doScriptableIncrDecr(cx, target, id, scopeChain, value, incrDecrMask);
            } while ((target = target.getPrototype(cx)) != null);
        } while ((scopeChain = scopeChain.getParentScope()) != null);
        throw ScriptRuntime.notFoundError(cx, null, id);
    }

    public static Object propIncrDecr(Context cx, Scriptable scope, Object obj, String id, int incrDecrMask) {
        Object value;
        Scriptable start = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (start == null) {
            throw ScriptRuntime.undefReadError(cx, obj, id);
        }
        Scriptable target = start;
        while ((value = target.get(cx, id, start)) == Scriptable.NOT_FOUND) {
            if ((target = target.getPrototype(cx)) != null) continue;
            start.put(cx, id, start, (Object)NaNobj);
            return NaNobj;
        }
        return ScriptRuntime.doScriptableIncrDecr(cx, target, id, start, value, incrDecrMask);
    }

    private static Object doScriptableIncrDecr(Context cx, Scriptable target, String id, Scriptable protoChainStart, Object value, int incrDecrMask) {
        double number;
        boolean post;
        boolean bl = post = (incrDecrMask & 2) != 0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else {
            number = ScriptRuntime.toNumber(cx, value);
            if (post) {
                value = ScriptRuntime.wrapNumber(number);
            }
        }
        number = (incrDecrMask & 1) == 0 ? (number += 1.0) : (number -= 1.0);
        Number result = ScriptRuntime.wrapNumber(number);
        target.put(cx, id, protoChainStart, (Object)result);
        if (post) {
            return value;
        }
        return result;
    }

    public static Object elemIncrDecr(Context cx, Object obj, Object index, Scriptable scope, int incrDecrMask) {
        double number;
        boolean post;
        Object value = ScriptRuntime.getObjectElem(cx, scope, obj, index);
        boolean bl = post = (incrDecrMask & 2) != 0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else {
            number = ScriptRuntime.toNumber(cx, value);
            if (post) {
                value = ScriptRuntime.wrapNumber(number);
            }
        }
        number = (incrDecrMask & 1) == 0 ? (number += 1.0) : (number -= 1.0);
        Number result = ScriptRuntime.wrapNumber(number);
        ScriptRuntime.setObjectElem(cx, scope, obj, index, result);
        if (post) {
            return value;
        }
        return result;
    }

    public static Object refIncrDecr(Context cx, Scriptable scope, Ref ref, int incrDecrMask) {
        double number;
        boolean post;
        Object value = ref.get(cx);
        boolean bl = post = (incrDecrMask & 2) != 0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else {
            number = ScriptRuntime.toNumber(cx, value);
            if (post) {
                value = ScriptRuntime.wrapNumber(number);
            }
        }
        number = (incrDecrMask & 1) == 0 ? (number += 1.0) : (number -= 1.0);
        Number result = ScriptRuntime.wrapNumber(number);
        ref.set(cx, scope, result);
        if (post) {
            return value;
        }
        return result;
    }

    public static Object toPrimitive(Context cx, Object val) {
        return ScriptRuntime.toPrimitive(cx, val, null);
    }

    public static Object toPrimitive(Context cx, Object val, Class<?> typeHint) {
        Object object = val;
        if (!(object instanceof Scriptable)) {
            return val;
        }
        Scriptable s = (Scriptable)object;
        Object result = s.getDefaultValue(cx, typeHint);
        if (result instanceof Scriptable && !ScriptRuntime.isSymbol(result)) {
            throw ScriptRuntime.typeError0(cx, "msg.bad.default.value");
        }
        return result;
    }

    public static boolean eq(Context cx, Object x, Object y) {
        Object y1;
        if (x == null || x == Undefined.instance) {
            Object test;
            if (y == null || y == Undefined.instance) {
                return true;
            }
            if (y instanceof ScriptableObject && (test = ((ScriptableObject)y).equivalentValues(x)) != Scriptable.NOT_FOUND) {
                return (Boolean)test;
            }
            return false;
        }
        if (x == y) {
            return true;
        }
        Object x1 = Wrapper.unwrapped(x);
        if (x1 == (y1 = Wrapper.unwrapped(y))) {
            return true;
        }
        if (SpecialEquality.checkSpecialEquality(x1, y1, false)) {
            return true;
        }
        if (SpecialEquality.checkSpecialEquality(y1, x1, false)) {
            return true;
        }
        if (x instanceof Number) {
            return ScriptRuntime.eqNumber(cx, ((Number)x).doubleValue(), y);
        }
        if (x instanceof CharSequence) {
            return ScriptRuntime.eqString(cx, (CharSequence)x, y);
        }
        if (x instanceof Boolean) {
            Object test;
            boolean b = (Boolean)x;
            if (y instanceof Boolean) {
                return b == (Boolean)y;
            }
            if (y instanceof ScriptableObject && (test = ((ScriptableObject)y).equivalentValues(x)) != Scriptable.NOT_FOUND) {
                return (Boolean)test;
            }
            return ScriptRuntime.eqNumber(cx, b ? 1.0 : 0.0, y);
        }
        if (x instanceof Scriptable) {
            if (y instanceof Scriptable) {
                Object test;
                if (x instanceof ScriptableObject && (test = ((ScriptableObject)x).equivalentValues(y)) != Scriptable.NOT_FOUND) {
                    return (Boolean)test;
                }
                if (y instanceof ScriptableObject && (test = ((ScriptableObject)y).equivalentValues(x)) != Scriptable.NOT_FOUND) {
                    return (Boolean)test;
                }
                if (x instanceof Wrapper && y instanceof Wrapper) {
                    return x1 == y1 || ScriptRuntime.isPrimitive(x1) && ScriptRuntime.isPrimitive(y1) && ScriptRuntime.eq(cx, x1, y1);
                }
                return false;
            }
            if (y instanceof Boolean) {
                Object test;
                if (x instanceof ScriptableObject && (test = ((ScriptableObject)x).equivalentValues(y)) != Scriptable.NOT_FOUND) {
                    return (Boolean)test;
                }
                double d = (Boolean)y != false ? 1.0 : 0.0;
                return ScriptRuntime.eqNumber(cx, d, x);
            }
            if (y instanceof Number) {
                return ScriptRuntime.eqNumber(cx, ((Number)y).doubleValue(), x);
            }
            if (y instanceof CharSequence) {
                return ScriptRuntime.eqString(cx, (CharSequence)y, x);
            }
            return false;
        }
        ScriptRuntime.warnAboutNonJSObject(cx, x);
        return x == y;
    }

    public static boolean same(Context cx, Object x, Object y) {
        if (ScriptRuntime.typeof(cx, x) != ScriptRuntime.typeof(cx, y)) {
            return false;
        }
        if (x instanceof Number) {
            if (ScriptRuntime.isNaN(x) && ScriptRuntime.isNaN(y)) {
                return true;
            }
            return x.equals(y);
        }
        return ScriptRuntime.eq(cx, x, y);
    }

    public static boolean sameZero(Context cx, Object x, Object y) {
        x = Wrapper.unwrapped(x);
        y = Wrapper.unwrapped(y);
        if (ScriptRuntime.typeof(cx, x) != ScriptRuntime.typeof(cx, y)) {
            return false;
        }
        if (x instanceof Number) {
            if (ScriptRuntime.isNaN(x) && ScriptRuntime.isNaN(y)) {
                return true;
            }
            double dx = ((Number)x).doubleValue();
            if (y instanceof Number) {
                double dy = ((Number)y).doubleValue();
                if (dx == negativeZero && dy == 0.0 || dx == 0.0 && dy == negativeZero) {
                    return true;
                }
            }
            return ScriptRuntime.eqNumber(cx, dx, y);
        }
        return ScriptRuntime.eq(cx, x, y);
    }

    public static boolean isNaN(Object n) {
        if (n instanceof Double) {
            return ((Double)n).isNaN();
        }
        if (n instanceof Float) {
            return ((Float)n).isNaN();
        }
        return false;
    }

    public static boolean isPrimitive(Object obj) {
        return obj == null || obj == Undefined.instance || obj instanceof Number || obj instanceof String || obj instanceof Boolean;
    }

    static boolean eqNumber(Context cx, double x, Object y) {
        if (y == null || y == Undefined.instance) {
            return false;
        }
        if (y instanceof Number) {
            return x == ((Number)y).doubleValue();
        }
        if (y instanceof CharSequence) {
            return x == ScriptRuntime.toNumber(cx, y);
        }
        if (y instanceof Boolean) {
            return x == ((Boolean)y != false ? 1.0 : 0.0);
        }
        if (ScriptRuntime.isSymbol(y)) {
            return false;
        }
        if (y instanceof Scriptable) {
            Number xval;
            Object test;
            if (y instanceof ScriptableObject && (test = ((ScriptableObject)y).equivalentValues(xval = ScriptRuntime.wrapNumber(x))) != Scriptable.NOT_FOUND) {
                return (Boolean)test;
            }
            return ScriptRuntime.eqNumber(cx, x, ScriptRuntime.toPrimitive(cx, y));
        }
        ScriptRuntime.warnAboutNonJSObject(cx, y);
        return false;
    }

    private static boolean eqString(Context cx, CharSequence x, Object y) {
        if (y == null || y == Undefined.instance) {
            return false;
        }
        Object object = y;
        if (object instanceof CharSequence) {
            CharSequence c = (CharSequence)object;
            return x.length() == c.length() && x.toString().equals(c.toString());
        }
        if (y instanceof Number) {
            return ScriptRuntime.toNumber(cx, x.toString()) == ((Number)y).doubleValue();
        }
        if (y instanceof Boolean) {
            return ScriptRuntime.toNumber(cx, x.toString()) == ((Boolean)y != false ? 1.0 : 0.0);
        }
        if (ScriptRuntime.isSymbol(y)) {
            return false;
        }
        if (y instanceof Scriptable) {
            Object test;
            if (y instanceof ScriptableObject && (test = ((ScriptableObject)y).equivalentValues(x.toString())) != Scriptable.NOT_FOUND) {
                return (Boolean)test;
            }
            return ScriptRuntime.eqString(cx, x, ScriptRuntime.toPrimitive(cx, y));
        }
        ScriptRuntime.warnAboutNonJSObject(cx, y);
        return false;
    }

    public static boolean shallowEq(Context cx, Object x, Object y) {
        Object y1;
        if (x == y) {
            if (!(x instanceof Number)) {
                return true;
            }
            double d = ((Number)x).doubleValue();
            return !Double.isNaN(d);
        }
        if (x == null || x == Undefined.instance || x == Undefined.SCRIPTABLE_UNDEFINED) {
            return x == Undefined.instance && y == Undefined.SCRIPTABLE_UNDEFINED || x == Undefined.SCRIPTABLE_UNDEFINED && y == Undefined.instance;
        }
        Object x1 = Wrapper.unwrapped(x);
        if (x1 == (y1 = Wrapper.unwrapped(y))) {
            return true;
        }
        if (SpecialEquality.checkSpecialEquality(x1, y1, true)) {
            return true;
        }
        if (SpecialEquality.checkSpecialEquality(y1, x1, true)) {
            return true;
        }
        if (x1 instanceof Number) {
            if (y1 instanceof Number) {
                return ((Number)x1).doubleValue() == ((Number)y1).doubleValue();
            }
        } else {
            if (x1 instanceof CharSequence) {
                return x1.toString().equals(String.valueOf(y1));
            }
            if (y1 instanceof CharSequence) {
                return y1.toString().equals(String.valueOf(x1));
            }
            if (x1 instanceof Boolean) {
                if (y1 instanceof Boolean) {
                    return x1.equals(y1);
                }
            } else if (!(x1 instanceof Scriptable)) {
                ScriptRuntime.warnAboutNonJSObject(cx, x1);
            }
        }
        return false;
    }

    public static boolean instanceOf(Context cx, Object a, Object b) {
        if (!(b instanceof Scriptable)) {
            throw ScriptRuntime.typeError0(cx, "msg.instanceof.not.object");
        }
        if (!(a instanceof Scriptable)) {
            return false;
        }
        return ((Scriptable)b).hasInstance(cx, (Scriptable)a);
    }

    public static boolean jsDelegatesTo(Context cx, Scriptable lhs, Scriptable rhs) {
        for (Scriptable proto = lhs.getPrototype(cx); proto != null; proto = proto.getPrototype(cx)) {
            if (!proto.equals(rhs)) continue;
            return true;
        }
        return false;
    }

    public static boolean in(Context cx, Object a, Object b) {
        if (!(b instanceof Scriptable)) {
            throw ScriptRuntime.typeError0(cx, "msg.in.not.object");
        }
        return ScriptRuntime.hasObjectElem(cx, (Scriptable)b, a);
    }

    public static boolean cmp_LT(Context cx, Object val1, Object val2) {
        double d2;
        double d1;
        if (val1 instanceof Number && val2 instanceof Number) {
            d1 = ((Number)val1).doubleValue();
            d2 = ((Number)val2).doubleValue();
        } else {
            if (val1 instanceof Symbol || val2 instanceof Symbol) {
                throw ScriptRuntime.typeError0(cx, "msg.compare.symbol");
            }
            if (val1 instanceof Scriptable) {
                val1 = ((Scriptable)val1).getDefaultValue(cx, NumberClass);
            }
            if (val2 instanceof Scriptable) {
                val2 = ((Scriptable)val2).getDefaultValue(cx, NumberClass);
            }
            if (val1 instanceof CharSequence && val2 instanceof CharSequence) {
                return val1.toString().compareTo(val2.toString()) < 0;
            }
            d1 = ScriptRuntime.toNumber(cx, val1);
            d2 = ScriptRuntime.toNumber(cx, val2);
        }
        return d1 < d2;
    }

    public static boolean cmp_LE(Context cx, Object val1, Object val2) {
        double d2;
        double d1;
        if (val1 instanceof Number && val2 instanceof Number) {
            d1 = ((Number)val1).doubleValue();
            d2 = ((Number)val2).doubleValue();
        } else {
            if (val1 instanceof Symbol || val2 instanceof Symbol) {
                throw ScriptRuntime.typeError0(cx, "msg.compare.symbol");
            }
            if (val1 instanceof Scriptable) {
                val1 = ((Scriptable)val1).getDefaultValue(cx, NumberClass);
            }
            if (val2 instanceof Scriptable) {
                val2 = ((Scriptable)val2).getDefaultValue(cx, NumberClass);
            }
            if (val1 instanceof CharSequence && val2 instanceof CharSequence) {
                return val1.toString().compareTo(val2.toString()) <= 0;
            }
            d1 = ScriptRuntime.toNumber(cx, val1);
            d2 = ScriptRuntime.toNumber(cx, val2);
        }
        return d1 <= d2;
    }

    public static boolean hasTopCall(Context cx) {
        return cx.topCallScope != null;
    }

    public static Scriptable getTopCallScope(Context cx) {
        Scriptable scope = cx.topCallScope;
        if (scope == null) {
            throw new IllegalStateException();
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doTopCall(Context cx, Scriptable scope, Callable callable, Scriptable thisObj, Object[] args, boolean isTopLevelStrict) {
        Object result;
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        if (cx.topCallScope != null) {
            throw new IllegalStateException();
        }
        cx.topCallScope = ScriptableObject.getTopLevelScope(scope);
        boolean previousTopLevelStrict = cx.isTopLevelStrict;
        cx.isTopLevelStrict = isTopLevelStrict;
        try {
            result = cx.doTopCall(callable, scope, thisObj, args);
        }
        finally {
            cx.topCallScope = null;
            cx.isTopLevelStrict = previousTopLevelStrict;
            if (cx.currentActivationCall != null) {
                throw new IllegalStateException();
            }
        }
        return result;
    }

    public static void initScript(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, boolean evalScript) {
        if (cx.topCallScope == null) {
            throw new IllegalStateException();
        }
        int varCount = funObj.getParamAndVarCount();
        if (varCount != 0) {
            Scriptable varScope = scope;
            while (varScope instanceof NativeWith) {
                varScope = varScope.getParentScope();
            }
            int i = varCount;
            while (i-- != 0) {
                String name = funObj.getParamOrVarName(i);
                boolean isConst = funObj.getParamOrVarConst(i);
                if (!ScriptableObject.hasProperty(scope, name, cx)) {
                    if (isConst) {
                        ScriptableObject.defineConstProperty(varScope, name, cx);
                        continue;
                    }
                    if (!evalScript) {
                        if (funObj instanceof InterpretedFunction && !((InterpretedFunction)funObj).hasFunctionNamed(name)) continue;
                        ScriptableObject.defineProperty(varScope, name, Undefined.instance, 4, cx);
                        continue;
                    }
                    varScope.put(cx, name, varScope, Undefined.instance);
                    continue;
                }
                ScriptableObject.redefineProperty(scope, name, isConst, cx);
            }
        }
    }

    public static Scriptable createFunctionActivation(Context cx, Scriptable scope, NativeFunction funObj, Object[] args, boolean isStrict) {
        return new NativeCall(funObj, scope, args, false, isStrict, cx);
    }

    public static Scriptable createArrowFunctionActivation(Context cx, Scriptable scope, NativeFunction funObj, Object[] args, boolean isStrict) {
        return new NativeCall(funObj, scope, args, true, isStrict, cx);
    }

    public static void enterActivationFunction(Context cx, Scriptable scope) {
        if (cx.topCallScope == null) {
            throw new IllegalStateException();
        }
        NativeCall call = (NativeCall)scope;
        call.parentActivationCall = cx.currentActivationCall;
        cx.currentActivationCall = call;
        call.defineAttributesForArguments(cx);
    }

    public static void exitActivationFunction(Context cx) {
        NativeCall call = cx.currentActivationCall;
        cx.currentActivationCall = call.parentActivationCall;
        call.parentActivationCall = null;
    }

    static NativeCall findFunctionActivation(Context cx, Function f) {
        NativeCall call = cx.currentActivationCall;
        while (call != null) {
            if (call.function == f) {
                return call;
            }
            call = call.parentActivationCall;
        }
        return null;
    }

    public static Scriptable newCatchScope(Context cx, Scriptable scope, Throwable t, Scriptable lastCatchScope, String exceptionName) {
        Object obj;
        boolean cacheObj;
        if (t instanceof JavaScriptException) {
            cacheObj = false;
            obj = ((JavaScriptException)t).getValue();
        } else {
            cacheObj = true;
            if (lastCatchScope != null) {
                NativeObject last = (NativeObject)lastCatchScope;
                obj = last.getAssociatedValue(t);
                if (obj == null) {
                    Kit.codeBug();
                }
            } else {
                Object wrap;
                int line;
                Object[] args;
                Scriptable errorObject;
                Object errorMsg;
                TopLevel.NativeErrors type;
                RhinoException re;
                Throwable javaException = null;
                Throwable throwable = t;
                if (throwable instanceof EcmaError) {
                    EcmaError ee = (EcmaError)throwable;
                    re = ee;
                    type = TopLevel.NativeErrors.valueOf(ee.getName());
                    errorMsg = ee.getErrorMessage();
                } else {
                    throwable = t;
                    if (throwable instanceof WrappedException) {
                        WrappedException we = (WrappedException)throwable;
                        re = we;
                        javaException = we.getWrappedException();
                        type = TopLevel.NativeErrors.JavaException;
                        errorMsg = javaException.getClass().getName() + ": " + javaException.getMessage();
                    } else {
                        throwable = t;
                        if (throwable instanceof EvaluatorException) {
                            EvaluatorException ee = (EvaluatorException)throwable;
                            re = ee;
                            type = TopLevel.NativeErrors.InternalError;
                            errorMsg = ee.getMessage();
                        } else {
                            throw Kit.codeBug();
                        }
                    }
                }
                String sourceUri = re.sourceName();
                if (sourceUri == null) {
                    sourceUri = "";
                }
                if ((errorObject = ScriptRuntime.newNativeError(cx, scope, type, args = (line = re.lineNumber()) > 0 ? new Object[]{errorMsg, sourceUri, line} : new Object[]{errorMsg, sourceUri})) instanceof NativeError) {
                    ((NativeError)errorObject).setStackProvider(re, cx);
                }
                if (javaException != null && ScriptRuntime.isVisible(cx, javaException, 3)) {
                    wrap = cx.getWrapFactory().wrap(cx, scope, javaException, null);
                    ScriptableObject.defineProperty(errorObject, "javaException", wrap, 7, cx);
                }
                if (ScriptRuntime.isVisible(cx, re, 3)) {
                    wrap = cx.getWrapFactory().wrap(cx, scope, re, null);
                    ScriptableObject.defineProperty(errorObject, "rhinoException", wrap, 7, cx);
                }
                obj = errorObject;
            }
        }
        NativeObject catchScopeObject = new NativeObject(cx);
        catchScopeObject.defineProperty(cx, exceptionName, obj, 4);
        if (ScriptRuntime.isVisible(cx, t, 3)) {
            catchScopeObject.defineProperty(cx, "__exception__", Context.javaToJS(cx, t, scope), 6);
        }
        if (cacheObj) {
            catchScopeObject.associateValue(t, obj);
        }
        return catchScopeObject;
    }

    public static Scriptable wrapException(Context cx, Scriptable scope, Throwable t) {
        Object wrap;
        int line;
        Object errorMsg;
        String errorName;
        RhinoException re;
        Throwable javaException = null;
        Throwable throwable = t;
        if (throwable instanceof EcmaError) {
            EcmaError ee = (EcmaError)throwable;
            re = ee;
            errorName = ee.getName();
            errorMsg = ee.getErrorMessage();
        } else {
            throwable = t;
            if (throwable instanceof WrappedException) {
                WrappedException we = (WrappedException)throwable;
                re = we;
                javaException = we.getWrappedException();
                errorName = "JavaException";
                errorMsg = javaException.getClass().getName() + ": " + javaException.getMessage();
            } else {
                throwable = t;
                if (throwable instanceof EvaluatorException) {
                    EvaluatorException ee = (EvaluatorException)throwable;
                    re = ee;
                    errorName = "InternalError";
                    errorMsg = ee.getMessage();
                } else {
                    throw Kit.codeBug();
                }
            }
        }
        String sourceUri = re.sourceName();
        if (sourceUri == null) {
            sourceUri = "";
        }
        Object[] args = (line = re.lineNumber()) > 0 ? new Object[]{errorMsg, sourceUri, line} : new Object[]{errorMsg, sourceUri};
        Scriptable errorObject = cx.newObject(scope, errorName, args);
        ScriptableObject.putProperty(errorObject, "name", (Object)errorName, cx);
        if (errorObject instanceof NativeError) {
            ((NativeError)errorObject).setStackProvider(re, cx);
        }
        if (javaException != null && ScriptRuntime.isVisible(cx, javaException, 3)) {
            wrap = cx.getWrapFactory().wrap(cx, scope, javaException, null);
            ScriptableObject.defineProperty(errorObject, "javaException", wrap, 7, cx);
        }
        if (ScriptRuntime.isVisible(cx, re, 3)) {
            wrap = cx.getWrapFactory().wrap(cx, scope, re, null);
            ScriptableObject.defineProperty(errorObject, "rhinoException", wrap, 7, cx);
        }
        return errorObject;
    }

    private static boolean isVisible(Context cx, Object obj, int type) {
        ClassShutter shutter = cx.getClassShutter();
        return shutter == null || shutter.visibleToScripts(obj.getClass().getName(), type);
    }

    public static Scriptable enterWith(Context cx, Scriptable scope, Object obj) {
        Scriptable sobj = ScriptRuntime.toObjectOrNull(cx, obj, scope);
        if (sobj == null) {
            throw ScriptRuntime.typeError1(cx, "msg.undef.with", ScriptRuntime.toString(cx, obj));
        }
        return new NativeWith(scope, sobj);
    }

    public static Scriptable leaveWith(Scriptable scope) {
        NativeWith nw = (NativeWith)scope;
        return nw.getParentScope();
    }

    public static Scriptable enterDotQuery(Object value, Scriptable scope, Context cx) {
        throw ScriptRuntime.notXmlError(cx, value);
    }

    public static Object updateDotQuery(boolean value, Scriptable scope) {
        NativeWith nw = (NativeWith)scope;
        return nw.updateDotQuery(value);
    }

    public static Scriptable leaveDotQuery(Scriptable scope) {
        NativeWith nw = (NativeWith)scope;
        return nw.getParentScope();
    }

    public static void setFunctionProtoAndParent(Context cx, Scriptable scope, BaseFunction fn) {
        ScriptRuntime.setFunctionProtoAndParent(cx, scope, fn, false);
    }

    public static void setFunctionProtoAndParent(Context cx, Scriptable scope, BaseFunction fn, boolean es6GeneratorFunction) {
        fn.setParentScope(scope);
        if (es6GeneratorFunction) {
            fn.setPrototype(ScriptableObject.getGeneratorFunctionPrototype(scope, cx));
        } else {
            fn.setPrototype(ScriptableObject.getFunctionPrototype(scope, cx));
        }
    }

    public static void setObjectProtoAndParent(Context cx, Scriptable scope, ScriptableObject object) {
        scope = ScriptableObject.getTopLevelScope(scope);
        object.setParentScope(scope);
        Scriptable proto = ScriptableObject.getClassPrototype(scope, object.getClassName(), cx);
        object.setPrototype(proto);
    }

    public static void setBuiltinProtoAndParent(Context cx, Scriptable scope, ScriptableObject object, TopLevel.Builtins type) {
        scope = ScriptableObject.getTopLevelScope(scope);
        object.setParentScope(scope);
        object.setPrototype(TopLevel.getBuiltinPrototype(scope, type, cx));
    }

    public static void initFunction(Context cx, Scriptable scope, NativeFunction function, int type, boolean fromEvalCode) {
        if (type == 1) {
            String name = function.getFunctionName();
            if (name != null && name.length() != 0) {
                if (!fromEvalCode) {
                    ScriptableObject.defineProperty(scope, name, function, 4, cx);
                } else {
                    scope.put(cx, name, scope, (Object)function);
                }
            }
        } else if (type == 3) {
            String name = function.getFunctionName();
            if (name != null && name.length() != 0) {
                while (scope instanceof NativeWith) {
                    scope = scope.getParentScope();
                }
                scope.put(cx, name, scope, (Object)function);
            }
        } else {
            throw Kit.codeBug();
        }
    }

    public static Scriptable newArrayLiteral(Context cx, Scriptable scope, Object[] objects, int[] skipIndices) {
        int length;
        int SKIP_DENSITY = 2;
        int count = objects.length;
        int skipCount = 0;
        if (skipIndices != null) {
            skipCount = skipIndices.length;
        }
        if ((length = count + skipCount) > 1 && skipCount * 2 < length) {
            Object[] sparse;
            if (skipCount == 0) {
                sparse = objects;
            } else {
                sparse = new Object[length];
                int skip = 0;
                int j = 0;
                for (int i = 0; i != length; ++i) {
                    if (skip != skipCount && skipIndices[skip] == i) {
                        sparse[i] = Scriptable.NOT_FOUND;
                        ++skip;
                        continue;
                    }
                    sparse[i] = objects[j];
                    ++j;
                }
            }
            return cx.newArray(scope, sparse);
        }
        Scriptable array = cx.newArray(scope, length);
        int skip = 0;
        int j = 0;
        for (int i = 0; i != length; ++i) {
            if (skip != skipCount && skipIndices[skip] == i) {
                ++skip;
                continue;
            }
            array.put(cx, i, array, objects[j]);
            ++j;
        }
        return array;
    }

    public static Scriptable newObjectLiteral(Context cx, Scriptable scope, Object[] propertyIds, Object[] propertyValues, int[] getterSetters) {
        Scriptable object = cx.newObject(scope);
        int end = propertyIds.length;
        for (int i = 0; i != end; ++i) {
            Object id = propertyIds[i];
            int getterSetter = getterSetters == null ? 0 : getterSetters[i];
            Object value = propertyValues[i];
            if (id instanceof String) {
                if (getterSetter == 0) {
                    if (ScriptRuntime.isSpecialProperty((String)id)) {
                        Ref ref = ScriptRuntime.specialRef(cx, scope, object, (String)id);
                        ref.set(cx, scope, value);
                        continue;
                    }
                    object.put(cx, (String)id, object, value);
                    continue;
                }
                ScriptableObject so = (ScriptableObject)object;
                Callable getterOrSetter = (Callable)value;
                boolean isSetter = getterSetter == 1;
                so.setGetterOrSetter(cx, (String)id, 0, getterOrSetter, isSetter);
                continue;
            }
            int index = (Integer)id;
            object.put(cx, index, object, value);
        }
        return object;
    }

    public static boolean isArrayObject(Object obj) {
        return obj instanceof NativeArray || obj instanceof Arguments;
    }

    public static Object[] getArrayElements(Context cx, Scriptable object) {
        long longLen = NativeArray.getLengthProperty(cx, object, false);
        if (longLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        int len = (int)longLen;
        if (len == 0) {
            return EMPTY_OBJECTS;
        }
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            Object elem = ScriptableObject.getProperty(object, i, cx);
            result[i] = elem == Scriptable.NOT_FOUND ? Undefined.instance : elem;
        }
        return result;
    }

    static void checkDeprecated(Context cx, String name) {
        throw Context.reportRuntimeError(ScriptRuntime.getMessage1("msg.deprec.ctor", name), cx);
    }

    public static String getMessage0(String messageId) {
        return ScriptRuntime.getMessage(messageId, null);
    }

    public static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return ScriptRuntime.getMessage(messageId, arguments);
    }

    public static String getMessage2(String messageId, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return ScriptRuntime.getMessage(messageId, arguments);
    }

    public static String getMessage3(String messageId, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return ScriptRuntime.getMessage(messageId, arguments);
    }

    public static String getMessage4(String messageId, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] arguments = new Object[]{arg1, arg2, arg3, arg4};
        return ScriptRuntime.getMessage(messageId, arguments);
    }

    public static String getMessage(String messageId, Object[] arguments) {
        return messageProvider.getMessage(messageId, arguments);
    }

    public static EcmaError constructError(Context cx, String error, String message) {
        int[] linep = new int[1];
        String filename = Context.getSourcePositionFromStack(cx, linep);
        return ScriptRuntime.constructError(cx, error, message, filename, linep[0], null, 0);
    }

    public static EcmaError constructError(Context cx, String error, String message, int lineNumberDelta) {
        int[] linep = new int[1];
        String filename = Context.getSourcePositionFromStack(cx, linep);
        if (linep[0] != 0) {
            linep[0] = linep[0] + lineNumberDelta;
        }
        return ScriptRuntime.constructError(cx, error, message, filename, linep[0], null, 0);
    }

    public static EcmaError constructError(Context cx, String error, String message, String sourceName, int lineNumber, String lineSource, int columnNumber) {
        return new EcmaError(cx, error, message, sourceName, lineNumber, lineSource, columnNumber);
    }

    public static EcmaError rangeError(Context cx, String message) {
        return ScriptRuntime.constructError(cx, "RangeError", message);
    }

    public static EcmaError typeError(Context cx, String message) {
        return ScriptRuntime.constructError(cx, "TypeError", message);
    }

    public static EcmaError typeError0(Context cx, String messageId) {
        String msg = ScriptRuntime.getMessage0(messageId);
        return ScriptRuntime.typeError(cx, msg);
    }

    public static EcmaError typeError1(Context cx, String messageId, Object arg1) {
        String msg = ScriptRuntime.getMessage1(messageId, arg1);
        return ScriptRuntime.typeError(cx, msg);
    }

    public static EcmaError typeError2(Context cx, String messageId, Object arg1, Object arg2) {
        String msg = ScriptRuntime.getMessage2(messageId, arg1, arg2);
        return ScriptRuntime.typeError(cx, msg);
    }

    public static EcmaError typeError3(Context cx, String messageId, String arg1, String arg2, String arg3) {
        String msg = ScriptRuntime.getMessage3(messageId, arg1, arg2, arg3);
        return ScriptRuntime.typeError(cx, msg);
    }

    public static RuntimeException undefReadError(Context cx, Object object, Object id) {
        return ScriptRuntime.typeError2(cx, "msg.undef.prop.read", ScriptRuntime.toString(cx, object), ScriptRuntime.toString(cx, id));
    }

    public static RuntimeException undefCallError(Context cx, Object object, Object id) {
        return ScriptRuntime.typeError2(cx, "msg.undef.method.call", ScriptRuntime.toString(cx, object), ScriptRuntime.toString(cx, id));
    }

    public static RuntimeException undefWriteError(Context cx, Object object, Object id, Object value) {
        return ScriptRuntime.typeError3(cx, "msg.undef.prop.write", ScriptRuntime.toString(cx, object), ScriptRuntime.toString(cx, id), ScriptRuntime.toString(cx, value));
    }

    private static RuntimeException undefDeleteError(Context cx, Object object, Object id) {
        throw ScriptRuntime.typeError2(cx, "msg.undef.prop.delete", ScriptRuntime.toString(cx, object), ScriptRuntime.toString(cx, id));
    }

    public static RuntimeException notFoundError(Context cx, Scriptable object, String property) {
        String msg = ScriptRuntime.getMessage1("msg.is.not.defined", property);
        throw ScriptRuntime.constructError(cx, "ReferenceError", msg);
    }

    public static RuntimeException notFunctionError(Context cx, Object value) {
        return ScriptRuntime.notFunctionError(cx, value, value);
    }

    public static RuntimeException notFunctionError(Context cx, Object value, Object messageHelper) {
        String msg;
        String string = msg = messageHelper == null ? "null" : messageHelper.toString();
        if (value == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError1(cx, "msg.function.not.found", msg);
        }
        return ScriptRuntime.typeError2(cx, "msg.isnt.function", msg, (Object)ScriptRuntime.typeof(cx, value));
    }

    public static RuntimeException notFunctionError(Context cx, Object obj, Object value, String propertyName) {
        int paren;
        int curly;
        Object objString = ScriptRuntime.toString(cx, obj);
        if (obj instanceof NativeFunction && (curly = ((String)objString).indexOf(123, paren = ((String)objString).indexOf(41))) > -1) {
            objString = ((String)objString).substring(0, curly + 1) + "...}";
        }
        if (value == Scriptable.NOT_FOUND) {
            return ScriptRuntime.typeError2(cx, "msg.function.not.found.in", propertyName, objString);
        }
        return ScriptRuntime.typeError3(cx, "msg.isnt.function.in", propertyName, (String)objString, ScriptRuntime.typeof(cx, value).toString());
    }

    private static RuntimeException notXmlError(Context cx, Object value) {
        throw ScriptRuntime.typeError1(cx, "msg.isnt.xml.object", ScriptRuntime.toString(cx, value));
    }

    private static void warnAboutNonJSObject(Context cx, Object nonJSObject) {
        String omitParam = ScriptRuntime.getMessage0("params.omit.non.js.object.warning");
        if (!"true".equals(omitParam)) {
            String message = ScriptRuntime.getMessage2("msg.non.js.object.warning", nonJSObject, nonJSObject.getClass().getName());
            Context.reportWarning(message, cx);
            System.err.println(message);
        }
    }

    public static void setRegExpProxy(Context cx, RegExp proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        cx.regExp = proxy;
    }

    public static Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return cx.getRegExp().wrapRegExp(cx, scope, compiled);
    }

    public static Scriptable getTemplateLiteralCallSite(Context cx, Scriptable scope, Object[] strings, int index) {
        Object callsite = strings[index];
        if (callsite instanceof Scriptable) {
            return (Scriptable)callsite;
        }
        assert (callsite instanceof String[]);
        String[] vals = (String[])callsite;
        assert ((vals.length & 1) == 0);
        int FROZEN = 5;
        ScriptableObject siteObj = (ScriptableObject)cx.newArray(scope, vals.length >>> 1);
        ScriptableObject rawObj = (ScriptableObject)cx.newArray(scope, vals.length >>> 1);
        int n = vals.length;
        for (int i = 0; i < n; i += 2) {
            int idx = i >>> 1;
            siteObj.put(cx, idx, (Scriptable)siteObj, (Object)vals[i]);
            siteObj.setAttributes(cx, idx, 5);
            rawObj.put(cx, idx, (Scriptable)rawObj, (Object)vals[i + 1]);
            rawObj.setAttributes(cx, idx, 5);
        }
        rawObj.setAttributes(cx, "length", 5);
        rawObj.preventExtensions();
        siteObj.put(cx, "raw", (Scriptable)siteObj, (Object)rawObj);
        siteObj.setAttributes(cx, "raw", 7);
        siteObj.setAttributes(cx, "length", 5);
        siteObj.preventExtensions();
        strings[index] = siteObj;
        return siteObj;
    }

    public static void storeUint32Result(Context cx, long value) {
        if (value >>> 32 != 0L) {
            throw new IllegalArgumentException();
        }
        cx.scratchUint32 = value;
    }

    public static long lastUint32Result(Context cx) {
        long value = cx.scratchUint32;
        if (value >>> 32 != 0L) {
            throw new IllegalStateException();
        }
        return value;
    }

    private static void storeScriptable(Context cx, Scriptable value) {
        if (cx.scratchScriptable != null) {
            throw new IllegalStateException();
        }
        cx.scratchScriptable = value;
    }

    public static Scriptable lastStoredScriptable(Context cx) {
        Scriptable result = cx.scratchScriptable;
        cx.scratchScriptable = null;
        return result;
    }

    static String makeUrlForGeneratedScript(boolean isEval, String masterScriptUrl, int masterScriptLine) {
        if (isEval) {
            return masterScriptUrl + "#" + masterScriptLine + "(eval)";
        }
        return masterScriptUrl + "#" + masterScriptLine + "(Function)";
    }

    static boolean isSymbol(Object obj) {
        return obj instanceof NativeSymbol && ((NativeSymbol)obj).isSymbol() || obj instanceof SymbolKey;
    }

    public static RuntimeException errorWithClassName(String msg, Object val, Context cx) {
        return Context.reportRuntimeError1(msg, val.getClass().getName(), cx);
    }

    public static JavaScriptException throwError(Context cx, Scriptable scope, String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        Scriptable error = ScriptRuntime.newBuiltinObject(cx, scope, TopLevel.Builtins.Error, new Object[]{message, filename, linep[0]});
        return new JavaScriptException(cx, error, filename, linep[0]);
    }

    public static JavaScriptException throwCustomError(Context cx, Scriptable scope, String constructorName, String message) {
        int[] linep = new int[]{0};
        String filename = Context.getSourcePositionFromStack(cx, linep);
        Scriptable error = cx.newObject(scope, constructorName, new Object[]{message, filename, linep[0]});
        return new JavaScriptException(cx, error, filename, linep[0]);
    }

    protected ScriptRuntime() {
    }

    static final class StringIdOrIndex {
        final String stringId;
        final int index;

        StringIdOrIndex(String stringId) {
            this.stringId = stringId;
            this.index = -1;
        }

        StringIdOrIndex(int index) {
            this.stringId = null;
            this.index = index;
        }
    }

    static class NoSuchMethodShim
    implements Callable {
        String methodName;
        Callable noSuchMethodMethod;

        NoSuchMethodShim(Callable noSuchMethodMethod, String methodName) {
            this.noSuchMethodMethod = noSuchMethodMethod;
            this.methodName = methodName;
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            Object[] nestedArgs = new Object[]{this.methodName, ScriptRuntime.newArrayLiteral(cx, scope, args, null)};
            return this.noSuchMethodMethod.call(cx, scope, thisObj, nestedArgs);
        }
    }

    public static interface MessageProvider {
        public String getMessage(String var1, Object[] var2);
    }

    private static class DefaultMessageProvider
    implements MessageProvider {
        private DefaultMessageProvider() {
        }

        @Override
        public String getMessage(String messageId, Object[] arguments) {
            String formatString;
            String defaultResource = "dev.latvian.mods.rhino.resources.Messages";
            Locale locale = Locale.getDefault();
            ResourceBundle rb = ResourceBundle.getBundle("dev.latvian.mods.rhino.resources.Messages", locale);
            try {
                formatString = rb.getString(messageId);
            }
            catch (MissingResourceException mre) {
                throw new RuntimeException("no message resource found for message property " + messageId);
            }
            MessageFormat formatter = new MessageFormat(formatString);
            return formatter.format(arguments);
        }
    }
}

