/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib;

import dev.gigaherz.rhinolib.BaseFunction;
import dev.gigaherz.rhinolib.Context;
import dev.gigaherz.rhinolib.Function;
import dev.gigaherz.rhinolib.IdScriptableObject;
import dev.gigaherz.rhinolib.ScriptRuntime;
import dev.gigaherz.rhinolib.Scriptable;
import java.util.EnumMap;

public class TopLevel
extends IdScriptableObject {
    private EnumMap<Builtins, BaseFunction> ctors;
    private EnumMap<NativeErrors, BaseFunction> errors;

    public static Function getBuiltinCtor(Context cx, Scriptable scope, Builtins type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinCtor(type)) != null) {
            return result;
        }
        String typeName = type == Builtins.GeneratorFunction ? "__GeneratorFunction" : type.name();
        return ScriptRuntime.getExistingCtor(cx, scope, typeName);
    }

    static Function getNativeErrorCtor(Context cx, Scriptable scope, NativeErrors type) {
        BaseFunction result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getNativeErrorCtor(type)) != null) {
            return result;
        }
        return ScriptRuntime.getExistingCtor(cx, scope, type.name());
    }

    public static Scriptable getBuiltinPrototype(Scriptable scope, Builtins type, Context cx) {
        Scriptable result;
        assert (scope.getParentScope() == null);
        if (scope instanceof TopLevel && (result = ((TopLevel)scope).getBuiltinPrototype(cx, type)) != null) {
            return result;
        }
        String typeName = type == Builtins.GeneratorFunction ? "__GeneratorFunction" : type.name();
        return TopLevel.getClassPrototype(scope, typeName, cx);
    }

    @Override
    public String getClassName() {
        return "global";
    }

    public void cacheBuiltins(Scriptable scope, boolean sealed, Context cx) {
        Object value;
        this.ctors = new EnumMap(Builtins.class);
        for (Builtins builtins : Builtins.values()) {
            value = TopLevel.getProperty((Scriptable)this, builtins.name(), cx);
            if (value instanceof BaseFunction) {
                this.ctors.put(builtins, (BaseFunction)value);
                continue;
            }
            if (builtins != Builtins.GeneratorFunction) continue;
            this.ctors.put(builtins, (BaseFunction)BaseFunction.initAsGeneratorFunction(scope, sealed, cx));
        }
        this.errors = new EnumMap(NativeErrors.class);
        for (Enum enum_ : NativeErrors.values()) {
            value = TopLevel.getProperty((Scriptable)this, enum_.name(), cx);
            if (!(value instanceof BaseFunction)) continue;
            this.errors.put((NativeErrors)enum_, (BaseFunction)value);
        }
    }

    public BaseFunction getBuiltinCtor(Builtins type) {
        return this.ctors != null ? this.ctors.get((Object)type) : null;
    }

    BaseFunction getNativeErrorCtor(NativeErrors type) {
        return this.errors != null ? this.errors.get((Object)type) : null;
    }

    public Scriptable getBuiltinPrototype(Context cx, Builtins type) {
        BaseFunction func = this.getBuiltinCtor(type);
        Object proto = func != null ? func.getPrototypeProperty(cx) : null;
        return proto instanceof Scriptable ? (Scriptable)proto : null;
    }

    public static enum Builtins {
        Object,
        Array,
        Function,
        String,
        Number,
        Boolean,
        RegExp,
        Error,
        Symbol,
        GeneratorFunction;

    }

    static enum NativeErrors {
        Error,
        EvalError,
        RangeError,
        ReferenceError,
        SyntaxError,
        TypeError,
        URIError,
        InternalError,
        JavaException;

    }
}

