/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.rhinolib.mod.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoProperties {
    public static final RhinoProperties INSTANCE = new RhinoProperties();
    private final Properties properties;
    private boolean writeProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"RhinoProperties");

    public static Path getGameDir() {
        throw new AssertionError();
    }

    public static boolean isDev() {
        throw new AssertionError();
    }

    public static InputStream openResource(String path) throws Exception {
        throw new AssertionError();
    }

    RhinoProperties() {
        block16: {
            this.properties = new Properties();
            try {
                Path propertiesFile = RhinoProperties.getGameDir().resolve("rhino.local.properties");
                this.writeProperties = false;
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                        this.properties.load(reader);
                    }
                } else {
                    this.writeProperties = true;
                }
                if (!this.writeProperties) break block16;
                try (BufferedWriter writer = Files.newBufferedWriter(propertiesFile, new OpenOption[0]);){
                    this.properties.store(writer, "Local properties for Rhino, please do not push this to version control if you don't know what you're doing!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LOGGER.info("Rhino properties loaded.");
    }

    private void remove(String key) {
        String s = this.properties.getProperty(key);
        if (s != null) {
            this.properties.remove(key);
            this.writeProperties = true;
        }
    }

    private String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    private boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }
}

