/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.loot.RandomDye;
import dev.gigaherz.sewingkit.needle.Needles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.color.item.Dye;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagAppender;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Util;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredItem;

public class SewingKitDataGen {
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(true, (DataProvider)new Lang(gen));
        gen.addProvider(true, (DataProvider)new EquipmentAsses(gen.getPackOutput()));
        gen.addProvider(true, (DataProvider)new ModelsAndClientItems(gen.getPackOutput()));
        gen.addProvider(true, (DataProvider)new BlockTagGen(gen.getPackOutput()));
        gen.addProvider(true, (DataProvider)new ItemTagGen(gen.getPackOutput()));
        gen.addProvider(true, (DataProvider)new Recipes(gen.getPackOutput(), event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)Loot.create(gen.getPackOutput(), event.getLookupProvider()));
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(DataGenerator gen) {
            super(gen.getPackOutput(), "sewingkit", "en_us");
        }

        protected void addTranslations() {
            this.add("tab.sewing_kit", "Sewing Kit");
            this.add("container.sewingkit.sewing_station", "Sewing Station");
            this.add("container.sewingkit.storing_sewing_station", "Sewing Station with Drawers");
            this.add("jei.category.sewingkit.sewing", "Sewing");
            this.add((Item)SewingKitMod.LEATHER_STRIP.get(), "Leather Strip");
            this.add((Item)SewingKitMod.LEATHER_SHEET.get(), "Leather Sheet");
            this.add((Block)SewingKitMod.SEWING_STATION_BLOCK.get(), "Sewing Table");
            this.add((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get(), "Sewing Table with Drawers");
            Arrays.stream(Needles.values()).forEach(needle -> {
                String type = needle.getType();
                String name = type.substring(0, 1).toUpperCase() + type.substring(1);
                this.add(needle.getNeedle(), name + " Sewing Needle");
            });
            this.add("text.sewingkit.needle.lore_text", "\"Ouch!\"");
            this.add((Item)SewingKitMod.WOOL_HAT.get(), "Wool Hat");
            this.add((Item)SewingKitMod.WOOL_SHIRT.get(), "Wool Shirt");
            this.add((Item)SewingKitMod.WOOL_PANTS.get(), "Wool Pants");
            this.add((Item)SewingKitMod.WOOL_SHOES.get(), "Wool Shoes");
            this.add((Item)SewingKitMod.WOOL_ROLL.get(), "Wool Roll");
            this.add((Item)SewingKitMod.WOOL_TRIM.get(), "Wool Trim");
            this.add((Item)SewingKitMod.COMMON_PATTERN.get(), "Common Pattern");
            this.add((Item)SewingKitMod.UNCOMMON_PATTERN.get(), "Uncommon Pattern");
            this.add((Item)SewingKitMod.RARE_PATTERN.get(), "Rare Pattern");
            this.add((Item)SewingKitMod.LEGENDARY_PATTERN.get(), "Legendary Pattern");
            this.add((Item)SewingKitMod.FILE.get(), "Raspy File");
            this.add("entity.minecraft.villager.sewingkit.tailor", "Tailor");
            this.add("text.sewingkit.recipe", "Required materials:");
            this.add("text.sewingkit.pattern.wip", "This feature is not implemented yet.");
            this.add("text.sewingkit.pattern.may_be_removed", "This item may be removed in the future.");
        }
    }

    private static class EquipmentAsses
    extends EquipmentAssetProvider {
        public EquipmentAsses(PackOutput output) {
            super(output);
        }

        protected void registerModels(BiConsumer<ResourceKey<EquipmentAsset>, EquipmentClientInfo> output) {
            Identifier textureId = SewingKitMod.location("wool");
            output.accept(SewingKitMod.WOOL_ASSET, EquipmentClientInfo.builder().addLayers(EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS, new EquipmentClientInfo.Layer[]{EquipmentAsses.whiteDefaultDyeable(textureId)}).addLayers(EquipmentClientInfo.LayerType.HUMANOID, new EquipmentClientInfo.Layer[]{EquipmentAsses.whiteDefaultDyeable(textureId)}).build());
        }

        public static EquipmentClientInfo.Layer whiteDefaultDyeable(Identifier textureId) {
            return new EquipmentClientInfo.Layer(textureId, Optional.of(new EquipmentClientInfo.Dyeable(Optional.of(-1))), false);
        }
    }

    private static class ModelsAndClientItems
    extends ModelProvider {
        public ModelsAndClientItems(PackOutput output) {
            super(output, "sewingkit");
        }

        protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
            ModelsAndClientItems.horizontalWithExistingModel(blockModels, (Block)SewingKitMod.SEWING_STATION_BLOCK.get());
            ModelsAndClientItems.horizontalWithExistingModel(blockModels, (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
            itemModels.generateFlatItem((Item)SewingKitMod.LEATHER_STRIP.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.LEATHER_SHEET.get(), ModelTemplates.FLAT_ITEM);
            for (Needles needle : Needles.values()) {
                itemModels.generateFlatItem(needle.getNeedle(), ModelTemplates.FLAT_ITEM);
            }
            ModelsAndClientItems.armorItem(itemModels, SewingKitMod.WOOL_HAT);
            ModelsAndClientItems.armorItem(itemModels, SewingKitMod.WOOL_SHIRT);
            ModelsAndClientItems.armorItem(itemModels, SewingKitMod.WOOL_PANTS);
            ModelsAndClientItems.armorItem(itemModels, SewingKitMod.WOOL_SHOES);
            itemModels.generateFlatItem((Item)SewingKitMod.WOOL_ROLL.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.WOOL_TRIM.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.COMMON_PATTERN.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.UNCOMMON_PATTERN.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.RARE_PATTERN.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.LEGENDARY_PATTERN.get(), ModelTemplates.FLAT_ITEM);
            itemModels.generateFlatItem((Item)SewingKitMod.FILE.get(), (ModelTemplate)ModelTemplates.FLAT_ITEM.extend().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, b -> b.rotation(62.0f, 147.0f, 40.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f)).transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, b -> b.rotation(45.0f, -33.0f, -55.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f)).transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, b -> b.rotation(-54.0f, 99.0f, 136.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f)).transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, b -> b.rotation(136.0f, -99.0f, 54.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f)).transform(ItemDisplayContext.GROUND, b -> b.translation(0.0f, 2.0f, 0.0f).scale(0.5f)).transform(ItemDisplayContext.HEAD, b -> b.rotation(-4.0f, 44.0f, 4.0f).translation(-7.25f, 6.75f, 0.75f)).transform(ItemDisplayContext.FIXED, b -> b.rotation(0.0f, 180.0f, 0.0f)).build());
        }

        private static void armorItem(ItemModelGenerators itemModels, DeferredItem<Item> item) {
            itemModels.createFlatItemModel((Item)item.get(), ModelTemplates.FLAT_ITEM);
            itemModels.itemModelOutput.accept((Item)item.get(), ItemModelUtils.tintedModel((Identifier)ModelLocationUtils.getModelLocation((Item)((Item)item.get())), (ItemTintSource[])new ItemTintSource[]{new Dye(-1)}));
        }

        private static void horizontalWithExistingModel(BlockModelGenerators blockModels, Block block) {
            Identifier modelLocation = ModelLocationUtils.getModelLocation((Block)block);
            Variant variant = new Variant(modelLocation);
            MultiVariant multiVariant = new MultiVariant(WeightedList.of((Object)variant));
            blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)multiVariant).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
        }
    }

    private static class BlockTagGen
    extends IntrinsicHolderTagsProvider<Block> {
        public BlockTagGen(PackOutput packOutput) {
            super(packOutput, Registries.BLOCK, CompletableFuture.supplyAsync(VanillaRegistries::createLookup, (Executor)Util.backgroundExecutor()), block -> (ResourceKey)BuiltInRegistries.BLOCK.getResourceKey(block).orElseThrow(), "sewingkit");
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)((Block)SewingKitMod.SEWING_STATION_BLOCK.get())).add((Object)((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get()));
        }
    }

    private static class ItemTagGen
    extends IntrinsicHolderTagsProvider<Item> {
        public ItemTagGen(PackOutput packOutput) {
            super(packOutput, Registries.ITEM, CompletableFuture.supplyAsync(VanillaRegistries::createLookup, (Executor)Util.backgroundExecutor()), item -> (ResourceKey)BuiltInRegistries.ITEM.getResourceKey(item).orElseThrow(), "sewingkit");
        }

        protected void addTags(HolderLookup.Provider lookup) {
            this.tag(ItemTags.DYEABLE).add((Object)((Item)SewingKitMod.WOOL_HAT.get())).add((Object)((Item)SewingKitMod.WOOL_SHIRT.get())).add((Object)((Item)SewingKitMod.WOOL_PANTS.get())).add((Object)((Item)SewingKitMod.WOOL_SHOES.get()));
            this.tag(ItemTags.FREEZE_IMMUNE_WEARABLES).add((Object)((Item)SewingKitMod.WOOL_HAT.get())).add((Object)((Item)SewingKitMod.WOOL_SHIRT.get())).add((Object)((Item)SewingKitMod.WOOL_PANTS.get())).add((Object)((Item)SewingKitMod.WOOL_SHOES.get()));
            List<Pair> list = List.of(Pair.of(SewingKitMod.WOOD_OR_HIGHER, List.of((Item)SewingKitMod.WOOD_SEWING_NEEDLE.get(), (Item)SewingKitMod.GOLD_SEWING_NEEDLE.get())), Pair.of(SewingKitMod.BONE_OR_HIGHER, List.of((Item)SewingKitMod.BONE_SEWING_NEEDLE.get(), (Item)SewingKitMod.STONE_SEWING_NEEDLE.get())), Pair.of(SewingKitMod.IRON_OR_HIGHER, List.of((Item)SewingKitMod.IRON_SEWING_NEEDLE.get())), Pair.of(SewingKitMod.DIAMOND_OR_HIGHER, List.of((Item)SewingKitMod.DIAMOND_SEWING_NEEDLE.get())), Pair.of(SewingKitMod.NETHERITE_OR_HIGHER, List.of((Item)SewingKitMod.NETHERITE_SEWING_NEEDLE.get())));
            for (int i = 0; i < list.size(); ++i) {
                Pair entry = list.get(i);
                TagKey tag = (TagKey)entry.getFirst();
                List items = (List)entry.getSecond();
                TagAppender tagBuilder = this.tag(tag);
                for (Item item : items) {
                    tagBuilder.add((Object)item);
                }
                int j = i + 1;
                if (j >= list.size()) continue;
                tagBuilder.addTag((TagKey)list.get(j).getFirst());
            }
        }
    }

    private static class Recipes
    extends RecipeProvider.Runner {
        public Recipes(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(final HolderLookup.Provider lookup, RecipeOutput output) {
            return new VanillaRecipeProvider(this, lookup, output){

                protected void buildRecipes() {
                    HolderLookup.RegistryLookup items = lookup.lookupOrThrow(Registries.ITEM);
                    this.shaped(RecipeCategory.MISC, (ItemLike)SewingKitMod.FILE.get()).pattern("  I").pattern(" I ").pattern("P  ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), ItemTags.PLANKS).unlockedBy("has_iron", this.has(Tags.Items.INGOTS_IRON)).save(this.output);
                    Arrays.stream(Needles.values()).forEach(needle -> this.shapeless(RecipeCategory.TOOLS, (ItemLike)needle.getNeedle()).requires((ItemLike)SewingKitMod.FILE.get()).requires(needle.getToolMaterial().repairItems()).unlockedBy("has_material", this.has(needle.getMaterial())).save(this.output));
                    this.shaped(RecipeCategory.MISC, (ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()).pattern("xxx").pattern("P P").pattern("S S").define(Character.valueOf('x'), ItemTags.WOODEN_SLABS).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_wood", this.has(ItemTags.PLANKS)).save(this.output);
                    this.shapeless(RecipeCategory.MISC, (ItemLike)SewingKitMod.STORING_SEWING_STATION_ITEM.get()).requires((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()).requires(Tags.Items.CHESTS_WOODEN).unlockedBy("has_station", this.has((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get())).save(this.output);
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_SHEET.get(), 4).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)Tags.Items.LEATHERS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_sheet_from_leather"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_SHEET.get(), 1).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial(new ItemLike[]{Items.RABBIT_HIDE}).addCriterion("has_leather", this.has((ItemLike)Items.RABBIT_HIDE)).save(this.output, SewingKitMod.location("leather_sheet_from_rabbit_hide"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.LEATHER_STRIP.get(), 3).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)Tags.Items.LEATHERS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_strip_from_leather"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, Items.LEATHER_BOOTS).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_boots_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, Items.LEATHER_LEGGINGS).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 4).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 3).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_leggings_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, Items.LEATHER_CHESTPLATE).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 8).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 2).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_chestplate_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, Items.LEATHER_HELMET).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_helmet_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, Items.LEATHER_HORSE_ARMOR).withTool(SewingKitMod.NETHERITE_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 12).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 6).addMaterial((TagKey<Item>)Tags.Items.STRINGS, 8).addCriterion("has_leather", this.has(Tags.Items.LEATHERS)).save(this.output, SewingKitMod.location("leather_horse_armor_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_ROLL.get(), 4).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)ItemTags.WOOL).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_roll_from_wool"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_ROLL.get(), 1).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)ItemTags.WOOL_CARPETS).addCriterion("has_wool", this.has(ItemTags.WOOL_CARPETS)).save(this.output, SewingKitMod.location("wool_roll_from_carpet"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_TRIM.get(), 8).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)ItemTags.WOOL).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_trim_from_wool"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_TRIM.get(), 3).withTool((TagKey<Item>)Tags.Items.TOOLS_SHEAR).addMaterial((TagKey<Item>)ItemTags.WOOL_CARPETS).addCriterion("has_wool", this.has(ItemTags.WOOL_CARPETS)).save(this.output, SewingKitMod.location("wool_trim_from_carpet"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_SHOES.get()).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 2).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_shoes_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_PANTS.get()).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 2).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 4).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_pants_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_SHIRT.get()).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 3).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 3).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_shirt_via_sewing"));
                    SewingRecipeBuilder.begin((HolderLookup.RegistryLookup<Item>)items, RecipeCategory.MISC, (Item)SewingKitMod.WOOL_HAT.get()).withTool(SewingKitMod.WOOD_OR_HIGHER).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 1).addMaterial((TagKey<Item>)Tags.Items.STRINGS).addCriterion("has_wool", this.has(ItemTags.WOOL)).save(this.output, SewingKitMod.location("wool_hat_via_sewing"));
                }
            };
        }

        public String getName() {
            return "Recipes";
        }
    }

    private static class Loot {
        private Loot() {
        }

        public static LootTableProvider create(PackOutput gen, CompletableFuture<HolderLookup.Provider> lookup) {
            return new LootTableProvider(gen, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockTables::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ChestTables::new, LootContextParamSets.CHEST)), lookup);
        }

        public static class ChestTables
        implements LootTableSubProvider {
            public ChestTables(HolderLookup.Provider provider) {
            }

            public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
                consumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (Identifier)SewingKitMod.location("chest/tailor_shop_upper_floor")), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_HAT.get())).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_SHIRT.get())).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_PANTS.get())).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_SHOES.get())).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_HELMET).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).setWeight(1).apply(RandomDye.builder())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).setWeight(1).apply(RandomDye.builder()))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOD_SEWING_NEEDLE.get())).setWeight(100)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.BONE_SEWING_NEEDLE.get())).setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.IRON_SEWING_NEEDLE.get())).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.DIAMOND_SEWING_NEEDLE.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.NETHERITE_SEWING_NEEDLE.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.GOLD_SEWING_NEEDLE.get())).setWeight(1))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_ROLL.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.WOOL_TRIM.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.LEATHER_SHEET.get())).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)SewingKitMod.LEATHER_STRIP.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STRING).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f))))));
            }
        }

        public static class BlockTables
        extends BlockLootSubProvider {
            protected BlockTables(HolderLookup.Provider provider) {
                super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
            }

            protected void generate() {
                this.dropSelf((Block)SewingKitMod.SEWING_STATION_BLOCK.get());
                this.dropSelf((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return BuiltInRegistries.BLOCK.entrySet().stream().filter(e -> ((ResourceKey)e.getKey()).identifier().getNamespace().equals("sewingkit")).map(Map.Entry::getValue).collect(Collectors.toList());
            }
        }
    }
}

