/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitDataGen;
import dev.gigaherz.sewingkit.api.SewingMaterialSlotDisplay;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.SewingRecipeDisplay;
import dev.gigaherz.sewingkit.file.FileItem;
import dev.gigaherz.sewingkit.loot.RandomDye;
import dev.gigaherz.sewingkit.needle.Needles;
import dev.gigaherz.sewingkit.network.SyncRecipeOrder;
import dev.gigaherz.sewingkit.structure.TailorShopProcessor;
import dev.gigaherz.sewingkit.table.SewingTableBlock;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import dev.gigaherz.sewingkit.table.SewingTableScreen;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlock;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlockEntity;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.entity.npc.villager.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jspecify.annotations.Nullable;

@Mod(value="sewingkit")
public class SewingKitMod {
    public static final String MODID = "sewingkit";
    public static final TagKey<Block> INCORRECT_BONE_TAG = TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)SewingKitMod.location("incorrect_for_bone_tool"));
    public static final ToolMaterial BONE_TIER = new ToolMaterial(INCORRECT_BONE_TAG, 100, 1.0f, 0.0f, 12, Tags.Items.BONES);
    private static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"sewingkit");
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"sewingkit");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"sewingkit");
    private static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.POINT_OF_INTEREST_TYPE, (String)"sewingkit");
    private static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((Registry)BuiltInRegistries.VILLAGER_PROFESSION, (String)"sewingkit");
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"sewingkit");
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"sewingkit");
    private static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"sewingkit");
    private static final DeferredRegister<StructureProcessorType<?>> STRUCTURE_PROCESSORS = DeferredRegister.create((Registry)BuiltInRegistries.STRUCTURE_PROCESSOR, (String)"sewingkit");
    private static final DeferredRegister<LootItemFunctionType<?>> LOOT_FUNCTIONS = DeferredRegister.create((Registry)BuiltInRegistries.LOOT_FUNCTION_TYPE, (String)"sewingkit");
    private static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"sewingkit");
    private static final DeferredRegister<IngredientType<?>> INGREDIENT_TYPE = DeferredRegister.create((Registry)NeoForgeRegistries.INGREDIENT_TYPES, (String)"sewingkit");
    private static final DeferredRegister<RecipeBookCategory> RECIPE_BOOK_CATEGORY = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_BOOK_CATEGORY, (String)"sewingkit");
    private static final DeferredRegister<SlotDisplay.Type<?>> SLOT_DISPLAY = DeferredRegister.create((Registry)BuiltInRegistries.SLOT_DISPLAY, (String)"sewingkit");
    private static final DeferredRegister<RecipeDisplay.Type<?>> RECIPE_DISPLAY = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_DISPLAY, (String)"sewingkit");
    public static final DeferredItem<Item> LEATHER_STRIP = ITEMS.registerItem("leather_strip", props -> new Item(props.stacksTo(64)));
    public static final DeferredItem<Item> LEATHER_SHEET = ITEMS.registerItem("leather_sheet", props -> new Item(props.stacksTo(64)));
    public static final DeferredItem<Item> WOOL_ROLL = ITEMS.registerItem("wool_roll", props -> new Item(props.stacksTo(64)));
    public static final DeferredItem<Item> WOOL_TRIM = ITEMS.registerItem("wool_trim", props -> new Item(props.stacksTo(64)));
    public static final DeferredItem<Item> WOOD_SEWING_NEEDLE = ITEMS.registerItem("wood_sewing_needle", props -> new Item(Needles.fillProperties(Needles.WOOD, props)));
    public static final DeferredItem<Item> STONE_SEWING_NEEDLE = ITEMS.registerItem("stone_sewing_needle", props -> new Item(Needles.fillProperties(Needles.STONE, props)));
    public static final DeferredItem<Item> BONE_SEWING_NEEDLE = ITEMS.registerItem("bone_sewing_needle", props -> new Item(Needles.fillProperties(Needles.BONE, props)));
    public static final DeferredItem<Item> GOLD_SEWING_NEEDLE = ITEMS.registerItem("gold_sewing_needle", props -> new Item(Needles.fillProperties(Needles.GOLD, props)));
    public static final DeferredItem<Item> IRON_SEWING_NEEDLE = ITEMS.registerItem("iron_sewing_needle", props -> new Item(Needles.fillProperties(Needles.IRON, props)));
    public static final DeferredItem<Item> DIAMOND_SEWING_NEEDLE = ITEMS.registerItem("diamond_sewing_needle", props -> new Item(Needles.fillProperties(Needles.DIAMOND, props)));
    public static final DeferredItem<Item> NETHERITE_SEWING_NEEDLE = ITEMS.registerItem("netherite_sewing_needle", props -> new Item(Needles.fillProperties(Needles.NETHERITE, props)));
    public static final DeferredBlock<Block> SEWING_STATION_BLOCK = BLOCKS.registerBlock("sewing_station", props -> new SewingTableBlock(props.mapColor(MapColor.WOOD).strength(2.5f)));
    public static final DeferredItem<Item> SEWING_STATION_ITEM = ITEMS.registerItem("sewing_station", props -> new BlockItem((Block)SEWING_STATION_BLOCK.get(), props.useBlockDescriptionPrefix()));
    public static final DeferredBlock<Block> STORING_SEWING_STATION_BLOCK = BLOCKS.registerBlock("storing_sewing_station", props -> new StoringSewingTableBlock(props.mapColor(MapColor.WOOD).strength(2.5f)));
    public static final DeferredItem<Item> STORING_SEWING_STATION_ITEM = ITEMS.registerItem("storing_sewing_station", props -> new BlockItem((Block)STORING_SEWING_STATION_BLOCK.get(), props.useBlockDescriptionPrefix()));
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<StoringSewingTableBlockEntity>> STORING_SEWING_STATION_BLOCK_ENTITY = BLOCK_ENTITIES.register("storing_sewing_station", () -> new BlockEntityType(StoringSewingTableBlockEntity::new, new Block[]{(Block)STORING_SEWING_STATION_BLOCK.get()}));
    public static final ResourceKey<EquipmentAsset> WOOL_ASSET = ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (Identifier)SewingKitMod.location("wool"));
    private static final EnumMap<ArmorType, Integer> WOOL_ARMOR_VALUES = (EnumMap)Util.make(new EnumMap(ArmorType.class), map -> {
        map.put(ArmorType.BOOTS, 0);
        map.put(ArmorType.LEGGINGS, 0);
        map.put(ArmorType.CHESTPLATE, 0);
        map.put(ArmorType.HELMET, 0);
        map.put(ArmorType.BODY, 0);
    });
    public static final ArmorMaterial WOOL = new ArmorMaterial(25, WOOL_ARMOR_VALUES, 25, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.01f, ItemTags.WOOL, WOOL_ASSET);
    public static final DeferredItem<Item> WOOL_HAT = ITEMS.registerItem("wool_hat", props -> new Item(props.humanoidArmor(WOOL, ArmorType.HELMET)));
    public static final DeferredItem<Item> WOOL_SHIRT = ITEMS.registerItem("wool_shirt", props -> new Item(props.humanoidArmor(WOOL, ArmorType.CHESTPLATE)));
    public static final DeferredItem<Item> WOOL_PANTS = ITEMS.registerItem("wool_pants", props -> new Item(props.humanoidArmor(WOOL, ArmorType.LEGGINGS)));
    public static final DeferredItem<Item> WOOL_SHOES = ITEMS.registerItem("wool_shoes", props -> new Item(props.humanoidArmor(WOOL, ArmorType.BOOTS)){

        public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
            return true;
        }
    });
    public static final DeferredItem<Item> COMMON_PATTERN = ITEMS.registerItem("common_pattern", props -> new Item(SewingKitMod.fillPatternProps(props.rarity(Rarity.COMMON))));
    public static final DeferredItem<Item> UNCOMMON_PATTERN = ITEMS.registerItem("uncommon_pattern", props -> new Item(SewingKitMod.fillPatternProps(props.rarity(Rarity.UNCOMMON))));
    public static final DeferredItem<Item> RARE_PATTERN = ITEMS.registerItem("rare_pattern", props -> new Item(SewingKitMod.fillPatternProps(props.rarity(Rarity.RARE))));
    public static final DeferredItem<Item> LEGENDARY_PATTERN = ITEMS.registerItem("legendary_pattern", props -> new Item(SewingKitMod.fillPatternProps(props.rarity(Rarity.EPIC))));
    public static final DeferredItem<Item> FILE = ITEMS.registerItem("file", props -> new FileItem(props.durability(354)));
    public static final DeferredHolder<PoiType, PoiType> TABLE_POI = POI_TYPES.register("tailor", () -> new PoiType(Stream.concat(((Block)SEWING_STATION_BLOCK.get()).getStateDefinition().getPossibleStates().stream(), ((Block)STORING_SEWING_STATION_BLOCK.get()).getStateDefinition().getPossibleStates().stream()).collect(Collectors.toUnmodifiableSet()), 1, 1));
    public static final DeferredHolder<VillagerProfession, VillagerProfession> TAILOR = PROFESSIONS.register("tailor", () -> {
        ResourceKey key = Objects.requireNonNull(TABLE_POI.getKey());
        return new VillagerProfession((Component)Component.translatable((String)"entity.minecraft.villager.sewingkit.tailor"), holder -> holder.is(key), holder -> holder.is(key), (ImmutableSet)Arrays.stream(Needles.values()).map(Needles::getNeedle).collect(ImmutableSet.toImmutableSet()), ImmutableSet.of(), null);
    });
    public static final RecipeBookType SEWING_BOOK_CATEGORY = Enum.valueOf(RecipeBookType.class, "SEWINGKIT_SEWING");
    public static final DeferredHolder<RecipeBookCategory, RecipeBookCategory> SEWING_SEARCH = RECIPE_BOOK_CATEGORY.register("sewing_search", RecipeBookCategory::new);
    public static final DeferredHolder<RecipeBookCategory, RecipeBookCategory> SEWING_MISC = RECIPE_BOOK_CATEGORY.register("sewing_misc", RecipeBookCategory::new);
    public static final DeferredHolder<RecipeType<?>, RecipeType<SewingRecipe>> SEWING = RECIPE_TYPES.register("sewing", RecipeType::simple);
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<SewingRecipe>> SEWING_RECIPE = RECIPE_SERIALIZERS.register("sewing", SewingRecipe.Serializer::new);
    public static final DeferredHolder<RecipeDisplay.Type<?>, RecipeDisplay.Type<SewingRecipeDisplay>> SEWING_DISPLAY = RECIPE_DISPLAY.register("sewing", () -> new RecipeDisplay.Type(SewingRecipeDisplay.MAP_CODEC, SewingRecipeDisplay.STREAM_CODEC));
    public static final DeferredHolder<SlotDisplay.Type<?>, SlotDisplay.Type<SewingMaterialSlotDisplay>> MATERIAL_SLOT_DISPLAY = SLOT_DISPLAY.register("material", () -> new SlotDisplay.Type(SewingMaterialSlotDisplay.MAP_CODEC, SewingMaterialSlotDisplay.STREAM_CODEC));
    public static final DeferredHolder<MenuType<?>, MenuType<SewingTableMenu>> SEWING_STATION_MENU = MENU_TYPES.register("sewing_station", () -> new MenuType(SewingTableMenu::new, FeatureFlags.DEFAULT_FLAGS));
    public static final DeferredHolder<LootItemFunctionType<?>, LootItemFunctionType<RandomDye>> RANDOM_DYE = LOOT_FUNCTIONS.register("random_dye", () -> new LootItemFunctionType(RandomDye.CODEC));
    public static final DeferredHolder<StructureProcessorType<?>, StructureProcessorType<TailorShopProcessor>> TAILOR_SHOP_PROCESSOR = STRUCTURE_PROCESSORS.register("tailor_shop_processor", () -> TailorShopProcessor::codec);
    private static final ResourceKey<StructureProcessorList> TAILOR_SHOP_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (Identifier)SewingKitMod.location("tailor_shop_processors"));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> SEWING_KIT_TAB = CREATIVE_TABS.register("sewing_kit", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).icon(() -> new ItemStack((ItemLike)WOOD_SEWING_NEEDLE.get())).title((Component)Component.translatable((String)"tab.sewing_kit")).displayItems((featureFlags, output) -> {
        output.accept((ItemLike)SEWING_STATION_ITEM.get());
        output.accept((ItemLike)STORING_SEWING_STATION_ITEM.get());
        output.accept((ItemLike)WOOD_SEWING_NEEDLE.get());
        output.accept((ItemLike)STONE_SEWING_NEEDLE.get());
        output.accept((ItemLike)BONE_SEWING_NEEDLE.get());
        output.accept((ItemLike)GOLD_SEWING_NEEDLE.get());
        output.accept((ItemLike)IRON_SEWING_NEEDLE.get());
        output.accept((ItemLike)DIAMOND_SEWING_NEEDLE.get());
        output.accept((ItemLike)NETHERITE_SEWING_NEEDLE.get());
        output.accept((ItemLike)FILE.get());
        output.accept((ItemLike)LEATHER_STRIP.get());
        output.accept((ItemLike)LEATHER_SHEET.get());
        output.accept((ItemLike)WOOL_ROLL.get());
        output.accept((ItemLike)WOOL_TRIM.get());
        output.accept((ItemLike)WOOL_HAT.get());
        output.accept((ItemLike)WOOL_SHIRT.get());
        output.accept((ItemLike)WOOL_PANTS.get());
        output.accept((ItemLike)WOOL_SHOES.get());
        output.accept((ItemLike)COMMON_PATTERN.get());
        output.accept((ItemLike)UNCOMMON_PATTERN.get());
        output.accept((ItemLike)RARE_PATTERN.get());
        output.accept((ItemLike)LEGENDARY_PATTERN.get());
    }).build());
    public static final TagKey<Item> WOOD_OR_HIGHER = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)SewingKitMod.location("needles/wood_or_higher"));
    public static final TagKey<Item> BONE_OR_HIGHER = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)SewingKitMod.location("needles/bone_or_higher"));
    public static final TagKey<Item> IRON_OR_HIGHER = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)SewingKitMod.location("needles/iron_or_higher"));
    public static final TagKey<Item> DIAMOND_OR_HIGHER = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)SewingKitMod.location("needles/diamond_or_higher"));
    public static final TagKey<Item> NETHERITE_OR_HIGHER = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)SewingKitMod.location("needles/netherite_or_higher"));

    private static Item.Properties fillPatternProps(Item.Properties props) {
        return props.component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.sewingkit.pattern.wip").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}), Component.translatable((String)"text.sewingkit.pattern.may_be_removed").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}))));
    }

    public SewingKitMod(IEventBus modBus) {
        modBus.addListener(this::gatherData);
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        POI_TYPES.register(modBus);
        PROFESSIONS.register(modBus);
        BLOCK_ENTITIES.register(modBus);
        RECIPE_SERIALIZERS.register(modBus);
        MENU_TYPES.register(modBus);
        RECIPE_TYPES.register(modBus);
        LOOT_FUNCTIONS.register(modBus);
        STRUCTURE_PROCESSORS.register(modBus);
        CREATIVE_TABS.register(modBus);
        INGREDIENT_TYPE.register(modBus);
        RECIPE_BOOK_CATEGORY.register(modBus);
        RECIPE_DISPLAY.register(modBus);
        SLOT_DISPLAY.register(modBus);
        modBus.addListener(this::networkSetup);
        NeoForge.EVENT_BUS.addListener(this::villagerTrades);
        NeoForge.EVENT_BUS.addListener(this::addBuildingToVillages);
        NeoForge.EVENT_BUS.addListener(this::dataSync);
    }

    private void networkSetup(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0");
        registrar.playToClient(SyncRecipeOrder.TYPE, SyncRecipeOrder.STREAM_CODEC, SyncRecipeOrder::handle);
    }

    private void dataSync(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{(RecipeType)SEWING.get()});
    }

    public void addBuildingToVillages(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = event.getServer().registryAccess().lookupOrThrow(Registries.TEMPLATE_POOL);
        Registry processorListRegistry = event.getServer().registryAccess().lookupOrThrow(Registries.PROCESSOR_LIST);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, Identifier.parse((String)"minecraft:village/plains/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, Identifier.parse((String)"minecraft:village/snowy/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, Identifier.parse((String)"minecraft:village/savanna/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, Identifier.parse((String)"minecraft:village/taiga/houses"), "sewingkit:tailor_shop", 5);
        SewingKitMod.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, Identifier.parse((String)"minecraft:village/desert/houses"), "sewingkit:tailor_shop", 5);
    }

    private static void addBuildingToPool(Registry<StructureTemplatePool> templatePoolRegistry, Registry<StructureProcessorList> processorListRegistry, Identifier poolRL, String nbtPieceRL, int weight) {
        Holder.Reference emptyProcessorList = processorListRegistry.getOrThrow(TAILOR_SHOP_PROCESSOR_LIST_KEY);
        StructureTemplatePool pool = templatePoolRegistry.getOptional(poolRL).orElse(null);
        if (pool == null) {
            return;
        }
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.single((String)nbtPieceRL, (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList<Pair> listOfPieceEntries = new ArrayList<Pair>(pool.rawTemplates);
        listOfPieceEntries.add(new Pair((Object)piece, (Object)weight));
        pool.rawTemplates = listOfPieceEntries;
    }

    private void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() != TAILOR.getKey()) {
            return;
        }
        Int2ObjectMap trademap = event.getTrades();
        ((List)trademap.get(1)).addAll(Arrays.asList(new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_PANTS.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_SHOES.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_HAT.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeralds((Item)WOOL_SHIRT.get(), 3, 12, 1), this.buyItem(new ItemStack((ItemLike)Items.STRING, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(2)).addAll(Arrays.asList(new SellRandomFromTag((TagKey<Item>)ItemTags.WOOL_CARPETS, 8, 7, 8, 1, 2.0f), this.sellItem((ItemLike)COMMON_PATTERN.get(), 15, 1, 10, 4.0f), this.buyItem(new ItemStack((ItemLike)LEATHER_STRIP.get(), 2), 1, 12, 1, 0.5f), this.buyItem(new ItemStack((ItemLike)Items.STRING, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(3)).addAll(Arrays.asList(this.sellItem((ItemLike)UNCOMMON_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(4)).addAll(Arrays.asList(this.sellItem((ItemLike)RARE_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(5)).addAll(Arrays.asList(this.sellItem((ItemLike)LEGENDARY_PATTERN.get(), 15, 1, 10, 4.0f)));
    }

    private VillagerTrades.ItemListing sellItem(ItemLike thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return this.sellItem(new ItemStack(thing), price, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ItemListing sellItem(ItemStack thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return new BasicItemListing(new ItemStack((ItemLike)Items.EMERALD, price), thing, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ItemListing buyItem(ItemStack thing, int reward, int maxTrades, int xp, float priceMultiplier) {
        return new BasicItemListing(thing, new ItemStack((ItemLike)Items.EMERALD, reward), maxTrades, xp, priceMultiplier);
    }

    private void gatherData(GatherDataEvent.Client event) {
        SewingKitDataGen.gatherData(event);
    }

    public static Identifier location(String path) {
        return Identifier.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static <B extends ByteBuf, V> StreamCodec<B, @org.jetbrains.annotations.Nullable V> nullable(final StreamCodec<B, V> streamCodec) {
        return new StreamCodec<B, V>(){

            public V decode(B buff) {
                boolean present = buff.readBoolean();
                return present ? streamCodec.decode(buff) : null;
            }

            public void encode(B buff, @org.jetbrains.annotations.Nullable V value) {
                buff.writeBoolean(value != null);
                if (value != null) {
                    streamCodec.encode(buff, value);
                }
            }
        };
    }

    private static class SellRandomFromTag
    implements VillagerTrades.ItemListing {
        private final TagKey<Item> tagSource;
        private final int quantity;
        private final int price;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        private SellRandomFromTag(TagKey<Item> tagSource, int quantity, int price, int maxUses, int xp, float priceMultiplier) {
            this.tagSource = tagSource;
            this.quantity = quantity;
            this.price = price;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        public @Nullable MerchantOffer getOffer(ServerLevel serverLevel, Entity entity, RandomSource randomSource) {
            return BuiltInRegistries.ITEM.getRandomElementOf(this.tagSource, randomSource).map(itemHolder -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, this.price), new ItemStack(itemHolder, this.quantity), this.maxUses, this.xp, this.priceMultiplier)).orElse(null);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientModBus {
        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)SEWING_STATION_MENU.get(), SewingTableScreen::new);
        }
    }
}

