/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.network.SyncRecipeOrder;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.Identifier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RecipesReceivedEvent;

public class ClientSewingRecipeAccessor {
    private static Map<Identifier, RecipeHolder<SewingRecipe>> clientRecipesByName;

    public static Map<Identifier, RecipeHolder<SewingRecipe>> getRecipesByName(Level level) {
        if (level.isClientSide()) {
            return clientRecipesByName;
        }
        throw new IllegalStateException("Cannot call in the server");
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="sewingkit")
    public static class Client {
        public static void handleClientOrder(SyncRecipeOrder packet) {
            AbstractContainerMenu menu = Minecraft.getInstance().player.containerMenu;
            if (menu.containerId == packet.menuId() && menu instanceof SewingTableMenu) {
                SewingTableMenu sewingTableMenu = (SewingTableMenu)menu;
                sewingTableMenu.setOrderedRecipes(packet.recipes());
            }
        }

        @SubscribeEvent
        public static void recipesReceived(RecipesReceivedEvent event) {
            Collection clientRecipes = event.getRecipeMap().byType((RecipeType)SewingKitMod.SEWING.get());
            clientRecipesByName = clientRecipes.stream().collect(Collectors.toMap(e -> e.id().identifier(), e -> e));
        }
    }
}

