/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.sewingkit.api.SewingMaterialSlotDisplay;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;

public record SewingMaterial(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final Codec<SewingMaterial> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SewingMaterial::ingredient), (App)Codec.INT.fieldOf("count").forGetter(SewingMaterial::count)).apply((Applicative)instance, SewingMaterial::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SewingMaterial> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SewingMaterial::ingredient, (StreamCodec)ByteBufCodecs.INT, SewingMaterial::count, SewingMaterial::new);

    public static SewingMaterial of(Ingredient ingredient, int count) {
        return new SewingMaterial(ingredient, count);
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.ingredient.test(itemStack) && itemStack.getCount() >= this.count;
    }

    public SlotDisplay display() {
        return new SewingMaterialSlotDisplay(this.ingredient.display(), this.count);
    }
}

