/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingMaterial;
import dev.gigaherz.sewingkit.api.SewingRecipeDisplay;
import dev.gigaherz.sewingkit.table.SewingInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SewingRecipe
implements Recipe<SewingInput> {
    public static final MapCodec<SewingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> SewingRecipe.defaultSewingFields(instance).apply((Applicative)instance, SewingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SewingRecipe> STREAM_CODEC = StreamCodec.composite(SewingKitMod.nullable(ByteBufCodecs.STRING_UTF8), SewingRecipe::group, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.RECIPE_BOOK_CATEGORY), SewingRecipe::recipeBookCategory, (StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, SewingMaterial.STREAM_CODEC), SewingRecipe::materials, SewingKitMod.nullable(Ingredient.CONTENTS_STREAM_CODEC), SewingRecipe::pattern, SewingKitMod.nullable(Ingredient.CONTENTS_STREAM_CODEC), SewingRecipe::tool, (StreamCodec)ItemStack.STREAM_CODEC, SewingRecipe::output, (StreamCodec)ByteBufCodecs.BOOL, SewingRecipe::showNotification, SewingRecipe::new);
    private final String group;
    private final RecipeBookCategory recipeBookCategory;
    private final NonNullList<SewingMaterial> materials;
    @Nullable
    private final Ingredient pattern;
    @Nullable
    private final Ingredient tool;
    private final ItemStack output;
    private final boolean showNotification;
    private PlacementInfo placementInfo;

    public static <T extends SewingRecipe> Products.P7<RecordCodecBuilder.Mu<T>, String, RecipeBookCategory, NonNullList<SewingMaterial>, Optional<Ingredient>, Optional<Ingredient>, ItemStack, Boolean> defaultSewingFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SewingRecipe::group), (App)BuiltInRegistries.RECIPE_BOOK_CATEGORY.byNameCodec().fieldOf("category").forGetter(SewingRecipe::recipeBookCategory), (App)NonNullList.codecOf(SewingMaterial.CODEC).fieldOf("materials").forGetter(SewingRecipe::materials), (App)Ingredient.CODEC.optionalFieldOf("pattern").forGetter(recipe -> Optional.ofNullable(recipe.pattern())), (App)Ingredient.CODEC.optionalFieldOf("tool").forGetter(recipe -> Optional.ofNullable(recipe.tool())), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(SewingRecipe::output), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(SewingRecipe::showNotification));
    }

    protected SewingRecipe(String group, RecipeBookCategory recipeBookCategory, NonNullList<SewingMaterial> materials, Optional<Ingredient> pattern, Optional<Ingredient> tool, ItemStack output, boolean showNotification) {
        this(group, recipeBookCategory, materials, (Ingredient)pattern.orElse(null), (Ingredient)tool.orElse(null), output, showNotification);
    }

    public SewingRecipe(String group, RecipeBookCategory recipeBookCategory, NonNullList<SewingMaterial> materials, @Nullable Ingredient pattern, @Nullable Ingredient tool, ItemStack output, boolean showNotification) {
        this.group = group;
        this.recipeBookCategory = recipeBookCategory;
        this.materials = materials;
        this.pattern = pattern;
        this.tool = tool;
        this.output = output;
        this.showNotification = showNotification;
    }

    public String group() {
        return this.group;
    }

    public RecipeSerializer<? extends Recipe<SewingInput>> getSerializer() {
        return (RecipeSerializer)SewingKitMod.SEWING_RECIPE.get();
    }

    public RecipeType<? extends Recipe<SewingInput>> getType() {
        return (RecipeType)SewingKitMod.SEWING.get();
    }

    public boolean matches(SewingInput input, Level worldIn) {
        boolean hasPattern;
        boolean hasTool;
        ItemStack toolStack = input.getTool();
        boolean bl = this.tool != null ? !toolStack.isEmpty() && this.tool.test(toolStack) : (hasTool = toolStack.isEmpty());
        if (!hasTool) {
            return false;
        }
        ItemStack patternStack = input.getPattern();
        boolean bl2 = this.pattern != null ? !patternStack.isEmpty() && this.pattern.test(patternStack) : (hasPattern = patternStack.isEmpty());
        if (!hasPattern) {
            return false;
        }
        Map<Ingredient, Integer> missing = this.materials.stream().collect(Collectors.toMap(SewingMaterial::ingredient, SewingMaterial::count));
        for (int i = 0; i < 4; ++i) {
            for (Map.Entry<Ingredient, Integer> mat : missing.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack = input.getMaterial(i);
                if (!ing.test(stack)) continue;
                int remaining = Math.max(0, value - stack.getCount());
                mat.setValue(remaining);
            }
        }
        return missing.values().stream().noneMatch(v -> v > 0);
    }

    public ItemStack assemble(SewingInput container, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public NonNullList<SewingMaterial> materials() {
        return this.materials;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            ArrayList<Optional<Ingredient>> ingredients = new ArrayList<Optional<Ingredient>>();
            ingredients.add(Optional.ofNullable(this.tool));
            ingredients.add(Optional.ofNullable(this.pattern));
            this.materials.stream().map(m -> Optional.of(m.ingredient())).forEach(ingredients::add);
            this.placementInfo = PlacementInfo.createFromOptionals(ingredients);
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return this.recipeBookCategory;
    }

    @Nullable
    public Ingredient tool() {
        return this.tool;
    }

    @Nullable
    public Ingredient pattern() {
        return this.pattern;
    }

    public ItemStack output() {
        return this.output;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public List<RecipeDisplay> display() {
        return List.of(new SewingRecipeDisplay(this.materials.stream().map(SewingMaterial::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.output), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(Items.CRAFTING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<SewingRecipe> {
        public MapCodec<SewingRecipe> codec() {
            return CODEC;
        }

        @Deprecated
        public StreamCodec<RegistryFriendlyByteBuf, SewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

