/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingMaterial;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.level.ItemLike;

public class SewingRecipeBuilder {
    private final RecipeCategory category;
    private final HolderLookup.RegistryLookup<Item> items;
    private String group;
    private Ingredient tool;
    private Ingredient pattern;
    private final NonNullList<SewingMaterial> materials = NonNullList.create();
    private final ItemStack result;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private boolean showNotification = true;

    public static SewingRecipeBuilder begin(HolderLookup.RegistryLookup<Item> items, RecipeCategory cat, Item result) {
        return SewingRecipeBuilder.begin(items, cat, new ItemStack((ItemLike)result));
    }

    public static SewingRecipeBuilder begin(HolderLookup.RegistryLookup<Item> items, RecipeCategory cat, Item result, int count) {
        return SewingRecipeBuilder.begin(items, cat, new ItemStack((ItemLike)result, count));
    }

    public static SewingRecipeBuilder begin(HolderLookup.RegistryLookup<Item> items, RecipeCategory cat, ItemStack result) {
        return new SewingRecipeBuilder(items, cat, result);
    }

    protected SewingRecipeBuilder(HolderLookup.RegistryLookup<Item> items, RecipeCategory cat, ItemStack result) {
        this.items = items;
        this.category = cat;
        this.result = result;
    }

    public SewingRecipeBuilder withTool(ItemLike ... tool) {
        return this.withTool(Ingredient.of((ItemLike[])tool));
    }

    public SewingRecipeBuilder withTool(TagKey<Item> tool) {
        return this.withTool(Ingredient.of((HolderSet)this.items.getOrThrow(tool)));
    }

    public SewingRecipeBuilder withTool(Ingredient tool) {
        this.tool = tool;
        return this;
    }

    public SewingRecipeBuilder withPattern(ItemLike ... pattern) {
        return this.withPattern(Ingredient.of((ItemLike[])pattern));
    }

    public SewingRecipeBuilder withPattern(TagKey<Item> pattern) {
        return this.withPattern(Ingredient.of((HolderSet)this.items.getOrThrow(pattern)));
    }

    public SewingRecipeBuilder withPattern(Ingredient pattern) {
        this.pattern = pattern;
        return this;
    }

    public SewingRecipeBuilder addMaterial(int count, ItemLike ... x) {
        return this.addMaterial(Ingredient.of((ItemLike[])x), count);
    }

    public SewingRecipeBuilder addMaterial(ItemLike x, int count) {
        return this.addMaterial(Ingredient.of((ItemLike)x), count);
    }

    public SewingRecipeBuilder addMaterial(TagKey<Item> x, int count) {
        return this.addMaterial(Ingredient.of((HolderSet)this.items.getOrThrow(x)), 1);
    }

    public SewingRecipeBuilder addMaterial(ItemLike ... x) {
        return this.addMaterial(Ingredient.of((ItemLike[])x), 1);
    }

    public SewingRecipeBuilder addMaterial(TagKey<Item> x) {
        return this.addMaterial(Ingredient.of((HolderSet)this.items.getOrThrow(x)), 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x) {
        return this.addMaterial(x, 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x, int count) {
        if (this.materials.size() >= 4) {
            throw new IllegalArgumentException("There can only be up to 4 materials!");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be a positive integer!");
        }
        this.materials.add((Object)SewingMaterial.of(x, count));
        return this;
    }

    public SewingRecipeBuilder addCriterion(String name, Criterion<?> criterionIn) {
        this.criteria.put(name, criterionIn);
        return this;
    }

    public SewingRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public SewingRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public void save(RecipeOutput consumerIn, Identifier id) {
        this.validate(id);
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)id);
        Advancement.Builder advancementBuilder = Advancement.Builder.advancement();
        advancementBuilder.addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)key)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)key)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancementBuilder).addCriterion(arg_0, arg_1));
        Identifier advancementId = id.withPrefix("recipes/" + this.category.getFolderName() + "/");
        SewingRecipe recipe = this.build(Objects.requireNonNullElse(this.group, ""), SewingRecipeBuilder.determineBookCategory(this.category), this.materials, this.pattern, this.tool, this.result, this.showNotification);
        consumerIn.accept(key, (Recipe)recipe, advancementBuilder.build(advancementId));
    }

    static RecipeBookCategory determineBookCategory(RecipeCategory category) {
        switch (category) {
            default: 
        }
        return (RecipeBookCategory)SewingKitMod.SEWING_MISC.get();
    }

    protected SewingRecipe build(String group, RecipeBookCategory category, NonNullList<SewingMaterial> materials, Ingredient pattern, Ingredient tool, ItemStack result, boolean showNotification) {
        return new SewingRecipe(group, category, materials, pattern, tool, result, showNotification);
    }

    private void validate(Identifier id) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining sewing recipe " + String.valueOf(id));
        }
        if (this.materials.isEmpty()) {
            throw new IllegalStateException("No ingredients for sewing recipe " + String.valueOf(id));
        }
    }
}

