/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.loot;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.gigaherz.sewingkit.SewingKitMod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomDye
extends LootItemConditionalFunction {
    public static final MapCodec<RandomDye> CODEC = RecordCodecBuilder.mapCodec(instance -> RandomDye.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, RandomDye::new));

    public static LootItemConditionalFunction.Builder<?> builder() {
        return LootItemConditionalFunction.simpleBuilder(RandomDye::new);
    }

    protected RandomDye(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public LootItemFunctionType<RandomDye> getType() {
        return (LootItemFunctionType)SewingKitMod.RANDOM_DYE.get();
    }

    protected ItemStack run(ItemStack itemStack, LootContext lootContext) {
        return RandomDye.getRandomDye(itemStack, lootContext.getRandom());
    }

    public static ItemStack getRandomDye(ItemStack original, RandomSource rand) {
        if (original.is(ItemTags.DYEABLE)) {
            ArrayList list = Lists.newArrayList();
            list.add(RandomDye.getRandomDye(rand));
            if (rand.nextFloat() > 0.7f) {
                list.add(RandomDye.getRandomDye(rand));
            }
            if (rand.nextFloat() > 0.8f) {
                list.add(RandomDye.getRandomDye(rand));
            }
            original = DyedItemColor.applyDyes((ItemStack)original, (List)list);
        }
        return original;
    }

    public static DyeItem getRandomDye(RandomSource rand) {
        return DyeItem.byColor((DyeColor)DyeColor.byId((int)rand.nextInt(16)));
    }
}

