/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.needle;

import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.needle.NeedleMaterial;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum Needles implements NeedleMaterial
{
    WOOD("wood", 10, ToolMaterial.WOOD, (DeferredHolder<Item, ? extends Item>)SewingKitMod.WOOD_SEWING_NEEDLE, (TagKey<Item>)ItemTags.PLANKS),
    STONE("stone", 15, ToolMaterial.STONE, (DeferredHolder<Item, ? extends Item>)SewingKitMod.STONE_SEWING_NEEDLE, (TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS),
    IRON("iron", 150, ToolMaterial.IRON, (DeferredHolder<Item, ? extends Item>)SewingKitMod.IRON_SEWING_NEEDLE, (TagKey<Item>)Tags.Items.INGOTS_IRON),
    DIAMOND("diamond", 250, ToolMaterial.DIAMOND, (DeferredHolder<Item, ? extends Item>)SewingKitMod.DIAMOND_SEWING_NEEDLE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND),
    GOLD("gold", 25, ToolMaterial.GOLD, (DeferredHolder<Item, ? extends Item>)SewingKitMod.GOLD_SEWING_NEEDLE, (TagKey<Item>)Tags.Items.INGOTS_GOLD),
    NETHERITE("netherite", 350, ToolMaterial.NETHERITE, (DeferredHolder<Item, ? extends Item>)SewingKitMod.NETHERITE_SEWING_NEEDLE, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE),
    BONE("bone", 50, SewingKitMod.BONE_TIER, (DeferredHolder<Item, ? extends Item>)SewingKitMod.BONE_SEWING_NEEDLE, (TagKey<Item>)Tags.Items.BONES);

    private final String type;
    private final int uses;
    private final ToolMaterial toolMaterial;
    private final DeferredHolder<Item, ? extends Item> needleSupplier;
    private final TagKey<Item> materialTag;
    public static final TagKey<Block> BREAKABLE_NEEDLE;

    private Needles(String type, int uses, ToolMaterial toolMaterial, DeferredHolder<Item, ? extends Item> needleSupplier, TagKey<Item> materialTag) {
        this.type = type;
        this.uses = uses;
        this.toolMaterial = toolMaterial;
        this.needleSupplier = needleSupplier;
        this.materialTag = materialTag;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Identifier getId() {
        return this.needleSupplier.getId();
    }

    @Override
    public Item getNeedle() {
        return (Item)this.needleSupplier.get();
    }

    @Override
    public ToolMaterial getToolMaterial() {
        return this.toolMaterial;
    }

    @Override
    public int getUses() {
        return this.uses;
    }

    public TagKey<Item> getMaterial() {
        return this.materialTag;
    }

    public static Item.Properties fillProperties(NeedleMaterial material, Item.Properties props) {
        return props.durability(material.getUses()).tool(material.getToolMaterial(), BREAKABLE_NEEDLE, 0.0f, 1.0f, 0.0f).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"text.sewingkit.needle.lore_text"))));
    }

    static {
        BREAKABLE_NEEDLE = TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)SewingKitMod.location("breakable_needle"));
    }
}

