/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.structure;

import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.loot.RandomDye;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TailorShopProcessor
extends StructureProcessor {
    public static final MapCodec<TailorShopProcessor> CODEC = Codec.EMPTY.xmap(u -> new TailorShopProcessor(), p -> Unit.INSTANCE);

    public static MapCodec<TailorShopProcessor> codec() {
        return CODEC;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)SewingKitMod.TAILOR_SHOP_PROCESSOR.get();
    }

    @Nullable
    public StructureTemplate.StructureEntityInfo processEntity(LevelReader level, BlockPos seedPos, StructureTemplate.StructureEntityInfo rawEntityInfo, StructureTemplate.StructureEntityInfo entityInfo, StructurePlaceSettings placementSettings, StructureTemplate template) {
        Optional id = entityInfo.nbt.getString("id");
        if (Objects.equals(id, "minecraft:armor_stand")) {
            RandomSource s = placementSettings.getRandom(entityInfo.blockPos);
            if (s.nextDouble() < 0.1) {
                return null;
            }
            entityInfo = new StructureTemplate.StructureEntityInfo(entityInfo.pos, entityInfo.blockPos, entityInfo.nbt.copy());
            ListTag armorTag = entityInfo.nbt.getListOrEmpty("ArmorItems");
            if (!entityInfo.nbt.contains("ArmorItems")) {
                entityInfo.nbt.put("ArmorItems", (Tag)armorTag);
            }
            RegistryAccess provider = level.registryAccess();
            this.putArmorPieceMaybe(armorTag, 3, s, (HolderLookup.Provider)provider, Items.LEATHER_HELMET, (Item)SewingKitMod.WOOL_HAT.get());
            this.putArmorPieceMaybe(armorTag, 2, s, (HolderLookup.Provider)provider, Items.LEATHER_CHESTPLATE, (Item)SewingKitMod.WOOL_SHIRT.get());
            this.putArmorPieceMaybe(armorTag, 1, s, (HolderLookup.Provider)provider, Items.LEATHER_LEGGINGS, (Item)SewingKitMod.WOOL_PANTS.get());
            this.putArmorPieceMaybe(armorTag, 0, s, (HolderLookup.Provider)provider, Items.LEATHER_BOOTS, (Item)SewingKitMod.WOOL_SHOES.get());
        }
        return entityInfo;
    }

    private void putArmorPieceMaybe(ListTag armorTag, int index, RandomSource rand, HolderLookup.Provider provider, Item ... items) {
        if (items.length > 0 && rand.nextDouble() < 0.25) {
            Item item = items[rand.nextInt(items.length)];
            ItemStack stack = RandomDye.getRandomDye(new ItemStack((ItemLike)item), rand);
            Tag stackTag = (Tag)ItemStack.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)provider), (Object)stack).getOrThrow();
            armorTag.set(index, stackTag);
        }
    }
}

