/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;

public class SewingInput
implements RecipeInput {
    private final List<ItemStack> materials;
    private final ItemStack tool;
    private final ItemStack pattern;

    public static SewingInput ofSewingTableInventory(Container inv) {
        ItemStack tool = inv.getItem(0);
        ItemStack pattern = inv.getItem(1);
        List<ItemStack> materials = List.of(inv.getItem(2), inv.getItem(3), inv.getItem(4), inv.getItem(5));
        return new SewingInput(materials, tool, pattern);
    }

    public SewingInput(List<ItemStack> materials, ItemStack tool, ItemStack pattern) {
        this.materials = materials;
        this.tool = tool;
        this.pattern = pattern;
    }

    public ItemStack getItem(int slot) {
        if (slot == 0) {
            return this.tool;
        }
        if (slot == 1) {
            return this.pattern;
        }
        return this.materials.get(slot - 2);
    }

    public ItemStack getTool() {
        return this.tool;
    }

    public ItemStack getPattern() {
        return this.pattern;
    }

    public ItemStack getMaterial(int mat) {
        return this.materials.get(mat);
    }

    public int size() {
        return 6;
    }
}

