/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.ClientSewingRecipeAccessor;
import dev.gigaherz.sewingkit.api.SewingMaterial;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.network.SyncRecipeOrder;
import dev.gigaherz.sewingkit.table.InventoryProvider;
import dev.gigaherz.sewingkit.table.SewingInput;
import dev.gigaherz.sewingkit.table.SewingTableInventory;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SewingTableMenu
extends RecipeBookMenu {
    private static final int NUM_INPUTS = 6;
    private static final int NUM_OUTPUTS = 1;
    private static final int NUM_INVENTORY = 27;
    private static final int NUM_HOTBAR = 9;
    private static final int OUTPUTS_START = 6;
    private static final int PLAYER_START = 7;
    private static final int HOTBAR_START = 34;
    private static final int PLAYER_END = 43;
    private final Level level;
    private final ContainerLevelAccess openedFrom;
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private final ItemStack[] inputStacksCache = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};
    private final InventoryProvider inventoryProvider;
    private final Player player;
    private List<RecipeHolder<SewingRecipe>> recipes = Lists.newArrayList();
    private List<RecipeHolder<SewingRecipe>> oldRecipes = null;
    private long lastTimeSoundPlayed;
    private Runnable inventoryUpdateListener = () -> {};
    public Container inputInventory;
    private final ResultContainer inventory = new ResultContainer();
    public static final int ITEM_NOT_FOUND = -1;

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.NULL);
    }

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn, ContainerLevelAccess worldPosCallableIn) {
        this(windowIdIn, playerInventoryIn, worldPosCallableIn, new SewingTableInventory());
    }

    public SewingTableMenu(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn, InventoryProvider inventoryProvider) {
        super((MenuType)SewingKitMod.SEWING_STATION_MENU.get(), windowIdIn);
        this.openedFrom = worldPosCallableIn;
        this.player = playerInventoryIn.player;
        this.level = playerInventoryIn.player.level();
        this.inputInventory = inventoryProvider.getInventory();
        this.inventoryProvider = inventoryProvider;
        inventoryProvider.addWeakListener(this);
        this.addSlot(new Slot(this, this.inputInventory, 0, 8, 15){
            {
                this.setBackground(SewingKitMod.location("needle_slot_background"));
            }
        });
        this.addSlot(new Slot(this, this.inputInventory, 1, 30, 15){
            {
                this.setBackground(SewingKitMod.location("pattern_slot_background"));
            }
        });
        this.addSlot(new Slot(this.inputInventory, 2, 10, 35));
        this.addSlot(new Slot(this.inputInventory, 3, 28, 35));
        this.addSlot(new Slot(this.inputInventory, 4, 10, 53));
        this.addSlot(new Slot(this.inputInventory, 5, 28, 53));
        this.addSlot(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    stack.onCraftedBy(player, stack.getCount());
                    ArrayList<ItemStack> consumed = new ArrayList<ItemStack>();
                    SewingRecipe recipe = (SewingRecipe)SewingTableMenu.this.recipes.get(SewingTableMenu.this.getSelectedRecipe()).value();
                    Map<Ingredient, Integer> remaining = recipe.materials().stream().collect(Collectors.toMap(SewingMaterial::ingredient, SewingMaterial::count));
                    if (SewingTableMenu.this.consumeCraftingMaterials(serverPlayer, remaining, consumed)) {
                        SewingTableMenu.this.updateRecipeResultSlot();
                    }
                    SewingTableMenu.this.inventory.awardUsedRecipes(player, consumed);
                    worldPosCallableIn.execute((world, pos) -> {
                        long l = world.getGameTime();
                        if (SewingTableMenu.this.lastTimeSoundPlayed != l) {
                            world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                            SewingTableMenu.this.lastTimeSoundPlayed = l;
                        }
                    });
                    SewingTableMenu.this.onInventoryChanged();
                }
                super.onTake(player, stack);
            }
        });
        this.bindPlayerInventory(playerInventoryIn);
        this.addDataSlot(this.selectedRecipe);
        this.onInventoryChanged();
    }

    private boolean consumeCraftingMaterials(ServerPlayer serverPlayer, Map<Ingredient, Integer> remaining, List<ItemStack> consumed) {
        boolean needsUpdate = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack;
            Slot slot = (Slot)this.slots.get(i);
            if (i == 0) {
                slot.getItem().hurtAndBreak(1, serverPlayer.level(), serverPlayer, item -> slot.set(ItemStack.EMPTY));
                itemstack = slot.getItem();
            } else if (i == 1) {
                itemstack = ItemStack.EMPTY;
            } else {
                int subtract = 0;
                for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                    Ingredient ing = mat.getKey();
                    int value = mat.getValue();
                    ItemStack stack1 = slot.getItem();
                    if (!ing.test(stack1)) continue;
                    consumed.add(stack1.copy());
                    int remaining1 = Math.max(0, value - (stack1.getCount() + subtract));
                    subtract += value - remaining1;
                    mat.setValue(remaining1);
                }
                itemstack = slot.remove(subtract);
            }
            if (itemstack.isEmpty()) continue;
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private void bindPlayerInventory(Inventory playerInventoryIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public void onInventoryChanged() {
        this.slotsChanged(null);
        this.inventoryUpdateListener.run();
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<RecipeHolder<SewingRecipe>> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsinInputSlots() {
        if (this.inputInventory == null) {
            return false;
        }
        return this.slots.stream().skip(2L).limit(4L).anyMatch(Slot::hasItem);
    }

    public boolean isAbleToCraft() {
        return this.hasItemsinInputSlots() && !this.recipes.isEmpty();
    }

    public boolean stillValid(Player playerIn) {
        return SewingTableMenu.isWithinUsableDistance(this.openedFrom, playerIn, (Block)SewingKitMod.SEWING_STATION_BLOCK.get(), (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
    }

    protected static boolean isWithinUsableDistance(ContainerLevelAccess worldPos, Player playerIn, Block ... targetBlocks) {
        return (Boolean)worldPos.evaluate((world, pos) -> {
            BlockState blockState = world.getBlockState(pos);
            if (Arrays.stream(targetBlocks).noneMatch(arg_0 -> ((BlockState)blockState).is(arg_0))) {
                return false;
            }
            return playerIn.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.set(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void slotsChanged(Container unused) {
        super.slotsChanged(unused);
        boolean anyChanged = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
            if (ItemStack.matches((ItemStack)itemstack, (ItemStack)this.inputStacksCache[i])) continue;
            this.inputStacksCache[i] = itemstack.copy();
            anyChanged = true;
        }
        if (anyChanged) {
            this.updateAvailableRecipes();
        }
    }

    public void broadcastFullState() {
        super.broadcastFullState();
        this.sendOrderedRecipes();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.recipes != this.oldRecipes) {
            this.sendOrderedRecipes();
            this.oldRecipes = this.recipes;
        }
    }

    private void updateAvailableRecipes() {
        int index;
        if (this.level.isClientSide()) {
            return;
        }
        SewingRecipe recipe = this.getSelectedRecipe() >= 0 && !this.recipes.isEmpty() ? (SewingRecipe)this.recipes.get(this.getSelectedRecipe()).value() : null;
        this.recipes = Lists.newArrayList();
        this.selectedRecipe.set(-1);
        ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        if (this.hasItemsinInputSlots()) {
            SewingInput input = SewingInput.ofSewingTableInventory(this.inputInventory);
            this.recipes = SewingTableMenu.getRecipes(input, this.level);
        }
        if (!this.recipes.isEmpty() && recipe != null && (index = this.recipes.indexOf(recipe)) >= 0) {
            this.selectedRecipe.set(index);
            this.updateRecipeResultSlot();
        }
    }

    public static List<RecipeHolder<SewingRecipe>> getRecipes(SewingInput input, Level level) {
        RecipeMap recipeMap = level.getServer().getRecipeManager().recipeMap();
        Collection recipes = recipeMap.byType((RecipeType)SewingKitMod.SEWING.get());
        return recipes.stream().filter(recipe -> ((SewingRecipe)recipe.value()).matches(input, level)).toList();
    }

    private void sendOrderedRecipes() {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new SyncRecipeOrder(this.containerId, this.recipes.stream().map(r -> r.id().identifier()).toList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setOrderedRecipes(List<Identifier> recipes) {
        Map<Identifier, RecipeHolder<SewingRecipe>> allRecipes = ClientSewingRecipeAccessor.getRecipesByName(this.level);
        this.recipes = recipes.stream().map(allRecipes::get).toList();
        this.onInventoryChanged();
    }

    private void updateRecipeResultSlot() {
        if (this.inputInventory == null) {
            return;
        }
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.get())) {
            RecipeHolder<SewingRecipe> sewingRecipe = this.recipes.get(this.selectedRecipe.get());
            this.inventory.setRecipeUsed(sewingRecipe);
            SewingInput input = SewingInput.ofSewingTableInventory(this.inputInventory);
            ((Slot)this.slots.get(6)).set(((SewingRecipe)sewingRecipe.value()).assemble(input, (HolderLookup.Provider)this.level.registryAccess()));
        } else {
            ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.inventory && super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        Item item = stackInSlot.getItem();
        ItemStack stackCopy = stackInSlot.copy();
        int startIndex = 7;
        int endIndex = 43;
        boolean reverse = false;
        boolean notify = false;
        if (index == 6) {
            reverse = true;
            notify = true;
        } else if (index >= 6) {
            if (stackInSlot.getMaxStackSize() == 1 && ((Slot)this.slots.get(0)).getItem().isEmpty()) {
                startIndex = 0;
                endIndex = 1;
            } else {
                startIndex = 2;
                endIndex = 6;
            }
        }
        if (endIndex > startIndex) {
            if (notify) {
                item.onCraftedBy(stackInSlot, player);
            }
            if (!this.moveItemStackTo(stackInSlot, startIndex, endIndex, reverse)) {
                return ItemStack.EMPTY;
            }
            if (notify) {
                slot.onQuickCraft(stackInSlot, stackCopy);
            }
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (stackInSlot.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stackInSlot);
        this.broadcastChanges();
        return stackCopy;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.inventory.removeItemNoUpdate(0);
        if (this.inventoryProvider.isDummy()) {
            this.openedFrom.execute((world, pos) -> this.returnAllItemsToPlayer(playerIn));
        }
    }

    protected void returnAllItemsToPlayer(Player pPlayer) {
        if (this.inputInventory == null) {
            return;
        }
        if (!pPlayer.isAlive() || pPlayer instanceof ServerPlayer && ((ServerPlayer)pPlayer).hasDisconnected()) {
            for (int j = 0; j < this.inputInventory.getContainerSize(); ++j) {
                pPlayer.drop(this.inputInventory.getItem(j), false);
            }
        } else {
            for (int i = 0; i < this.inputInventory.getContainerSize(); ++i) {
                Inventory inventory = pPlayer.getInventory();
                if (!(inventory.player instanceof ServerPlayer)) continue;
                inventory.placeItemBackInInventory(this.inputInventory.getItem(i));
            }
        }
        this.inputInventory = null;
    }

    public boolean isCraftingSlot(Slot slot) {
        return this.slots.indexOf((Object)slot) < 6;
    }

    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean useMaxItems, boolean isCreative, RecipeHolder<?> recipe, ServerLevel level, Inventory playerInventory) {
        if (!isCreative && !this.testClearGrid(playerInventory)) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents stackeditemcontents = new StackedItemContents();
        playerInventory.fillStackedContents(stackeditemcontents);
        this.fillCraftSlotsStackedContents(stackeditemcontents);
        return this.tryPlaceRecipe(playerInventory, recipe, stackeditemcontents, useMaxItems);
    }

    public void fillCraftSlotsStackedContents(StackedItemContents stackedItemContents) {
        Container container = this.inputInventory;
        if (container instanceof StackedContentsCompatible) {
            StackedContentsCompatible stackedContentsCompatible = (StackedContentsCompatible)container;
            stackedContentsCompatible.fillStackedContents(stackedItemContents);
        }
    }

    public RecipeBookType getRecipeBookType() {
        return SewingKitMod.SEWING_BOOK_CATEGORY;
    }

    private boolean testClearGrid(Inventory playerInventory) {
        ArrayList list = Lists.newArrayList();
        int freeSlots = SewingTableMenu.getAmountOfFreeSlotsInInventory(playerInventory);
        for (int i = 0; i < 6; ++i) {
            Slot slot = this.getSlot(i);
            ItemStack itemstack = slot.getItem().copy();
            if (itemstack.isEmpty()) continue;
            int j = playerInventory.getSlotWithRemainingSpace(itemstack);
            if (j == -1 && list.size() <= freeSlots) {
                for (ItemStack itemstack1 : list) {
                    if (!ItemStack.isSameItem((ItemStack)itemstack1, (ItemStack)itemstack) || itemstack1.getCount() == itemstack1.getMaxStackSize() || itemstack1.getCount() + itemstack.getCount() > itemstack1.getMaxStackSize()) continue;
                    itemstack1.grow(itemstack.getCount());
                    itemstack.setCount(0);
                    break;
                }
                if (itemstack.isEmpty()) continue;
                if (list.size() >= freeSlots) {
                    return false;
                }
                list.add(itemstack);
                continue;
            }
            if (j != -1) continue;
            return false;
        }
        return true;
    }

    private static int getAmountOfFreeSlotsInInventory(Inventory platerInventory) {
        int i = 0;
        for (ItemStack itemstack : platerInventory.getNonEquipmentItems()) {
            if (!itemstack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(Inventory inventory, RecipeHolder<SewingRecipe> recipe, StackedItemContents stackedItemContents, boolean useMaxItems) {
        if (stackedItemContents.canCraft(recipe.value(), null)) {
            this.placeRecipe(inventory, recipe, stackedItemContents, useMaxItems);
            inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearGrid(inventory);
        inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void clearGrid(Inventory inventory) {
        for (int i = 0; i < 6; ++i) {
            Slot slot = this.getSlot(i);
            ItemStack itemstack = slot.getItem().copy();
            inventory.placeItemBackInInventory(itemstack, false);
            slot.set(itemstack);
        }
        this.inputInventory.clearContent();
    }

    /*
     * WARNING - void declaration
     */
    private void placeRecipe(Inventory inventory, RecipeHolder<SewingRecipe> recipeHolder, StackedItemContents stackedItemContents, boolean useMaxItems) {
        void var16_18;
        ArrayList<Holder<Item>> list;
        SewingRecipe recipe = (SewingRecipe)recipeHolder.value();
        Ingredient tool = recipe.tool();
        Ingredient pattern = recipe.pattern();
        NonNullList<SewingMaterial> materials = recipe.materials();
        SewingInput input = SewingInput.ofSewingTableInventory(this.inputInventory);
        boolean recipeMatches = recipe.matches(input, this.level);
        Int2IntArrayMap slotToAmount = new Int2IntArrayMap();
        int amountToCraft = SewingTableMenu.getMaxCraft(tool, pattern, materials, stackedItemContents, slotToAmount);
        if (!useMaxItems) {
            amountToCraft = 1;
            if (recipeMatches) {
                StackedItemContents stacked = new StackedItemContents();
                for (int i = 0; i < 6; ++i) {
                    Slot slot2 = this.getSlot(i);
                    stacked.accountStack(slot2.getItem());
                }
                int amountCraftable = SewingTableMenu.getMaxCraft(tool, pattern, materials, stacked, slotToAmount);
                if (amountCraftable < amountToCraft && this.canFitInGrid(materials, amountCraftable + 1)) {
                    amountToCraft = amountCraftable + 1;
                }
            }
        }
        if (this.tryPickItemsForCraft(stackedItemContents, recipe, amountToCraft, list = new ArrayList<Holder<Item>>())) {
            return;
        }
        int amount = amountToCraft;
        for (Holder holder : list) {
            amount = Math.min(amount, ((Item)holder.value()).getDefaultMaxStackSize());
        }
        if (amount != amountToCraft) {
            list.clear();
            if (this.tryPickItemsForCraft(stackedItemContents, recipe, amount, list)) {
                return;
            }
        }
        this.clearGrid(inventory);
        IntListIterator iterator = recipe.placementInfo().slotsToIngredientIndex().iterator();
        boolean bl = false;
        while (var16_18 < 6) {
            if (!iterator.hasNext()) {
                return;
            }
            int item = iterator.nextInt();
            if (item != -1) {
                Slot targetSlot = this.getSlot((int)var16_18);
                Holder holder = (Holder)list.get(item);
                int countPerItem = slotToAmount.getOrDefault((int)var16_18, 0);
                int remaining = amount * countPerItem;
                while (remaining > 0) {
                    int result;
                    ItemStack inSlot = targetSlot.getItem();
                    int matchingSlot = inventory.findSlotMatchingCraftingIngredient(holder, inSlot);
                    if (matchingSlot == -1) {
                        result = -1;
                    } else {
                        ItemStack itemstack1 = inventory.getItem(matchingSlot);
                        ItemStack itemstack2 = remaining < itemstack1.getCount() ? inventory.removeItem(matchingSlot, remaining) : inventory.removeItemNoUpdate(matchingSlot);
                        int j = itemstack2.getCount();
                        if (inSlot.isEmpty()) {
                            targetSlot.set(itemstack2);
                        } else {
                            inSlot.grow(j);
                        }
                        result = remaining - j;
                    }
                    if ((remaining = result) != -1) continue;
                    return;
                }
            }
            ++var16_18;
        }
    }

    private boolean tryPickItemsForCraft(StackedItemContents stackedItemContents, SewingRecipe recipe, int amountToCraft, List<Holder<Item>> list) {
        IntArrayList amounts = new IntArrayList();
        if (recipe.tool() != null) {
            amounts.add(-1);
        }
        if (recipe.pattern() != null) {
            amounts.add(-1);
        }
        for (SewingMaterial mat : recipe.materials()) {
            amounts.add(mat.count());
        }
        PlacementInfo placementinfo = recipe.placementInfo();
        if (placementinfo.isImpossibleToPlace()) {
            return true;
        }
        List ingredients = placementinfo.ingredients();
        CustomRecipePicker picker = new CustomRecipePicker(stackedItemContents.raw, ingredients, (IntList)amounts);
        return !picker.tryPick(amountToCraft, list::add);
    }

    private boolean canFitInGrid(NonNullList<SewingMaterial> materials, int quantity) {
        block0: for (SewingMaterial mat : materials) {
            Ingredient ingredient = mat.ingredient();
            for (int i = 2; i < 6; ++i) {
                ItemStack inSlot = this.getSlot(i).getItem();
                if (!ingredient.test(inSlot)) continue;
                if (mat.count() * quantity <= inSlot.getMaxStackSize()) continue block0;
                return false;
            }
        }
        return true;
    }

    private static int getMaxCraft(@Nullable Ingredient tool, @Nullable Ingredient pattern, NonNullList<SewingMaterial> materials, StackedItemContents stackedItemContents, Int2IntArrayMap slotToAmount) {
        Reference2IntOpenHashMap am = stackedItemContents.raw.amounts;
        int size = Integer.MAX_VALUE;
        slotToAmount.clear();
        if (tool != null) {
            slotToAmount.put(0, 1);
            if (am.reference2IntEntrySet().stream().noneMatch(kv -> tool.acceptsItem((Holder)kv.getKey()) && kv.getIntValue() > 0)) {
                size = 0;
            }
        }
        if (size > 0 && pattern != null) {
            slotToAmount.put(1, 1);
            if (am.reference2IntEntrySet().stream().noneMatch(kv -> pattern.acceptsItem((Holder)kv.getKey()) && kv.getIntValue() > 0)) {
                size = 0;
            }
        }
        for (int i = 0; size > 0 && i < materials.size(); ++i) {
            SewingMaterial mat = (SewingMaterial)materials.get(i);
            slotToAmount.put(i + 2, mat.count());
            int count = am.reference2IntEntrySet().stream().mapToInt(kv -> mat.ingredient().acceptsItem((Holder)kv.getKey()) ? kv.getIntValue() : 0).sum();
            size = Math.min(size, count /= mat.count());
        }
        return size;
    }

    private static class CustomRecipePicker<T> {
        private final StackedContents<T> raw;
        private final List<? extends StackedContents.IngredientInfo<T>> ingredients;
        private final int ingredientCount;
        private final List<T> items;
        private final IntList amountsList;
        private final int itemCount;
        private final BitSet data;
        private final IntList path = new IntArrayList();

        public CustomRecipePicker(StackedContents<T> raw, List<? extends StackedContents.IngredientInfo<T>> ingredients, IntList amountsList) {
            this.raw = raw;
            this.ingredients = ingredients;
            this.ingredientCount = ingredients.size();
            this.items = this.getUniqueAvailableIngredientItems(ingredients);
            this.amountsList = amountsList;
            this.itemCount = this.items.size();
            this.data = new BitSet(this.visitedIngredientCount() + this.visitedItemCount() + this.satisfiedCount() + this.connectionCount() + this.residualCount());
            this.setInitialConnections();
        }

        List<T> getUniqueAvailableIngredientItems(Iterable<? extends StackedContents.IngredientInfo<T>> ingredients) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Reference2IntMap.Entry entry : Reference2IntMaps.fastIterable((Reference2IntMap)this.raw.amounts)) {
                if (entry.getIntValue() <= 0 || !CustomRecipePicker.anyIngredientMatches(ingredients, entry.getKey())) continue;
                list.add(entry.getKey());
            }
            return list;
        }

        private static <T> boolean anyIngredientMatches(Iterable<? extends StackedContents.IngredientInfo<T>> ingredients, T item) {
            for (StackedContents.IngredientInfo<T> ingredientinfo : ingredients) {
                if (!ingredientinfo.acceptsItem(item)) continue;
                return true;
            }
            return false;
        }

        private void setInitialConnections() {
            for (int i = 0; i < this.ingredientCount; ++i) {
                StackedContents.IngredientInfo<T> ingredientinfo = this.ingredients.get(i);
                for (int j = 0; j < this.itemCount; ++j) {
                    if (!ingredientinfo.acceptsItem(this.items.get(j))) continue;
                    this.setConnection(j, i);
                }
            }
        }

        public boolean tryPick(int amount, @javax.annotation.Nullable StackedContents.Output<T> output) {
            if (amount <= 0) {
                return true;
            }
            int i = 0;
            block0: while (true) {
                int ingredientAmount = i < this.ingredientCount ? (this.amountsList.getInt(i) < 0 ? -this.amountsList.getInt(i) : amount * this.amountsList.getInt(i)) : amount;
                IntList intlist = this.tryAssigningNewItem(ingredientAmount);
                if (intlist == null) {
                    boolean flag = i == this.ingredientCount;
                    boolean flag1 = flag && output != null;
                    this.clearAllVisited();
                    this.clearSatisfied();
                    block1: for (int k1 = 0; k1 < this.ingredientCount; ++k1) {
                        int ingredientAmount1 = this.amountsList.getInt(k1) < 0 ? -this.amountsList.getInt(k1) : amount * this.amountsList.getInt(k1);
                        for (int l1 = 0; l1 < this.itemCount; ++l1) {
                            if (!this.isAssigned(l1, k1)) continue;
                            this.unassign(l1, k1);
                            this.raw.put(this.items.get(l1), ingredientAmount1);
                            if (!flag1) continue block1;
                            output.accept(this.items.get(l1));
                            continue block1;
                        }
                    }
                    assert (this.data.get(this.residualOffset(), this.residualOffset() + this.residualCount()).isEmpty());
                    return flag;
                }
                int j = intlist.getInt(0);
                this.raw.take(this.items.get(j), ingredientAmount);
                int k = intlist.size() - 1;
                this.setSatisfied(intlist.getInt(k));
                ++i;
                int l = 0;
                while (true) {
                    if (l >= intlist.size() - 1) continue block0;
                    if (CustomRecipePicker.isPathIndexItem(l)) {
                        int i1 = intlist.getInt(l);
                        int j1 = intlist.getInt(l + 1);
                        this.assign(i1, j1);
                    } else {
                        int i2 = intlist.getInt(l + 1);
                        int j2 = intlist.getInt(l);
                        this.unassign(i2, j2);
                    }
                    ++l;
                }
                break;
            }
        }

        private static boolean isPathIndexItem(int index) {
            return (index & 1) == 0;
        }

        @javax.annotation.Nullable
        private IntList tryAssigningNewItem(int amount) {
            this.clearAllVisited();
            for (int i = 0; i < this.itemCount; ++i) {
                IntList intlist;
                if (!this.raw.hasAtLeast(this.items.get(i), amount) || (intlist = this.findNewItemAssignmentPath(i)) == null) continue;
                return intlist;
            }
            return null;
        }

        @javax.annotation.Nullable
        private IntList findNewItemAssignmentPath(int amount) {
            this.path.clear();
            this.visitItem(amount);
            this.path.add(amount);
            while (!this.path.isEmpty()) {
                int i1;
                int i = this.path.size();
                if (CustomRecipePicker.isPathIndexItem(i - 1)) {
                    int l = this.path.getInt(i - 1);
                    for (int j1 = 0; j1 < this.ingredientCount; ++j1) {
                        if (this.hasVisitedIngredient(j1) || !this.hasConnection(l, j1) || this.isAssigned(l, j1)) continue;
                        this.visitIngredient(j1);
                        this.path.add(j1);
                        break;
                    }
                } else {
                    int j = this.path.getInt(i - 1);
                    if (!this.isSatisfied(j)) {
                        return this.path;
                    }
                    for (int k = 0; k < this.itemCount; ++k) {
                        if (this.hasVisitedItem(k) || !this.isAssigned(k, j)) continue;
                        assert (this.hasConnection(k, j));
                        this.visitItem(k);
                        this.path.add(k);
                        break;
                    }
                }
                if ((i1 = this.path.size()) != i) continue;
                this.path.removeInt(i1 - 1);
            }
            return null;
        }

        private int visitedIngredientOffset() {
            return 0;
        }

        private int visitedIngredientCount() {
            return this.ingredientCount;
        }

        private int visitedItemOffset() {
            return this.visitedIngredientOffset() + this.visitedIngredientCount();
        }

        private int visitedItemCount() {
            return this.itemCount;
        }

        private int satisfiedOffset() {
            return this.visitedItemOffset() + this.visitedItemCount();
        }

        private int satisfiedCount() {
            return this.ingredientCount;
        }

        private int connectionOffset() {
            return this.satisfiedOffset() + this.satisfiedCount();
        }

        private int connectionCount() {
            return this.ingredientCount * this.itemCount;
        }

        private int residualOffset() {
            return this.connectionOffset() + this.connectionCount();
        }

        private int residualCount() {
            return this.ingredientCount * this.itemCount;
        }

        private boolean isSatisfied(int stackingIndex) {
            return this.data.get(this.getSatisfiedIndex(stackingIndex));
        }

        private void setSatisfied(int stackingIndex) {
            this.data.set(this.getSatisfiedIndex(stackingIndex));
        }

        private int getSatisfiedIndex(int stackingIndex) {
            assert (stackingIndex >= 0 && stackingIndex < this.ingredientCount);
            return this.satisfiedOffset() + stackingIndex;
        }

        private void clearSatisfied() {
            this.clearRange(this.satisfiedOffset(), this.satisfiedCount());
        }

        private void setConnection(int itemIndex, int ingredientIndex) {
            this.data.set(this.getConnectionIndex(itemIndex, ingredientIndex));
        }

        private boolean hasConnection(int itemIndex, int ingredientIndex) {
            return this.data.get(this.getConnectionIndex(itemIndex, ingredientIndex));
        }

        private int getConnectionIndex(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.itemCount);
            assert (ingredientIndex >= 0 && ingredientIndex < this.ingredientCount);
            return this.connectionOffset() + itemIndex * this.ingredientCount + ingredientIndex;
        }

        private boolean isAssigned(int itemIndex, int ingredientIndex) {
            return this.data.get(this.getResidualIndex(itemIndex, ingredientIndex));
        }

        private void assign(int itemIndex, int ingredientIndex) {
            int i = this.getResidualIndex(itemIndex, ingredientIndex);
            assert (!this.data.get(i));
            this.data.set(i);
        }

        private void unassign(int itemIndex, int ingredientIndex) {
            int i = this.getResidualIndex(itemIndex, ingredientIndex);
            assert (this.data.get(i));
            this.data.clear(i);
        }

        private int getResidualIndex(int itemIndex, int ingredientIndex) {
            assert (itemIndex >= 0 && itemIndex < this.itemCount);
            assert (ingredientIndex >= 0 && ingredientIndex < this.ingredientCount);
            return this.residualOffset() + itemIndex * this.ingredientCount + ingredientIndex;
        }

        private void visitIngredient(int ingredientIndex) {
            this.data.set(this.getVisitedIngredientIndex(ingredientIndex));
        }

        private boolean hasVisitedIngredient(int ingredientIndex) {
            return this.data.get(this.getVisitedIngredientIndex(ingredientIndex));
        }

        private int getVisitedIngredientIndex(int ingredientIndex) {
            assert (ingredientIndex >= 0 && ingredientIndex < this.ingredientCount);
            return this.visitedIngredientOffset() + ingredientIndex;
        }

        private void visitItem(int itemIndex) {
            this.data.set(this.getVisitiedItemIndex(itemIndex));
        }

        private boolean hasVisitedItem(int itemIndex) {
            return this.data.get(this.getVisitiedItemIndex(itemIndex));
        }

        private int getVisitiedItemIndex(int itemIndex) {
            assert (itemIndex >= 0 && itemIndex < this.itemCount);
            return this.visitedItemOffset() + itemIndex;
        }

        private void clearAllVisited() {
            this.clearRange(this.visitedIngredientOffset(), this.visitedIngredientCount());
            this.clearRange(this.visitedItemOffset(), this.visitedItemCount());
        }

        private void clearRange(int offset, int count) {
            this.data.clear(offset, offset + count);
        }
    }
}

