/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingMaterial;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.SewingRecipeBookComponent;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;

public class SewingTableScreen
extends AbstractRecipeBookScreen<SewingTableMenu> {
    private static final Identifier BACKGROUND_TEXTURE = SewingKitMod.location("textures/gui/sewing_station.png");
    private static SewingRecipe recipeContext;
    private float sliderProgress;
    private boolean clickedOnScroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public SewingTableScreen(SewingTableMenu menu, Inventory playerInv, Component title) {
        super((RecipeBookMenu)menu, (RecipeBookComponent)new SewingRecipeBookComponent(menu), playerInv, title);
        menu.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.titleLabelY;
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 140, this.topPos + 60);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.drawRecipeCosts(graphics, mouseX, mouseY);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, left, top, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int scrollPosition = (int)(41.0f * this.sliderProgress);
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, left + 119, top + 15 + scrollPosition, (float)(176 + (this.canScroll() ? 0 : 12)), 0.0f, 12, 15, 256, 256);
        int leftRecipes = this.leftPos + 52;
        int topRecipes = this.topPos + 14;
        int selectedRecipe = this.recipeIndexOffset + 12;
        this.renderButtons(graphics, x, y, leftRecipes, topRecipes, selectedRecipe);
        this.drawRecipesItems(graphics, leftRecipes, topRecipes, selectedRecipe);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        super.renderTooltip(graphics, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.recipeIndexOffset + 12;
            List<RecipeHolder<SewingRecipe>> list = ((SewingTableMenu)this.menu).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((SewingTableMenu)this.menu).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                recipeContext = (SewingRecipe)list.get(l).value();
                ItemStack output = recipeContext.output();
                List lines = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)output);
                List clientComponents = ClientHooks.gatherTooltipComponents((ItemStack)output, (List)lines, (Optional)output.getTooltipImage(), (int)x, (int)graphics.guiWidth(), (int)graphics.guiHeight(), (Font)this.font);
                ArrayList<ClientTooltipComponent> mutable = new ArrayList<ClientTooltipComponent>(clientComponents);
                mutable.add(ClientTooltipComponent.create((TooltipComponent)new RecipeTooltipComponent(recipeContext)));
                graphics.renderTooltip(this.font, mutable, x, y, DefaultTooltipPositioner.INSTANCE, (Identifier)output.get(DataComponents.TOOLTIP_STYLE), output);
                recipeContext = null;
            }
        }
    }

    private void drawRecipeCosts(GuiGraphics graphics, int mouseX, int mouseY) {
        int recipeIdx = ((SewingTableMenu)this.menu).getSelectedRecipe();
        if (recipeIdx < 0 || recipeIdx >= ((SewingTableMenu)this.menu).getRecipeListSize()) {
            return;
        }
        SewingRecipe recipe = (SewingRecipe)((SewingTableMenu)this.menu).getRecipeList().get(recipeIdx).value();
        if (recipe == null) {
            return;
        }
        Map<Ingredient, Integer> remaining = recipe.materials().stream().collect(Collectors.toMap(SewingMaterial::ingredient, SewingMaterial::count));
        for (int i = 0; i < 4; ++i) {
            Slot slot = (Slot)((SewingTableMenu)this.menu).slots.get(i + 2);
            int subtract = 0;
            for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack1 = slot.getItem();
                if (!ing.test(stack1)) continue;
                int remaining1 = Math.max(0, value - (stack1.getCount() + subtract));
                subtract += value - remaining1;
                mat.setValue(remaining1);
            }
            if (slot.getItem().isEmpty()) continue;
            int x = slot.x + this.leftPos;
            int y = slot.y + this.topPos;
            String text = String.format("%s", subtract);
            int w = this.font.width(text);
            graphics.drawString(this.font, text, x + 17 - w, y, -171);
        }
    }

    private void renderButtons(GuiGraphics graphics, int x, int y, int buttonsLeft, int buttonsTop, int someOffset) {
        for (int index = this.recipeIndexOffset; index < someOffset && index < ((SewingTableMenu)this.menu).getRecipeListSize(); ++index) {
            int position = index - this.recipeIndexOffset;
            int xpos = buttonsLeft + position % 4 * 16;
            int row = position / 4;
            int ypos = buttonsTop + row * 18 + 2;
            int v0 = this.imageHeight;
            if (index == ((SewingTableMenu)this.menu).getSelectedRecipe()) {
                v0 += 18;
            } else if (x >= xpos && y >= ypos && x < xpos + 16 && y < ypos + 18) {
                v0 += 36;
            }
            graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND_TEXTURE, xpos, ypos - 1, 0.0f, (float)v0, 16, 18, 256, 256);
        }
    }

    private void drawRecipesItems(GuiGraphics graphics, int left, int top, int recipeIndexOffsetMax) {
        PoseStack poseStack = new PoseStack();
        List<RecipeHolder<SewingRecipe>> list = ((SewingTableMenu)this.menu).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((SewingTableMenu)this.menu).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            poseStack.translate(0.0f, 0.0f, 0.0f);
            ItemStack resultItem = ((SewingRecipe)list.get(i).value()).output();
            graphics.renderItem(resultItem, k, i1);
            graphics.renderItemDecorations(this.font, resultItem, k, i1);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean shiftMaybe) {
        double mouseX = event.x();
        double mouseY = event.y();
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((SewingTableMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((SewingTableMenu)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnScroll = true;
            }
        }
        return super.mouseClicked(event, shiftMaybe);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (this.clickedOnScroll && this.canScroll()) {
            double mouseX = event.x();
            double mouseY = event.y();
            int i = this.topPos + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = Mth.clamp((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - deltaY / (double)i);
            this.sliderProgress = Mth.clamp((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((SewingTableMenu)this.menu).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((SewingTableMenu)this.menu).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((SewingTableMenu)this.menu).isAbleToCraft();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }

    public record RecipeTooltipComponent(SewingRecipe recipe) implements TooltipComponent
    {
    }

    public static class ClientRecipeTooltipComponent
    implements ClientTooltipComponent {
        private static final Identifier RECIPE_TEXTURE = SewingKitMod.location("textures/gui/recipetooltip.png");
        private final SewingRecipe recipe;
        private final Component label;
        private SewingRecipe cachedIngredientRecipe = null;
        private Map<SewingMaterial, List<ItemStack>> cachedIngredientLists = null;

        public ClientRecipeTooltipComponent(RecipeTooltipComponent component) {
            this.recipe = component.recipe();
            this.label = Component.translatable((String)"text.sewingkit.recipe");
        }

        public int getHeight(Font font) {
            return 38;
        }

        public int getWidth(Font font) {
            return Math.max(76, font.width((FormattedText)this.label));
        }

        public void renderImage(Font font, int x, int y, int p_368529_, int p_368584_, GuiGraphics graphics) {
            int i;
            NonNullList<SewingMaterial> materials;
            Objects.requireNonNull(font);
            graphics.drawString(font, this.label, x, y += 9, -1);
            Objects.requireNonNull(font);
            y += 9;
            if (this.cachedIngredientRecipe != this.recipe) {
                this.cachedIngredientRecipe = this.recipe;
                this.cachedIngredientLists = new Reference2ObjectOpenHashMap();
                materials = this.recipe.materials();
                for (i = 0; i < materials.size(); ++i) {
                    SewingMaterial material = (SewingMaterial)materials.get(i);
                    List<ItemStack> stacks = material.ingredient().items().map(ItemStack::new).toList();
                    this.cachedIngredientLists.put(material, stacks);
                }
            }
            materials = this.recipe.materials();
            for (i = 0; i < materials.size(); ++i) {
                int xx = x + i * 17 + 4;
                SewingMaterial material = (SewingMaterial)materials.get(i);
                List<ItemStack> stacks = this.cachedIngredientLists.get(material);
                if (stacks.size() > 0) {
                    long ticks = Minecraft.getInstance().level != null ? Minecraft.getInstance().level.getGameTime() : 0L;
                    ItemStack stack = stacks.get((int)(ticks / 32L % (long)stacks.size()));
                    graphics.renderItem(stack, xx, y);
                    graphics.renderItemDecorations(font, stack, xx, y);
                } else {
                    graphics.blit(RenderPipelines.GUI_TEXTURED, RECIPE_TEXTURE, xx, y, 36.0f, 0.0f, 16, 16, 64, 64);
                }
                if (material.count() == 1) continue;
                String text = String.format("%d", material.count());
                int w = font.width(text);
                graphics.drawString(font, text, xx + 17 - w, y + 9, -1);
            }
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="sewingkit")
    public static class ClientEvents {
        @SubscribeEvent
        public static void register(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(RecipeTooltipComponent.class, ClientRecipeTooltipComponent::new);
        }
    }
}

