/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import dev.gigaherz.sewingkit.table.SewingTableMenu;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlockEntity;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StoringSewingTableBlock
extends Block
implements EntityBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final EnumMap<Direction, VoxelShape> cache = new EnumMap(Direction.class);

    public StoringSewingTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape cuboidWithRotation(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return StoringSewingTableBlock.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return StoringSewingTableBlock.box((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return StoringSewingTableBlock.box((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return StoringSewingTableBlock.box((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        LOGGER.warn("Sewing Table voxel shape requested for an invalid rotation " + String.valueOf(facing) + ". This can't happen. The selection/collision shape will be wrong.");
        return StoringSewingTableBlock.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Nonnull
    private VoxelShape makeTableShape(Direction facing) {
        return Shapes.or((VoxelShape)this.cuboidWithRotation(facing, 0.0, 14.0, 0.0, 16.0, 16.0, 16.0), (VoxelShape[])new VoxelShape[]{this.cuboidWithRotation(facing, 11.0, 6.0, 1.0, 15.0, 14.0, 15.0), this.cuboidWithRotation(facing, 12.0, 0.0, 2.0, 14.0, 6.0, 14.0), this.cuboidWithRotation(facing, 1.0, 6.0, 1.0, 5.0, 14.0, 15.0), this.cuboidWithRotation(facing, 2.0, 0.0, 2.0, 4.0, 6.0, 14.0)});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(FACING);
        return this.cache.computeIfAbsent(facing, this::makeTableShape);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult p_60508_) {
        return this.use(level, pos, player);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.use(level, pos, player);
    }

    public InteractionResult use(Level level, BlockPos pos, Player player) {
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof StoringSewingTableBlockEntity)) {
            return InteractionResult.FAIL;
        }
        StoringSewingTableBlockEntity table = (StoringSewingTableBlockEntity)te;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInv, p) -> new SewingTableMenu(id, playerInv, ContainerLevelAccess.create((Level)level, (BlockPos)pos), table), (Component)Component.translatable((String)"container.sewingkit.storing_sewing_station")));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StoringSewingTableBlockEntity(pos, state);
    }
}

