/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.mojang.logging.LogUtils;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.table.InventoryProvider;
import dev.gigaherz.sewingkit.table.ListenableHolder;
import dev.gigaherz.sewingkit.table.SewingTableMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.slf4j.Logger;

public class StoringSewingTableBlockEntity
extends BlockEntity
implements InventoryProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final SewingTableContainer inventory = new SewingTableContainer();
    private final ListenableHolder listenable = new ListenableHolder();

    protected StoringSewingTableBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public StoringSewingTableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SewingKitMod.STORING_SEWING_STATION_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public Container getInventory() {
        return this.inventory;
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.inventory.serialize(output.child("Items"));
    }

    public void loadAdditional(ValueInput nbt) {
        super.loadAdditional(nbt);
        this.inventory.deserialize(nbt.childOrEmpty("Items"));
    }

    @Override
    public void addWeakListener(SewingTableMenu e) {
        this.listenable.addWeakListener(e);
    }

    public void preRemoveSideEffects(BlockPos p_394577_, BlockState p_394161_) {
        this.dropContents();
    }

    public void dropContents() {
        Containers.dropContents((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (Container)this.inventory);
    }

    private class SewingTableContainer
    extends SimpleContainer
    implements ValueIOSerializable {
        public SewingTableContainer() {
            super(6);
            this.addListener(this::onContentsChanged);
        }

        private void onContentsChanged(Container itemStacks) {
            StoringSewingTableBlockEntity.this.setChanged();
            StoringSewingTableBlockEntity.this.listenable.doCallbacks();
        }

        public void serialize(ValueOutput output) {
            ValueOutput.ValueOutputList children = output.childrenList("Items");
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack stack = this.getItem(i);
                if (stack.isEmpty()) continue;
                ValueOutput child = children.addChild();
                child.putInt("Slot", i);
                child.store(ItemStack.MAP_CODEC, (Object)stack);
            }
        }

        public void deserialize(ValueInput input) {
            this.clearContent();
            Optional childrenOpt = input.childrenList("Items");
            if (childrenOpt.isEmpty()) {
                return;
            }
            for (ValueInput child : (ValueInput.ValueInputList)childrenOpt.get()) {
                try {
                    int slot = (Integer)child.getInt("Slot").orElseThrow();
                    ItemStack stack = (ItemStack)child.read(ItemStack.MAP_CODEC).orElseThrow();
                    this.setItem(slot, stack);
                }
                catch (Exception e) {
                    LOGGER.error("Could not deserialize stack", (Throwable)e);
                }
            }
        }
    }
}

