/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.google.common.collect.ImmutableSet;
import dev.gigaherz.sewingkit.SewingKitDataGen;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.ToolIngredient;
import dev.gigaherz.sewingkit.clothing.ClothArmorItem;
import dev.gigaherz.sewingkit.clothing.ClothArmorMaterial;
import dev.gigaherz.sewingkit.file.FileItem;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import dev.gigaherz.sewingkit.patterns.PatternItem;
import dev.gigaherz.sewingkit.table.SewingTableBlock;
import dev.gigaherz.sewingkit.table.SewingTableContainer;
import dev.gigaherz.sewingkit.table.SewingTableScreen;
import dev.gigaherz.sewingkit.table.StoringSewingTableBlock;
import dev.gigaherz.sewingkit.table.StoringSewingTableTileEntity;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sewingkit")
public class SewingKitMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "sewingkit";
    public static final ItemGroup SEWING_KIT = new ItemGroup("sewing_kit"){

        public ItemStack makeIcon() {
            return new ItemStack((IItemProvider)WOOD_SEWING_NEEDLE.get());
        }
    };
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"sewingkit");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"sewingkit");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"sewingkit");
    private static final DeferredRegister<PointOfInterestType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"sewingkit");
    private static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"sewingkit");
    public static final RegistryObject<Item> LEATHER_STRIP = ITEMS.register("leather_strip", () -> new Item(new Item.Properties().stacksTo(64).tab(SEWING_KIT)));
    public static final RegistryObject<Item> LEATHER_SHEET = ITEMS.register("leather_sheet", () -> new Item(new Item.Properties().stacksTo(64).tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOL_ROLL = ITEMS.register("wool_roll", () -> new Item(new Item.Properties().stacksTo(64).tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOL_TRIM = ITEMS.register("wool_trim", () -> new Item(new Item.Properties().stacksTo(64).tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOD_SEWING_NEEDLE = ITEMS.register("wood_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.WOOD, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> STONE_SEWING_NEEDLE = ITEMS.register("stone_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.STONE, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> BONE_SEWING_NEEDLE = ITEMS.register("bone_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.BONE, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> GOLD_SEWING_NEEDLE = ITEMS.register("gold_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.GOLD, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> IRON_SEWING_NEEDLE = ITEMS.register("iron_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.IRON, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> DIAMOND_SEWING_NEEDLE = ITEMS.register("diamond_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.DIAMOND, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> NETHERITE_SEWING_NEEDLE = ITEMS.register("netherite_sewing_needle", () -> new NeedleItem(0.0f, 1.0f, Needles.NETHERITE, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Block> SEWING_STATION_BLOCK = BLOCKS.register("sewing_station", () -> new SewingTableBlock(AbstractBlock.Properties.of((Material)Material.WOOD).strength(2.5f)));
    public static final RegistryObject<Item> SEWING_STATION_ITEM = ITEMS.register("sewing_station", () -> new BlockItem((Block)SEWING_STATION_BLOCK.get(), new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Block> STORING_SEWING_STATION_BLOCK = BLOCKS.register("storing_sewing_station", () -> new StoringSewingTableBlock(AbstractBlock.Properties.of((Material)Material.WOOD).strength(2.5f)));
    public static final RegistryObject<Item> STORING_SEWING_STATION_ITEM = ITEMS.register("storing_sewing_station", () -> new BlockItem((Block)STORING_SEWING_STATION_BLOCK.get(), new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<TileEntityType<?>> STORING_SEWING_STATION_TILE_ENTITY = TILE_ENTITIES.register("storing_sewing_station", () -> TileEntityType.Builder.of(StoringSewingTableTileEntity::new, (Block[])new Block[]{(Block)STORING_SEWING_STATION_BLOCK.get()}).build(null));
    public static final RegistryObject<Item> WOOL_HAT = ITEMS.register("wool_hat", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, EquipmentSlotType.HEAD, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOL_SHIRT = ITEMS.register("wool_shirt", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, EquipmentSlotType.CHEST, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOL_PANTS = ITEMS.register("wool_pants", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, EquipmentSlotType.LEGS, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> WOOL_SHOES = ITEMS.register("wool_shoes", () -> new ClothArmorItem(ClothArmorMaterial.WOOL, EquipmentSlotType.FEET, new Item.Properties().tab(SEWING_KIT)));
    public static final RegistryObject<Item> COMMON_PATTERN = ITEMS.register("common_pattern", () -> new PatternItem(new Item.Properties().tab(SEWING_KIT).rarity(Rarity.COMMON)));
    public static final RegistryObject<Item> UNCOMMON_PATTERN = ITEMS.register("uncommon_pattern", () -> new PatternItem(new Item.Properties().tab(SEWING_KIT).rarity(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> RARE_PATTERN = ITEMS.register("rare_pattern", () -> new PatternItem(new Item.Properties().tab(SEWING_KIT).rarity(Rarity.RARE)));
    public static final RegistryObject<Item> LEGENDARY_PATTERN = ITEMS.register("legendary_pattern", () -> new PatternItem(new Item.Properties().tab(SEWING_KIT).rarity(Rarity.EPIC)));
    public static final RegistryObject<Item> FILE = ITEMS.register("file", () -> new FileItem(new Item.Properties().tab(SEWING_KIT).durability(354)));
    public static final RegistryObject<PointOfInterestType> TABLE_POI = POI_TYPES.register("tailor", () -> new PointOfInterestType("tailor", PointOfInterestType.getBlockStates((Block)((Block)SEWING_STATION_BLOCK.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> TAILOR = PROFESSIONS.register("tailor", () -> new VillagerProfession("tailor", (PointOfInterestType)TABLE_POI.get(), (ImmutableSet)Arrays.stream(Needles.values()).map(Needles::getNeedle).collect(ImmutableSet.toImmutableSet()), ImmutableSet.of(), null));

    public SewingKitMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::processIMC);
        modBus.addListener(this::gatherData);
        modBus.addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        modBus.addGenericListener(ContainerType.class, this::registerContainers);
        ITEMS.register(modBus);
        BLOCKS.register(modBus);
        POI_TYPES.register(modBus);
        PROFESSIONS.register(modBus);
        TILE_ENTITIES.register(modBus);
        MinecraftForge.EVENT_BUS.addListener(this::villagerTrades);
    }

    private void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CraftingHelper.register((ResourceLocation)ToolIngredient.NAME, ToolIngredient.Serializer.INSTANCE);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new SewingRecipe.Serializer().setRegistryName("sewing")});
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)new ContainerType(SewingTableContainer::new).setRegistryName("sewing_station")});
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    private void villagerTrades(VillagerTradesEvent event) {
        if (event.getType() != TAILOR.get()) {
            return;
        }
        Int2ObjectMap trademap = event.getTrades();
        ((List)trademap.get(1)).addAll(Arrays.asList(new VillagerTrades.DyedArmorForEmeraldsTrade((Item)WOOL_PANTS.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeraldsTrade((Item)WOOL_SHOES.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeraldsTrade((Item)WOOL_HAT.get(), 3, 12, 1), new VillagerTrades.DyedArmorForEmeraldsTrade((Item)WOOL_SHIRT.get(), 3, 12, 1), this.buyItem(new ItemStack((IItemProvider)Items.STRING, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(2)).addAll(Arrays.asList(new SellRandomFromTag((ITag)ItemTags.CARPETS, 8, 7, 8, 1, 2.0f), this.sellItem((IItemProvider)COMMON_PATTERN.get(), 15, 1, 10, 4.0f), this.buyItem(new ItemStack((IItemProvider)LEATHER_STRIP.get(), 2), 1, 12, 1, 0.5f), this.buyItem(new ItemStack((IItemProvider)Items.STRING, 16), 1, 12, 1, 2.0f)));
        ((List)trademap.get(3)).addAll(Arrays.asList(this.sellItem((IItemProvider)UNCOMMON_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(4)).addAll(Arrays.asList(this.sellItem((IItemProvider)RARE_PATTERN.get(), 15, 1, 10, 4.0f)));
        ((List)trademap.get(5)).addAll(Arrays.asList(this.sellItem((IItemProvider)LEGENDARY_PATTERN.get(), 15, 1, 10, 4.0f)));
    }

    private VillagerTrades.ITrade sellItem(IItemProvider thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return this.sellItem(new ItemStack(thing), price, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ITrade sellItem(ItemStack thing, int price, int maxTrades, int xp, float priceMultiplier) {
        return new BasicTrade(new ItemStack((IItemProvider)Items.EMERALD, price), thing, maxTrades, xp, priceMultiplier);
    }

    private VillagerTrades.ITrade buyItem(ItemStack thing, int reward, int maxTrades, int xp, float priceMultiplier) {
        return new BasicTrade(thing, new ItemStack((IItemProvider)Items.EMERALD, reward), maxTrades, xp, priceMultiplier);
    }

    private void gatherData(GatherDataEvent event) {
        SewingKitDataGen.gatherData(event);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBus {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ScreenManager.register(SewingTableContainer.TYPE, SewingTableScreen::new);
        }

        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre event) {
            if (event.getMap().location().equals((Object)AtlasTexture.LOCATION_BLOCKS)) {
                event.addSprite(SewingKitMod.location("gui/needle_slot_background"));
                event.addSprite(SewingKitMod.location("gui/pattern_slot_background"));
            }
        }

        @SubscribeEvent
        public static void modelRegistry(ModelRegistryEvent event) {
        }

        @SubscribeEvent
        public static void itemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().register((stack, color) -> color > 0 ? -1 : ((IDyeableArmorItem)stack.getItem()).getColor(stack), new IItemProvider[]{(IItemProvider)WOOL_HAT.get(), (IItemProvider)WOOL_SHIRT.get(), (IItemProvider)WOOL_PANTS.get(), (IItemProvider)WOOL_SHOES.get()});
        }
    }

    private static class SellRandomFromTag
    implements VillagerTrades.ITrade {
        private final ITag<Item> tagSource;
        private final int quantity;
        private final int price;
        private final int maxUses;
        private final int xp;
        private final float priceMultiplier;

        private SellRandomFromTag(ITag<Item> tagSource, int quantity, int price, int maxUses, int xp, float priceMultiplier) {
            this.tagSource = tagSource;
            this.quantity = quantity;
            this.price = price;
            this.maxUses = maxUses;
            this.xp = xp;
            this.priceMultiplier = priceMultiplier;
        }

        @Nullable
        public MerchantOffer getOffer(Entity trader, Random rand) {
            Item random = (Item)this.tagSource.getRandomElement(rand);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.EMERALD, this.price), new ItemStack((IItemProvider)random, this.quantity), this.maxUses, this.xp, this.priceMultiplier);
        }
    }
}

