/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.needle;

import com.mojang.datafixers.util.Either;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.needle.INeedleTier;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.RegistryObject;

public enum Needles implements INeedleTier
{
    WOOD("wood", 1, 10, 2.0f, 0.0f, 15, SewingKitMod.WOOD_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"minecraft:planks")),
    STONE("stone", 2, 15, 4.0f, 1.0f, 5, SewingKitMod.STONE_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"minecraft:stone_crafting_materials")),
    IRON("iron", 3, 150, 6.0f, 2.0f, 4, SewingKitMod.IRON_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"forge:ingots/iron")),
    DIAMOND("diamond", 4, 250, 8.0f, 3.0f, 10, SewingKitMod.DIAMOND_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"forge:gems/diamond")),
    GOLD("gold", 1, 25, 12.0f, 0.0f, 22, SewingKitMod.GOLD_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"forge:ingots/gold")),
    NETHERITE("netherite", 5, 350, 9.0f, 4.0f, 15, SewingKitMod.NETHERITE_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"forge:ingots/netherite")),
    BONE("bone", 2, 50, 4.0f, 1.0f, 12, SewingKitMod.BONE_SEWING_NEEDLE, (ITag<Item>)ItemTags.bind((String)"forge:bones"));

    private final String type;
    private final int toolLevel;
    private final int uses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final RegistryObject<Item> needleSupplier;
    private final Lazy<Ingredient> repairMaterial;
    private final Either<ITag<Item>, Item> material;

    private Needles(String type, int toolLevel, int uses, float efficiency, float attackDamage, int enchantability, RegistryObject<Item> needleSupplier, ITag<Item> materialTag) {
        this(type, toolLevel, uses, efficiency, attackDamage, enchantability, needleSupplier, (Either<ITag<Item>, Item>)Either.left(materialTag));
    }

    private Needles(String type, int toolLevel, int uses, float efficiency, float attackDamage, int enchantability, RegistryObject<Item> needleSupplier, Item materialItem) {
        this(type, toolLevel, uses, efficiency, attackDamage, enchantability, needleSupplier, (Either<ITag<Item>, Item>)Either.right((Object)materialItem));
    }

    private Needles(String type, int toolLevel, int uses, float efficiency, float attackDamage, int enchantability, RegistryObject<Item> needleSupplier, Either<ITag<Item>, Item> material) {
        this.type = type;
        this.toolLevel = toolLevel;
        this.uses = uses;
        this.efficiency = efficiency;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.needleSupplier = needleSupplier;
        this.material = material;
        this.repairMaterial = Lazy.of(() -> (Ingredient)material.map(Ingredient::of, xva$0 -> Ingredient.of((IItemProvider[])new IItemProvider[]{xva$0})));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public ResourceLocation getId() {
        return this.needleSupplier.getId();
    }

    @Override
    public Item getNeedle() {
        return (Item)this.needleSupplier.get();
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.efficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public int getLevel() {
        return this.toolLevel;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return (Ingredient)this.repairMaterial.get();
    }

    public Either<ITag<Item>, Item> getMaterial() {
        return this.material;
    }
}

