/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.SewingTableContainer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="sewingkit", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SewingTableScreen
extends ContainerScreen<SewingTableContainer> {
    private static final ResourceLocation BACKGROUND_TEXTURE = SewingKitMod.location("textures/gui/sewing_station.png");
    private float sliderProgress;
    private boolean clickedOnScroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;
    private static int tooltipX = 0;
    private static int tooltipY = 0;
    private static int tooltipWidth = 0;
    private static int tooltipHeight = 0;
    private int ticks = 0;
    private static final ResourceLocation RECIPE_TEXTURE = SewingKitMod.location("textures/gui/recipetooltip.png");

    public SewingTableScreen(SewingTableContainer containerIn, PlayerInventory playerInv, ITextComponent titleIn) {
        super((Container)containerIn, playerInv, titleIn);
        containerIn.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.titleLabelY;
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.drawRecipeCosts(matrixStack, mouseX, mouseY);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderBg(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.renderBackground(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.getTextureManager().bind(BACKGROUND_TEXTURE);
        int i = this.leftPos;
        int j = this.topPos;
        this.blit(matrixStack, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.sliderProgress);
        this.blit(matrixStack, i + 119, j + 15 + k, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int l = this.leftPos + 52;
        int i1 = this.topPos + 14;
        int j1 = this.recipeIndexOffset + 12;
        this.renderButtons(matrixStack, x, y, l, i1, j1);
        this.drawRecipesItems(l, i1, j1);
    }

    protected void renderLabels(MatrixStack matrixStack, int x, int y) {
        super.renderLabels(matrixStack, x, y);
        SewingTableScreen.drawString((MatrixStack)matrixStack, (FontRenderer)this.font, (String)"This is a string, can also be a text component instead", (int)0, (int)0, (int)-1);
    }

    protected void renderTooltip(MatrixStack matrixStack, int x, int y) {
        super.renderTooltip(matrixStack, x, y);
        if (this.hasItemsInInputSlot) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.recipeIndexOffset + 12;
            List<SewingRecipe> list = ((SewingTableContainer)this.menu).getRecipeList();
            for (int l = this.recipeIndexOffset; l < k && l < ((SewingTableContainer)this.menu).getRecipeListSize(); ++l) {
                int i1 = l - this.recipeIndexOffset;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (x < j1 || x >= j1 + 16 || y < k1 || y >= k1 + 18) continue;
                this.renderTooltip(matrixStack, list.get(l).getResultItem(), x, y);
                this.renderHoveredRecipe(matrixStack, x, y, ((SewingTableContainer)this.menu).getRecipeList().get(l));
            }
        }
    }

    private void drawRecipeCosts(MatrixStack matrixStack, int mouseX, int mouseY) {
        int recipeIdx = ((SewingTableContainer)this.menu).getSelectedRecipe();
        if (recipeIdx < 0 || recipeIdx >= ((SewingTableContainer)this.menu).getRecipeListSize()) {
            return;
        }
        SewingRecipe recipe = ((SewingTableContainer)this.menu).getRecipeList().get(recipeIdx);
        if (recipe == null) {
            return;
        }
        Map<Ingredient, Integer> remaining = recipe.getMaterials().stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 300.0);
        for (int i2 = 0; i2 < 4; ++i2) {
            Slot slot = (Slot)((SewingTableContainer)this.menu).slots.get(i2 + 2);
            int subtract = 0;
            for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack1 = slot.getItem();
                if (!ing.test(stack1)) continue;
                int remaining1 = Math.max(0, value - (stack1.getCount() + subtract));
                subtract += value - remaining1;
                mat.setValue(remaining1);
            }
            if (subtract == true || slot.getItem().getCount() <= 0) continue;
            int x = slot.x + this.leftPos;
            int y = slot.y + this.topPos;
            String text = String.format("%s", subtract);
            int w = this.font.width(text);
            SewingTableScreen.drawString((MatrixStack)matrixStack, (FontRenderer)this.font, (String)text, (int)(x + 17 - w), (int)y, (int)TextFormatting.YELLOW.getColor());
        }
        matrixStack.popPose();
    }

    protected void renderHoveredRecipe(MatrixStack matrixStack, int mouseX, int mouseY, SewingRecipe sewingRecipe) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 300.0);
        int x = tooltipX;
        int y = tooltipY - 35 - 8;
        Objects.requireNonNull(this.minecraft).getTextureManager().bind(RECIPE_TEXTURE);
        SewingTableScreen.blit((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)35, (int)35, (int)64, (int)64);
        NonNullList<SewingRecipe.Material> materials = sewingRecipe.getMaterials();
        for (int i = 0; i < materials.size(); ++i) {
            int xx = x + i % 2 * 17 + 1;
            int yy = y + i / 2 * 17 + 1;
            SewingRecipe.Material material = (SewingRecipe.Material)materials.get(i);
            ItemStack[] stacks = material.ingredient.getItems();
            if (stacks.length > 0) {
                float zz = this.itemRenderer.blitOffset;
                this.itemRenderer.blitOffset = 0.0f;
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((Matrix4f)matrixStack.last().pose());
                ItemStack stack = stacks[this.ticks / 32 % stacks.length].copy();
                stack.setCount(material.count);
                this.itemRenderer.renderAndDecorateItem(stack, xx, yy);
                RenderSystem.popMatrix();
                this.itemRenderer.blitOffset = zz;
            } else {
                Objects.requireNonNull(this.minecraft).getTextureManager().bind(RECIPE_TEXTURE);
                SewingTableScreen.blit((MatrixStack)matrixStack, (int)xx, (int)yy, (float)36.0f, (float)0.0f, (int)16, (int)16, (int)64, (int)64);
            }
            if (material.count == 1) continue;
            matrixStack.pushPose();
            matrixStack.translate(0.0, 0.0, 300.0);
            String text = String.format("%d", material.count);
            int w = this.font.width(text);
            this.font.drawShadow(matrixStack, text, (float)(xx + 17 - w), (float)(yy + 9), 0xFFFFFF);
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public void tick() {
        super.tick();
        ++this.ticks;
    }

    @SubscribeEvent
    public static void tooltipEvent(RenderTooltipEvent.PostText event) {
        tooltipX = event.getX();
        tooltipY = event.getY();
        tooltipWidth = event.getWidth();
        tooltipHeight = event.getHeight();
    }

    private void renderButtons(MatrixStack matrixStack, int x, int y, int pX, int pY, int pLastVisibleElementIndex) {
        for (int i = this.recipeIndexOffset; i < pLastVisibleElementIndex && i < ((SewingTableContainer)this.menu).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = pX + j % 4 * 16;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            int j1 = this.imageHeight;
            if (i == ((SewingTableContainer)this.menu).getSelectedRecipe()) {
                j1 += 18;
            } else if (x >= k && y >= i1 && x < k + 16 && y < i1 + 18) {
                j1 += 36;
            }
            this.blit(matrixStack, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<SewingRecipe> list = ((SewingTableContainer)this.menu).getRecipeList();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((SewingTableContainer)this.menu).getRecipeListSize(); ++i) {
            int j = i - this.recipeIndexOffset;
            int k = left + j % 4 * 16;
            int l = j / 4;
            int i1 = top + l * 18 + 2;
            this.minecraft.getItemRenderer().renderAndDecorateItem(list.get(i).getResultItem(), k, i1);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.clickedOnScroll = false;
        if (this.hasItemsInInputSlot) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < k; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double d0 = mouseX - (double)(i + i1 % 4 * 16);
                double d1 = mouseY - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((SewingTableContainer)this.menu).clickMenuButton((PlayerEntity)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((ISound)SimpleSound.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((SewingTableContainer)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (mouseX >= (double)i && mouseX < (double)(i + 12) && mouseY >= (double)j && mouseY < (double)(j + 54)) {
                this.clickedOnScroll = true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnScroll && this.canScroll()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.clamp((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int i = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)i);
            this.sliderProgress = MathHelper.clamp((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((SewingTableContainer)this.menu).getRecipeListSize() > 12;
    }

    protected int getHiddenRows() {
        return (((SewingTableContainer)this.menu).getRecipeListSize() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((SewingTableContainer)this.menu).isAbleToCraft();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

