/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.ModelsResourceUtil;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingKitDataGen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.addProvider((IDataProvider)new Lang(gen));
            ItemModels itemModels = new ItemModels(gen, event.getExistingFileHelper());
            gen.addProvider((IDataProvider)itemModels);
            gen.addProvider((IDataProvider)new BlockStates(gen, itemModels.existingFileHelper));
        }
        if (event.includeServer()) {
            gen.addProvider((IDataProvider)new Recipes(gen));
            gen.addProvider((IDataProvider)new LootTables(gen));
        }
    }

    private static class LootTables
    extends LootTableProvider
    implements IDataProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.BLOCK));

        public LootTables(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.tables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
            map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.validate((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
        }

        public static class BlockTables
        extends BlockLootTables {
            protected void addTables() {
                this.dropSelf((Block)SewingKitMod.SEWING_STATION_BLOCK.get());
                this.dropSelf((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().getNamespace().equals("sewingkit")).collect(Collectors.toList());
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void buildShapelessRecipes(Consumer<IFinishedRecipe> consumer) {
            Arrays.stream(Needles.values()).forEach(needle -> ShapelessRecipeBuilder.shapeless((IItemProvider)needle.getNeedle()).requires((IItemProvider)SewingKitMod.FILE.get()).requires(needle.getRepairIngredient()).unlockedBy("has_material", (ICriterionInstance)needle.getMaterial().map(RecipeProvider::has, RecipeProvider::has)).save(consumer));
            ShapedRecipeBuilder.shaped((IItemProvider)((IItemProvider)SewingKitMod.SEWING_STATION_ITEM.get())).pattern("xxx").pattern("P P").pattern("S S").define(Character.valueOf('x'), (ITag)ItemTags.WOODEN_SLABS).define(Character.valueOf('P'), (ITag)ItemTags.PLANKS).define(Character.valueOf('S'), (IItemProvider)Items.STICK).unlockedBy("has_wood", (ICriterionInstance)Recipes.has((ITag)ItemTags.PLANKS)).save(consumer);
            ShapelessRecipeBuilder.shapeless((IItemProvider)((IItemProvider)SewingKitMod.STORING_SEWING_STATION_ITEM.get())).requires((IItemProvider)SewingKitMod.SEWING_STATION_ITEM.get()).requires((ITag)Tags.Items.CHESTS_WOODEN).unlockedBy("has_station", (ICriterionInstance)Recipes.has((IItemProvider)((IItemProvider)SewingKitMod.SEWING_STATION_ITEM.get()))).save(consumer);
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_SHEET.get(), 4).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_sheet_from_leather"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_SHEET.get(), 1).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial(new IItemProvider[]{Items.RABBIT_HIDE}).addCriterion("has_leather", (ICriterionInstance)Recipes.has((IItemProvider)Items.RABBIT_HIDE)).build(consumer, SewingKitMod.location("leather_sheet_from_rabbit_hide"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_STRIP.get(), 3).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_strip_from_leather"));
            SewingRecipeBuilder.begin(Items.LEATHER_BOOTS).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((IItemProvider)SewingKitMod.LEATHER_STRIP.get()).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_boots_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_LEGGINGS).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.LEATHER_SHEET.get(), 4).addMaterial((IItemProvider)SewingKitMod.LEATHER_STRIP.get(), 3).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_leggings_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_CHESTPLATE).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.LEATHER_SHEET.get(), 8).addMaterial((IItemProvider)SewingKitMod.LEATHER_STRIP.get(), 2).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_chestplate_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_HELMET).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((IItemProvider)SewingKitMod.LEATHER_STRIP.get()).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_helmet_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_HORSE_ARMOR).withTool(NeedleItem.SEWING_NEEDLE, Needles.NETHERITE.getLevel()).addMaterial((IItemProvider)SewingKitMod.LEATHER_SHEET.get(), 12).addMaterial((IItemProvider)SewingKitMod.LEATHER_STRIP.get(), 6).addMaterial((ITag<Item>)Tags.Items.STRING, 8).addCriterion("has_leather", (ICriterionInstance)Recipes.has((ITag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_horse_armor_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_ROLL.get(), 4).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)ItemTags.WOOL).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_roll_from_wool"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_ROLL.get(), 1).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)ItemTags.CARPETS).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.CARPETS)).build(consumer, SewingKitMod.location("wool_roll_from_carpet"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_TRIM.get(), 8).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)ItemTags.WOOL).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_trim_from_wool"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_TRIM.get(), 3).withTool((ITag<Item>)Tags.Items.SHEARS).addMaterial((ITag<Item>)ItemTags.CARPETS).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.CARPETS)).build(consumer, SewingKitMod.location("wool_trim_from_carpet"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_SHOES.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((IItemProvider)SewingKitMod.WOOL_TRIM.get(), 2).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_shoes_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_PANTS.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.WOOL_ROLL.get(), 2).addMaterial((IItemProvider)SewingKitMod.WOOL_TRIM.get(), 4).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_pants_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_SHIRT.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.WOOL_ROLL.get(), 3).addMaterial((IItemProvider)SewingKitMod.WOOL_TRIM.get(), 3).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_shirt_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_HAT.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((IItemProvider)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((IItemProvider)SewingKitMod.WOOL_TRIM.get(), 1).addMaterial((ITag<Item>)Tags.Items.STRING).addCriterion("has_wool", (ICriterionInstance)Recipes.has((ITag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_hat_via_sewing"));
            ShapedRecipeBuilder.shaped((IItemProvider)((IItemProvider)SewingKitMod.FILE.get())).pattern("  I").pattern(" I ").pattern("P  ").define(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ITag)ItemTags.PLANKS).unlockedBy("has_iron", (ICriterionInstance)Recipes.has((ITag)Tags.Items.INGOTS_IRON)).save(consumer);
        }
    }

    public static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "sewingkit", existingFileHelper);
        }

        protected void registerModels() {
            this.basicIcon(SewingKitMod.LEATHER_STRIP.getId());
            this.basicIcon(SewingKitMod.LEATHER_SHEET.getId());
            Arrays.stream(Needles.values()).forEach(needle -> this.basicIcon(needle.getId()));
            this.basicIcon(SewingKitMod.WOOL_HAT.getId());
            this.basicIcon(SewingKitMod.WOOL_SHIRT.getId());
            this.basicIcon(SewingKitMod.WOOL_PANTS.getId());
            this.basicIcon(SewingKitMod.WOOL_SHOES.getId());
            this.basicIcon(SewingKitMod.WOOL_ROLL.getId());
            this.basicIcon(SewingKitMod.WOOL_TRIM.getId());
            this.basicIcon(SewingKitMod.COMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.UNCOMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.RARE_PATTERN.getId());
            this.basicIcon(SewingKitMod.LEGENDARY_PATTERN.getId());
            this.basicIcon(SewingKitMod.FILE.getId()).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(62.0f, 147.0f, 40.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(45.0f, -33.0f, -55.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-54.0f, 99.0f, 136.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(136.0f, -99.0f, 54.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 2.0f, 0.0f).scale(0.5f).end().transform(ModelBuilder.Perspective.HEAD).rotation(-4.0f, 44.0f, 4.0f).translation(-7.25f, 6.75f, 0.75f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).end().end();
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.SEWING_STATION_ITEM.getId().getPath())).parent((ModelFile)this.getExistingFile(ModelsResourceUtil.getModelLocation((Block)((Block)SewingKitMod.SEWING_STATION_BLOCK.get()))));
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.STORING_SEWING_STATION_ITEM.getId().getPath())).parent((ModelFile)this.getExistingFile(ModelsResourceUtil.getModelLocation((Block)((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get()))));
        }

        private ItemModelBuilder basicIcon(ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SewingKitMod.location("item/" + item.getPath()));
        }
    }

    public static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "sewingkit", exFileHelper);
        }

        protected void registerStatesAndModels() {
            Block block = (Block)SewingKitMod.SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelsResourceUtil.getModelLocation((Block)block)));
            block = (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelsResourceUtil.getModelLocation((Block)block)));
        }
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(DataGenerator gen) {
            super(gen, "sewingkit", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.sewing_kit", "Sewing Kit");
            this.add("container.sewingkit.sewing_station", "Sewing Station");
            this.add("jei.category.sewingkit.sewing", "Sewing");
            this.add((Item)SewingKitMod.LEATHER_STRIP.get(), "Leather Strip");
            this.add((Item)SewingKitMod.LEATHER_SHEET.get(), "Leather Sheet");
            this.add((Block)SewingKitMod.SEWING_STATION_BLOCK.get(), "Sewing Table");
            this.add((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get(), "Sewing Table with Drawers");
            Arrays.stream(Needles.values()).forEach(needle -> {
                String type = needle.getType();
                String name = type.substring(0, 1).toUpperCase() + type.substring(1);
                this.add(needle.getNeedle(), name + " Sewing Needle");
            });
            this.add("text.sewingkit.needle.lore_text", "\"Ow! Prickl...zz..z...\"");
            this.add((Item)SewingKitMod.WOOL_HAT.get(), "Wool Hat");
            this.add((Item)SewingKitMod.WOOL_SHIRT.get(), "Wool Shirt");
            this.add((Item)SewingKitMod.WOOL_PANTS.get(), "Wool Pants");
            this.add((Item)SewingKitMod.WOOL_SHOES.get(), "Wool Shoes");
            this.add((Item)SewingKitMod.WOOL_ROLL.get(), "Wool Roll");
            this.add((Item)SewingKitMod.WOOL_TRIM.get(), "Wool Trim");
            this.add((Item)SewingKitMod.COMMON_PATTERN.get(), "Common Pattern");
            this.add((Item)SewingKitMod.UNCOMMON_PATTERN.get(), "Uncommon Pattern");
            this.add((Item)SewingKitMod.RARE_PATTERN.get(), "Rare Pattern");
            this.add((Item)SewingKitMod.LEGENDARY_PATTERN.get(), "Legendary Pattern");
            this.add((Item)SewingKitMod.FILE.get(), "Raspy File");
            this.add("entity.minecraft.villager.sewingkit.tailor", "Tailor");
        }
    }
}

