/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.sewingkit.SewingKitMod;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

public class SewingRecipe
implements IRecipe<IInventory> {
    @ObjectHolder(value="sewingkit:sewing")
    public static IRecipeSerializer<?> SERIALIZER = null;
    public static IRecipeType<SewingRecipe> SEWING = IRecipeType.register((String)SewingKitMod.location("sewing").toString());
    private final String group;
    private final ResourceLocation id;
    private final NonNullList<Material> materials;
    @Nullable
    private final Ingredient pattern;
    @Nullable
    private final Ingredient tool;
    private final ItemStack output;

    public SewingRecipe(ResourceLocation id, String group, NonNullList<Material> materials, @Nullable Ingredient pattern, @Nullable Ingredient tool, ItemStack output) {
        this.group = group;
        this.id = id;
        this.materials = materials;
        this.pattern = pattern;
        this.tool = tool;
        this.output = output;
    }

    public static Collection<SewingRecipe> getAllRecipes(World world) {
        return world.getRecipeManager().getAllRecipesFor(SEWING);
    }

    public String getGroup() {
        return this.group;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 4;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList allIngredients = NonNullList.create();
        allIngredients.add((Object)(this.pattern != null ? this.pattern : Ingredient.EMPTY));
        allIngredients.add((Object)(this.tool != null ? this.tool : Ingredient.EMPTY));
        this.materials.stream().map(m -> m.ingredient).forEach(arg_0 -> allIngredients.add(arg_0));
        return allIngredients;
    }

    public boolean matches(IInventory inv, World worldIn) {
        ItemStack toolStack = inv.getItem(0);
        ItemStack patternStack = inv.getItem(1);
        Map<Ingredient, Integer> missing = this.materials.stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
        for (int i2 = 0; i2 < 4; ++i2) {
            for (Map.Entry<Ingredient, Integer> mat : missing.entrySet()) {
                Ingredient ing = mat.getKey();
                int value = mat.getValue();
                ItemStack stack = inv.getItem(i2 + 2);
                if (!ing.test(stack)) continue;
                int remaining = Math.max(0, value - stack.getCount());
                mat.setValue(remaining);
            }
        }
        return missing.values().stream().noneMatch(v -> v > 0) && (this.pattern != null ? patternStack.getCount() > 0 && this.pattern.test(patternStack) : patternStack.getCount() == 0) && (this.tool != null ? toolStack.getCount() > 0 && this.tool.test(toolStack) : toolStack.getCount() == 0);
    }

    public ItemStack assemble(IInventory inv) {
        return this.getResultItem().copy();
    }

    public ItemStack getResultItem() {
        return this.output;
    }

    public NonNullList<Material> getMaterials() {
        return this.materials;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IRecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public IRecipeType<?> getType() {
        return SEWING;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((IItemProvider)SewingKitMod.WOOD_SEWING_NEEDLE.get());
    }

    public Ingredient getTool() {
        return this.tool != null ? this.tool : Ingredient.EMPTY;
    }

    public Ingredient getPattern() {
        return this.pattern != null ? this.pattern : Ingredient.EMPTY;
    }

    public static class Material
    implements Predicate<ItemStack> {
        public final Ingredient ingredient;
        public final int count;

        private Material(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.count = count;
        }

        public static Material of(Ingredient ingredient, int count) {
            return new Material(ingredient, count);
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.ingredient.test(itemStack) && itemStack.getCount() >= this.count;
        }

        public JsonObject serialize() {
            JsonObject material = new JsonObject();
            material.add("ingredient", this.ingredient.toJson());
            material.addProperty("count", (Number)this.count);
            return material;
        }

        public static Material deserialize(JsonObject object) {
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)object.get("ingredient"));
            int count = JSONUtils.getAsInt((JsonObject)object, (String)"count", (int)1);
            if (count <= 0) {
                throw new IllegalArgumentException("Material count must be a positive integer.");
            }
            return new Material(ingredient, count);
        }

        public void write(PacketBuffer packet) {
            packet.writeVarInt(this.count);
            this.ingredient.toNetwork(packet);
        }

        public static Material read(PacketBuffer packet) {
            int count = packet.readVarInt();
            Ingredient ingredient = Ingredient.fromNetwork((PacketBuffer)packet);
            return new Material(ingredient, count);
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SewingRecipe> {
        protected SewingRecipe createRecipe(ResourceLocation recipeId, String group, NonNullList<Material> materials, Ingredient pattern, Ingredient tool, ItemStack result) {
            return new SewingRecipe(recipeId, group, materials, pattern, tool, result);
        }

        public SewingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.getAsString((JsonObject)json, (String)"group", (String)"");
            JsonArray materialsJson = JSONUtils.getAsJsonArray((JsonObject)json, (String)"materials");
            NonNullList materials = NonNullList.create();
            for (int i = 0; i < materialsJson.size(); ++i) {
                materials.add((Object)Material.deserialize(materialsJson.get(i).getAsJsonObject()));
            }
            Ingredient pattern = json.has("pattern") ? CraftingHelper.getIngredient((JsonElement)json.get("ingredient")) : null;
            Ingredient tool = json.has("tool") ? CraftingHelper.getIngredient((JsonElement)json.get("tool")) : null;
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.getAsJsonObject((JsonObject)json, (String)"result"), (boolean)true);
            return this.createRecipe(recipeId, group, (NonNullList<Material>)materials, pattern, tool, result);
        }

        public SewingRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            int numMaterials = buffer.readVarInt();
            NonNullList materials = NonNullList.create();
            for (int i = 0; i < numMaterials; ++i) {
                materials.add((Object)Material.read(buffer));
            }
            boolean hasPattern = buffer.readBoolean();
            Ingredient pattern = hasPattern ? Ingredient.fromNetwork((PacketBuffer)buffer) : null;
            boolean hasTool = buffer.readBoolean();
            Ingredient tool = hasTool ? Ingredient.fromNetwork((PacketBuffer)buffer) : null;
            ItemStack result = buffer.readItem();
            return this.createRecipe(recipeId, group, (NonNullList<Material>)materials, pattern, tool, result);
        }

        public void toNetwork(PacketBuffer buffer, SewingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeVarInt(recipe.materials.size());
            for (Material input : recipe.materials) {
                input.write(buffer);
            }
            boolean hasPattern = recipe.pattern != null;
            buffer.writeBoolean(hasPattern);
            if (hasPattern) {
                recipe.pattern.toNetwork(buffer);
            }
            boolean hasTool = recipe.tool != null;
            buffer.writeBoolean(hasTool);
            if (hasTool) {
                recipe.tool.toNetwork(buffer);
            }
            buffer.writeItem(recipe.output);
        }
    }
}

