/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.api.ToolIngredient;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.ToolType;

public class SewingRecipeBuilder {
    private String group;
    private Ingredient tool;
    private Ingredient pattern;
    private final List<SewingRecipe.Material> materials = Lists.newArrayList();
    private final Item result;
    private final int count;
    private CompoundNBT tag;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.advancement();

    public static SewingRecipeBuilder begin(Item result) {
        return SewingRecipeBuilder.begin(result, 1, null);
    }

    public static SewingRecipeBuilder begin(Item result, int count) {
        return SewingRecipeBuilder.begin(result, count, null);
    }

    public static SewingRecipeBuilder begin(Item result, CompoundNBT tag) {
        return SewingRecipeBuilder.begin(result, 1, tag);
    }

    public static SewingRecipeBuilder begin(Item result, int count, @Nullable CompoundNBT tag) {
        return new SewingRecipeBuilder(result, count, tag);
    }

    protected SewingRecipeBuilder(Item result, int count, @Nullable CompoundNBT tag) {
        this.result = result;
        this.count = count;
        this.tag = tag;
    }

    public SewingRecipeBuilder withTool(IItemProvider ... tool) {
        return this.withTool(Ingredient.of((IItemProvider[])tool));
    }

    public SewingRecipeBuilder withTool(ITag<Item> tool) {
        return this.withTool(Ingredient.of(tool));
    }

    public SewingRecipeBuilder withTool(ToolType tool, int level) {
        return this.withTool(ToolIngredient.fromTool(tool, level));
    }

    public SewingRecipeBuilder withTool(Ingredient tool) {
        this.tool = tool;
        return this;
    }

    public SewingRecipeBuilder withPattern(Ingredient pattern) {
        this.pattern = pattern;
        return this;
    }

    public SewingRecipeBuilder addMaterial(int count, IItemProvider ... x) {
        return this.addMaterial(Ingredient.of((IItemProvider[])x), count);
    }

    public SewingRecipeBuilder addMaterial(IItemProvider x, int count) {
        return this.addMaterial(Ingredient.of((IItemProvider[])new IItemProvider[]{x}), count);
    }

    public SewingRecipeBuilder addMaterial(ITag<Item> x, int count) {
        return this.addMaterial(Ingredient.of(x), 1);
    }

    public SewingRecipeBuilder addMaterial(IItemProvider ... x) {
        return this.addMaterial(Ingredient.of((IItemProvider[])x), 1);
    }

    public SewingRecipeBuilder addMaterial(ITag<Item> x) {
        return this.addMaterial(Ingredient.of(x), 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x) {
        return this.addMaterial(x, 1);
    }

    public SewingRecipeBuilder addMaterial(Ingredient x, int count) {
        if (this.materials.size() >= 4) {
            throw new IllegalArgumentException("There can only be up to 4 materials!");
        }
        if (count <= 0) {
            throw new IllegalArgumentException("Count must be a positive integer!");
        }
        this.materials.add(SewingRecipe.Material.of(x, count));
        return this;
    }

    public SewingRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        this.advancementBuilder.addCriterion(name, criterionIn);
        return this;
    }

    public SewingRecipeBuilder setGroup(String groupIn) {
        this.group = groupIn;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Registry.ITEM.getKey((Object)this.result));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        this.validate(id);
        this.advancementBuilder.parent(new ResourceLocation("recipes/root")).addCriterion("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(IRequirementsStrategy.OR);
        ResourceLocation advancementId = new ResourceLocation(id.getNamespace(), "recipes/" + this.result.getItemCategory().getRecipeFolderName() + "/" + id.getPath());
        consumerIn.accept(this.createFinishedRecipe(id, this.group == null ? "" : this.group, this.result, this.count, this.tag, this.tool, this.pattern, this.materials, this.advancementBuilder, advancementId));
    }

    protected IFinishedRecipe createFinishedRecipe(ResourceLocation id, String group, Item result, int count, CompoundNBT tag, Ingredient tool, Ingredient pattern, List<SewingRecipe.Material> materials, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
        return new Result(id, group, result, count, tag, tool, pattern, materials, advancementBuilder, advancementId);
    }

    private void validate(ResourceLocation id) {
        if (this.advancementBuilder.getCriteria().isEmpty()) {
            throw new IllegalStateException("No way of obtaining sewing recipe " + id);
        }
        if (this.materials.isEmpty()) {
            throw new IllegalStateException("No ingredients for sewing recipe " + id);
        }
    }

    protected static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Item result;
        private final int count;
        @Nullable
        private final CompoundNBT tag;
        private final String group;
        @Nullable
        private final Ingredient tool;
        @Nullable
        private final Ingredient pattern;
        private final List<SewingRecipe.Material> materials;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Item result, int count, @Nullable CompoundNBT tag, @Nullable Ingredient tool, @Nullable Ingredient pattern, List<SewingRecipe.Material> materials, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.result = result;
            this.count = count;
            this.tag = tag;
            this.group = group;
            this.tool = tool;
            this.pattern = pattern;
            this.materials = materials;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void serializeRecipeData(JsonObject recipeJson) {
            if (!this.group.isEmpty()) {
                recipeJson.addProperty("group", this.group);
            }
            JsonArray jsonarray = new JsonArray();
            for (SewingRecipe.Material material : this.materials) {
                jsonarray.add((JsonElement)material.serialize());
            }
            recipeJson.add("materials", (JsonElement)jsonarray);
            if (this.tool != null) {
                recipeJson.add("tool", this.tool.toJson());
            }
            if (this.pattern != null) {
                recipeJson.add("tool", this.pattern.toJson());
            }
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", Registry.ITEM.getKey((Object)this.result).toString());
            if (this.count > 1) {
                resultJson.addProperty("count", (Number)this.count);
            }
            if (this.tag != null) {
                CompoundNBT.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.tag).result().ifPresent(result -> resultJson.add("nbt", result));
            }
            recipeJson.add("result", (JsonElement)resultJson);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public IRecipeSerializer<?> getType() {
            return SewingRecipe.SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return this.advancementBuilder.serializeToJson();
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return this.advancementId;
        }
    }
}

