/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class SewingCategory
implements IRecipeCategory<SewingRecipe> {
    private static final ResourceLocation GUI_TEXTURE_LOCATION = SewingKitMod.location("textures/gui/sewing_station.png");
    public static final ResourceLocation UID = SewingKitMod.location("drying");
    public static SewingCategory INSTANCE;
    private final IDrawable background;
    private final IDrawable icon;
    private static final int[] slotX;
    private static final int[] slotY;

    public SewingCategory(IGuiHelper guiHelper) {
        INSTANCE = this;
        this.background = guiHelper.createDrawable(GUI_TEXTURE_LOCATION, 6, 12, 159, 61);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)SewingKitMod.SEWING_STATION_BLOCK.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends SewingRecipe> getRecipeClass() {
        return SewingRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.get((String)"jei.category.sewingkit.sewing", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setInputMaterials(IIngredients iIngredients, Ingredient tool, Ingredient pattern, List<SewingRecipe.Material> inputs) {
        ArrayList<List<Object>> inputLists = new ArrayList<List<Object>>();
        inputLists.add(Arrays.asList(tool.getItems()));
        inputLists.add(Arrays.asList(pattern.getItems()));
        for (SewingRecipe.Material material : inputs) {
            ItemStack[] stacks = material.ingredient.getItems();
            List expandedInput = Arrays.stream(stacks).map(stack -> {
                ItemStack copy = stack.copy();
                copy.setCount(material.count);
                return copy;
            }).collect(Collectors.toList());
            inputLists.add(expandedInput);
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, inputLists);
    }

    public void setIngredients(SewingRecipe dryingRecipe, IIngredients iIngredients) {
        this.setInputMaterials(iIngredients, dryingRecipe.getTool(), dryingRecipe.getPattern(), (List<SewingRecipe.Material>)dryingRecipe.getMaterials());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)dryingRecipe.getResultItem());
    }

    public void setRecipe(IRecipeLayout recipeLayout, SewingRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        for (int i = 0; i <= 6; ++i) {
            itemStacks.init(i, i < 6, slotX[i], slotY[i]);
        }
        itemStacks.set(ingredients);
    }

    public void draw(SewingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
    }

    static {
        slotX = new int[]{1, 23, 3, 21, 3, 21, 136};
        slotY = new int[]{2, 2, 22, 22, 40, 40, 20};
    }
}

