/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import dev.gigaherz.sewingkit.table.SewingTableContainer;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SewingTableBlock
extends Block {
    private static final Logger LOGGER = LogManager.getLogger();
    public static DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final EnumMap<Direction, VoxelShape> cache = new EnumMap(Direction.class);

    public SewingTableBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape cuboidWithRotation(Direction facing, double x1, double y1, double z1, double x2, double y2, double z2) {
        switch (facing) {
            case NORTH: {
                return SewingTableBlock.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return SewingTableBlock.box((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return SewingTableBlock.box((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return SewingTableBlock.box((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        LOGGER.warn("Sewing Table voxel shape requested for an invalid rotation " + facing + ". This can't happen. The selection/collision shape will be wrong.");
        return SewingTableBlock.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    @Nonnull
    private VoxelShape makeTableShape(Direction facing) {
        return VoxelShapes.or((VoxelShape)this.cuboidWithRotation(facing, 0.0, 14.0, 0.0, 16.0, 16.0, 16.0), (VoxelShape[])new VoxelShape[]{this.cuboidWithRotation(facing, 11.0, 6.0, 1.0, 15.0, 14.0, 15.0), this.cuboidWithRotation(facing, 12.0, 0.0, 2.0, 14.0, 6.0, 14.0), this.cuboidWithRotation(facing, 1.0, 6.0, 1.0, 5.0, 14.0, 15.0), this.cuboidWithRotation(facing, 2.0, 0.0, 2.0, 4.0, 6.0, 14.0)});
    }

    public VoxelShape getShape(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return this.cache.computeIfAbsent(facing, this::makeTableShape);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockItemUseContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateContainer.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public ActionResultType use(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.isClientSide) {
            return ActionResultType.SUCCESS;
        }
        player.openMenu((INamedContainerProvider)new SimpleNamedContainerProvider((id, playerInv, p) -> new SewingTableContainer(id, playerInv, IWorldPosCallable.create((World)worldIn, (BlockPos)pos)), (ITextComponent)new TranslationTextComponent("container.sewingkit.sewing_station")));
        return ActionResultType.SUCCESS;
    }
}

