/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.InventoryProvider;
import dev.gigaherz.sewingkit.table.SewingTableInventory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ObjectHolder;

public class SewingTableContainer
extends Container {
    @ObjectHolder(value="sewingkit:sewing_station")
    public static ContainerType<SewingTableContainer> TYPE;
    private static final int NUM_INPUTS = 6;
    private static final int NUM_OUTPUTS = 1;
    private static final int NUM_INVENTORY = 27;
    private static final int NUM_HOTBAR = 9;
    private static final int OUTPUTS_START = 6;
    private static final int PLAYER_START = 7;
    private static final int HOTBAR_START = 34;
    private static final int PLAYER_END = 43;
    private final World world;
    private final IWorldPosCallable openedFrom;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.standalone();
    private final ItemStack[] inputStacksCache = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};
    @Nullable
    private final InventoryProvider inventoryProvider;
    private List<SewingRecipe> recipes = Lists.newArrayList();
    private long lastTimeSoundPlayed;
    private Runnable inventoryUpdateListener = () -> {};
    public final IItemHandlerModifiable inputInventory;
    private final CraftResultInventory inventory = new CraftResultInventory();

    public SewingTableContainer(int windowIdIn, PlayerInventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, IWorldPosCallable.NULL);
    }

    public SewingTableContainer(int windowIdIn, PlayerInventory playerInventoryIn, IWorldPosCallable worldPosCallableIn) {
        this(windowIdIn, playerInventoryIn, worldPosCallableIn, new SewingTableInventory());
    }

    public SewingTableContainer(int windowIdIn, PlayerInventory playerInventoryIn, final IWorldPosCallable worldPosCallableIn, InventoryProvider inventoryProvider) {
        super(TYPE, windowIdIn);
        this.openedFrom = worldPosCallableIn;
        this.world = playerInventoryIn.player.level;
        this.inputInventory = inventoryProvider.getInventory();
        this.inventoryProvider = inventoryProvider;
        inventoryProvider.addWeakListener(this);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 0, 8, 15){
            {
                this.setBackground(PlayerContainer.BLOCK_ATLAS, SewingKitMod.location("gui/needle_slot_background"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 1, 30, 15){
            {
                this.setBackground(PlayerContainer.BLOCK_ATLAS, SewingKitMod.location("gui/pattern_slot_background"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 2, 10, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 3, 28, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 4, 10, 53));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 5, 28, 53));
        this.addSlot(new Slot((IInventory)this.inventory, 1, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public ItemStack onTake(PlayerEntity thePlayer, ItemStack stack) {
                if (!thePlayer.level.isClientSide) {
                    stack.onCraftedBy(thePlayer.level, thePlayer, stack.getCount());
                    SewingTableContainer.this.inventory.awardUsedRecipes(thePlayer);
                    SewingRecipe recipe = (SewingRecipe)SewingTableContainer.this.recipes.get(SewingTableContainer.this.getSelectedRecipe());
                    Map<Ingredient, Integer> remaining = recipe.getMaterials().stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
                    if (SewingTableContainer.this.consumeCraftingMaterials(thePlayer, remaining)) {
                        SewingTableContainer.this.updateRecipeResultSlot();
                    }
                    worldPosCallableIn.execute((world, pos) -> {
                        long l = world.getGameTime();
                        if (SewingTableContainer.this.lastTimeSoundPlayed != l) {
                            world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            SewingTableContainer.this.lastTimeSoundPlayed = l;
                        }
                    });
                }
                return super.onTake(thePlayer, stack);
            }
        });
        this.bindPlayerInventory(playerInventoryIn);
        this.addDataSlot(this.selectedRecipe);
    }

    private boolean consumeCraftingMaterials(PlayerEntity thePlayer, Map<Ingredient, Integer> remaining) {
        boolean needsUpdate = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack;
            Slot slot = (Slot)this.slots.get(i);
            if (i == 0) {
                slot.getItem().hurtAndBreak(1, (LivingEntity)thePlayer, player -> slot.remove(1));
                itemstack = slot.getItem();
            } else if (i == 1) {
                itemstack = ItemStack.EMPTY;
            } else {
                int subtract = 0;
                for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                    Ingredient ing = mat.getKey();
                    int value = mat.getValue();
                    ItemStack stack1 = slot.getItem();
                    if (!ing.test(stack1)) continue;
                    int remaining1 = Math.max(0, value - (stack1.getCount() + subtract));
                    subtract += value - remaining1;
                    mat.setValue(remaining1);
                }
                itemstack = slot.remove(subtract);
            }
            if (itemstack.isEmpty()) continue;
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private void bindPlayerInventory(PlayerInventory playerInventoryIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((IInventory)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((IInventory)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public void onInventoryChanged() {
        this.slotsChanged((IInventory)new RecipeWrapper(this.inputInventory));
        this.inventoryUpdateListener.run();
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<SewingRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsinInputSlots() {
        return this.slots.stream().skip(2L).limit(4L).anyMatch(Slot::hasItem);
    }

    public boolean isAbleToCraft() {
        return this.hasItemsinInputSlots() && !this.recipes.isEmpty();
    }

    public boolean stillValid(PlayerEntity playerIn) {
        return SewingTableContainer.isWithinUsableDistance(this.openedFrom, playerIn, (Block)SewingKitMod.SEWING_STATION_BLOCK.get(), (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
    }

    protected static boolean isWithinUsableDistance(IWorldPosCallable worldPos, PlayerEntity playerIn, Block ... targetBlocks) {
        return (Boolean)worldPos.evaluate((world, pos) -> {
            BlockState blockState = world.getBlockState(pos);
            if (Arrays.stream(targetBlocks).noneMatch(arg_0 -> ((BlockState)blockState).is(arg_0))) {
                return false;
            }
            return playerIn.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public boolean clickMenuButton(PlayerEntity playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.set(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int pRecipeIndex) {
        return pRecipeIndex >= 0 && pRecipeIndex < this.recipes.size();
    }

    public void slotsChanged(IInventory inventoryIn) {
        boolean anyChanged = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
            if (ItemStack.matches((ItemStack)itemstack, (ItemStack)this.inputStacksCache[i])) continue;
            this.inputStacksCache[i] = itemstack.copy();
            anyChanged = true;
        }
        if (anyChanged) {
            this.updateAvailableRecipes(inventoryIn);
        }
    }

    private void updateAvailableRecipes(IInventory inventoryIn) {
        int index;
        SewingRecipe recipe = this.getSelectedRecipe() >= 0 && this.recipes.size() > 0 ? this.recipes.get(this.getSelectedRecipe()) : null;
        this.recipes.clear();
        this.selectedRecipe.set(-1);
        ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        if (this.hasItemsinInputSlots()) {
            this.recipes = this.world.getRecipeManager().getRecipesFor(SewingRecipe.SEWING, inventoryIn, this.world);
        }
        if (this.recipes.size() > 0 && recipe != null && (index = this.recipes.indexOf(recipe)) >= 0) {
            this.selectedRecipe.set(index);
            this.updateRecipeResultSlot();
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.get())) {
            SewingRecipe stonecuttingrecipe = this.recipes.get(this.selectedRecipe.get());
            this.inventory.setRecipeUsed((IRecipe)stonecuttingrecipe);
            ((Slot)this.slots.get(6)).set(stonecuttingrecipe.assemble((IInventory)new RecipeWrapper(this.inputInventory)));
        } else {
            ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.inventory && super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        Item item = stackInSlot.getItem();
        ItemStack stackCopy = stackInSlot.copy();
        int startIndex = 7;
        int endIndex = 43;
        boolean reverse = false;
        boolean notify = false;
        if (index == 6) {
            reverse = true;
            notify = true;
        } else if (index >= 6) {
            if (stackInSlot.getMaxStackSize() == 1 && ((Slot)this.slots.get(0)).getItem().getCount() == 0) {
                startIndex = 0;
                endIndex = 1;
            } else {
                startIndex = 2;
                endIndex = 6;
            }
        }
        if (endIndex > startIndex) {
            if (notify) {
                item.onCraftedBy(stackInSlot, playerIn.level, playerIn);
            }
            if (!this.moveItemStackTo(stackInSlot, startIndex, endIndex, reverse)) {
                return ItemStack.EMPTY;
            }
            if (notify) {
                slot.onQuickCraft(stackInSlot, stackCopy);
            }
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (stackInSlot.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stackInSlot);
        this.broadcastChanges();
        return stackCopy;
    }

    private boolean hasRecipe(ItemStack stackInSlot) {
        return this.world.getRecipeManager().getRecipeFor(SewingRecipe.SEWING, (IInventory)new Inventory(new ItemStack[]{stackInSlot}), this.world).isPresent();
    }

    public void removed(PlayerEntity playerIn) {
        super.removed(playerIn);
        this.inventory.removeItemNoUpdate(0);
        if (this.inventoryProvider.isDummy()) {
            this.openedFrom.execute((world, pos) -> this.clearContainer(playerIn, playerIn.level, (IInventory)new RecipeWrapper(this.inputInventory)));
        }
    }
}

