/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipeBuilder;
import dev.gigaherz.sewingkit.needle.NeedleItem;
import dev.gigaherz.sewingkit.needle.Needles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class SewingKitDataGen {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.addProvider((DataProvider)new Lang(gen));
            ItemModels itemModels = new ItemModels(gen, event.getExistingFileHelper());
            gen.addProvider((DataProvider)itemModels);
            gen.addProvider((DataProvider)new BlockStates(gen, itemModels.existingFileHelper));
        }
        if (event.includeServer()) {
            BlockTags blockTags = new BlockTags(gen, event.getExistingFileHelper());
            gen.addProvider((DataProvider)blockTags);
            gen.addProvider((DataProvider)new Recipes(gen));
            gen.addProvider((DataProvider)new Loot(gen));
        }
    }

    public static class Lang
    extends LanguageProvider {
        public Lang(DataGenerator gen) {
            super(gen, "sewingkit", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.sewing_kit", "Sewing Kit");
            this.add("container.sewingkit.sewing_station", "Sewing Station");
            this.add("jei.category.sewingkit.sewing", "Sewing");
            this.add((Item)SewingKitMod.LEATHER_STRIP.get(), "Leather Strip");
            this.add((Item)SewingKitMod.LEATHER_SHEET.get(), "Leather Sheet");
            this.add((Block)SewingKitMod.SEWING_STATION_BLOCK.get(), "Sewing Table");
            this.add((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get(), "Sewing Table with Drawers");
            Arrays.stream(Needles.values()).forEach(needle -> {
                String type = needle.getType();
                String name = type.substring(0, 1).toUpperCase() + type.substring(1);
                this.add(needle.getNeedle(), name + " Sewing Needle");
            });
            this.add("text.sewingkit.needle.lore_text", "\"Ow! Prickl...zz..z...\"");
            this.add((Item)SewingKitMod.WOOL_HAT.get(), "Wool Hat");
            this.add((Item)SewingKitMod.WOOL_SHIRT.get(), "Wool Shirt");
            this.add((Item)SewingKitMod.WOOL_PANTS.get(), "Wool Pants");
            this.add((Item)SewingKitMod.WOOL_SHOES.get(), "Wool Shoes");
            this.add((Item)SewingKitMod.WOOL_ROLL.get(), "Wool Roll");
            this.add((Item)SewingKitMod.WOOL_TRIM.get(), "Wool Trim");
            this.add((Item)SewingKitMod.COMMON_PATTERN.get(), "Common Pattern");
            this.add((Item)SewingKitMod.UNCOMMON_PATTERN.get(), "Uncommon Pattern");
            this.add((Item)SewingKitMod.RARE_PATTERN.get(), "Rare Pattern");
            this.add((Item)SewingKitMod.LEGENDARY_PATTERN.get(), "Legendary Pattern");
            this.add((Item)SewingKitMod.FILE.get(), "Raspy File");
            this.add("entity.minecraft.villager.sewingkit.tailor", "Tailor");
        }
    }

    public static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "sewingkit", existingFileHelper);
        }

        protected void registerModels() {
            this.basicIcon(SewingKitMod.LEATHER_STRIP.getId());
            this.basicIcon(SewingKitMod.LEATHER_SHEET.getId());
            Arrays.stream(Needles.values()).forEach(needle -> this.basicIcon(needle.getId()));
            this.basicIcon(SewingKitMod.WOOL_HAT.getId());
            this.basicIcon(SewingKitMod.WOOL_SHIRT.getId());
            this.basicIcon(SewingKitMod.WOOL_PANTS.getId());
            this.basicIcon(SewingKitMod.WOOL_SHOES.getId());
            this.basicIcon(SewingKitMod.WOOL_ROLL.getId());
            this.basicIcon(SewingKitMod.WOOL_TRIM.getId());
            this.basicIcon(SewingKitMod.COMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.UNCOMMON_PATTERN.getId());
            this.basicIcon(SewingKitMod.RARE_PATTERN.getId());
            this.basicIcon(SewingKitMod.LEGENDARY_PATTERN.getId());
            this.basicIcon(SewingKitMod.FILE.getId()).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(62.0f, 147.0f, 40.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(45.0f, -33.0f, -55.0f).translation(-2.25f, 1.5f, -0.25f).scale(0.48f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(-54.0f, 99.0f, 136.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(136.0f, -99.0f, 54.0f).translation(1.13f, 5.0f, 1.13f).scale(0.68f).end().transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 2.0f, 0.0f).scale(0.5f).end().transform(ModelBuilder.Perspective.HEAD).rotation(-4.0f, 44.0f, 4.0f).translation(-7.25f, 6.75f, 0.75f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).end().end();
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.SEWING_STATION_ITEM.getId().getPath())).parent((ModelFile)this.getExistingFile(ModelLocationUtils.getModelLocation((Block)((Block)SewingKitMod.SEWING_STATION_BLOCK.get()))));
            ((ItemModelBuilder)this.getBuilder(SewingKitMod.STORING_SEWING_STATION_ITEM.getId().getPath())).parent((ModelFile)this.getExistingFile(ModelLocationUtils.getModelLocation((Block)((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get()))));
        }

        private ItemModelBuilder basicIcon(ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", SewingKitMod.location("item/" + item.getPath()));
        }
    }

    public static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "sewingkit", exFileHelper);
        }

        protected void registerStatesAndModels() {
            Block block = (Block)SewingKitMod.SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelLocationUtils.getModelLocation((Block)block)));
            block = (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get();
            this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(ModelLocationUtils.getModelLocation((Block)block)));
        }
    }

    private static class BlockTags
    extends BlockTagsProvider
    implements DataProvider {
        public BlockTags(DataGenerator gen, ExistingFileHelper existingFileHelper) {
            super(gen, "sewingkit", existingFileHelper);
        }

        protected void addTags() {
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void buildCraftingRecipes(Consumer<FinishedRecipe> consumer) {
            Arrays.stream(Needles.values()).forEach(needle -> ShapelessRecipeBuilder.shapeless((ItemLike)needle.getNeedle()).requires((ItemLike)SewingKitMod.FILE.get()).requires(needle.getRepairIngredient()).unlockedBy("has_material", (CriterionTriggerInstance)needle.getMaterial().map(x$0 -> RecipeProvider.has((Tag)x$0), x$0 -> RecipeProvider.has((ItemLike)x$0))).save(consumer));
            ShapedRecipeBuilder.shaped((ItemLike)((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get())).pattern("xxx").pattern("P P").pattern("S S").define(Character.valueOf('x'), (Tag)ItemTags.WOODEN_SLABS).define(Character.valueOf('P'), (Tag)ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_wood", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.PLANKS)).save(consumer);
            ShapelessRecipeBuilder.shapeless((ItemLike)((ItemLike)SewingKitMod.STORING_SEWING_STATION_ITEM.get())).requires((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()).requires((Tag)Tags.Items.CHESTS_WOODEN).unlockedBy("has_station", (CriterionTriggerInstance)Recipes.has((ItemLike)((ItemLike)SewingKitMod.SEWING_STATION_ITEM.get()))).save(consumer);
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_SHEET.get(), 4).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_sheet_from_leather"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_SHEET.get(), 1).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial(new ItemLike[]{Items.RABBIT_HIDE}).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((ItemLike)Items.RABBIT_HIDE)).build(consumer, SewingKitMod.location("leather_sheet_from_rabbit_hide"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.LEATHER_STRIP.get(), 3).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)Tags.Items.LEATHER).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_strip_from_leather"));
            SewingRecipeBuilder.begin(Items.LEATHER_BOOTS).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_boots_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_LEGGINGS).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 4).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 3).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_leggings_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_CHESTPLATE).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 8).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 2).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_chestplate_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_HELMET).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 2).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get()).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_helmet_via_sewing"));
            SewingRecipeBuilder.begin(Items.LEATHER_HORSE_ARMOR).withTool(NeedleItem.SEWING_NEEDLE, Needles.NETHERITE.getLevel()).addMaterial((ItemLike)SewingKitMod.LEATHER_SHEET.get(), 12).addMaterial((ItemLike)SewingKitMod.LEATHER_STRIP.get(), 6).addMaterial((Tag<Item>)Tags.Items.STRING, 8).addCriterion("has_leather", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.LEATHER)).build(consumer, SewingKitMod.location("leather_horse_armor_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_ROLL.get(), 4).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)ItemTags.WOOL).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_roll_from_wool"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_ROLL.get(), 1).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)ItemTags.CARPETS).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.CARPETS)).build(consumer, SewingKitMod.location("wool_roll_from_carpet"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_TRIM.get(), 8).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)ItemTags.WOOL).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_trim_from_wool"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_TRIM.get(), 3).withTool((Tag<Item>)Tags.Items.SHEARS).addMaterial((Tag<Item>)ItemTags.CARPETS).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.CARPETS)).build(consumer, SewingKitMod.location("wool_trim_from_carpet"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_SHOES.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 2).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_shoes_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_PANTS.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 2).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 4).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_pants_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_SHIRT.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 3).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 3).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_shirt_via_sewing"));
            SewingRecipeBuilder.begin((Item)SewingKitMod.WOOL_HAT.get()).withTool(NeedleItem.SEWING_NEEDLE, 1).addMaterial((ItemLike)SewingKitMod.WOOL_ROLL.get(), 1).addMaterial((ItemLike)SewingKitMod.WOOL_TRIM.get(), 1).addMaterial((Tag<Item>)Tags.Items.STRING).addCriterion("has_wool", (CriterionTriggerInstance)Recipes.has((Tag)ItemTags.WOOL)).build(consumer, SewingKitMod.location("wool_hat_via_sewing"));
            ShapedRecipeBuilder.shaped((ItemLike)((ItemLike)SewingKitMod.FILE.get())).pattern("  I").pattern(" I ").pattern("P  ").define(Character.valueOf('I'), (Tag)Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (Tag)ItemTags.PLANKS).unlockedBy("has_iron", (CriterionTriggerInstance)Recipes.has((Tag)Tags.Items.INGOTS_IRON)).save(consumer);
        }
    }

    private static class Loot
    extends LootTableProvider
    implements DataProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootContextParamSets.BLOCK));

        public Loot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return this.tables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
            map.forEach((p_218436_2_, p_218436_3_) -> LootTables.validate((ValidationContext)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
        }

        public static class BlockTables
        extends BlockLoot {
            protected void addTables() {
                this.dropSelf((Block)SewingKitMod.SEWING_STATION_BLOCK.get());
                this.dropSelf((Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().getNamespace().equals("sewingkit")).collect(Collectors.toList());
            }
        }
    }
}

