/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.gson.JsonObject;
import dev.gigaherz.sewingkit.SewingKitMod;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolIngredient
extends Ingredient {
    public static final ResourceLocation NAME = SewingKitMod.location("tool_ingredient");

    public static ToolIngredient fromTool(ToolType toolType, int level) {
        return new ToolIngredient(toolType, level);
    }

    protected ToolIngredient(ToolType toolType, int toolLevel) {
        super(Stream.of(new ItemList(toolType, toolLevel)));
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    private static class ItemList
    implements Ingredient.Value {
        private final ToolType toolType;
        private final int toolLevel;

        public ItemList(ToolType toolType, int toolLevel) {
            this.toolType = toolType;
            this.toolLevel = toolLevel;
        }

        public Collection<ItemStack> getItems() {
            return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(stack -> stack.getHarvestLevel(this.toolType, null, null) >= this.toolLevel).collect(Collectors.toList());
        }

        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", NAME.toString());
            object.addProperty("tool_type", this.toolType.getName());
            object.addProperty("tool_level", (Number)this.toolLevel);
            return object;
        }
    }

    public static class Serializer
    extends VanillaIngredientSerializer {
        public static final IIngredientSerializer<? extends Ingredient> INSTANCE = new Serializer();

        public Ingredient parse(JsonObject json) {
            return new ToolIngredient(ToolType.get((String)GsonHelper.getAsString((JsonObject)json, (String)"tool_type")), GsonHelper.getAsInt((JsonObject)json, (String)"tool_level"));
        }
    }
}

