/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.SewingKitMod;
import dev.gigaherz.sewingkit.api.SewingRecipe;
import dev.gigaherz.sewingkit.table.Listenable;
import dev.gigaherz.sewingkit.table.ListenableHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ObjectHolder;

public class SewingTableContainer
extends AbstractContainerMenu {
    @ObjectHolder(value="sewingkit:sewing_station")
    public static MenuType<SewingTableContainer> TYPE;
    private static final int NUM_INPUTS = 6;
    private static final int NUM_OUTPUTS = 1;
    private static final int NUM_INVENTORY = 27;
    private static final int NUM_HOTBAR = 9;
    private static final int OUTPUTS_START = 6;
    private static final int PLAYER_START = 7;
    private static final int HOTBAR_START = 34;
    private static final int PLAYER_END = 43;
    private final Level world;
    private final ContainerLevelAccess openedFrom;
    private final DataSlot selectedRecipe = DataSlot.standalone();
    private final ItemStack[] inputStacksCache = new ItemStack[]{ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY};
    private final Listenable te;
    private List<SewingRecipe> recipes = Lists.newArrayList();
    private long lastTimeSoundPlayed;
    private Runnable inventoryUpdateListener = () -> {};
    public final IItemHandlerModifiable inputInventory;
    private final ResultContainer inventory = new ResultContainer();

    public SewingTableContainer(int windowIdIn, Inventory playerInventoryIn) {
        this(windowIdIn, playerInventoryIn, ContainerLevelAccess.NULL);
    }

    public SewingTableContainer(int windowIdIn, Inventory playerInventoryIn, ContainerLevelAccess worldPosCallableIn) {
        this(windowIdIn, playerInventoryIn, worldPosCallableIn, new SimpleInventory());
    }

    public SewingTableContainer(int windowIdIn, Inventory playerInventoryIn, final ContainerLevelAccess worldPosCallableIn, Listenable listenable) {
        super(TYPE, windowIdIn);
        this.openedFrom = worldPosCallableIn;
        this.world = playerInventoryIn.player.level;
        this.inputInventory = listenable.getInventory();
        listenable.addWeakListener(this);
        this.te = listenable;
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 0, 8, 15){
            {
                this.setBackground(InventoryMenu.BLOCK_ATLAS, SewingKitMod.location("gui/needle_slot_background"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 1, 30, 15){
            {
                this.setBackground(InventoryMenu.BLOCK_ATLAS, SewingKitMod.location("gui/pattern_slot_background"));
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 2, 10, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 3, 28, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 4, 10, 53));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inputInventory, 5, 28, 53));
        this.addSlot(new Slot((Container)this.inventory, 1, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player thePlayer, ItemStack stack) {
                if (!thePlayer.level.isClientSide) {
                    stack.onCraftedBy(thePlayer.level, thePlayer, stack.getCount());
                    SewingTableContainer.this.inventory.awardUsedRecipes(thePlayer);
                    SewingRecipe recipe = SewingTableContainer.this.recipes.get(SewingTableContainer.this.getSelectedRecipe());
                    Map<Ingredient, Integer> remaining = recipe.getMaterials().stream().collect(Collectors.toMap(i -> i.ingredient, i -> i.count));
                    if (SewingTableContainer.this.consumeCraftingMaterials(thePlayer, remaining)) {
                        SewingTableContainer.this.updateRecipeResultSlot();
                    }
                    worldPosCallableIn.execute((world, pos) -> {
                        long l = world.getGameTime();
                        if (SewingTableContainer.this.lastTimeSoundPlayed != l) {
                            world.playSound(null, pos, SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
                            SewingTableContainer.this.lastTimeSoundPlayed = l;
                        }
                    });
                }
                super.onTake(thePlayer, stack);
            }
        });
        this.bindPlayerInventory(playerInventoryIn);
        this.addDataSlot(this.selectedRecipe);
    }

    private boolean consumeCraftingMaterials(Player thePlayer, Map<Ingredient, Integer> remaining) {
        boolean needsUpdate = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack;
            Slot slot = (Slot)this.slots.get(i);
            if (i == 0) {
                slot.getItem().hurtAndBreak(1, (LivingEntity)thePlayer, player -> slot.remove(1));
                itemstack = slot.getItem();
            } else if (i == 1) {
                itemstack = ItemStack.EMPTY;
            } else {
                int subtract = 0;
                for (Map.Entry<Ingredient, Integer> mat : remaining.entrySet()) {
                    Ingredient ing = mat.getKey();
                    int value = mat.getValue();
                    ItemStack stack1 = slot.getItem();
                    if (!ing.test(stack1)) continue;
                    int remaining1 = Math.max(0, value - (stack1.getCount() + subtract));
                    subtract += value - remaining1;
                    mat.setValue(remaining1);
                }
                itemstack = slot.remove(subtract);
            }
            if (itemstack.isEmpty()) continue;
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private void bindPlayerInventory(Inventory playerInventoryIn) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventoryIn, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventoryIn, k, 8 + k * 18, 142));
        }
    }

    public void onInventoryChanged() {
        this.slotsChanged((Container)new RecipeWrapper(this.inputInventory));
        this.inventoryUpdateListener.run();
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.get();
    }

    public List<SewingRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getRecipeListSize() {
        return this.recipes.size();
    }

    public boolean hasItemsinInputSlots() {
        return this.slots.stream().skip(2L).limit(4L).anyMatch(Slot::hasItem);
    }

    public boolean isAbleToCraft() {
        return this.hasItemsinInputSlots() && !this.recipes.isEmpty();
    }

    public boolean stillValid(Player playerIn) {
        return SewingTableContainer.isWithinUsableDistance(this.openedFrom, playerIn, (Block)SewingKitMod.SEWING_STATION_BLOCK.get(), (Block)SewingKitMod.STORING_SEWING_STATION_BLOCK.get());
    }

    protected static boolean isWithinUsableDistance(ContainerLevelAccess worldPos, Player playerIn, Block ... targetBlocks) {
        return (Boolean)worldPos.evaluate((world, pos) -> {
            BlockState blockState = world.getBlockState(pos);
            if (Arrays.stream(targetBlocks).noneMatch(arg_0 -> ((BlockState)blockState).is(arg_0))) {
                return false;
            }
            return playerIn.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    public boolean clickMenuButton(Player playerIn, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipe.set(id);
            this.updateRecipeResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int p_241818_1_) {
        return p_241818_1_ >= 0 && p_241818_1_ < this.recipes.size();
    }

    public void slotsChanged(Container inventoryIn) {
        boolean anyChanged = false;
        for (int i = 0; i < 6; ++i) {
            ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
            if (ItemStack.matches((ItemStack)itemstack, (ItemStack)this.inputStacksCache[i])) continue;
            this.inputStacksCache[i] = itemstack.copy();
            anyChanged = true;
        }
        if (anyChanged) {
            this.updateAvailableRecipes(inventoryIn);
        }
    }

    private void updateAvailableRecipes(Container inventoryIn) {
        int index;
        SewingRecipe recipe = this.getSelectedRecipe() >= 0 && this.recipes.size() > 0 ? this.recipes.get(this.getSelectedRecipe()) : null;
        this.recipes.clear();
        this.selectedRecipe.set(-1);
        ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        if (this.hasItemsinInputSlots()) {
            this.recipes = this.world.getRecipeManager().getRecipesFor(SewingRecipe.SEWING, inventoryIn, this.world);
        }
        if (this.recipes.size() > 0 && recipe != null && (index = this.recipes.indexOf(recipe)) >= 0) {
            this.selectedRecipe.set(index);
            this.updateRecipeResultSlot();
        }
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipe.get())) {
            SewingRecipe stonecuttingrecipe = this.recipes.get(this.selectedRecipe.get());
            this.inventory.setRecipeUsed((Recipe)stonecuttingrecipe);
            ((Slot)this.slots.get(6)).set(stonecuttingrecipe.assemble((Container)new RecipeWrapper(this.inputInventory)));
        } else {
            ((Slot)this.slots.get(6)).set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.inventory && super.canTakeItemForPickAll(stack, slotIn);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        Item item = stackInSlot.getItem();
        ItemStack stackCopy = stackInSlot.copy();
        int startIndex = 7;
        int endIndex = 43;
        boolean reverse = false;
        boolean notify = false;
        if (index == 6) {
            reverse = true;
            notify = true;
        } else if (index >= 6) {
            if (stackInSlot.getMaxStackSize() == 1 && ((Slot)this.slots.get(0)).getItem().getCount() == 0) {
                startIndex = 0;
                endIndex = 1;
            } else {
                startIndex = 2;
                endIndex = 6;
            }
        }
        if (endIndex > startIndex) {
            if (notify) {
                item.onCraftedBy(stackInSlot, playerIn.level, playerIn);
            }
            if (!this.moveItemStackTo(stackInSlot, startIndex, endIndex, reverse)) {
                return ItemStack.EMPTY;
            }
            if (notify) {
                slot.onQuickCraft(stackInSlot, stackCopy);
            }
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        }
        slot.setChanged();
        if (stackInSlot.getCount() == stackCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, stackInSlot);
        this.broadcastChanges();
        return stackCopy;
    }

    private boolean hasRecipe(ItemStack stackInSlot) {
        return this.world.getRecipeManager().getRecipeFor(SewingRecipe.SEWING, (Container)new SimpleContainer(new ItemStack[]{stackInSlot}), this.world).isPresent();
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        this.inventory.removeItemNoUpdate(0);
        if (this.te.isDummy()) {
            this.openedFrom.execute((world, pos) -> this.clearContainer(playerIn, (Container)new RecipeWrapper(this.inputInventory)));
        }
    }

    private static class SimpleInventory
    extends ItemStackHandler
    implements Listenable {
        private final ListenableHolder listenable = new ListenableHolder();

        public SimpleInventory() {
            super(6);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.listenable.doCallbacks();
        }

        @Override
        public void addWeakListener(SewingTableContainer e) {
            this.listenable.addWeakListener(e);
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this;
        }

        @Override
        public boolean isDummy() {
            return true;
        }
    }
}

