/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.api;

import com.google.gson.JsonObject;
import dev.gigaherz.sewingkit.SewingKitMod;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class ToolActionIngredient
extends Ingredient {
    public static final ResourceLocation NAME = SewingKitMod.location("tool_ingredient");

    public static ToolActionIngredient fromTool(ToolAction toolType, @Nullable Tier level) {
        return new ToolActionIngredient(toolType, level);
    }

    protected ToolActionIngredient(ToolAction toolType, @Nullable Tier toolLevel) {
        super(Stream.of(new ItemList(toolType, toolLevel)));
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    private record ItemList(ToolAction toolType, @Nullable Tier toolLevel) implements Ingredient.Value
    {
        public Collection<ItemStack> getItems() {
            return ForgeRegistries.ITEMS.getValues().stream().map(ItemStack::new).filter(stack -> stack.canPerformAction(this.toolType) && this.checkTier((ItemStack)stack)).collect(Collectors.toList());
        }

        private boolean checkTier(ItemStack stack) {
            TieredItem tieredItem;
            Item item;
            return this.toolLevel == null || (item = stack.getItem()) instanceof TieredItem && TierSortingRegistry.getTiersLowerThan((Tier)(tieredItem = (TieredItem)item).getTier()).contains(this.toolLevel);
        }

        public JsonObject serialize() {
            JsonObject object = new JsonObject();
            object.addProperty("type", NAME.toString());
            object.addProperty("tool_type", this.toolType.name());
            if (this.toolLevel != null) {
                object.addProperty("tool_level", Objects.requireNonNull(TierSortingRegistry.getName((Tier)this.toolLevel), "Tool level not found: " + this.toolLevel).toString());
            }
            return object;
        }
    }

    public static class Serializer
    extends VanillaIngredientSerializer {
        public static final IIngredientSerializer<? extends Ingredient> INSTANCE = new Serializer();

        public Ingredient parse(JsonObject json) {
            return new ToolActionIngredient(ToolAction.get((String)GsonHelper.getAsString((JsonObject)json, (String)"tool_type")), this.getTier(GsonHelper.getAsString((JsonObject)json, (String)"tool_level", null)));
        }

        @Nullable
        private Tier getTier(@Nullable String str) {
            return str == null ? null : TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(str));
        }
    }
}

