/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.needle;

import dev.gigaherz.sewingkit.needle.NeedleMaterial;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ToolAction;

public class NeedleItem
extends DiggerItem {
    public static final ToolAction SEW = ToolAction.get((String)"sewingkit_sew");
    public static final Tag.Named<Block> BREAKABLE_NEEDLE = BlockTags.createOptional((ResourceLocation)new ResourceLocation("toolbelt:breakable_needle"));
    private static final Set<ToolAction> actions = Set.of(SEW);

    public NeedleItem(float attackDamageIn, float attackSpeedIn, NeedleMaterial material, Item.Properties builderIn) {
        super(attackDamageIn, attackSpeedIn, material.getTier(), BREAKABLE_NEEDLE, builderIn.durability(material.getUses()));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("text.sewingkit.needle.lore_text").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return actions.contains(toolAction);
    }
}

