/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.sewingkit.table;

import com.google.common.collect.Lists;
import dev.gigaherz.sewingkit.table.SewingTableContainer;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;

public class ListenableHolder {
    private final List<Reference<? extends SewingTableContainer>> listeners = Lists.newArrayList();
    private final ReferenceQueue<SewingTableContainer> pendingRemovals = new ReferenceQueue();

    public void addWeakListener(SewingTableContainer e) {
        this.listeners.add(new WeakReference<SewingTableContainer>(e, this.pendingRemovals));
    }

    public void doCallbacks() {
        Reference<SewingTableContainer> ref = this.pendingRemovals.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.pendingRemovals.poll();
        }
        Iterator<Reference<? extends SewingTableContainer>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Reference<? extends SewingTableContainer> reference = iterator.next();
            SewingTableContainer listener = reference.get();
            if (listener == null) {
                iterator.remove();
                continue;
            }
            listener.onInventoryChanged();
        }
    }
}

