/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.dynamic;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.structure.GddlList;
import dev.gigaherz.util.gddl2.structure.GddlMap;
import dev.gigaherz.util.gddl2.structure.GddlValue;
import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Stream;

public final class GDDLOps
implements DynamicOps<GddlElement<?>> {
    public static final GDDLOps INSTANCE = new GDDLOps();

    private GDDLOps() {
    }

    public GddlElement<?> empty() {
        return GddlValue.nullValue();
    }

    public GddlElement<?> emptyMap() {
        return GddlList.empty();
    }

    public GddlElement<?> emptyList() {
        return GddlList.empty();
    }

    public <U> U convertTo(DynamicOps<U> outOps, GddlElement<?> input) {
        if ((input = input.resolvedValue()).isNull()) {
            return (U)outOps.empty();
        }
        if (input.isString()) {
            return (U)outOps.createString(input.stringValue());
        }
        if (input.isBoolean()) {
            return (U)outOps.createBoolean(input.booleanValue());
        }
        if (input.isInteger()) {
            long l = input.longValue();
            if ((long)((byte)l) == l) {
                return (U)outOps.createByte((byte)l);
            }
            if ((long)((short)l) == l) {
                return (U)outOps.createShort((short)l);
            }
            if ((long)((int)l) == l) {
                return (U)outOps.createInt((int)l);
            }
            return (U)outOps.createLong(l);
        }
        if (input.isDouble()) {
            double d = input.doubleValue();
            if ((double)((float)d) == d) {
                return (U)outOps.createFloat((float)d);
            }
            return (U)outOps.createDouble(d);
        }
        if (input.isMap()) {
            return (U)this.convertMap(outOps, input.asMap());
        }
        if (input.isList()) {
            return (U)this.convertList(outOps, input.asList());
        }
        if (input.isReference()) {
            throw new IllegalStateException("Unsupported conversion of unresolved reference");
        }
        if (input.isValue()) {
            throw new IllegalStateException("Unimplemented value type " + input);
        }
        throw new IllegalStateException("Unknown input type " + input.getClass());
    }

    public DataResult<Number> getNumberValue(GddlElement<?> input) {
        if (input.isInteger()) {
            return DataResult.success((Object)input.longValue());
        }
        if (input.isDouble()) {
            return DataResult.success((Object)input.doubleValue());
        }
        return DataResult.error(() -> "Not a number");
    }

    public GddlElement<?> createByte(byte value) {
        return GddlValue.of((long)value);
    }

    public GddlElement<?> createShort(short value) {
        return GddlValue.of((long)value);
    }

    public GddlElement<?> createInt(int value) {
        return GddlValue.of((long)value);
    }

    public GddlElement<?> createLong(long value) {
        return GddlValue.of((long)value);
    }

    public GddlElement<?> createFloat(float value) {
        return GddlValue.of((double)value);
    }

    public GddlElement<?> createDouble(double value) {
        return GddlValue.of((double)value);
    }

    public DataResult<Boolean> getBooleanValue(GddlElement<?> input) {
        if (input.isBoolean()) {
            return DataResult.success((Object)input.booleanValue());
        }
        return DataResult.error(() -> "Not a boolean");
    }

    public GddlElement<?> createBoolean(boolean value) {
        return GddlValue.of((boolean)value);
    }

    public GddlElement<?> createNumeric(Number i) {
        if (i instanceof Double || i instanceof Float || i instanceof BigDecimal) {
            double d = i.doubleValue();
            return GddlValue.of((double)d);
        }
        long l = i.longValue();
        return GddlValue.of((long)l);
    }

    public DataResult<String> getStringValue(GddlElement<?> input) {
        if (input.isString()) {
            return DataResult.success((Object)input.stringValue());
        }
        return DataResult.error(() -> "Not a string");
    }

    public GddlElement<?> createString(String value) {
        return GddlValue.of((String)value);
    }

    public DataResult<GddlElement<?>> mergeToList(GddlElement<?> list, GddlElement<?> value) {
        return this.asNewList(list).map(c -> {
            c.add(value.copy());
            return c;
        });
    }

    private DataResult<GddlList> asNewList(GddlElement<?> element) {
        if (element.isNull()) {
            return DataResult.success((Object)GddlList.empty());
        }
        if (element.isList()) {
            return DataResult.success((Object)((GddlList)element.asList().copy()));
        }
        return DataResult.error(() -> "Not a list");
    }

    public DataResult<GddlElement<?>> mergeToMap(GddlElement<?> map, GddlElement<?> key, GddlElement<?> value) {
        if (!key.isString()) {
            return DataResult.error(() -> "Key is not a string");
        }
        return this.asNewMap(map).map(c -> {
            c.put(key.stringValue(), value);
            return c;
        });
    }

    private DataResult<GddlMap> asNewMap(GddlElement<?> element) {
        if (element.isNull()) {
            return DataResult.success((Object)GddlMap.empty());
        }
        if (element.isMap()) {
            return DataResult.success((Object)((GddlMap)element.asMap().copy()));
        }
        return DataResult.error(() -> "Not a map");
    }

    public DataResult<Stream<Pair<GddlElement<?>, GddlElement<?>>>> getMapValues(GddlElement<?> input) {
        if (!input.isMap()) {
            return DataResult.error(() -> "Not a map");
        }
        return DataResult.success(input.asMap().entrySet().stream().map(e -> Pair.of((Object)GddlValue.of((String)((String)e.getKey())), (Object)((GddlElement)e.getValue()))));
    }

    public GddlElement<?> createMap(Stream<Pair<GddlElement<?>, GddlElement<?>>> map) {
        GddlMap c = GddlMap.empty();
        map.forEach(kv -> c.put(((GddlElement)kv.getFirst()).stringValue(), (GddlElement)kv.getSecond()));
        return c;
    }

    public GddlElement<?> createMap(Map<GddlElement<?>, GddlElement<?>> map) {
        GddlMap c = GddlMap.empty();
        map.forEach((k, v) -> c.put(k.stringValue(), v));
        return c;
    }

    public DataResult<Stream<GddlElement<?>>> getStream(GddlElement<?> input) {
        if (input.isList()) {
            return DataResult.success((Object)input.asList().stream());
        }
        return DataResult.error(() -> "Not a list");
    }

    public GddlElement<?> createList(Stream<GddlElement<?>> input) {
        GddlList c = GddlList.empty();
        input.forEach(arg_0 -> ((GddlList)c).add(arg_0));
        return c;
    }

    public GddlElement<?> remove(GddlElement<?> input, String key) {
        GddlMap c;
        if (input.isMap() && (c = input.asMap()).containsKey(key)) {
            c = (GddlMap)c.copy();
            c.remove(key);
            return c;
        }
        return input;
    }
}

