/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.parsing;

import dev.gigaherz.util.gddl2.exceptions.LexerException;
import dev.gigaherz.util.gddl2.exceptions.ReaderException;
import dev.gigaherz.util.gddl2.parsing.ParsingContext;
import dev.gigaherz.util.gddl2.parsing.Reader;
import dev.gigaherz.util.gddl2.parsing.Token;
import dev.gigaherz.util.gddl2.parsing.TokenProvider;
import dev.gigaherz.util.gddl2.parsing.TokenType;
import dev.gigaherz.util.gddl2.parsing.WhitespaceMode;
import dev.gigaherz.util.gddl2.util.ArrayQueue;
import dev.gigaherz.util.gddl2.util.Utility;
import java.io.IOException;

public class Lexer
implements TokenProvider,
AutoCloseable {
    private final ArrayQueue<Token> lookAhead = new ArrayQueue();
    private final StringBuilder whitespaceBuilder = new StringBuilder();
    private final StringBuilder commentBuilder = new StringBuilder();
    private final Reader reader;
    private WhitespaceMode whitespaceMode;
    private boolean seenEnd = false;

    public Lexer(Reader r) {
        this.reader = r;
    }

    @Override
    public WhitespaceMode getWhitespaceMode() {
        return this.whitespaceMode;
    }

    @Override
    public void setWhitespaceMode(WhitespaceMode whitespaceMode) {
        this.whitespaceMode = whitespaceMode;
    }

    @Override
    public TokenType peek(int pos) throws LexerException, IOException {
        this.require(pos + 1);
        return this.lookAhead.get((int)pos).type;
    }

    @Override
    public TokenType peek() throws LexerException, IOException {
        this.require(1);
        return this.lookAhead.get((int)0).type;
    }

    @Override
    public Token peekFull() throws LexerException, IOException {
        this.require(1);
        return this.lookAhead.get(0);
    }

    @Override
    public Token pop() throws LexerException, IOException {
        this.require(2);
        return this.lookAhead.remove();
    }

    private void require(int count) throws LexerException, IOException {
        int needed = count - this.lookAhead.size();
        if (needed > 0) {
            this.readAhead(needed);
        }
    }

    private void readAhead(int needed) throws LexerException, IOException {
        while (needed-- > 0) {
            this.lookAhead.add(this.parseOne());
        }
    }

    private Token parseOne() throws LexerException, IOException {
        ParsingContext startContext = this.reader.getParsingContext();
        if (this.seenEnd) {
            return this.makeEndToken(startContext, "", "");
        }
        this.whitespaceAndComments();
        String comment = this.getComment();
        String whitespace = this.getWhitespace();
        int ich = this.reader.peek();
        if (ich < 0) {
            return this.makeEndToken(startContext, comment, whitespace);
        }
        switch (ich) {
            case 123: {
                return new Token(TokenType.L_BRACE, this.reader.read(1), startContext, comment, whitespace);
            }
            case 125: {
                return new Token(TokenType.R_BRACE, this.reader.read(1), startContext, comment, whitespace);
            }
            case 91: {
                return new Token(TokenType.L_BRACKET, this.reader.read(1), startContext, comment, whitespace);
            }
            case 93: {
                return new Token(TokenType.R_BRACKET, this.reader.read(1), startContext, comment, whitespace);
            }
            case 44: {
                return new Token(TokenType.COMMA, this.reader.read(1), startContext, comment, whitespace);
            }
            case 58: {
                return new Token(TokenType.COLON, this.reader.read(1), startContext, comment, whitespace);
            }
            case 47: {
                return new Token(TokenType.SLASH, this.reader.read(1), startContext, comment, whitespace);
            }
            case 61: {
                return new Token(TokenType.EQUAL_SIGN, this.reader.read(1), startContext, comment, whitespace);
            }
            case 37: {
                return new Token(TokenType.PERCENT, this.reader.read(1), startContext, comment, whitespace);
            }
            case 94: {
                return new Token(TokenType.CARET, this.reader.read(1), startContext, comment, whitespace);
            }
        }
        if (Utility.isLetter(ich) || ich == 95) {
            int number = 1;
            while ((ich = this.reader.peek(number)) >= 0 && (Utility.isLetter(ich) || Utility.isDigit(ich) || ich == 95)) {
                ++number;
            }
            Token id = new Token(TokenType.IDENTIFIER, this.reader.read(number), startContext, comment, whitespace);
            if (id.text.compareToIgnoreCase("nil") == 0) {
                return id.specialize(TokenType.NIL);
            }
            if (id.text.compareToIgnoreCase("null") == 0) {
                return id.specialize(TokenType.NULL);
            }
            if (id.text.compareToIgnoreCase("true") == 0) {
                return id.specialize(TokenType.TRUE);
            }
            if (id.text.compareToIgnoreCase("false") == 0) {
                return id.specialize(TokenType.FALSE);
            }
            if (id.text.compareToIgnoreCase("boolean") == 0) {
                return id.specialize(TokenType.BOOLEAN);
            }
            if (id.text.compareToIgnoreCase("string") == 0) {
                return id.specialize(TokenType.STRING);
            }
            if (id.text.compareToIgnoreCase("integer") == 0) {
                return id.specialize(TokenType.INTEGER);
            }
            if (id.text.compareToIgnoreCase("decimal") == 0) {
                return id.specialize(TokenType.DECIMAL);
            }
            return id;
        }
        if (ich == 34 || ich == 39) {
            int startedWith = ich;
            int number = 1;
            ich = this.reader.peek(number);
            while (ich != startedWith && ich >= 0) {
                switch (ich) {
                    case 92: {
                        number = this.countEscapeSeq(number);
                        break;
                    }
                    case 13: {
                        ich = this.reader.peek(++number);
                        if (ich != 10) break;
                        ++number;
                        break;
                    }
                    default: {
                        ++number;
                    }
                }
                ich = this.reader.peek(number);
            }
            if (ich != startedWith) {
                throw new LexerException(this, String.format("Expected '%c', found %s", startedWith, this.debugChar(ich)));
            }
            return new Token(TokenType.STRING_LITERAL, this.reader.read(++number), startContext, comment, whitespace);
        }
        if (Utility.isDigit(ich) || ich == 46 || ich == 43 || ich == 45) {
            int number = 0;
            boolean fractional = false;
            if (ich == 46) {
                ich = this.reader.peek(1);
                if (ich == 46) {
                    ich = this.reader.peek(2);
                    if (ich == 46) {
                        return new Token(TokenType.TRIPLE_DOT, this.reader.read(3), startContext, comment, whitespace);
                    }
                    return new Token(TokenType.DOUBLE_DOT, this.reader.read(2), startContext, comment, whitespace);
                }
                if (!Utility.isDigit(ich) && ich != 73 && ich != 78) {
                    return new Token(TokenType.DOT, this.reader.read(2), startContext, comment, whitespace);
                }
                ich = this.reader.peek();
            }
            if (ich == 46 && this.reader.peek(number + 1) == 78 && this.reader.peek(number + 2) == 97 && this.reader.peek(number + 3) == 78) {
                return new Token(TokenType.DECIMAL_LITERAL, this.reader.read(number + 4), startContext, comment, whitespace);
            }
            if (ich == 45 || ich == 43) {
                ich = this.reader.peek(++number);
            }
            if (ich == 46 && this.reader.peek(number + 1) == 73 && this.reader.peek(number + 2) == 110 && this.reader.peek(number + 3) == 102) {
                return new Token(TokenType.DECIMAL_LITERAL, this.reader.read(number + 4), startContext, comment, whitespace);
            }
            if (Utility.isDigit(ich)) {
                if (this.reader.peek(number) == 48 && this.reader.peek(number + 1) == 120) {
                    ich = this.reader.peek(number += 2);
                    while (Utility.isDigit(ich) || ich >= 97 && ich <= 102 || ich >= 65 && ich <= 70) {
                        ich = this.reader.peek(++number);
                    }
                    return new Token(TokenType.HEX_INT_LITERAL, this.reader.read(number), startContext, comment, whitespace);
                }
                number = 1;
                ich = this.reader.peek(number);
                while (Utility.isDigit(ich)) {
                    ich = this.reader.peek(++number);
                }
            }
            boolean doubleDot = false;
            if (ich == 46) {
                if (this.reader.peek(number + 1) == 46) {
                    doubleDot = true;
                } else {
                    fractional = true;
                    ich = this.reader.peek(++number);
                    while (Utility.isDigit(ich)) {
                        ich = this.reader.peek(++number);
                    }
                }
            }
            if (!(doubleDot || ich != 101 && ich != 69)) {
                fractional = true;
                if ((ich = this.reader.peek(++number)) == 43 || ich == 45) {
                    ich = this.reader.peek(++number);
                }
                if (!Utility.isDigit(ich)) {
                    throw new LexerException(this, String.format("Expected DIGIT, found %c", ich));
                }
                while (Utility.isDigit(ich)) {
                    ich = this.reader.peek(++number);
                }
            }
            if (fractional) {
                return new Token(TokenType.DECIMAL_LITERAL, this.reader.read(number), startContext, comment, whitespace);
            }
            return new Token(TokenType.INTEGER_LITERAL, this.reader.read(number), startContext, comment, whitespace);
        }
        throw new LexerException(this, String.format("Unexpected character: %c", this.reader.peek()));
    }

    private void whitespaceAndComments() throws ReaderException, IOException {
        int ich = this.reader.peek();
        this.whitespaceBuilder.setLength(0);
        this.commentBuilder.setLength(0);
        boolean commentStarted = false;
        block5: while (ich >= 0) {
            char cch;
            switch (ich) {
                case 9: 
                case 32: {
                    cch = (char)ich;
                    this.whitespaceBuilder.append(cch);
                    if (commentStarted) {
                        this.commentBuilder.append(cch);
                    }
                    this.reader.skip(1);
                    ich = this.reader.peek();
                    continue block5;
                }
                case 10: 
                case 13: {
                    cch = (char)ich;
                    this.whitespaceBuilder.append(cch);
                    if (commentStarted) {
                        this.commentBuilder.append(cch);
                    }
                    this.reader.skip(1);
                    ich = this.reader.peek();
                    if (cch == '\r' && ich == 10) {
                        cch = (char)ich;
                        this.whitespaceBuilder.append(cch);
                        if (commentStarted) {
                            this.commentBuilder.append(cch);
                        }
                        this.reader.skip(1);
                        ich = this.reader.peek();
                    }
                    commentStarted = false;
                    continue block5;
                }
                case 35: {
                    cch = (char)ich;
                    this.whitespaceBuilder.append(cch);
                    if (!commentStarted) {
                        commentStarted = true;
                    } else {
                        this.commentBuilder.append(cch);
                    }
                    this.reader.skip(1);
                    ich = this.reader.peek();
                    continue block5;
                }
            }
            if (!commentStarted) break;
            cch = (char)ich;
            this.whitespaceBuilder.append(cch);
            this.commentBuilder.append(cch);
            this.reader.skip(1);
            ich = this.reader.peek();
        }
    }

    private String getComment() {
        return this.commentBuilder.length() > 0 ? this.commentBuilder.toString() : "";
    }

    private String getWhitespace() {
        return this.whitespaceBuilder.length() > 0 ? this.whitespaceBuilder.toString() : "";
    }

    private Token makeEndToken(ParsingContext startContext, String comment, String whitespace) {
        this.seenEnd = true;
        return new Token(TokenType.END, "", startContext, comment, whitespace);
    }

    private String debugChar(int ich) {
        if (ich < 0) {
            return "EOF";
        }
        switch (ich) {
            case 0: {
                return "'\\0'";
            }
            case 8: {
                return "'\\b'";
            }
            case 9: {
                return "'\\t'";
            }
            case 10: {
                return "'\\n'";
            }
            case 13: {
                return "'\\r'";
            }
        }
        if (Utility.isControl(ich)) {
            return String.format("'\\u%04x'", ich);
        }
        return String.format("'%c'", ich);
    }

    private int countEscapeSeq(int number) throws LexerException, IOException {
        int ich = this.reader.peek(number);
        if (ich != 92) {
            throw new LexerException(this, "Internal Error");
        }
        ich = this.reader.peek(++number);
        switch (ich) {
            case 10: 
            case 34: 
            case 39: 
            case 48: 
            case 92: 
            case 98: 
            case 102: 
            case 110: 
            case 114: 
            case 116: {
                return ++number;
            }
        }
        if (ich == 120 || ich == 117) {
            if ((Utility.isDigit(ich = this.reader.peek(++number)) || ich >= 97 && ich <= 102 || ich >= 65 && ich <= 70) && (Utility.isDigit(ich = this.reader.peek(++number)) || ich >= 97 && ich <= 102 || ich >= 65 && ich <= 70) && (Utility.isDigit(ich = this.reader.peek(++number)) || ich >= 97 && ich <= 102 || ich >= 65 && ich <= 70) && (Utility.isDigit(ich = this.reader.peek(++number)) || ich >= 97 && ich <= 102 || ich >= 65 && ich <= 70)) {
                ++number;
            }
            return number;
        }
        if (ich == 13) {
            if ((ich = this.reader.peek(++number)) == 10) {
                ++number;
            }
            return number;
        }
        throw new LexerException(this, String.format("Unknown escape sequence \\%d", ich));
    }

    public String toString() {
        return String.format("{Lexer ahead=%s, reader=%s}", Utility.join((CharSequence)", ", this.lookAhead.elements()), this.reader);
    }

    @Override
    public ParsingContext getParsingContext() {
        if (this.lookAhead.size() > 0) {
            return this.lookAhead.get((int)0).context;
        }
        return this.reader.getParsingContext();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

