/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.util.gddl2.queries;

import dev.gigaherz.util.gddl2.queries.QueryComponent;
import dev.gigaherz.util.gddl2.serialization.Formatter;
import dev.gigaherz.util.gddl2.structure.GddlElement;
import dev.gigaherz.util.gddl2.util.Index;
import dev.gigaherz.util.gddl2.util.Range;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class ListQueryComponent
extends QueryComponent {
    private final Range range;

    public ListQueryComponent(Range range) {
        this.range = range;
    }

    @Override
    public Stream<GddlElement<?>> filter(Stream<GddlElement<?>> input) {
        return input.filter(GddlElement::isList).map(GddlElement::asList).flatMap(m -> {
            int start = this.range.start().value();
            int end = this.range.end().value();
            if (this.range.start().fromEnd()) {
                start = m.size() - start;
            }
            if (this.range.end().fromEnd()) {
                end = m.size() - end;
            }
            return m.stream().skip(start).limit(end - start);
        });
    }

    @Override
    public String toString(Formatter formatter) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Index start = this.range.start();
        Index end = this.range.end();
        if (start.value() != 0 || start.fromEnd()) {
            if (start.fromEnd()) {
                sb.append("^");
            }
            sb.append(start.value());
            if (end.fromEnd() == start.fromEnd() && (!start.fromEnd() && start.value() + 1 == end.value() || start.fromEnd() && start.value() == end.value() + 1)) {
                sb.append("]");
                return sb.toString();
            }
        }
        sb.append("..");
        if (end.value() != 0 || end.fromEnd()) {
            if (end.fromEnd()) {
                sb.append("^");
            }
            sb.append(end.value());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public QueryComponent copy() {
        return new ListQueryComponent(this.range);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.equalsImpl((ListQueryComponent)other);
    }

    public boolean equals(ListQueryComponent other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.equalsImpl(other);
    }

    private boolean equalsImpl(@NotNull ListQueryComponent other) {
        return this.range.equals(other.range);
    }

    @Override
    public int hashCode() {
        return this.range.hashCode();
    }
}

